/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.util;

import io.github.admin4j.http.ApiClient;
import io.github.admin4j.http.core.HttpDefaultConfig;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    private static volatile ApiClient SINGLETON_REQUEST = null;

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiClient getClient() {
        if (null != SINGLETON_REQUEST) return SINGLETON_REQUEST;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (null != SINGLETON_REQUEST) return SINGLETON_REQUEST;
            SINGLETON_REQUEST = new ApiClient(HttpDefaultConfig.get());
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLETON_REQUEST;
        }
    }

    public static void setClient(ApiClient apiJsonClient) {
        SINGLETON_REQUEST = apiJsonClient;
    }

    public static Response get(String url, Pair<?> ... queryParams) {
        return HttpUtil.getClient().get(url, (Map<String, Object>)null, queryParams);
    }

    public static Response get(String url, Map<String, Object> queryParams) {
        return HttpUtil.getClient().get(url, queryParams, (Pair[])null);
    }

    public static Response post(String url, Object body) {
        return HttpUtil.getClient().post(url, MediaTypeEnum.JSON, body, null, null);
    }

    public static Response postForm(String url, Map<String, Object> formParams) {
        return HttpUtil.getClient().post(url, MediaTypeEnum.FORM, null, formParams, null);
    }

    public static Response upload(String url, Map<String, Object> formParams) {
        return HttpUtil.getClient().post(url, MediaTypeEnum.FORM_DATA, null, formParams, null);
    }

    public static InputStream down(String url) {
        return HttpUtil.getClient().down(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void down(String url, String savePath) throws IOException {
        InputStream in = HttpUtil.down(url);
        File file = new File(savePath);
        boolean isFile = savePath.contains(".");
        if (isFile) {
            file.getParentFile().mkdirs();
        } else {
            file.mkdirs();
        }
        if (!isFile) {
            String fName = StringUtils.substringBefore((String)url, (String)"?");
            fName = StringUtils.substringAfterLast((String)fName, (String)"/");
            savePath = savePath + (StringUtils.endsWith((CharSequence)savePath, (CharSequence)"/") ? "" : "/") + fName;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(savePath);
            try {
                byte[] b = new byte[1024];
                while (bufferedInputStream.read(b) != -1) {
                    fileOutputStream.write(b);
                }
            }
            finally {
                if (Collections.singletonList(fileOutputStream).get(0) != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bufferedInputStream).get(0) != null) {
                bufferedInputStream.close();
            }
        }
    }
}

