/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.ConfusableException;
import io.github.adraffy.ens.Decoder;
import io.github.adraffy.ens.DisallowedCharacterException;
import io.github.adraffy.ens.EmojiSequence;
import io.github.adraffy.ens.Group;
import io.github.adraffy.ens.GroupKind;
import io.github.adraffy.ens.IllegalMixtureException;
import io.github.adraffy.ens.IntList;
import io.github.adraffy.ens.InvalidLabelException;
import io.github.adraffy.ens.Label;
import io.github.adraffy.ens.NF;
import io.github.adraffy.ens.NormException;
import io.github.adraffy.ens.OutputToken;
import io.github.adraffy.ens.ReadOnlyIntList;
import io.github.adraffy.ens.ReadOnlyIntSet;
import io.github.adraffy.ens.StringUtils;
import io.github.adraffy.ens.Whole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ENSIP15 {
    public static final String DISALLOWED_CHARACTER = "disallowed character";
    public static final String ILLEGAL_MIXTURE = "illegal mixture";
    public static final String WHOLE_CONFUSABLE = "whole-script confusable";
    public static final String EMPTY_LABEL = "empty label";
    public static final String NSM_DUPLICATE = "duplicate non-spacing marks";
    public static final String NSM_EXCESSIVE = "excessive non-spacing marks";
    public static final String CM_LEADING = "leading combining mark";
    public static final String CM_AFTER_EMOJI = "emoji + combining mark";
    public static final String FENCED_LEADING = "leading fenced";
    public static final String FENCED_ADJACENT = "adjacent fenced";
    public static final String FENCED_TRAILING = "trailing fenced";
    public static final String INVALID_LABEL_EXTENSION = "invalid label extension";
    public static final String INVALID_UNDERSCORE = "underscore allowed only at start";
    public static final char STOP_CH = '.';
    public final NF NF;
    public final int maxNonSpacingMarks;
    public final ReadOnlyIntSet shouldEscape;
    public final ReadOnlyIntSet ignored;
    public final ReadOnlyIntSet combiningMarks;
    public final ReadOnlyIntSet nonSpacingMarks;
    public final ReadOnlyIntSet NFCCheck;
    public final ReadOnlyIntSet possiblyValid;
    public final ReadOnlyIntSet invalidCompositions;
    public final Map<Integer, String> fenced;
    public final Map<Integer, ReadOnlyIntList> mapped;
    public final List<Group> groups;
    public final List<EmojiSequence> emojis;
    public final List<Whole> wholes;
    final HashMap<Integer, Whole> confusables = new HashMap();
    final EmojiNode emojiRoot = new EmojiNode();
    final Group GREEK;
    final Group ASCII;
    final Group EMOJI;

    ENSIP15(NF NF2, Decoder dec) {
        this.NF = NF2;
        this.shouldEscape = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.ignored = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.combiningMarks = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.maxNonSpacingMarks = dec.readUnsigned();
        this.nonSpacingMarks = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.NFCCheck = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.fenced = Collections.unmodifiableMap(ENSIP15.decodeNamedCodepoints(dec));
        this.mapped = Collections.unmodifiableMap(ENSIP15.decodeMapped(dec));
        this.groups = Collections.unmodifiableList(ENSIP15.decodeGroups(dec));
        this.emojis = Collections.unmodifiableList(dec.readTree(cps -> new EmojiSequence((int[])cps)));
        this.wholes = Collections.unmodifiableList(this.decodeWholes(dec));
        for (EmojiSequence emoji : this.emojis) {
            ArrayList<EmojiNode> nodes = new ArrayList<EmojiNode>();
            nodes.add(this.emojiRoot);
            for (int cp2 : emoji.beautified.array) {
                int i;
                int e;
                if (cp2 == 65039) {
                    e = nodes.size();
                    for (i = 0; i < e; ++i) {
                        nodes.add(((EmojiNode)nodes.get(i)).then(cp2));
                    }
                    continue;
                }
                e = nodes.size();
                for (i = 0; i < e; ++i) {
                    nodes.set(i, ((EmojiNode)nodes.get(i)).then(cp2));
                }
            }
            Iterator object = nodes.iterator();
            while (object.hasNext()) {
                EmojiNode x2 = (EmojiNode)object.next();
                x2.emoji = emoji;
            }
        }
        HashSet union = new HashSet();
        HashSet multi = new HashSet();
        for (Group group : this.groups) {
            IntStream.concat(group.primary.stream(), group.secondary.stream()).forEach(cp -> {
                if (union.contains(cp)) {
                    multi.add(cp);
                } else {
                    union.add(cp);
                }
            });
        }
        HashSet<Integer> valid = new HashSet<Integer>(union);
        for (int cp2 : NF2.NFD(union.stream().mapToInt(x -> x).toArray())) {
            valid.add(cp2);
        }
        this.possiblyValid = ReadOnlyIntSet.fromOwnedUnsorted(valid.stream().mapToInt(x -> x).toArray());
        this.invalidCompositions = ReadOnlyIntSet.fromOwnedUnsorted(union.stream().mapToInt(x -> x).filter(x -> !this.possiblyValid.contains(x)).toArray());
        HashSet hashSet = new HashSet(union);
        hashSet.removeAll(multi);
        hashSet.removeAll(this.confusables.keySet());
        for (Integer cp3 : hashSet) {
            this.confusables.put(cp3, Whole.UNIQUE_PH);
        }
        this.GREEK = this.groups.stream().filter(g -> g.name.equals("Greek")).findFirst().get();
        this.ASCII = new Group(-1, GroupKind.ASCII, "ASCII", false, ReadOnlyIntSet.fromOwnedUnsorted(this.possiblyValid.stream().filter(cp -> cp < 128).toArray()), ReadOnlyIntSet.EMPTY);
        this.EMOJI = new Group(-1, GroupKind.Emoji, "Emoji", false, ReadOnlyIntSet.EMPTY, ReadOnlyIntSet.EMPTY);
    }

    private ArrayList<Whole> decodeWholes(Decoder dec) {
        int[] confused;
        ArrayList<Whole> ret = new ArrayList<Whole>();
        while ((confused = dec.readUnique()).length != 0) {
            class Extent {
                final HashSet<Group> groups = new HashSet();
                final ArrayList<Integer> cps = new ArrayList();

                Extent() {
                }
            }
            int[] valid = dec.readUnique();
            Whole w = new Whole(ReadOnlyIntSet.fromOwnedUnsorted(valid), ReadOnlyIntSet.fromOwnedUnsorted(confused));
            for (int cp2 : confused) {
                this.confusables.put(cp2, w);
            }
            HashSet cover = new HashSet();
            ArrayList extents = new ArrayList();
            IntConsumer fn = cp -> {
                List gs = this.groups.stream().filter(g -> g.contains(cp)).collect(Collectors.toList());
                Extent extent = extents.stream().filter(e -> gs.stream().anyMatch(g -> e.groups.contains(g))).findFirst().orElseGet(() -> {
                    Extent temp = new Extent();
                    extents.add(temp);
                    return temp;
                });
                extent.cps.add(cp);
                extent.groups.addAll(gs);
                cover.addAll(gs);
            };
            for (int cp3 : valid) {
                fn.accept(cp3);
            }
            for (int cp3 : confused) {
                fn.accept(cp3);
            }
            Object object = extents.iterator();
            while (object.hasNext()) {
                Extent extent = (Extent)object.next();
                int[] complement = cover.stream().filter(g -> !extent.groups.contains(g)).mapToInt(g -> g.index).sorted().toArray();
                for (Integer cp4 : extent.cps) {
                    w.complements.put(cp4, complement);
                }
            }
        }
        return ret;
    }

    static HashMap<Integer, String> decodeNamedCodepoints(Decoder dec) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (int cp : dec.readSortedAscending(dec.readUnsigned())) {
            ret.put(cp, dec.readString());
        }
        return ret;
    }

    static HashMap<Integer, ReadOnlyIntList> decodeMapped(Decoder dec) {
        int w;
        HashMap<Integer, ReadOnlyIntList> ret = new HashMap<Integer, ReadOnlyIntList>();
        while ((w = dec.readUnsigned()) != 0) {
            int[] keys = dec.readSortedUnique();
            int n = keys.length;
            int[][] m = new int[n][w];
            for (int j = 0; j < w; ++j) {
                int[] v = dec.readUnsortedDeltas(n);
                for (int i = 0; i < n; ++i) {
                    m[i][j] = v[i];
                }
            }
            for (int i = 0; i < n; ++i) {
                ret.put(keys[i], new ReadOnlyIntList(m[i]));
            }
        }
        return ret;
    }

    static ArrayList<Group> decodeGroups(Decoder dec) {
        String name;
        ArrayList<Group> ret = new ArrayList<Group>();
        while (!(name = dec.readString()).isEmpty()) {
            int bits = dec.readUnsigned();
            GroupKind kind = (bits & 1) != 0 ? GroupKind.Restricted : GroupKind.Script;
            boolean cm = (bits & 2) != 0;
            ret.add(new Group(ret.size(), kind, name, cm, ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique()), ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique())));
        }
        return ret;
    }

    static void appendHexEscape(StringBuilder sb, int cp) {
        sb.append('{');
        StringUtils.appendHex(sb, cp);
        sb.append('}');
    }

    public String safeCodepoint(int cp) {
        StringBuilder sb = new StringBuilder();
        if (!this.shouldEscape.contains(cp)) {
            sb.append('\"');
            this.safeImplode(sb, new int[]{cp});
            sb.append('\"');
            sb.append(' ');
        }
        ENSIP15.appendHexEscape(sb, cp);
        return sb.toString();
    }

    public String safeImplode(int ... cps) {
        StringBuilder sb = new StringBuilder(cps.length + 16);
        this.safeImplode(sb, cps);
        return sb.toString();
    }

    public void safeImplode(StringBuilder sb, int[] cps) {
        if (cps.length == 0) {
            return;
        }
        if (this.combiningMarks.contains(cps[0])) {
            StringUtils.appendCodepoint(sb, 9676);
        }
        for (int cp : cps) {
            if (this.shouldEscape.contains(cp)) {
                ENSIP15.appendHexEscape(sb, cp);
                continue;
            }
            StringUtils.appendCodepoint(sb, cp);
        }
        StringUtils.appendCodepoint(sb, 8206);
    }

    static int[] flatten(List<OutputToken> tokens) {
        return tokens.stream().flatMapToInt(t -> t.stream()).toArray();
    }

    public String normalize(String name) {
        return this.transform(name, cps -> this.outputTokenize((int[])cps, this.NF::NFC, e -> e.normalized.array), tokens -> {
            int[] norm = ENSIP15.flatten(tokens);
            this.checkValidLabel(norm, (List<OutputToken>)tokens);
            return norm;
        });
    }

    public String beautify(String name) {
        return this.transform(name, cps -> this.outputTokenize((int[])cps, this.NF::NFC, e -> e.beautified.array), tokens -> {
            int[] norm = ENSIP15.flatten(tokens);
            Group group = this.checkValidLabel(norm, (List<OutputToken>)tokens);
            if (group != this.GREEK) {
                int e = norm.length;
                for (int i = 0; i < e; ++i) {
                    if (norm[i] != 958) continue;
                    norm[i] = 926;
                }
            }
            return norm;
        });
    }

    public String normalizeFragment(String name) {
        return this.normalizeFragment(name, false);
    }

    public String normalizeFragment(String name, boolean decompose) {
        return this.transform(name, cps -> this.outputTokenize((int[])cps, decompose ? this.NF::NFD : this.NF::NFC, e -> e.normalized.array), ENSIP15::flatten);
    }

    String transform(String name, Function<int[], List<OutputToken>> tokenizer, Function<List<OutputToken>, int[]> normalizer) {
        int n = name.length();
        StringBuilder sb = new StringBuilder(n + 16);
        int prev = 0;
        boolean more = true;
        while (more) {
            int next = name.indexOf(46, prev);
            if (next < 0) {
                next = n;
                more = false;
            }
            int[] cps = StringUtils.explode(name, prev, next);
            try {
                List<OutputToken> tokens = tokenizer.apply(cps);
                if (prev == 0 && !more && tokens.isEmpty()) {
                    return "";
                }
                for (int cp : normalizer.apply(tokens)) {
                    StringUtils.appendCodepoint(sb, cp);
                }
                if (more) {
                    sb.append('.');
                }
            }
            catch (NormException e) {
                throw new InvalidLabelException(prev, next, String.format("Invalid label \"%s\": %s", this.safeImplode(cps), e.getMessage()), e);
            }
            prev = next + 1;
        }
        return sb.toString();
    }

    public List<Label> split(String name) {
        ArrayList<Label> labels = new ArrayList<Label>();
        int prev = 0;
        boolean more = true;
        while (more) {
            int next = name.indexOf(46, prev);
            if (next < 0) {
                next = name.length();
                more = false;
            }
            Label l = new Label();
            l.input = StringUtils.explode(name, prev, next);
            l.start = prev;
            l.end = next;
            try {
                l.tokens = this.outputTokenize(l.input, this.NF::NFC, e -> e.normalized.toArray());
                if (prev == 0 && !more && l.tokens.isEmpty()) break;
                l.normalized = ENSIP15.flatten(l.tokens);
                l.group = this.checkValidLabel(l.normalized, l.tokens);
            }
            catch (NormException err) {
                l.error = err;
            }
            labels.add(l);
            prev = next + 1;
        }
        labels.trimToSize();
        return labels;
    }

    EmojiResult findEmoji(int[] cps, int i) {
        EmojiNode node = this.emojiRoot;
        EmojiResult last = null;
        int e = cps.length;
        while (i < e && node.map != null && (node = node.map.get(cps[i++])) != null) {
            if (node.emoji == null) continue;
            last = new EmojiResult(i, node.emoji);
        }
        return last;
    }

    ArrayList<OutputToken> outputTokenize(int[] cps, Function<int[], int[]> nf, Function<EmojiSequence, int[]> emojiStyler) {
        ArrayList<OutputToken> tokens = new ArrayList<OutputToken>();
        int n = cps.length;
        IntList buf = new IntList(n);
        int i = 0;
        while (i < n) {
            int cp;
            EmojiResult match = this.findEmoji(cps, i);
            if (match != null) {
                if (buf.count > 0) {
                    tokens.add(new OutputToken(nf.apply(buf.consume()), null));
                    buf.count = 0;
                }
                tokens.add(new OutputToken(emojiStyler.apply(match.emoji), match.emoji));
                i = match.pos;
                continue;
            }
            if (this.possiblyValid.contains(cp = cps[i++])) {
                buf.add(cp);
                continue;
            }
            ReadOnlyIntList replace = this.mapped.get(cp);
            if (replace != null) {
                buf.add(replace.array);
                continue;
            }
            if (this.ignored.contains(cp)) continue;
            throw new DisallowedCharacterException(this.safeCodepoint(cp), cp);
        }
        if (buf.count > 0) {
            tokens.add(new OutputToken(nf.apply(buf.consume()), null));
        }
        return tokens;
    }

    Group checkValidLabel(int[] norm, List<OutputToken> tokens) {
        boolean emoji;
        if (norm.length == 0) {
            throw new NormException(EMPTY_LABEL);
        }
        ENSIP15.checkLeadingUnderscore(norm);
        boolean bl = emoji = tokens.size() > 1 || tokens.get((int)0).emoji != null;
        if (!emoji && Arrays.stream(norm).allMatch(cp -> cp < 128)) {
            ENSIP15.checkLabelExtension(norm);
            return this.ASCII;
        }
        int[] chars = tokens.stream().filter(t -> t.emoji == null).flatMapToInt(t -> t.stream()).toArray();
        if (emoji && chars.length == 0) {
            return this.EMOJI;
        }
        this.checkCombiningMarks(tokens);
        this.checkFenced(norm);
        int[] unique = Arrays.stream(chars).distinct().toArray();
        Group group = this.determineGroup(unique);
        this.checkGroup(group, chars);
        this.checkWhole(group, unique);
        return group;
    }

    static void checkLeadingUnderscore(int[] cps) {
        int UNDERSCORE = 95;
        boolean allowed = true;
        for (int cp : cps) {
            if (allowed) {
                if (cp == 95) continue;
                allowed = false;
                continue;
            }
            if (cp != 95) continue;
            throw new NormException(INVALID_UNDERSCORE);
        }
    }

    static void checkLabelExtension(int[] cps) {
        int HYPHEN = 45;
        if (cps.length >= 4 && cps[2] == 45 && cps[3] == 45) {
            throw new NormException(INVALID_LABEL_EXTENSION, StringUtils.implode(Arrays.copyOf(cps, 4)));
        }
    }

    void checkFenced(int[] cps) {
        String name = this.fenced.get(cps[0]);
        if (name != null) {
            throw new NormException(FENCED_LEADING, name);
        }
        int n = cps.length;
        int last = -1;
        String prev = "";
        for (int i = 1; i < n; ++i) {
            name = this.fenced.get(cps[i]);
            if (name == null) continue;
            if (last == i) {
                throw new NormException(FENCED_ADJACENT, String.format("%s + %s", prev, name));
            }
            last = i + 1;
            prev = name;
        }
        if (last == n) {
            throw new NormException(FENCED_TRAILING, prev);
        }
    }

    void checkCombiningMarks(List<OutputToken> tokens) {
        int e = tokens.size();
        for (int i = 0; i < e; ++i) {
            int cp;
            OutputToken t = tokens.get(i);
            if (t.emoji != null || !this.combiningMarks.contains(cp = t.cps[0])) continue;
            if (i == 0) {
                throw new NormException(CM_LEADING, this.safeCodepoint(cp));
            }
            throw new NormException(CM_AFTER_EMOJI, String.format("%s + %s", tokens.get((int)(i - 1)).emoji.form, this.safeCodepoint(cp)));
        }
    }

    Group determineGroup(int[] unique) {
        int prev = this.groups.size();
        Group[] gs = this.groups.toArray(new Group[prev]);
        for (int cp : unique) {
            int next = 0;
            for (int i = 0; i < prev; ++i) {
                if (!gs[i].contains(cp)) continue;
                gs[next++] = gs[i];
            }
            if (next == 0) {
                if (this.invalidCompositions.contains(cp)) {
                    throw new DisallowedCharacterException(this.safeCodepoint(cp), cp);
                }
                throw this.createMixtureException(gs[0], cp);
            }
            prev = next;
            if (prev == 1) break;
        }
        return gs[0];
    }

    void checkGroup(Group group, int[] cps) {
        for (int cp : cps) {
            if (group.contains(cp)) continue;
            throw this.createMixtureException(group, cp);
        }
        if (group.CMWhitelisted) {
            return;
        }
        int[] decomposed = this.NF.NFD(cps);
        int e = decomposed.length;
        for (int i = 1; i < e; ++i) {
            int cp;
            int j;
            if (!this.nonSpacingMarks.contains(decomposed[i])) continue;
            for (j = i + 1; j < e && this.nonSpacingMarks.contains(cp = decomposed[j]); ++j) {
                for (int k = i; k < j; ++k) {
                    if (decomposed[k] != cp) continue;
                    throw new NormException(NSM_DUPLICATE, this.safeCodepoint(cp));
                }
            }
            int n = j - i;
            if (n > this.maxNonSpacingMarks) {
                throw new NormException(NSM_EXCESSIVE, String.format("%s (%d/%d)", this.safeImplode(Arrays.copyOfRange(decomposed, i - 1, j)), n, this.maxNonSpacingMarks));
            }
            i = j;
        }
    }

    void checkWhole(Group group, int[] unique) {
        int bound = 0;
        int[] maker = null;
        IntList shared = new IntList(unique.length);
        for (int cp : unique) {
            Whole w = this.confusables.get(cp);
            if (w == null) {
                shared.add(cp);
                continue;
            }
            if (w == Whole.UNIQUE_PH) {
                return;
            }
            int[] comp = w.complements.get(cp);
            if (bound == 0) {
                maker = (int[])comp.clone();
                bound = comp.length;
            } else {
                int b = 0;
                for (int i = 0; i < bound; ++i) {
                    if (Arrays.binarySearch(comp, maker[i]) < 0) continue;
                    maker[b++] = maker[i];
                }
                bound = b;
            }
            if (bound != 0) continue;
            return;
        }
        if (bound > 0) {
            for (int i = 0; i < bound; ++i) {
                Group other = this.groups.get((int)maker[i]);
                if (!shared.stream().allMatch(other::contains)) continue;
                throw new ConfusableException(group, other);
            }
        }
    }

    IllegalMixtureException createMixtureException(Group group, int cp) {
        String conflict = this.safeCodepoint(cp);
        Group other = this.groups.stream().filter(g -> g.primary.contains(cp)).findFirst().orElse(null);
        if (other != null) {
            conflict = String.format("%s %s", other, conflict);
        }
        return new IllegalMixtureException(String.format("%s + %s", group, conflict), cp, group, other);
    }

    static class EmojiResult {
        final int pos;
        final EmojiSequence emoji;

        EmojiResult(int pos, EmojiSequence emoji) {
            this.pos = pos;
            this.emoji = emoji;
        }
    }

    static class EmojiNode {
        EmojiSequence emoji;
        HashMap<Integer, EmojiNode> map;

        EmojiNode() {
        }

        EmojiNode then(int cp) {
            EmojiNode node;
            if (this.map == null) {
                this.map = new HashMap();
            }
            if ((node = this.map.get(cp)) == null) {
                node = new EmojiNode();
                this.map.put(cp, node);
            }
            return node;
        }
    }
}

