/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.Decoder;
import io.github.adraffy.ens.ENSIP15;
import io.github.adraffy.ens.NF;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ENSNormalize {
    public static final NF NF = new NF(ENSNormalize.decoder("/nf.bin"));
    public static final ENSIP15 ENSIP15 = new ENSIP15(NF, ENSNormalize.decoder("/spec.bin"));

    public static void main(String[] args) {
        System.out.println(ENSNormalize.decoder("/nf.bin"));
        System.out.println(ENSNormalize.decoder("/spec.bin"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Decoder decoder(String name) {
        try (InputStream in = ENSNormalize.class.getResourceAsStream(name);){
            int chunk = 8192;
            byte[] buf = new byte[8192];
            int len = 0;
            while (true) {
                int read;
                if ((read = in.read(buf, len, 8192)) == -1) {
                    Decoder decoder = new Decoder(ByteBuffer.wrap(buf, 0, len).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer());
                    return decoder;
                }
                if (buf.length - (len += read) >= 8192) continue;
                buf = Arrays.copyOf(buf, buf.length << 1);
            }
        }
        catch (Exception err) {
            throw new IllegalStateException(name, err);
        }
    }
}

