/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Helper {
    public static Type getActualTypeForGenericInterfaceByIndex(Class<?> clazz, Class<?> genericInterface, int paramIndex) {
        String genericTypeName = genericInterface.getTypeName();
        while (!Object.class.equals(clazz)) {
            for (Type genericType : clazz.getGenericInterfaces()) {
                if (!genericType.getTypeName().startsWith(genericTypeName)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                return typeArguments[paramIndex];
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static <T> Class<T> getActualClassForGenericInterfaceByIndex(Class<?> clazz, Class<?> genericInterface, int paramIndex) {
        Type typeArgument = Helper.getActualTypeForGenericInterfaceByIndex(clazz, genericInterface, paramIndex);
        if (typeArgument instanceof Class) {
            return (Class)typeArgument;
        }
        if (typeArgument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)typeArgument).getRawType();
        }
        throw new RuntimeException(" unknown typeArgument type for class " + clazz.getSimpleName());
    }

    public static String getActualTypeNameForGenericInterfaceByIndex(Class<?> clazz, Class<?> genericInterface, int paramIndex) {
        Type typeArgument = Helper.getActualTypeForGenericInterfaceByIndex(clazz, genericInterface, paramIndex);
        if (typeArgument != null) {
            return typeArgument.getTypeName();
        }
        throw new RuntimeException(" unknown typeArgument type for class " + clazz.getSimpleName());
    }

    public static <T> Class<T> getActualTypeForGenericTypeByIndex(Class<?> clazz, int paramIndex) {
        TypeVariable<Class<?>>[] typeArguments = clazz.getTypeParameters();
        TypeVariable<Class<?>> typeArgument = typeArguments[paramIndex];
        if (typeArgument instanceof Class) {
            return (Class)((Object)typeArgument);
        }
        if (typeArgument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)((Object)typeArgument)).getRawType();
        }
        throw new RuntimeException(" unknown typeArgument type for class " + clazz.getSimpleName());
    }

    public static <T> Class<T> getMethodReturnType(Class<?> clazz, String methodName) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method.getReturnType();
        }
        throw new RuntimeException("No such method " + methodName + " was found in Class " + clazz.getSimpleName());
    }

    public static Stream<Annotation> unpackAnnotation(Annotation a) {
        Stream<Annotation> singleStream = Stream.of(a);
        Class<? extends Annotation> annotationType = a.annotationType();
        try {
            Method value = annotationType.getMethod("value", new Class[0]);
            Object result = value.invoke((Object)a, new Object[0]);
            if (result != null && result instanceof Annotation[]) {
                return Stream.of((Annotation[])result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return singleStream;
    }

    public static List<Annotation> unpackAnnotations(List<Annotation> input) {
        return input.stream().flatMap(Helper::unpackAnnotation).collect(Collectors.toCollection(LinkedList::new));
    }

    public static Stream<Annotation> unpackAnnotations(Stream<Annotation> input) {
        return input.flatMap(Helper::unpackAnnotation);
    }
}

