/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.annotator;

import io.github.agache41.annotator.accessor.Accessor;
import io.github.agache41.annotator.matcher.Matcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.stream.Stream;

public interface Annotate<T> {
    public static final boolean DEBUG = false;

    public T get();

    public Stream<Annotation> getAnnotations();

    public <A extends Annotation> A getAnnotation(Class<A> var1, boolean var2);

    public <I> Class<?>[] getParameterizedTypesForImplementedInterface(Class<I> var1, boolean var2);

    public Stream<Field> getFields();

    public Field getField(String var1);

    public Stream<Method> getMethods();

    public Stream<Accessor<?>> getAccessors();

    public Accessor<?> getAccessor(String var1);

    public String toString();

    default public <A extends Annotation> boolean hasAnnotation(Class<A> clazz) {
        return this.getAnnotations(clazz).findAny().isPresent();
    }

    default public <A extends Annotation> Stream<A> getAnnotations(Class<A> clazz) {
        return this.getAnnotations().filter(annotation -> clazz.equals(annotation.annotationType()));
    }

    default public Stream<Annotation> getAnnotationsThat(Matcher<Object, ?> matcher) {
        return this.getAnnotations().filter(matcher::matches);
    }

    default public Stream<Field> getFieldsThat(Matcher<Object, ?> matcher) {
        return this.getFields().filter(matcher::matches);
    }

    default public Stream<Method> getMethodsThat(Matcher<Object, ?> matcher) {
        return this.getMethods().filter(matcher::matches);
    }

    default public Stream<Accessor<?>> getAccessorsThat(Matcher<Object, ?> matcher) {
        return this.getAccessors().filter(matcher::matches);
    }
}

