/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.annotator;

import io.github.agache41.annotator.accessor.Accessor;
import io.github.agache41.annotator.annotator.AccessorAnnotator;
import io.github.agache41.annotator.annotator.Annotate;
import io.github.agache41.annotator.annotator.ClassAnnotator;
import io.github.agache41.annotator.annotator.FieldAnnotator;
import io.github.agache41.annotator.annotator.MethodAnnotator;
import io.github.agache41.annotator.predicate.AreInDefaultOrInView;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;

public class Annotator {
    public static final <T> Annotate<T> of(T value) {
        if (value instanceof Accessor) {
            return AccessorAnnotator.of((Accessor)value);
        }
        if (value instanceof Field) {
            return FieldAnnotator.of((Field)value);
        }
        if (value instanceof Method) {
            return MethodAnnotator.of((Method)value);
        }
        if (value instanceof Annotation) {
            Annotation annotation = (Annotation)value;
            return ClassAnnotator.of(annotation.annotationType());
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return ClassAnnotator.of(clazz);
        }
        return ClassAnnotator.of(value.getClass());
    }

    public static <M extends Annotation, T> M getAnnotationForView(T value, Class<M> annotationClass, String view) {
        return Annotator.getAnnotationForView(value, annotationClass, view, false);
    }

    public static <M extends Annotation, T> M getAnnotationForView(T value, Class<M> annotationClass, String view, boolean throwOnFailure) {
        List collect = Annotator.of(value).getAnnotations(annotationClass).filter(AreInDefaultOrInView.of(view)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            if (throwOnFailure) {
                throw new RuntimeException("No annotations of type " + annotationClass.getSimpleName() + " where found in default or " + view + " view on " + value.toString());
            }
            return null;
        }
        if (collect.size() > 1) {
            throw new RuntimeException("More than one annotation of type " + annotationClass.getSimpleName() + " where found in default or " + view + " view on " + value.toString());
        }
        return (M)((Annotation)collect.get(0));
    }
}

