/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.annotator;

import io.github.agache41.annotator.Helper;
import io.github.agache41.annotator.accessor.Accessor;
import io.github.agache41.annotator.annotator.Annotate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassAnnotator<T>
implements Annotate<Class<T>> {
    private static final Map<Class<?>, ClassAnnotator<?>> classAnnotatorMap = new ConcurrentHashMap();
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final Map<String, Accessor<?>> accessors = new HashMap();
    private final Set<Method> methods = new HashSet<Method>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Class<T> clazz;

    private ClassAnnotator(Class<T> clazz) {
        this.clazz = clazz;
        for (Class<T> classType = clazz; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            for (Field field : classType.getDeclaredFields()) {
                this.fields.put(field.getName(), field);
            }
            Collections.addAll(this.methods, classType.getDeclaredMethods());
            this.annotations.addAll(Helper.unpackAnnotations(Stream.of(classType.getDeclaredAnnotations())).collect(Collectors.toList()));
        }
        if (!this.clazz.isAnnotation()) {
            this.fields.keySet().stream().map(fieldName -> new Accessor(this.fields.get(fieldName).getType(), this.clazz, this.fields.get(fieldName))).flatMap(Accessor::expand).forEach(accessor -> this.accessors.put(accessor.getName(), (Accessor<?>)accessor));
        } else {
            this.methods.stream().map(method -> new Accessor(method.getReturnType(), (Class<?>)this.clazz, (Method)method)).flatMap(Accessor::expand).forEach(accessor -> this.accessors.put(accessor.getName(), (Accessor<?>)accessor));
        }
    }

    public static synchronized <T> ClassAnnotator of(Class<T> clazz) {
        ClassAnnotator<Object> classAnnotator = classAnnotatorMap.get(clazz);
        if (classAnnotator == null) {
            classAnnotator = new ClassAnnotator<T>(clazz);
            classAnnotatorMap.put(clazz, classAnnotator);
        }
        return classAnnotator;
    }

    @Override
    public Class<T> get() {
        return this.clazz;
    }

    @Override
    public Stream<Annotation> getAnnotations() {
        return this.annotations.stream();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass, boolean throwOnFailure) {
        A annotation = this.clazz.getAnnotation(annotationClass);
        if (throwOnFailure && annotation == null) {
            throw new RuntimeException("No annotations of type " + annotationClass.getSimpleName() + " where found on class " + this.clazz.getSimpleName());
        }
        return annotation;
    }

    @Override
    public <I> Class<?>[] getParameterizedTypesForImplementedInterface(Class<I> implementedInterface, boolean throwOnFailure) {
        Class<?>[] classes = this.clazz.getInterfaces();
        int index = -1;
        for (int i = 0; i < classes.length; ++i) {
            if (!implementedInterface.equals(classes[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new RuntimeException(" Interface " + implementedInterface.getSimpleName() + " was not implemented in class" + this.clazz.getSimpleName() + "!");
        }
        ParameterizedType parameterizedType = (ParameterizedType)this.clazz.getGenericInterfaces()[index];
        return (Class[])parameterizedType.getActualTypeArguments();
    }

    @Override
    public Stream<Field> getFields() {
        return this.fields.values().stream();
    }

    @Override
    public Field getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public Stream<Method> getMethods() {
        return this.methods.stream();
    }

    @Override
    public Stream<Accessor<?>> getAccessors() {
        return this.accessors.values().stream();
    }

    @Override
    public Accessor<?> getAccessor(String name) {
        if (!this.accessors.containsKey(name)) {
            throw new IllegalArgumentException("No such method or field " + name + " in " + this.clazz.getSimpleName() + "!");
        }
        return this.accessors.get(name);
    }

    @Override
    public String toString() {
        return "Class<" + this.clazz.getSimpleName() + ">";
    }
}

