/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.matcher;

import io.github.agache41.annotator.matcher.Matcher;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Match<M>
implements Matcher<M, M> {
    private final Predicate<M> predicate;

    public Match(Predicate<M> predicate) {
        this.predicate = predicate;
    }

    public static <M> Match<M> the(Predicate<M> predicate) {
        return new Match<M>(predicate);
    }

    @Override
    public Stream<M> match(M value) {
        if (this.predicate.test(value)) {
            return Stream.of(value);
        }
        return Stream.empty();
    }
}

