/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.matcher;

import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Matcher<V, M> {
    public Stream<M> match(V var1);

    default public boolean matches(V value) {
        return this.match(value).findAny().isPresent();
    }

    default public <R> Matcher<V, Object> or(Matcher<V, R> matcher) {
        return value -> Stream.concat(this.match(value), matcher.match(value)).distinct();
    }

    default public <R> Matcher<V, R> and(Matcher<V, R> matcher) {
        return value -> {
            if (!this.matches(value)) {
                return Stream.empty();
            }
            return matcher.match(value);
        };
    }

    default public Matcher<V, M> having(Matcher<M, M> matcher) {
        return value -> this.match(value).filter(matcher::matches);
    }

    default public Matcher<V, M> that(Predicate<M> predicate) {
        return value -> this.match(value).filter(predicate::test);
    }

    default public Matcher<V, M> where(Predicate<M> predicate) {
        return value -> this.match(value).filter(predicate::test);
    }

    default public Matcher<V, M> matching(Matcher<M, M> matcher) {
        return value -> this.match(value).filter(matcher::matches);
    }
}

