/*
 * Decompiled with CFR 0.152.
 */
package io.github.agache41.annotator.predicate;

import io.github.agache41.annotator.accessor.Accessor;
import io.github.agache41.annotator.annotator.Annotator;
import java.util.function.Predicate;

public class AreInDefaultOrInView<M>
implements Predicate<M> {
    public static final String DEFAULT = "default";
    private final String viewValue;

    public AreInDefaultOrInView(String viewValue) {
        this.viewValue = viewValue;
    }

    public static <M> AreInDefaultOrInView<M> of(String viewValue) {
        return new AreInDefaultOrInView<M>(viewValue);
    }

    @Override
    public boolean test(M m) {
        Accessor<?> viewAcc = Annotator.of(m).getAccessor("view");
        if (viewAcc == null) {
            return true;
        }
        Object actualValue = viewAcc.get(m);
        return this.viewValue.equals(actualValue) || DEFAULT.equalsIgnoreCase(actualValue.toString());
    }
}

