/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import io.agora.avc.R;
import io.agora.avc.widget.RoundProgressBar;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J(\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u0007H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u001d\"\u0004\b$\u0010\u001fR\u001a\u0010%\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001fR$\u0010(\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001d\"\u0004\b*\u0010\u001fR\u001b\u0010+\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0010\u001a\u0004\b,\u0010\u000eR\u000e\u0010.\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lio/agora/avc/widget/RoundProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "arcRectF", "Landroid/graphics/RectF;", "bgPaint", "Landroid/graphics/Paint;", "getBgPaint", "()Landroid/graphics/Paint;", "bgPaint$delegate", "Lkotlin/Lazy;", "boundRectF", "clipPath", "Landroid/graphics/Path;", "getClipPath", "()Landroid/graphics/Path;", "clipPath$delegate", "cornerRadius", "", "endAngle", "value", "indicatorColor", "getIndicatorColor", "()I", "setIndicatorColor", "(I)V", "indicatorDirection", "getIndicatorDirection$annotations", "()V", "getIndicatorDirection", "setIndicatorDirection", "max", "getMax", "setMax", "progress", "getProgress", "setProgress", "progressPaint", "getProgressPaint", "progressPaint$delegate", "startAngle", "clockwise", "", "getColorPrimary", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "IndicatorDirection", "app_release"})
public final class RoundProgressBar
extends View {
    @NotNull
    private RectF boundRectF;
    @NotNull
    private RectF arcRectF;
    @NotNull
    private final Lazy progressPaint$delegate;
    @NotNull
    private final Lazy bgPaint$delegate;
    private float startAngle;
    private float endAngle;
    private float cornerRadius;
    @NotNull
    private final Lazy clipPath$delegate;
    private int progress;
    private int max;
    private int indicatorColor;
    private int indicatorDirection;

    @JvmOverloads
    public RoundProgressBar(@NotNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n2);
        this.boundRectF = new RectF();
        this.arcRectF = new RectF();
        this.progressPaint$delegate = LazyKt.lazy((Function0)progressPaint.2.INSTANCE);
        this.bgPaint$delegate = LazyKt.lazy((Function0)bgPaint.2.INSTANCE);
        this.startAngle = 270.0f;
        this.endAngle = 630.0f;
        this.clipPath$delegate = LazyKt.lazy((Function0)clipPath.2.INSTANCE);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.AvcRoundProgressBar);
        RoundProgressBar roundProgressBar = this;
        RoundProgressBar roundProgressBar2 = this;
        this.cornerRadius = context.getDimension(R.styleable.AvcRoundProgressBar_avc_radius, 0.0f);
        this.setProgress(context.getInt(R.styleable.AvcRoundProgressBar_avc_progress, 0));
        this.setMax(context.getInt(R.styleable.AvcRoundProgressBar_avc_max, 0));
        roundProgressBar2.setIndicatorDirection(context.getInt(R.styleable.AvcRoundProgressBar_avc_indicatorDirection, 0));
        int n3 = R.styleable.AvcRoundProgressBar_avc_indicatorColor;
        roundProgressBar.setIndicatorColor(context.getColor(n3, roundProgressBar2.getColorPrimary()));
        n3 = R.styleable.AvcRoundProgressBar_avc_trackColor;
        n3 = context.getColor(n3, roundProgressBar.getColorPrimary());
        this.getBgPaint().setColor(n3);
        context.recycle();
        this.getProgressPaint().setColor(this.indicatorColor);
    }

    public /* synthetic */ RoundProgressBar(Context context, AttributeSet attributeSet, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n2);
    }

    private final Paint getProgressPaint() {
        return (Paint)this.progressPaint$delegate.getValue();
    }

    private final Paint getBgPaint() {
        return (Paint)this.bgPaint$delegate.getValue();
    }

    private final Path getClipPath() {
        return (Path)this.clipPath$delegate.getValue();
    }

    @IndicatorDirection
    public static /* synthetic */ void getIndicatorDirection$annotations() {
    }

    private final boolean clockwise() {
        return this.indicatorDirection == 1;
    }

    private final int getColorPrimary() {
        TypedValue typedValue;
        TypedValue typedValue2 = typedValue;
        typedValue2();
        this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, typedValue2, true);
        return typedValue.data;
    }

    @JvmOverloads
    public RoundProgressBar(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public RoundProgressBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n2) {
        this.progress = n2;
        this.invalidate();
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n2) {
        this.max = n2;
    }

    public final int getIndicatorColor() {
        return this.indicatorColor;
    }

    public final void setIndicatorColor(int n2) {
        this.indicatorColor = n2;
        this.getProgressPaint().setColor(n2);
    }

    public final int getIndicatorDirection() {
        return this.indicatorDirection;
    }

    public final void setIndicatorDirection(int n2) {
        this.indicatorDirection = n2;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        float f2;
        float f3;
        RoundProgressBar roundProgressBar = this;
        super.onSizeChanged(n2, n3, n4, n5);
        RectF rectF = roundProgressBar.boundRectF;
        rectF.right = f3 = (float)n2;
        rectF.bottom = f2 = (float)n3;
        RectF rectF2 = roundProgressBar.arcRectF;
        float f4 = f2;
        float f5 = f3;
        rectF2.left = (float)(-n2) / 2.0f;
        rectF2.top = (float)(-n3) / 2.0f;
        rectF2.right = f5 + f5 / 2.0f;
        roundProgressBar.arcRectF.bottom = f4 + f4 / 2.0f;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        RoundProgressBar roundProgressBar = roundProgressBar5;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.onDraw(canvas2);
        float f2 = 360.0f / (float)roundProgressBar.max;
        float f3 = roundProgressBar.clockwise() ? roundProgressBar5.progress : roundProgressBar5.max - roundProgressBar5.progress;
        Canvas canvas3 = canvas;
        RoundProgressBar roundProgressBar2 = roundProgressBar5;
        RoundProgressBar roundProgressBar3 = roundProgressBar5;
        float f4 = RangesKt.coerceAtMost((float)(f2 * f3), (float)(roundProgressBar5.endAngle - roundProgressBar5.startAngle));
        canvas.save();
        Path path = roundProgressBar3.getClipPath();
        RoundProgressBar roundProgressBar4 = roundProgressBar5;
        path.reset();
        RoundProgressBar roundProgressBar5 = roundProgressBar4.boundRectF;
        float f5 = roundProgressBar4.cornerRadius;
        RoundProgressBar roundProgressBar6 = roundProgressBar5;
        roundProgressBar5 = Path.Direction.CW;
        float f6 = f5;
        path.addRoundRect((RectF)roundProgressBar6, f6, f6, (Path.Direction)roundProgressBar5);
        canvas.clipPath(roundProgressBar3.getClipPath());
        roundProgressBar5 = roundProgressBar2.arcRectF;
        f5 = roundProgressBar2.startAngle;
        Paint paint = roundProgressBar2.getProgressPaint();
        canvas3.drawArc((RectF)roundProgressBar5, f5, f4, true, paint);
        canvas3.restore();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0086\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lio/agora/avc/widget/RoundProgressBar$IndicatorDirection;", "", "Companion", "app_release"})
    public static @interface IndicatorDirection {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int clockwise = 0;
        public static final int counterclockwise = 1;

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/agora/avc/widget/RoundProgressBar$IndicatorDirection$Companion;", "", "()V", "clockwise", "", "counterclockwise", "app_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            public static final int clockwise = 0;
            public static final int counterclockwise = 1;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

