/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import io.agora.avc.R;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 32\u00020\u0001:\u000234B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0014J(\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0014J\b\u0010(\u001a\u00020\u001cH\u0002J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000eJ\u0010\u0010,\u001a\u00020\u001c2\b\b\u0001\u0010-\u001a\u00020\u0007J\b\u0010.\u001a\u00020\u001cH\u0002J\u000e\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u000eJ\u000e\u00101\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000eR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/agora/avc/widget/Watermark;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "data", "Ljava/util/ArrayList;", "Lio/agora/avc/widget/Watermark$Point;", "Lkotlin/collections/ArrayList;", "degrees", "", "horGap", "markColor", "markHeight", "markSize", "markWidth", "minHeight", "minWidth", "paint", "Landroid/graphics/Paint;", "showText", "", "verticalGap", "designData", "", "w", "h", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "oldw", "oldh", "reDraw", "setDegree", "setHorGap", "gap", "setMarkColor", "color", "setMarkRect", "setMarkSize", "size", "setMarkText", "setVerticalGap", "Companion", "Point", "app_release"})
public final class Watermark
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "Watermark";
    @NotNull
    private Paint paint;
    @NotNull
    private String showText;
    private int markColor;
    private float markSize;
    private float verticalGap;
    private float horGap;
    private float degrees;
    private int markWidth;
    private int markHeight;
    private int minWidth;
    private int minHeight;
    @NotNull
    private ArrayList<Point> data;

    @JvmOverloads
    public Watermark(@NotNull Context context, @Nullable AttributeSet object, int n2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, object, n2);
            this.paint = new Paint();
            this.showText = TAG;
            this.markColor = -1;
            this.markSize = 36.0f;
            this.verticalGap = 100.0f;
            this.horGap = 50.0f;
            this.degrees = -20.0f;
            this.minWidth = 100;
            this.minHeight = 100;
            this.data = new ArrayList();
            context = context.getTheme().obtainStyledAttributes(object, R.styleable.AvcWatermark, 0, 0);
            try {
                object = context.getString(R.styleable.AvcWatermark_avc_markText);
                if (object != null) break block3;
                object = TAG;
            }
            catch (Throwable throwable) {
                context.recycle();
                throw throwable;
            }
        }
        Watermark watermark = this;
        Watermark watermark2 = watermark;
        this.showText = object;
        this.markSize = context.getDimension(R.styleable.AvcWatermark_avc_markSize, 36.0f);
        this.markColor = context.getColor(R.styleable.AvcWatermark_avc_markColor, -1);
        this.verticalGap = context.getDimension(R.styleable.AvcWatermark_avc_verticalGap, 100.0f);
        this.horGap = context.getDimension(R.styleable.AvcWatermark_avc_horGap, 50.0f);
        this.degrees = context.getFloat(R.styleable.AvcWatermark_avc_degrees, -20.0f);
        context.recycle();
        context = watermark.paint;
        context.setAntiAlias(true);
        context.setTextSize(this.markSize);
        context.setColor(this.markColor);
        watermark2.setMarkRect();
    }

    public /* synthetic */ Watermark(Context context, AttributeSet attributeSet, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n2);
    }

    private final void setMarkRect() {
        Rect rect;
        Rect rect2 = rect;
        rect2();
        String string2 = this.showText;
        this.paint.getTextBounds(string2, 0, string2.length(), rect2);
        this.markWidth = rect.width();
        this.markHeight = rect2.height();
        if (this.markWidth == 0) {
            this.markHeight = this.minWidth;
        }
        if (this.markHeight == 0) {
            this.markHeight = this.minHeight;
        }
    }

    private final void designData(int n2, int n3) {
        Watermark watermark = this;
        int n4 = Math.max(watermark.getPaddingStart(), this.getPaddingLeft());
        Watermark watermark2 = this;
        int n5 = Math.max(watermark2.getPaddingEnd(), this.getPaddingRight());
        float f2 = watermark2.getPaddingTop();
        float f3 = watermark2.getPaddingBottom();
        watermark2.data.clear();
        float f4 = n4;
        f2 = (float)watermark.markHeight + f2;
        int n6 = 1;
        float f5 = f4;
        while (true) {
            Watermark watermark3 = this;
            watermark3.data.add(new Point(f5, f2));
            int n7 = watermark3.markWidth;
            float f6 = f5 + ((float)n7 + this.horGap);
            if (!((double)f6 < (double)n2 * 1.5 - (double)n5 - (double)n7)) {
                f5 = ++n6 % 2 == 0 ? f4 + (float)n7 : f4;
                if ((double)(f2 += (float)this.markHeight + this.verticalGap) < (double)n3 * 1.5 - (double)f3) continue;
                return;
            }
            f5 = f6;
        }
    }

    private final void reDraw() {
        Watermark watermark = this;
        int n2 = watermark.getMeasuredWidth();
        watermark.designData(n2, watermark.getMeasuredHeight());
        watermark.invalidate();
    }

    @JvmOverloads
    public Watermark(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public Watermark(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    protected void onMeasure(int n2, int n3) {
        Watermark watermark = this;
        watermark.setMeasuredDimension(View.getDefaultSize((int)watermark.markWidth, (int)n2), View.getDefaultSize((int)this.markHeight, (int)n3));
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        this.designData(n2, n3);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        canvas2.save();
        canvas.translate((float)this.getMeasuredWidth() * -0.25f, (float)this.getMeasuredHeight() * -0.25f);
        Watermark watermark = this;
        float f2 = (float)watermark.getMeasuredWidth() / 2.0f;
        canvas.rotate(this.degrees, f2, (float)watermark.getMeasuredHeight() / 2.0f);
        for (Point point : this.data) {
            String string2 = this.showText;
            float f3 = point.getX();
            float f4 = point.getY();
            Paint paint = this.paint;
            canvas.drawText(string2, f3, f4, paint);
        }
        canvas.restore();
    }

    public final void setDegree(float f2) {
        this.degrees = f2;
        this.invalidate();
    }

    public final void setHorGap(float f2) {
        this.horGap = f2;
        this.reDraw();
    }

    public final void setVerticalGap(float f2) {
        this.verticalGap = f2;
        this.reDraw();
    }

    public final void setMarkSize(float f2) {
        Watermark watermark = this;
        watermark.markSize = f2;
        watermark.paint.setTextSize(f2);
        watermark.setMarkRect();
        watermark.reDraw();
    }

    public final void setMarkColor(@ColorInt int n2) {
        Watermark watermark = this;
        watermark.markColor = n2;
        watermark.paint.setColor(n2);
        watermark.invalidate();
    }

    public final void setMarkText(@NotNull String string2) {
        Watermark watermark = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"showText");
        watermark.showText = string2;
        watermark.setMarkRect();
        watermark.reDraw();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/agora/avc/widget/Watermark$Point;", "", "x", "", "y", "(FF)V", "getX", "()F", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "app_release"})
    public static final class Point {
        private final float x;
        private final float y;

        public Point(float f2, float f3) {
            this.x = f2;
            this.y = f3;
        }

        public static /* synthetic */ Point copy$default(Point point, float f2, float f3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f2 = point.x;
            }
            if ((n2 & 2) != 0) {
                f3 = point.y;
            }
            return point.copy(f2, f3);
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        @NotNull
        public final Point copy(float f2, float f3) {
            return new Point(f2, f3);
        }

        @NotNull
        public String toString() {
            return "Point(x=" + this.x + ", y=" + this.y + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.x) * 31 + Float.hashCode(this.y);
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Point)) {
                return false;
            }
            object = (Point)object;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(((Point)object).x))) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(((Point)object).y));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/agora/avc/widget/Watermark$Companion;", "", "()V", "TAG", "", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

