/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.danceview;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import io.agora.avc.widget.danceview.Sprite;

public abstract class ShapeSprite
extends Sprite {
    private Paint mPaint;
    private int mUseColor;
    private int mBaseColor;

    public ShapeSprite() {
        ShapeSprite shapeSprite = this;
        shapeSprite.setColor(-1);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        shapeSprite.mPaint.setColor(this.mUseColor);
    }

    private void updateUseColor() {
        ShapeSprite shapeSprite = this;
        int n2 = shapeSprite.getAlpha();
        int n3 = n2 + (n2 >> 7);
        int n4 = shapeSprite.mBaseColor;
        n3 = (n4 >>> 24) * n3 >> 8;
        shapeSprite.mUseColor = n4 << 8 >>> 8 | n3 << 24;
    }

    @Override
    public void setColor(int n2) {
        this.mBaseColor = n2;
        this.updateUseColor();
    }

    public void setShape(LinearGradient linearGradient) {
        this.mPaint.setShader((Shader)linearGradient);
    }

    @Override
    public int getColor() {
        return this.mBaseColor;
    }

    public int getUseColor() {
        return this.mUseColor;
    }

    @Override
    public void setAlpha(int n2) {
        ShapeSprite shapeSprite = this;
        super.setAlpha(n2);
        shapeSprite.updateUseColor();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    protected final void drawSelf(Canvas canvas) {
        ShapeSprite shapeSprite = this;
        shapeSprite.mPaint.setColor(this.mUseColor);
        this.drawShape(canvas, shapeSprite.mPaint);
    }

    public abstract void drawShape(Canvas var1, Paint var2);
}

