/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.danceview;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.Property;
import io.agora.avc.widget.danceview.AnimationUtils;
import io.agora.avc.widget.danceview.IntProperty;

public abstract class Sprite
extends Drawable
implements ValueAnimator.AnimatorUpdateListener,
Animatable,
Drawable.Callback {
    private static final Rect ZERO_BOUNDS_RECT = new Rect();
    public static final Property<Sprite, Integer> ROTATE_X = new IntProperty<Sprite>("rotateX"){

        @Override
        public void setValue(Sprite sprite, int n2) {
            sprite.setRotateX(n2);
        }

        public Integer get(Sprite sprite) {
            return sprite.getRotateX();
        }
    };
    public static final Property<Sprite, Integer> ROTATE = new IntProperty<Sprite>("rotate"){

        @Override
        public void setValue(Sprite sprite, int n2) {
            sprite.setRotate(n2);
        }

        public Integer get(Sprite sprite) {
            return sprite.getRotate();
        }
    };
    public static final Property<Sprite, Integer> ROTATE_Y = new IntProperty<Sprite>("rotateY"){

        @Override
        public void setValue(Sprite sprite, int n2) {
            sprite.setRotateY(n2);
        }

        public Integer get(Sprite sprite) {
            return sprite.getRotateY();
        }
    };
    private float scale = 1.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float pivotX;
    private float pivotY;
    private int animationDelay;
    private int rotateX;
    private int rotateY;
    private int translateX;
    private int translateY;
    private int rotate;
    private float translateXPercentage;
    private float translateYPercentage;
    private ValueAnimator animator;
    private int alpha = 255;
    protected Rect drawBounds = ZERO_BOUNDS_RECT;
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();

    public abstract int getColor();

    public abstract void setColor(int var1);

    public void setAlpha(int n2) {
        this.alpha = n2;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getOpacity() {
        return -3;
    }

    public float getTranslateXPercentage() {
        return this.translateXPercentage;
    }

    public void setTranslateXPercentage(float f2) {
        this.translateXPercentage = f2;
    }

    public float getTranslateYPercentage() {
        return this.translateYPercentage;
    }

    public void setTranslateYPercentage(float f2) {
        this.translateYPercentage = f2;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public void setTranslateX(int n2) {
        this.translateX = n2;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public void setTranslateY(int n2) {
        this.translateY = n2;
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int n2) {
        this.rotate = n2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f2) {
        Sprite sprite = this;
        sprite.scale = f2;
        sprite.setScaleX(f2);
        sprite.setScaleY(f2);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f2) {
        this.scaleX = f2;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f2) {
        this.scaleY = f2;
    }

    public int getRotateX() {
        return this.rotateX;
    }

    public void setRotateX(int n2) {
        this.rotateX = n2;
    }

    public int getRotateY() {
        return this.rotateY;
    }

    public void setRotateY(int n2) {
        this.rotateY = n2;
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public void setPivotX(float f2) {
        this.pivotX = f2;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    public void setPivotY(float f2) {
        this.pivotY = f2;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public Sprite setAnimationDelay(int n2) {
        this.animationDelay = n2;
        return this;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public abstract ValueAnimator onCreateAnimation();

    public void start() {
        ValueAnimator valueAnimator;
        if (AnimationUtils.isStarted(this.animator)) {
            return;
        }
        this.animator = valueAnimator = this.obtainAnimation();
        if (valueAnimator == null) {
            return;
        }
        AnimationUtils.start((Animator)valueAnimator);
        this.invalidateSelf();
    }

    public ValueAnimator obtainAnimation() {
        ValueAnimator valueAnimator;
        if (this.animator == null) {
            this.animator = this.onCreateAnimation();
        }
        if ((valueAnimator = this.animator) != null) {
            valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.animator.setStartDelay((long)this.animationDelay);
        }
        return this.animator;
    }

    public void stop() {
        if (AnimationUtils.isStarted(this.animator)) {
            Sprite sprite = this;
            sprite.animator.removeAllUpdateListeners();
            sprite.animator.end();
            sprite.reset();
        }
    }

    protected abstract void drawSelf(Canvas var1);

    public void reset() {
        Sprite sprite = this;
        sprite.scale = 1.0f;
        sprite.rotateX = 0;
        sprite.rotateY = 0;
        sprite.translateX = 0;
        sprite.translateY = 0;
        sprite.rotate = 0;
        sprite.translateXPercentage = 0.0f;
        sprite.translateYPercentage = 0.0f;
    }

    public boolean isRunning() {
        return AnimationUtils.isRunning(this.animator);
    }

    protected void onBoundsChange(Rect rect) {
        Sprite sprite = this;
        super.onBoundsChange(rect);
        sprite.setDrawBounds(rect);
    }

    public void setDrawBounds(Rect rect) {
        Rect rect2 = rect;
        int n2 = rect2.left;
        int n3 = rect2.top;
        int n4 = rect2.right;
        int n5 = rect2.bottom;
        this.setDrawBounds(n2, n3, n4, n5);
    }

    public void setDrawBounds(int n2, int n3, int n4, int n5) {
        Sprite sprite = this;
        sprite.drawBounds = new Rect(n2, n3, n4, n5);
        sprite.setPivotX(sprite.getDrawBounds().centerX());
        sprite.setPivotY(sprite.getDrawBounds().centerY());
    }

    public void invalidateDrawable(Drawable drawable2) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l2) {
    }

    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        valueAnimator = this.getCallback();
        if (valueAnimator != null) {
            valueAnimator.invalidateDrawable((Drawable)this);
        }
    }

    public Rect getDrawBounds() {
        return this.drawBounds;
    }

    public void draw(Canvas canvas) {
        int n2;
        int n3 = this.getTranslateX();
        if (n3 == 0) {
            n3 = (int)((float)this.getBounds().width() * this.getTranslateXPercentage());
        }
        if ((n2 = this.getTranslateY()) == 0) {
            n2 = (int)((float)this.getBounds().height() * this.getTranslateYPercentage());
        }
        Sprite sprite = this;
        Sprite sprite2 = this;
        float f2 = n3;
        canvas.translate(f2, (float)n2);
        f2 = sprite2.getScaleX();
        float f3 = sprite2.getScaleY();
        float f4 = sprite2.getPivotX();
        float f5 = sprite2.getPivotY();
        canvas.scale(f2, f3, f4, f5);
        f2 = sprite.getRotate();
        f3 = sprite.getPivotX();
        f4 = sprite.getPivotY();
        canvas.rotate(f2, f3, f4);
        if (this.getRotateX() != 0 || this.getRotateY() != 0) {
            Sprite sprite3 = this;
            sprite3.mCamera.save();
            sprite3.mCamera.rotateX((float)this.getRotateX());
            sprite3.mCamera.rotateY((float)this.getRotateY());
            sprite3.mCamera.getMatrix(this.mMatrix);
            sprite3.mMatrix.preTranslate(-this.getPivotX(), -this.getPivotY());
            Sprite sprite4 = this;
            f2 = sprite4.getPivotX();
            sprite3.mMatrix.postTranslate(f2, sprite4.getPivotY());
            sprite3.mCamera.restore();
            canvas.concat(sprite3.mMatrix);
        }
        this.drawSelf(canvas);
    }

    public Rect clipSquare(Rect rect) {
        Rect rect2 = rect;
        int n2 = rect2.centerX();
        int n3 = rect2.centerY();
        int n4 = Math.min(rect.width(), rect.height()) / 2;
        int n5 = n3;
        int n6 = n4;
        int n7 = n2;
        n2 -= n4;
        n3 -= n4;
        n4 = n7 + n4;
        int n8 = n5 + n6;
        return new Rect(n2, n3, n4, n8);
    }
}

