/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.danceview;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.animation.Interpolator;
import io.agora.avc.widget.danceview.Sprite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class SpriteAnimatorBuilder {
    private static final String TAG = "SpriteAnimatorBuilder";
    private Sprite sprite;
    private Interpolator interpolator;
    private int repeatCount = -1;
    private long duration = 2000L;
    private int startFrame = 0;
    private Map<String, FrameData> fds;

    public SpriteAnimatorBuilder(Sprite sprite) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        v1.fds = hashMap2;
        v1.sprite = sprite;
    }

    private void holder(float[] fArray, Property property, Integer[] integerArray) {
        SpriteAnimatorBuilder spriteAnimatorBuilder = this;
        int n2 = fArray.length;
        spriteAnimatorBuilder.ensurePair(n2, integerArray.length);
        spriteAnimatorBuilder.fds.put(property.getName(), new IntFrameData(fArray, property, integerArray));
    }

    private void ensurePair(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = n3;
        throw new IllegalStateException(String.format(Locale.getDefault(), "The fractions.length must equal values.length, fraction.length[%d], values.length[%d]", objectArray2));
    }

    public SpriteAnimatorBuilder rotate(float[] fArray, Integer ... integerArray) {
        SpriteAnimatorBuilder spriteAnimatorBuilder = this;
        spriteAnimatorBuilder.holder(fArray, Sprite.ROTATE, integerArray);
        return spriteAnimatorBuilder;
    }

    public SpriteAnimatorBuilder interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public SpriteAnimatorBuilder duration(long l2) {
        this.duration = l2;
        return this;
    }

    public SpriteAnimatorBuilder repeatCount(int n2) {
        this.repeatCount = n2;
        return this;
    }

    public ObjectAnimator build() {
        SpriteAnimatorBuilder spriteAnimatorBuilder = this;
        ObjectAnimator objectAnimator = new PropertyValuesHolder[spriteAnimatorBuilder.fds.size()];
        int n2 = 0;
        Iterator<Map.Entry<String, FrameData>> iterator = spriteAnimatorBuilder.fds.entrySet().iterator();
        while (iterator.hasNext()) {
            FrameData frameData = iterator.next().getValue();
            float[] fArray = frameData.fractions;
            Keyframe[] keyframeArray = new Keyframe[fArray.length];
            int n3 = this.startFrame;
            float f2 = frameData.fractions[n3];
            while (true) {
                float f3;
                int n4 = this.startFrame;
                T[] TArray = frameData.values;
                if (n3 >= n4 + frameData.values.length) break;
                n4 = n3 - n4;
                int n5 = n3 % TArray.length;
                float f4 = fArray[n5] - f2;
                if (f3 < 0.0f) {
                    f4 = fArray[fArray.length - 1] + f4;
                }
                keyframeArray[n4] = frameData instanceof IntFrameData ? Keyframe.ofInt((float)f4, (int)((Integer)frameData.values[n5])) : (frameData instanceof FloatFrameData ? Keyframe.ofFloat((float)f4, (float)((Float)frameData.values[n5]).floatValue()) : Keyframe.ofObject((float)f4, frameData.values[n5]));
                ++n3;
            }
            objectAnimator[n2] = PropertyValuesHolder.ofKeyframe((Property)frameData.property, (Keyframe[])keyframeArray);
            ++n2;
        }
        objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.sprite), (PropertyValuesHolder[])objectAnimator);
        objectAnimator.setDuration(this.duration);
        objectAnimator.setRepeatCount(this.repeatCount);
        objectAnimator.setInterpolator((TimeInterpolator)this.interpolator);
        return objectAnimator;
    }

    class FloatFrameData
    extends FrameData<Float> {
        public FloatFrameData(float[] fArray, Property property, Float[] floatArray) {
            super(fArray, property, floatArray);
        }
    }

    class IntFrameData
    extends FrameData<Integer> {
        public IntFrameData(float[] fArray, Property property, Integer[] integerArray) {
            super(fArray, property, integerArray);
        }
    }

    class FrameData<T> {
        float[] fractions;
        Property property;
        T[] values;

        public FrameData(float[] fArray, Property property, T[] TArray) {
            this.fractions = fArray;
            this.property = property;
            this.values = TArray;
        }
    }
}

