/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.danceview;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Rect;
import io.agora.avc.widget.danceview.AnimationUtils;
import io.agora.avc.widget.danceview.Sprite;

public abstract class SpriteContainer
extends Sprite {
    private Sprite[] sprites;
    private int color;

    public SpriteContainer() {
        SpriteContainer spriteContainer = this;
        spriteContainer.sprites = spriteContainer.onCreateChild();
        spriteContainer.initCallBack();
        spriteContainer.onChildCreated(spriteContainer.sprites);
    }

    private void initCallBack() {
        Sprite[] spriteArray = this.sprites;
        if (this.sprites != null) {
            int n2 = spriteArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                spriteArray[i2].setCallback(this);
            }
        }
    }

    public void onChildCreated(Sprite ... spriteArray) {
    }

    public int getChildCount() {
        Sprite[] spriteArray = spriteArray.sprites;
        return spriteArray.sprites == null ? 0 : spriteArray.length;
    }

    public Sprite getChildAt(int n2) {
        Sprite[] spriteArray = spriteArray.sprites;
        return spriteArray.sprites == null ? null : spriteArray[n2];
    }

    @Override
    public void setColor(int n2) {
        this.color = n2;
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            this.getChildAt(i2).setColor(n2);
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void draw(Canvas canvas) {
        SpriteContainer spriteContainer = this;
        super.draw(canvas);
        spriteContainer.drawChild(canvas);
    }

    public void drawChild(Canvas canvas) {
        Sprite[] spriteArray = spriteArray.sprites;
        if (spriteArray.sprites != null) {
            int n2 = spriteArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Canvas canvas2 = canvas;
                int n3 = canvas2.save();
                spriteArray[i2].draw(canvas2);
                canvas.restoreToCount(n3);
            }
        }
    }

    @Override
    protected void drawSelf(Canvas canvas) {
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        Sprite[] spriteArray = spriteArray.sprites;
        int n2 = spriteArray.sprites.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            spriteArray[i2].setBounds(rect);
        }
    }

    @Override
    public void start() {
        SpriteContainer spriteContainer = this;
        super.start();
        AnimationUtils.start(spriteContainer.sprites);
    }

    @Override
    public void stop() {
        SpriteContainer spriteContainer = this;
        super.stop();
        AnimationUtils.stop(spriteContainer.sprites);
    }

    @Override
    public boolean isRunning() {
        return AnimationUtils.isRunning(this.sprites) || super.isRunning();
    }

    public abstract Sprite[] onCreateChild();

    @Override
    public ValueAnimator onCreateAnimation() {
        return null;
    }
}

