/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.divider;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

public class VerticalDivider
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mPaddingLeft;
    private int mPaddingRight;
    private boolean mDrawFirst;
    private boolean mDrawLast;

    public VerticalDivider(Context context, int n2, int n3, int n4) {
        this(context, n2, n3, n4, true, true);
    }

    public VerticalDivider(Context context, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)n2);
        this.mPaddingLeft = n3;
        this.mPaddingRight = n4;
        this.mDrawFirst = bl;
        this.mDrawLast = bl2;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        VerticalDivider verticalDivider = this;
        super.onDraw(canvas, recyclerView, state);
        verticalDivider.drawVertical(canvas, recyclerView);
    }

    public void drawVertical(Canvas canvas, RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        int n2 = recyclerView2.getPaddingLeft() + this.mPaddingLeft;
        int n3 = recyclerView2.getWidth() - recyclerView.getPaddingRight() - this.mPaddingRight;
        int n4 = recyclerView2.getChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            RecyclerView recyclerView3 = recyclerView;
            View view = recyclerView3.getChildAt(i2);
            int n5 = recyclerView3.getChildAdapterPosition(view);
            if (!this.mDrawFirst && n5 == 0) continue;
            if (!this.mDrawLast) {
                int n6 = 0;
                if (recyclerView.getAdapter() != null) {
                    n6 = recyclerView.getAdapter().getItemCount();
                }
                if (n5 == n6 - 1) continue;
            }
            VerticalDivider verticalDivider = this;
            View view2 = view;
            view = (RecyclerView.LayoutParams)view2.getLayoutParams();
            int n7 = view2.getBottom() + view.bottomMargin;
            n5 = n7 + this.mDivider.getIntrinsicHeight();
            verticalDivider.mDivider.setBounds(n2, n7, n3, n5);
            verticalDivider.mDivider.draw(canvas);
        }
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int n2 = this.mDivider.getIntrinsicHeight();
        rect.set(0, 0, 0, n2);
    }
}

