/*
 * Decompiled with CFR 0.152.
 */
package io.agora.avc.widget.helper;

import android.app.Activity;
import android.app.PictureInPictureParams;
import android.os.Build;
import android.util.Rational;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleObserver;
import io.agora.avc.bo.VideoStats;
import io.agora.avc.bo.valoran.ARoomUser;
import io.agora.avc.g.a;
import io.agora.avc.utils.a0;
import io.agora.avc.utils.f;
import io.agora.logger.LogConverter;
import io.agora.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0006\u0010\u001c\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\r\u00a8\u0006#"}, d2={"Lio/agora/avc/widget/helper/PictureInPictureHelper;", "Landroidx/lifecycle/LifecycleObserver;", "activity", "Landroidx/fragment/app/FragmentActivity;", "callback", "Lio/agora/avc/widget/helper/PictureInPictureHelper$Callback;", "(Landroidx/fragment/app/FragmentActivity;Lio/agora/avc/widget/helper/PictureInPictureHelper$Callback;)V", "value", "", "enable", "getEnable", "()Z", "setEnable", "(Z)V", "isInPictureInPictureMode", "setInPictureInPictureMode", "changeAspectRatioInPicMode", "", "user", "Lio/agora/avc/bo/valoran/ARoomUser;", "enterPictureInPicture", "getCurrentVideoRational", "Landroid/util/Rational;", "getLocalVideoRational", "Landroid/app/Activity;", "getRemoteVideoRational", "videoStats", "Lio/agora/avc/bo/VideoStats;", "onDestroy", "onPictureInPictureModeChanged", "setPictureInPictureParams", "params", "Landroid/app/PictureInPictureParams;", "Callback", "Companion", "app_release"})
public final class PictureInPictureHelper
implements LifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "[UI][PictureInPicture]";
    @Nullable
    private FragmentActivity activity;
    @Nullable
    private Callback callback;
    private boolean isInPictureInPictureMode;
    private boolean enable;

    public PictureInPictureHelper(@Nullable FragmentActivity fragmentActivity, @Nullable Callback callback) {
        this.activity = fragmentActivity;
        this.callback = callback;
        this.enable = true;
    }

    public /* synthetic */ PictureInPictureHelper(FragmentActivity fragmentActivity, Callback callback, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            fragmentActivity = null;
        }
        if ((n2 & 2) != 0) {
            callback = null;
        }
        this(fragmentActivity, callback);
    }

    @RequiresApi(value=26)
    private final void setPictureInPictureParams(PictureInPictureParams pictureInPictureParams) {
        PictureInPictureHelper pictureInPictureHelper = pictureInPictureHelper.activity;
        if (pictureInPictureHelper != null) {
            pictureInPictureHelper.setPictureInPictureParams(pictureInPictureParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresApi(value=21)
    private final Rational getCurrentVideoRational() {
        PictureInPictureHelper pictureInPictureHelper;
        Rational rational;
        int n2 = 2;
        Rational rational2 = rational;
        rational = new Rational(360, 640);
        Object object = pictureInPictureHelper.callback;
        if (object == null || (object = object.getMainScreenUser()) == null || !((ARoomUser)object).getVideoState()) {
            pictureInPictureHelper = rational2;
        } else {
            if (a.f((ARoomUser)object) && (rational2 = pictureInPictureHelper.activity) != null) {
                Intrinsics.checkNotNull((Object)rational2);
                pictureInPictureHelper = pictureInPictureHelper.getLocalVideoRational((Activity)rational2);
            } else {
                pictureInPictureHelper = pictureInPictureHelper.getRemoteVideoRational(a.e((ARoomUser)object));
            }
            if (pictureInPictureHelper.doubleValue() > (double)n2) {
                Rational rational3;
                pictureInPictureHelper = rational3;
                rational3 = new Rational(n2, 1);
            } else if (pictureInPictureHelper.doubleValue() < (double)(1.0f / (float)n2)) {
                Rational rational4;
                pictureInPictureHelper = rational4;
                rational4 = new Rational(1, n2);
            }
        }
        Logger.INSTANCE.i(TAG, "Pic in pic mode, screen width:" + pictureInPictureHelper.getNumerator() + " screen height:" + pictureInPictureHelper.getDenominator());
        return pictureInPictureHelper;
    }

    @RequiresApi(value=21)
    private final Rational getLocalVideoRational(Activity activity) {
        int n2 = a0.a(activity);
        n2 = n2 != 0 && n2 != 2 ? 0 : 1;
        Object object = ((PictureInPictureHelper)object).callback;
        object = object == null ? null : Integer.valueOf(object.getResolutionOption());
        if (object != null && (Integer)object == 0) {
            if (n2 != 0) {
                Rational rational;
                object = rational;
                rational = new Rational(360, 640);
            } else {
                Rational rational;
                object = rational;
                rational = new Rational(640, 360);
            }
        } else {
            int n3 = 1;
            if (object != null && (Integer)object == n3) {
                if (n2 != 0) {
                    Rational rational;
                    object = rational;
                    rational = new Rational(480, 640);
                } else {
                    Rational rational;
                    object = rational;
                    rational = new Rational(640, 480);
                }
            } else if (n2 != 0) {
                Rational rational;
                object = rational;
                rational = new Rational(720, 960);
            } else {
                Rational rational;
                object = rational;
                rational = new Rational(960, 720);
            }
        }
        return object;
    }

    public PictureInPictureHelper() {
        this(null, null, 3, null);
    }

    public final boolean isInPictureInPictureMode() {
        return this.isInPictureInPictureMode;
    }

    public final void setInPictureInPictureMode(boolean bl) {
        this.isInPictureInPictureMode = bl;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"in picture in picture mode:", (Object)bl));
    }

    public final boolean getEnable() {
        return this.enable;
    }

    public final void setEnable(boolean bl) {
        this.enable = bl;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"picture in picture enable:", (Object)LogConverter.INSTANCE.enable(bl)));
    }

    public final boolean enterPictureInPicture() {
        boolean bl;
        block7: {
            bl = false;
            if (Build.VERSION.SDK_INT >= 26 && f.a.f()) {
                FragmentActivity fragmentActivity = this.activity;
                if (fragmentActivity == null) break block7;
                PictureInPictureHelper pictureInPictureHelper = this;
                FragmentActivity fragmentActivity2 = fragmentActivity;
                PictureInPictureParams.Builder builder = new PictureInPictureParams.Builder();
                builder.setAspectRatio(this.getCurrentVideoRational());
                bl = fragmentActivity2.enterPictureInPictureMode(builder.build());
                try {
                    pictureInPictureHelper.setInPictureInPictureMode(true);
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.INSTANCE.e(TAG, "start picture in picture model error!", (Throwable)illegalStateException);
                }
            }
        }
        return bl;
    }

    public final void changeAspectRatioInPicMode(@NotNull ARoomUser aRoomUser) {
        Intrinsics.checkNotNullParameter((Object)aRoomUser, (String)"user");
        if (this.isInPictureInPictureMode && aRoomUser.getVideoState()) {
            if (Build.VERSION.SDK_INT >= 26 && f.a.f() && this.activity != null) {
                PictureInPictureParams.Builder builder = new PictureInPictureParams.Builder();
                builder.setAspectRatio(this.getCurrentVideoRational());
                PictureInPictureParams pictureInPictureParams = builder.build();
                Intrinsics.checkNotNullExpressionValue((Object)pictureInPictureParams, (String)"params.build()");
                this.setPictureInPictureParams(pictureInPictureParams);
            }
            return;
        }
    }

    @RequiresApi(value=21)
    @NotNull
    public final Rational getRemoteVideoRational(@NotNull VideoStats videoStats) {
        VideoStats videoStats2 = videoStats;
        Intrinsics.checkNotNullParameter((Object)videoStats2, (String)"videoStats");
        int n2 = videoStats2.getRotation();
        n2 = n2 != 0 && n2 != 2 ? 0 : 1;
        if (videoStats.getWidth() != 0 && videoStats.getHeight() != 0) {
            Rational rational;
            if (n2 != 0) {
                Rational rational2;
                rational = rational2;
                VideoStats videoStats3 = videoStats;
                int n3 = videoStats3.getWidth();
                rational2 = new Rational(n3, videoStats3.getHeight());
            } else {
                Rational rational3;
                rational = rational3;
                VideoStats videoStats4 = videoStats;
                int n4 = videoStats4.getHeight();
                rational3 = new Rational(n4, videoStats4.getWidth());
            }
            return rational;
        }
        return new Rational(360, 640);
    }

    public final void onPictureInPictureModeChanged(boolean bl) {
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"onPictureInPictureModeChanged: open = ", (Object)bl));
        this.setInPictureInPictureMode(bl);
    }

    public final void onDestroy() {
        PictureInPictureHelper pictureInPictureHelper = this;
        pictureInPictureHelper.activity = null;
        pictureInPictureHelper.callback = null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/agora/avc/widget/helper/PictureInPictureHelper$Callback;", "", "getMainScreenUser", "Lio/agora/avc/bo/valoran/ARoomUser;", "getResolutionOption", "", "app_release"})
    public static interface Callback {
        public int getResolutionOption();

        @Nullable
        public ARoomUser getMainScreenUser();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/agora/avc/widget/helper/PictureInPictureHelper$Companion;", "", "()V", "TAG", "", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

