/*
 * Decompiled with CFR 0.152.
 */
package io.agora.common;

import io.agora.common.Logging;
import io.agora.rtm.internal.RtmSdkContext;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

public class AgoraServiceJNI {
    private static final String TAG = "AgoraServiceJNI";
    private static boolean isNativeInitialized = false;

    public static boolean ensureNativeInitialized() {
        if (!isNativeInitialized) {
            System.loadLibrary(RtmSdkContext.getLibraryName());
            isNativeInitialized = AgoraServiceJNI.nativeClassInit() == 0;
        }
        return isNativeInitialized;
    }

    private static native int nativeClassInit();

    private static native int nativeClassDestroy();

    public static native long createRtmService(String var0, String var1, String var2, String var3, String var4, String var5, String var6);

    public static native void deleteRtmService(long var0);

    public static native int nativeLog(int var0, String var1);

    public static native String nativeGetSdkVersion();

    public static native long newPointerArray(int var0);

    public static native void deletePointerArray(long var0);

    public static native void setPointerArrayElement(long var0, int var2, long var3);

    public static native long getPointerArrayElement(long var0, int var2);

    public static native long newCharArray(int var0);

    public static native void deleteCharArray(long var0);

    public static native void setCharArrayElement(long var0, int var2, byte var3);

    public static native Byte getCharArrayElement(long var0, int var2);

    public static final native long newLongLongPointer();

    public static final native void deleteLongLongPointer(long var0);

    public static final native long dereferenceLongLongPointer(long var0);

    protected static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getLocalHost() {
        try {
            for (Object object : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (((NetworkInterface)object).getName().startsWith("usb")) continue;
                object = Collections.list(((NetworkInterface)object).getInetAddresses()).iterator();
                while (object.hasNext()) {
                    String string2 = AgoraServiceJNI.inetAddressToIpAddress((InetAddress)object.next());
                    if (string2 == null || string2.isEmpty()) continue;
                    return string2;
                }
            }
            return null;
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected static String[] getLocalHostList() {
        v0 = Collections.list(NetworkInterface.getNetworkInterfaces());
        var0 = v1;
        v1 = new ArrayList();
        var1_1 = v0.iterator();
        block15: while (true) {
            if (!var1_1.hasNext()) break;
            var2_3 = (NetworkInterface)var1_1.next();
            if (var2_3.getName().startsWith("usb")) continue;
            var2_3 = Collections.list(var2_3.getInetAddresses()).iterator();
            while (true) {
                if (var2_3.hasNext()) ** break;
                continue block15;
                var3_4 = AgoraServiceJNI.inetAddressToIpAddress((InetAddress)var2_3.next());
                if (var3_4 == null) continue;
                var0.add(var3_4);
            }
            break;
        }
        try {
            ** if (var0.isEmpty()) goto lbl-1000
        }
        catch (Exception v3) {}
lbl-1000:
        // 1 sources

        {
            v2 = var0;
            var0 = new String[var0.size()];
            var1_2 = 0;
            var2_3 = v2.iterator();
            while (true) {
                if (!var2_3.hasNext()) break;
                var0[var1_2] = (String)var2_3.next();
                ++var1_2;
                continue;
                break;
            }
            return var0;
        }
lbl-1000:
        // 1 sources

        {
        }
        return null;
    }

    protected static byte[] stringToUtf8(String string2) {
        if (string2 != null) {
            try {
                return string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logging.e(TAG, "failed to encode string to UTF-8: " + unsupportedEncodingException.getMessage());
            }
        }
        return null;
    }

    protected static String utf8ToString(byte[] byArray) {
        if (byArray != null) {
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logging.e(TAG, "failed to construct a string from UTF-8: " + unsupportedEncodingException.getMessage());
            }
        }
        return null;
    }

    private static String inetAddressToIpAddress(InetAddress inetAddress) {
        if (!inetAddress.isLoopbackAddress()) {
            if (inetAddress instanceof Inet4Address) {
                return ((Inet4Address)inetAddress).getHostAddress();
            }
            boolean cfr_ignored_0 = inetAddress instanceof Inet6Address;
        }
        return null;
    }

    static {
        AgoraServiceJNI.ensureNativeInitialized();
    }
}

