/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTrack;
import android.media.MediaRouter;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.LocaleList;
import android.os.Process;
import android.util.DisplayMetrics;
import io.agora.rtc.audio.HardwareEarbackController;
import io.agora.rtc.audio.VolumeBroadcastReceiver;
import io.agora.rtc.internal.Logging;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

class AudioDevice {
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    final String TAG;
    private final int _MaxRecPlay10msBlocks;
    private AudioTrack _audioTrack;
    private AudioRecord _audioRecord;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock;
    private final ReentrantLock _recLock;
    private boolean _doPlayInit;
    private boolean _doRecInit;
    private boolean _isRecording;
    private boolean _isPlaying;
    private long previous_time_ms;
    private long current_time_ms;
    private long _currentTotalPostion;
    private long _framePostion;
    private int _bufferedRecSamples;
    private int _bufferedPlaySamples;
    private int _playPosition;
    private int _playbackSampleRate;
    private int _playBufSize;
    private int _playbackRestartCount;
    private int _recordSampleRate;
    private int _recordChannel;
    private int _playChannel;
    private int _recordBufSize;
    private int _recordSource;
    private int _recordRestartCount;
    private boolean _renderStart;
    private long _firstRenderTS;
    private int _playPreviousUnderrun;
    private long _recDelay;
    private long _lastRecDelay;
    private long _recStartTS;
    private int _recStartDelay;
    private int _sdkVer;
    private long _recPosition;
    private long[] _audioStatistic;
    private final int POSITION_PLAY_APP;
    private final int POSITION_PLAY_SYS;
    private final int LAST_WRITE_TIME;
    private final int POSITION_REC_APP;
    private final int POSITION_REC_SYS;
    private final int LAST_READ_TIME;
    private AcousticEchoCanceler aec;
    private boolean useBuiltInAEC;
    private int _streamType;
    private int playWriten;
    private int maxDelay;
    private int totalDelay;
    private long mNativeHandle;
    private int currentPlayoutVolume;
    private VolumeBroadcastReceiver mVolumeBroadcastReceiver;

    AudioDevice(long l2) {
        AudioDevice audioDevice = audioDevice2;
        audioDevice2.TAG = "AudioDevice Java";
        audioDevice2._MaxRecPlay10msBlocks = 4;
        audioDevice2._audioTrack = null;
        audioDevice2._audioRecord = null;
        audioDevice2._playLock = new ReentrantLock();
        audioDevice2._recLock = new ReentrantLock();
        audioDevice2._doPlayInit = true;
        audioDevice2._doRecInit = true;
        audioDevice2._isRecording = false;
        audioDevice2._isPlaying = false;
        audioDevice2.previous_time_ms = 0L;
        audioDevice2.current_time_ms = 0L;
        audioDevice2._currentTotalPostion = 0L;
        audioDevice2._framePostion = 0L;
        audioDevice2._bufferedRecSamples = 0;
        audioDevice2._bufferedPlaySamples = 0;
        audioDevice2._playPosition = 0;
        audioDevice2._playbackSampleRate = 0;
        audioDevice2._playBufSize = 0;
        audioDevice2._playbackRestartCount = 0;
        audioDevice2._recordSampleRate = 0;
        audioDevice2._recordChannel = 0;
        audioDevice2._playChannel = 0;
        audioDevice2._recordBufSize = 0;
        audioDevice2._recordSource = 0;
        audioDevice2._recordRestartCount = 0;
        audioDevice2._renderStart = false;
        audioDevice2._firstRenderTS = 0L;
        audioDevice2._playPreviousUnderrun = 0;
        audioDevice2._recDelay = 10L;
        audioDevice2._lastRecDelay = 0L;
        audioDevice2._recStartTS = 0L;
        audioDevice2._recStartDelay = 0;
        audioDevice2._sdkVer = Build.VERSION.SDK_INT;
        audioDevice2._recPosition = 0L;
        audioDevice2._audioStatistic = new long[6];
        audioDevice2.POSITION_PLAY_APP = 0;
        audioDevice2.POSITION_PLAY_SYS = 1;
        audioDevice2.LAST_WRITE_TIME = 2;
        audioDevice2.POSITION_REC_APP = 3;
        audioDevice2.POSITION_REC_SYS = 4;
        audioDevice2.LAST_READ_TIME = 5;
        audioDevice2.aec = null;
        audioDevice2.useBuiltInAEC = false;
        audioDevice2._streamType = 0;
        audioDevice2.playWriten = 0;
        audioDevice2.maxDelay = 0;
        audioDevice2.totalDelay = 0;
        audioDevice2.mNativeHandle = 0L;
        audioDevice2.currentPlayoutVolume = -1;
        audioDevice2.mVolumeBroadcastReceiver = null;
        audioDevice.mNativeHandle = l2;
        try {
            audioDevice._playBuffer = ByteBuffer.allocateDirect(7680);
            audioDevice._recBuffer = ByteBuffer.allocateDirect(7680);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "failed to allocate bytebuffer", exception);
        }
        audioDevice2._tempBufPlay = new byte[7680];
        audioDevice2._tempBufRec = new byte[7680];
        AudioDevice audioDevice2 = audioDevice2._context;
        if (audioDevice2 != null) {
            HardwareEarbackController.getInstance((Context)audioDevice2);
        }
    }

    private boolean BuiltInAECIsAvailable() {
        block4: {
            if (Build.VERSION.SDK_INT < 17) break block4;
            try {
                return AcousticEchoCanceler.isAvailable();
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "Unable to query Audio Effect: Acoustic Echo Cancellation");
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                Logging.e("AudioDevice Java", "Unable to create AEC object ", exceptionInInitializerError);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int GetPreferedSampleRate() {
        int n2 = 0;
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            n2 = Integer.parseInt(this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE"));
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "GetPreferedSampleRate error", exception);
        }
        if (n2 != 0) return n2;
        return 16000;
    }

    private boolean EnableBuiltInAEC(boolean bl) {
        if (Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        this.useBuiltInAEC = bl;
        AcousticEchoCanceler acousticEchoCanceler = this.aec;
        if (acousticEchoCanceler != null) {
            if (acousticEchoCanceler.setEnabled(bl) != 0) {
                Logging.e("AudioDevice Java", "AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private boolean BuiltInAECIsEnabled() {
        return this.useBuiltInAEC;
    }

    private int InitRecording(int n2, int n3, int n4) {
        AcousticEchoCanceler acousticEchoCanceler;
        int n5;
        block10: {
            int n6;
            this._recLock.lock();
            n5 = n4 == 2 ? 12 : 16;
            int n7 = n3;
            n5 = AudioRecord.getMinBufferSize((int)n7, (int)n5, (int)2);
            Logging.d("AudioDevice Java", "Java minimum recording buffer size is " + n5);
            this._bufferedRecSamples = n7 * 5 / 200;
            AcousticEchoCanceler acousticEchoCanceler2 = this.aec;
            if (acousticEchoCanceler2 != null) {
                acousticEchoCanceler2.release();
                this.aec = null;
            }
            if ((acousticEchoCanceler2 = this._audioRecord) != null) {
                acousticEchoCanceler2.release();
                this._audioRecord = null;
            }
            try {
                n6 = n4 == 2 ? 12 : 16;
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "Unable to new AudioRecord: ", exception);
                this._recLock.unlock();
                return -1;
            }
            AcousticEchoCanceler acousticEchoCanceler3 = acousticEchoCanceler2;
            acousticEchoCanceler3(n2, n3, n6, 2, n5);
            this._audioRecord = acousticEchoCanceler3;
            if (acousticEchoCanceler2.getState() == 1) break block10;
            Logging.e("AudioDevice Java", "Java recording not initialized " + n3);
            this._recLock.unlock();
            return -2;
        }
        this._recordSampleRate = n3;
        this._recordChannel = n4;
        this._recordSource = n2;
        this._recordBufSize = n5;
        this._recordRestartCount = 0;
        Logging.d("AudioDevice Java", "Java recording sample rate set to " + n3);
        Logging.d("AudioDevice Java", "AcousticEchoCanceler.isAvailable: " + this.BuiltInAECIsAvailable());
        if (!this.BuiltInAECIsAvailable()) {
            AudioDevice audioDevice = this;
            audioDevice._recLock.unlock();
            return audioDevice._bufferedRecSamples;
        }
        this.aec = acousticEchoCanceler = AcousticEchoCanceler.create((int)this._audioRecord.getAudioSessionId());
        if (acousticEchoCanceler == null) {
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.create failed");
        } else {
            if ((acousticEchoCanceler = acousticEchoCanceler.getDescriptor()) == null) {
                Logging.e("AudioDevice Java", "getDescriptor() failed");
            } else {
                Logging.d("AudioDevice Java", "AcousticEchoCanceler name: " + acousticEchoCanceler.name + ", implementor: " + acousticEchoCanceler.implementor + ", uuid: " + acousticEchoCanceler.uuid);
            }
            AudioDevice audioDevice = this;
            audioDevice.EnableBuiltInAEC(audioDevice.useBuiltInAEC);
        }
        AudioDevice audioDevice = this;
        audioDevice._recLock.unlock();
        return audioDevice._bufferedRecSamples;
    }

    /*
     * Exception decompiling
     */
    private int StartRecording() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [9 : 98->108)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private int CheckAudioStatus(int n2) {
        Context context;
        int n3 = 0;
        if (Build.VERSION.SDK_INT < 24) return n3;
        if (((AudioDevice)((Object)iterator))._audioManager == null) {
            context = ((AudioDevice)((Object)iterator))._context;
            if (context == null) {
                Logging.e("AudioDevice Java", "CheckAudioStatus error");
                return -1;
            }
            ((AudioDevice)((Object)iterator))._audioManager = (AudioManager)context.getSystemService("audio");
        }
        if (n2 != 0) return n3;
        n2 = Process.myUid();
        if (((AudioDevice)((Object)iterator))._context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), n2) == 0) {
            n2 = Process.myUid();
            if (((AudioDevice)((Object)iterator))._context.checkPermission("android.permission.MODIFY_AUDIO_SETTINGS", Process.myPid(), n2) == 0) {
                if (((AudioDevice)((Object)iterator))._audioManager == null) {
                    Logging.e("AudioDevice Java", "CheckAudioStatus unkonwn error");
                    return -1;
                }
                n2 = -1;
                context = ((AudioDevice)((Object)iterator))._audioRecord;
                if (context != null) {
                    n2 = context.getAudioSessionId();
                }
                Iterator iterator = ((AudioDevice)((Object)iterator))._audioManager.getActiveRecordingConfigurations().iterator();
                while (iterator.hasNext()) {
                    if (((AudioRecordingConfiguration)iterator.next()).getClientAudioSessionId() == n2) continue;
                    n3 = 1033;
                }
                return n3;
            }
        }
        Logging.e("AudioDevice Java", "CheckAudioStatus Microphone Permission denied");
        return 2;
    }

    private int InitPlayback(int n2, int n3, int n4, int n5) {
        Context context;
        block8: {
            AudioDevice audioDevice;
            int n6;
            this._playLock.lock();
            this._streamType = n4;
            n4 = n5 * n2 * n3 * 2 / 1000;
            n5 = n3 == 2 ? 12 : 4;
            n5 = AudioTrack.getMinBufferSize((int)n2, (int)n5, (int)2);
            Logging.d("AudioDevice Java", "Java minimum playback buffer size is " + n5 + ", profiledMiniOutBufferSize is " + n4 + " stream type " + this._streamType);
            if (n5 < n4) {
                n5 = n4;
            }
            this._bufferedPlaySamples = 0;
            this._currentTotalPostion = 0L;
            Logging.d("AudioDevice Java", "Java playback buffer size is " + n5 + ", duration is " + n5 * 1000 / (n2 * n3 * 2) + " ms");
            AudioTrack audioTrack = this._audioTrack;
            if (audioTrack != null) {
                audioTrack.release();
                this._audioTrack = null;
            }
            try {
                n6 = n3;
                audioDevice = this;
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "Unable to new AudioTrack: ", exception);
                this._playLock.unlock();
                return -1;
            }
            int n7 = audioDevice._streamType;
            int n8 = n6 == 2 ? 12 : 4;
            AudioTrack audioTrack2 = audioTrack;
            audioTrack2(n7, n2, n8, 2, n5, 1);
            this._audioTrack = audioTrack2;
            this._playbackSampleRate = n2;
            this._playChannel = n3;
            this._playBufSize = n5;
            this._playbackRestartCount = 0;
            if (audioTrack.getState() == 1) break block8;
            Logging.e("AudioDevice Java", "Java playback not initialized " + n2);
            this._playLock.unlock();
            return -1;
        }
        Logging.d("AudioDevice Java", "Java play sample rate is set to " + n2);
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this._playLock.unlock();
            return 0;
        }
        AudioDevice audioDevice = this;
        audioDevice._playLock.unlock();
        return audioDevice._audioManager.getStreamMaxVolume(this._streamType);
    }

    /*
     * Exception decompiling
     */
    private int StartPlayback() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 69->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int StopRecording() {
        Throwable throwable22;
        block9: {
            block8: {
                AudioRecord audioRecord;
                AudioDevice audioDevice = this;
                audioDevice._recLock.lock();
                try {
                    if (audioDevice._audioRecord.getRecordingState() == 3) {
                        this._audioRecord.stop();
                    }
                    if (this.aec != null) {
                        this.aec.release();
                        this.aec = null;
                    }
                    this._audioRecord.release();
                    audioRecord = null;
                    AudioDevice audioDevice2 = this;
                    audioDevice2._audioRecord = audioRecord;
                    audioDevice2._isRecording = false;
                }
                catch (Throwable throwable22) {
                    break block9;
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "error in StopRecording ", exception);
                    audioRecord = this._audioRecord;
                    if (audioRecord == null) break block8;
                    audioRecord.release();
                    this._audioRecord = null;
                }
            }
            this._doRecInit = true;
            this._recLock.unlock();
            return 0;
        }
        AudioRecord audioRecord = this._audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this._audioRecord = null;
        }
        this._doRecInit = true;
        this._recLock.unlock();
        throw throwable22;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int StopPlayback() {
        block11: {
            block12: {
                this._firstRenderTS = 0L;
                this._isPlaying = false;
                this._playLock.lock();
                if (Build.VERSION.SDK_INT < 21) ** GOTO lbl-1000
                v0 = this._audioTrack.setVolume(0.0f);
                ** GOTO lbl31
                {
                    block13: {
                        catch (Throwable var1_2) {
                            break block11;
                        }
                        catch (Exception var1_3) {
                            Logging.e("AudioDevice Java", "Stop playback fail", var1_3);
                            var1_1 = this._audioTrack;
                            if (var1_1 != null) {
                                var1_1.flush();
                                this._audioTrack.release();
                                this._audioTrack = null;
                            }
                            break block12;
                        }
                        catch (IllegalStateException var1_4) {}
                        {
                            Logging.e("AudioDevice Java", "Unable to stop playback: ", var1_4);
                            var1_5 = -1;
                            var2_6 = this._audioTrack;
                            if (var2_6 == null) break block13;
                        }
                        var2_6.flush();
                        this._audioTrack.release();
                        this._audioTrack = null;
                    }
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return var1_5;
                }
lbl-1000:
                // 1 sources

                {
                    v0 = this._audioTrack.setStereoVolume(0.0f, 0.0f);
lbl31:
                    // 2 sources

                    if (this._audioTrack.getPlayState() == 3) {
                        v1 = this;
                        v1._audioTrack.stop();
                        v1._audioTrack.flush();
                    }
                    this._audioTrack.release();
                    var1_1 = null;
                }
                {
                    this._audioTrack = var1_1;
                }
            }
            this._doPlayInit = true;
            this._playLock.unlock();
            this.monitorPlayoutVolumeChange(false);
            return 0;
        }
        var2_7 = this._audioTrack;
        if (var2_7 != null) {
            var2_7.flush();
            this._audioTrack.release();
            this._audioTrack = null;
        }
        this._doPlayInit = true;
        this._playLock.unlock();
        throw var1_2;
    }

    private int getPlayBufferMs() {
        int n2;
        int n3 = this._playbackSampleRate;
        if (n3 != 0 && (n2 = this._playChannel) != 0) {
            return this._playBufSize / (n2 * 2) * 1000 / n3;
        }
        return 10;
    }

    /*
     * Exception decompiling
     */
    private int PlayNoBlockAudio(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 41[TRYBLOCK] [80 : 652->663)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int PlayAudio(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 39[TRYBLOCK] [76 : 561->571)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int RecordAudio(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 40[TRYBLOCK] [78 : 647->656)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int GetUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.GetUnderrunCountOnNougatOrHigher();
        }
        return this.GetUnderrunCountOnLowerThanNougat();
    }

    @TargetApi(value=24)
    private int GetUnderrunCountOnNougatOrHigher() {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                n3 = this._audioTrack.getUnderrunCount();
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "getUnderrun fail ", exception);
            }
            n2 = n3 - this._playPreviousUnderrun;
            if (n2 < 0) {
                n2 = 0;
            }
            this._playPreviousUnderrun = n3;
            if (n2 > 0) {
                Logging.d("AudioDevice Java", "Android AudioTrack underrun count: " + n2);
            }
        }
        return n2;
    }

    private int GetUnderrunCountOnLowerThanNougat() {
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int QuerySpeakerStatus() {
        Context context;
        block16: {
            Configuration configuration;
            AudioDevice audioDevice;
            AudioDevice audioDevice2;
            AudioDevice audioDevice3;
            if (this._audioManager == null && (context = this._context) != null) {
                this._audioManager = (AudioManager)context.getSystemService("audio");
            }
            try {
                if (Build.VERSION.SDK_INT < 26) break block16;
                context = ((MediaRouter)this._context.getSystemService("media_router")).getSelectedRoute(1);
            }
            catch (Exception exception) {
                Logging.e("error in Query audio route ");
                exception.printStackTrace();
                break block16;
            }
            {
                AudioDevice audioDevice4 = this;
                audioDevice3 = audioDevice4;
                audioDevice2 = audioDevice4;
                audioDevice = audioDevice4;
                context.getName().toString().compareToIgnoreCase("phone");
            }
            {
                configuration = audioDevice2._context.getResources().getConfiguration();
            }
            {
                LocaleList localeList = configuration.getLocales();
                DisplayMetrics displayMetrics = this._context.getResources().getDisplayMetrics();
                configuration.setLocale(Locale.ENGLISH);
                int n2 = -1;
                audioDevice._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (context.getName(audioDevice3._context).toString().compareToIgnoreCase("phone") == 0) {
                    Logging.e("AudioDevice Java", "speaker");
                } else if (context.getName(this._context).toString().compareToIgnoreCase("headset") == 0) {
                    Logging.e("AudioDevice Java", "headset");
                    n2 = 0;
                } else if (context.getName(this._context).toString().compareToIgnoreCase("bluetooth") == 0) {
                    Logging.e("AudioDevice Java", "bluetooth");
                    n2 = 5;
                }
                configuration.setLocales(localeList);
                this._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (n2 == -1) break block16;
                return n2;
            }
        }
        if ((context = this._audioManager) == null) {
            Logging.e("AudioDevice Java", "Could not get audio routing - no audio manager");
            return -1;
        }
        if (context.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this._audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        if (this._audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this._audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        if ((this = this._audioManager) == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        this.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetPlayoutVolume(int n2) {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        int n3 = -1;
        AudioManager audioManager = this._audioManager;
        if (audioManager != null) {
            n3 = audioManager.getStreamMaxVolume(this._streamType);
            if (n2 < 255) {
                n3 = n2 * n3 / 255;
            }
            this._audioManager.setStreamVolume(this._streamType, n3, 0);
            n3 = 0;
        }
        return n3;
    }

    private int GetPlayoutVolume() {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        int n2 = -1;
        AudioManager audioManager = this._audioManager;
        if (audioManager != null) {
            n2 = audioManager.getStreamVolume(this._streamType);
        }
        return n2;
    }

    private int GetPlayoutMaxVolume() {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        int n2 = -1;
        AudioManager audioManager = this._audioManager;
        if (audioManager != null) {
            n2 = audioManager.getStreamMaxVolume(this._streamType);
        }
        return n2;
    }

    /*
     * Exception decompiling
     */
    private int SetAudioMode(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CASE]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int GetAudioMode() {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        if ((this = this._audioManager) == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        return this.getMode();
    }

    private int GetNativeSampleRate() {
        Context context;
        int n2 = 44100;
        if (((AudioDevice)this)._audioManager == null && (context = ((AudioDevice)this)._context) != null) {
            ((AudioDevice)this)._audioManager = (AudioManager)context.getSystemService("audio");
        }
        if ((this = ((AudioDevice)this)._audioManager) == null) {
            Logging.w("AudioDevice Java", "Could not set audio mode - no audio manager");
            return n2;
        }
        if (Build.VERSION.SDK_INT >= 17 && (this = this.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) != null) {
            n2 = Integer.parseInt((String)this);
        }
        return n2;
    }

    private int GetNativePlayDelay() {
        if (this._recDelay < 0L) {
            this._recDelay = -1L;
        }
        if (this.totalDelay < 0) {
            this.totalDelay = -1;
        }
        return this.totalDelay + (int)this._recDelay;
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        Context context = this._context;
        if (context != null) {
            bl = HardwareEarbackController.getInstance(context).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl);
        int n2 = HardwareEarbackController.getInstance(this._context).enableHardwareEarback(bl);
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl + " ret " + n2);
        return n2;
    }

    private int setHardwareEarbackVolume(int n2) {
        int n3 = -1;
        Context context = this._context;
        if (context != null) {
            n3 = HardwareEarbackController.getInstance(context).setHardwareEarbackVolume(n2);
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void monitorPlayoutVolumeChange(boolean bl) {
        block10: {
            Context context;
            if (bl) {
                IntentFilter intentFilter;
                VolumeBroadcastReceiver volumeBroadcastReceiver;
                AudioDevice audioDevice;
                if (audioDevice5.mVolumeBroadcastReceiver != null) return;
                try {
                    AudioDevice audioDevice2 = audioDevice5;
                    AudioDevice audioDevice3 = audioDevice2;
                    audioDevice = audioDevice2;
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "Unable to create VolumeBroadcastReceiver, ", exception);
                    return;
                }
                VolumeBroadcastReceiver volumeBroadcastReceiver2 = volumeBroadcastReceiver;
                audioDevice3.mVolumeBroadcastReceiver = new VolumeBroadcastReceiver(audioDevice5);
                Context context2 = audioDevice._context;
                if (context2 == null || volumeBroadcastReceiver2 == null) return;
                Context context3 = context2;
                AudioDevice audioDevice4 = audioDevice5;
                AudioDevice audioDevice5 = intentFilter;
                new IntentFilter().addAction(VOLUME_CHANGED_ACTION);
                context3.registerReceiver((BroadcastReceiver)audioDevice4.mVolumeBroadcastReceiver, (IntentFilter)audioDevice5);
                return;
            }
            try {
                context = audioDevice5._context;
                if (context == null) break block10;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (audioDevice5.mVolumeBroadcastReceiver == null) break block10;
            context.unregisterReceiver((BroadcastReceiver)audioDevice5.mVolumeBroadcastReceiver);
        }
        audioDevice5.mVolumeBroadcastReceiver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyPlayoutVolumeChange() {
        AudioDevice audioDevice = this;
        synchronized (audioDevice) {
            int n2 = audioDevice.GetPlayoutVolume();
            if (audioDevice.currentPlayoutVolume != n2) {
                AudioDevice audioDevice2 = this;
                audioDevice2.nativeNotifyPlayoutVolumeChange(audioDevice2.mNativeHandle, n2);
                this.currentPlayoutVolume = n2;
                Logging.i("AudioDevice Java", " notifyPlayoutVolumeChange: " + n2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    native void nativeNotifyPlayoutVolumeChange(long var1, int var3);
}

