/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.audio.ReflectUtils;
import io.agora.rtc.internal.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class HuaweiHardwareEarback
implements IHardwareEarback {
    private static final String TAG = "HuaweiHardwareEarback";
    private Context mContext;
    private Object mHwAudioKit;
    private Object mHwAudioKaraokeFeatureKit;
    private boolean mInited;
    private boolean mEarbackEnabled;
    private int latency;
    private int volume;
    Class clsHwAudioKit;
    Class clsAudioKitCallback;
    Class clsHwAudioKaraokeFeatureKit;
    private boolean mClsInited;

    public HuaweiHardwareEarback(Context context) {
        HuaweiHardwareEarback huaweiHardwareEarback = this;
        huaweiHardwareEarback.mContext = null;
        huaweiHardwareEarback.mHwAudioKit = null;
        huaweiHardwareEarback.mHwAudioKaraokeFeatureKit = null;
        huaweiHardwareEarback.mInited = false;
        huaweiHardwareEarback.mEarbackEnabled = false;
        huaweiHardwareEarback.latency = 0;
        huaweiHardwareEarback.volume = 0;
        huaweiHardwareEarback.clsHwAudioKit = null;
        huaweiHardwareEarback.clsAudioKitCallback = null;
        huaweiHardwareEarback.clsHwAudioKaraokeFeatureKit = null;
        huaweiHardwareEarback.mClsInited = false;
        Logging.d(TAG, ">>ctor");
        huaweiHardwareEarback.mContext = context;
        huaweiHardwareEarback.initialize();
    }

    public static boolean hasHwAudioKitClass() {
        Class clazz = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
        Class clazz2 = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
        return ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback") != null && clazz != null && clazz2 != null;
        {
        }
    }

    static /* synthetic */ boolean access$002(HuaweiHardwareEarback huaweiHardwareEarback, boolean bl) {
        huaweiHardwareEarback.mInited = bl;
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() {
        Object object;
        block27: {
            block26: {
                Object[] objectArray;
                Class clazz;
                GenericDeclaration genericDeclaration;
                block25: {
                    Class[] classArray;
                    Class clazz2;
                    if (this.mContext == null) {
                        Logging.e(TAG, "mContext is null!");
                        return;
                    }
                    Logging.d(TAG, ">>initialize");
                    this.clsHwAudioKit = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
                    this.clsAudioKitCallback = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback");
                    object = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
                    this.clsHwAudioKaraokeFeatureKit = object;
                    genericDeclaration = this.clsAudioKitCallback;
                    if (genericDeclaration == null) return;
                    if (this.clsHwAudioKit == null) return;
                    if (object == null) {
                        return;
                    }
                    object = Proxy.newProxyInstance(genericDeclaration.getClassLoader(), new Class[]{this.clsAudioKitCallback}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            if (method.getName().equals("onResult")) {
                                int n2 = (Integer)objectArray[0];
                                if (n2 != 0) {
                                    if (n2 != 2) {
                                        if (n2 != 1000) {
                                            Logging.e(HuaweiHardwareEarback.TAG, "IAudioKitCallback: onResult error number " + n2);
                                        } else {
                                            HuaweiHardwareEarback.access$002(HuaweiHardwareEarback.this, true);
                                            Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKaraokeFeatureKit init success ");
                                        }
                                    } else {
                                        Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: audio kit not installed");
                                    }
                                } else {
                                    Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKit init success");
                                }
                            }
                            return null;
                        }
                    });
                    genericDeclaration = null;
                    try {
                        clazz2 = this.clsHwAudioKit;
                        classArray = new Class[2];
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                        break block25;
                    }
                    {
                        classArray[0] = Context.class;
                        int n2 = 1;
                        classArray[n2] = this.clsAudioKitCallback;
                        genericDeclaration = clazz2.getConstructor(classArray);
                    }
                }
                if (genericDeclaration == null) {
                    Logging.e(TAG, "find HwAudioKit constructor failed");
                    return;
                }
                try {
                    HuaweiHardwareEarback huaweiHardwareEarback = this;
                    clazz = genericDeclaration;
                    objectArray = new Object[2];
                    int n3 = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break block26;
                }
                {
                    objectArray[n3] = this.mContext;
                    objectArray[1] = object;
                    huaweiHardwareEarback.mHwAudioKit = ((Constructor)((Object)clazz)).newInstance(objectArray);
                }
            }
            if (this.mHwAudioKit == null) {
                Logging.e(TAG, "create HwAudioKit failed");
                return;
            }
            try {
                object = this.clsHwAudioKit.getMethod("initialize", new Class[0]);
                if (object == null) break block27;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                Logging.e(TAG, "create HwAudioKit initialize failed");
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                Logging.e(TAG, "create HwAudioKit initialize failed");
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                Logging.e(TAG, "create HwAudioKit initialize failed");
                return;
            }
            {
                ((Method)object).invoke(this.mHwAudioKit, new Object[0]);
            }
        }
        if ((object = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit$FeatureType")) == null) {
            Logging.e(TAG, "cannot find class  HwAudioKit$FeatureType initialize failed");
            return;
        }
        Object var2_4 = null;
        if (((Class)object).isEnum()) {
            var2_4 = ((Class)object).getEnumConstants()[0];
        }
        if (var2_4 == null) {
            Logging.e(TAG, "cannot find class  HwAudioKit$FeatureType initialize failed");
            return;
        }
        Method method = null;
        try {
            method = this.clsHwAudioKit.getMethod("createFeature", new Class[]{object});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        if (method == null) {
            Logging.e(TAG, "cannot find method createFeature ");
            return;
        }
        try {
            this.mHwAudioKaraokeFeatureKit = method.invoke(this.mHwAudioKit, var2_4);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (this.mHwAudioKaraokeFeatureKit == null) {
            Logging.e(TAG, " createFeature failed");
            return;
        }
        this.mClsInited = true;
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        if (this.mInited && this.mClsInited) {
            Logging.d(TAG, ">>isHardwareEarbackSupported");
            boolean bl = false;
            Class clazz = this.clsHwAudioKaraokeFeatureKit;
            Object object = this.mHwAudioKaraokeFeatureKit;
            try {
                bl = (Boolean)ReflectUtils.safeCallMethod(clazz, object, "isKaraokeFeatureSupport", new Class[0], new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Logging.d(TAG, "isSupported " + bl);
            return bl;
        }
        return false;
    }

    @Override
    public synchronized int setHardwareEarbackVolume(int n2) {
        if (this.mInited && this.mClsInited) {
            Logging.d(TAG, ">>setHardwareEarbackVolume " + n2);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 100) {
                n2 = 100;
            }
            int n3 = -1;
            Class clazz = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit$ParameName");
            if (clazz == null) {
                Logging.e(TAG, "cannot find method  ParameName.getParameName");
                return -1;
            }
            Method method = ReflectUtils.safeGetMethod(clazz, "getParameName", new Class[0]);
            if (method == null) {
                Logging.e(TAG, "cannot find method  ParameName.getParameName");
                return -1;
            }
            Object var5_6 = null;
            T[] TArray = clazz.getEnumConstants();
            int n4 = TArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Object t2;
                block23: {
                    block22: {
                        Method method2 = method;
                        t2 = TArray[i2];
                        Object object = method2.invoke(t2, new Object[0]);
                        if (object == null) break block22;
                        try {
                            if (((String)object).equals("Karaoke_volume=")) break block23;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                            break;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            break;
                        }
                    }
                    t2 = var5_6;
                }
                var5_6 = t2;
                continue;
            }
            if (var5_6 == null) {
                Logging.e(TAG, "cannot find object  ParameName.CMD_SET_VOCAL_VOLUME_BASE");
                return -1;
            }
            Class clazz2 = this.clsHwAudioKaraokeFeatureKit;
            Object object = this.mHwAudioKaraokeFeatureKit;
            Class[] classArray = new Class[2];
            Class[] classArray2 = classArray;
            Class[] classArray3 = classArray;
            classArray[0] = clazz;
            classArray3[1] = Integer.TYPE;
            Object[] objectArray = new Object[2];
            int n5 = n2;
            objectArray[0] = var5_6;
            int n6 = 1;
            try {
                objectArray[n6] = n5;
                n3 = (Integer)ReflectUtils.safeCallMethod(clazz2, object, "setParameter", classArray2, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n3 != 0) {
                Logging.e(TAG, "setParameter error number " + n3);
                return -1;
            }
            this.volume = n2;
            return 0;
        }
        return -7;
    }

    @Override
    public synchronized int enableEarbackFeature(boolean bl) {
        if (this.mInited && this.mClsInited) {
            Logging.d(TAG, ">>enableEarbackFeature " + bl);
            Object object = new Object[]{};
            object = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "isKaraokeFeatureSupport", new Class[0], (Object[])object);
            if (object != null && object.getClass().equals(Boolean.class)) {
                if (!((Boolean)object).booleanValue()) {
                    Logging.e(TAG, "karaoke not supported");
                    return -1;
                }
                Class[] classArray = new Class[1];
                object = classArray;
                classArray[0] = Boolean.TYPE;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = bl;
                if ((object = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "enableKaraokeFeature", (Class[])object, objectArray2)) != null && object.getClass().equals(Integer.class)) {
                    int n2 = (Integer)object;
                    if (n2 != 0) {
                        Logging.e(TAG, "enableKaraokeFeature failed ret " + n2);
                        return -1;
                    }
                    this.mEarbackEnabled = bl;
                    if (bl) {
                        Object object2 = new Object[]{};
                        if ((object2 = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "getKaraokeLatency", new Class[0], (Object[])object2)) == null || !object2.getClass().equals(Integer.class)) {
                            this.latency = (Integer)object2;
                        }
                        Logging.i(TAG, "latency " + this.latency);
                    }
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return -7;
    }

    @Override
    public void destroy() {
        Logging.d(TAG, ">>destroy");
        Object[] objectArray = objectArray3.mHwAudioKaraokeFeatureKit;
        if (objectArray3.mHwAudioKaraokeFeatureKit != null) {
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{};
            ReflectUtils.safeCallMethod(objectArray3.clsHwAudioKaraokeFeatureKit, objectArray2, "destroy", new Class[0], objectArray);
        }
        if ((objectArray = objectArray3.mHwAudioKit) != null) {
            Object[] objectArray3 = new Object[]{};
            ReflectUtils.safeCallMethod(objectArray3.clsHwAudioKit, objectArray, "destroy", new Class[0], objectArray3);
        }
    }

    protected void finalize() throws Throwable {
        HuaweiHardwareEarback huaweiHardwareEarback = this;
        Logging.d(TAG, ">>finalize");
        huaweiHardwareEarback.destroy();
        super.finalize();
    }
}

