/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.webkit.URLUtil;
import io.agora.rtc.internal.Logging;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MediaCodecAudioDecoder {
    private static final int EXTRACTOR_TIMEOUT_MS = 6000;
    private static final int MAX_DECODER_RETRY_COUNT = 300;
    private static final int HTTP_REQUEST_TIMEOUT = 4000;
    private static final String PREFIX_ASSETS = "/assets/";
    private static final String PREFIX_DOCUMENT = "content://";
    private static final String TAG = "MediaCodec Audio Decoder";
    private Context mContext = null;
    private MediaCodec mMediaCodec = null;
    private MediaExtractorWrapper mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean mDecodedDataReady = false;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private long mFileLength;
    private int mRetryCount = 0;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer mDecodedRAWBuffer;
    private MediaCodec mAACDecoder = null;
    private ByteBuffer mAACOutputBuffer = ByteBuffer.allocateDirect(4096);

    protected static String encodeUrl(String string2) {
        URL uRL;
        URL uRL2;
        URL uRL3;
        URL uRL4;
        URL uRL5;
        URL uRL6;
        URI uRI;
        URI uRI2;
        URL uRL7;
        Logging.d(TAG, "encodedUrl()");
        Object object = uRL7;
        try {
            URI uRI3;
            uRL7 = new URL(string2);
            uRI2 = uRI3;
            uRI = uRI3;
            URL uRL8 = object;
            uRL6 = uRL8;
            uRL5 = uRL8;
            uRL4 = uRL8;
            uRL3 = uRL8;
            uRL2 = uRL8;
            uRL = uRL8;
            object = uRL8.getProtocol();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
        String string3 = uRL3.getUserInfo();
        String string4 = uRL2.getHost();
        int n2 = uRL.getPort();
        String string5 = uRL5.getPath();
        String string6 = uRL4.getQuery();
        String string7 = uRL6.getRef();
        uRI2((String)object, string3, string4, n2, string5, string6, string7);
        return uRI.toASCIIString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean testNetworkUrlAvailable(String string2) {
        Throwable throwable2;
        HttpURLConnection httpURLConnection;
        block7: {
            boolean bl;
            block8: {
                block9: {
                    InputStream inputStream;
                    Logging.d(TAG, "testNetworkUrlAvailable encodedUrl");
                    httpURLConnection = null;
                    httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
                    {
                        catch (Throwable throwable2) {
                            break block7;
                        }
                        catch (Exception exception) {}
                        {
                            exception.printStackTrace();
                            bl = false;
                            if (httpURLConnection == null) return bl;
                            break block8;
                        }
                    }
                    {
                        httpURLConnection.setConnectTimeout(4000);
                        httpURLConnection.setReadTimeout(4000);
                        httpURLConnection.getResponseCode();
                    }
                    {
                        bl = httpURLConnection.getResponseCode() != 404;
                        inputStream = httpURLConnection.getInputStream();
                        if (inputStream == null) break block9;
                    }
                    {
                        inputStream.close();
                    }
                }
                if (httpURLConnection == null) return bl;
            }
            httpURLConnection.disconnect();
            return bl;
        }
        if (httpURLConnection == null) throw throwable2;
        httpURLConnection.disconnect();
        throw throwable2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean createStreaming(int var1_1, long var2_2) {
        block14: {
            block13: {
                var4_3 = this.mExtractor.getTrackCount();
                if (var4_3 >= ++var1_1) break block13;
                return false;
            }
            for (var5_4 = 0; var5_4 < var4_3; ++var5_4) {
                this.mExtractor.unselectTrack(var5_4);
                continue;
            }
            var5_4 = 0;
            var6_5 = false;
            for (var7_6 = 0; var7_6 < var4_3; ++var7_6) {
                v0 = this.mExtractor.getTrackFormat(var7_6);
                this.mTrackFormat = v0;
                if (!v0.getString("mime").contains("audio/") || ++var5_4 != var1_1) continue;
                var6_5 = true;
                break;
            }
            if (!var6_5) {
                Logging.e("MediaCodec Audio Decoder", "the selected audio track won't found");
                return false;
            }
            try {
                v1 = this;
                this.mExtractor.selectTrack(var7_6);
                v1.setCurrentFilePosition(var2_2);
                v1.mChannels = v1.mTrackFormat.getInteger("channel-count");
                var1_1 = v1.mTrackFormat.getInteger("sample-rate");
            }
            catch (Exception v2) {
                Logging.e("MediaCodec Audio Decoder", "Error when creating aac audio file decoder");
                v2.printStackTrace();
                return false;
            }
            this.mSampleRate = var1_1;
            if (var1_1 != 22050) break block14;
            this.mSampleRate = 22000;
            ** GOTO lbl44
        }
        if (var1_1 != 11025) ** GOTO lbl44
        this.mSampleRate = 11000;
lbl44:
        // 3 sources

        this.mFileLength = this.mTrackFormat.getLong("durationUs");
        return true;
    }

    private boolean checkInfoChange() {
        boolean bl;
        int n2;
        int n3;
        block11: {
            block10: {
                MediaFormat mediaFormat;
                block9: {
                    if (Build.VERSION.SDK_INT < 19) {
                        return false;
                    }
                    try {
                        mediaFormat = this.mMediaCodec.getOutputFormat();
                    }
                    catch (Exception exception) {
                        Logging.e(TAG, "Error when checking file's new format");
                        exception.printStackTrace();
                        return false;
                    }
                    n3 = mediaFormat.getInteger("sample-rate");
                    if (n3 == 22050) {
                        n3 = 22000;
                        break block9;
                    }
                    if (n3 != 11025) break block9;
                    n3 = 11000;
                }
                MediaCodecAudioDecoder mediaCodecAudioDecoder = this;
                n2 = mediaFormat.getInteger("channel-count");
                if (mediaCodecAudioDecoder.mSampleRate != n3) break block10;
                if (this.mChannels != n2) break block10;
                bl = false;
                break block11;
            }
            bl = true;
        }
        this.mSampleRate = n3;
        this.mChannels = n2;
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private void cloneByteBuffer(ByteBuffer var1_1) {
        block7: {
            if (this.mDecodedRAWBuffer == null) break block7;
            if (this.mDecodedRAWBuffer.limit() == var1_1.limit()) ** GOTO lbl16
        }
        if (this.mDecodedRAWBuffer == null) ** GOTO lbl15
        v0 = this;
        v1 = v0;
        v0.mDecodedRAWBuffer.clear();
        v1.mDecodedRAWBuffer = null;
lbl15:
        // 2 sources

        this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(var1_1.limit());
lbl16:
        // 2 sources

        v2 = this;
        v3 = v2;
        v2.mDecodedRAWBuffer.position(0);
        try {
            v3.mDecodedRAWBuffer.put(var1_1);
        }
        catch (Exception v4) {
            v4.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void cloneByteBufferByLength(ByteBuffer var1_1, int var2_2) {
        block8: {
            if (this.mDecodedRAWBuffer == null) break block8;
            if (this.mDecodedRAWBuffer.capacity() >= var2_2) ** GOTO lbl16
        }
        if (this.mDecodedRAWBuffer == null) ** GOTO lbl15
        v0 = this;
        v1 = v0;
        v0.mDecodedRAWBuffer.clear();
        v1.mDecodedRAWBuffer = null;
lbl15:
        // 2 sources

        this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(var2_2);
lbl16:
        // 2 sources

        v2 = this;
        v3 = var1_1;
        v4 = var2_2;
        this.mDecodedRAWBuffer.position(0);
        v3.limit(v4);
        try {
            v2.mDecodedRAWBuffer.put(var1_1);
        }
        catch (Exception v5) {
            v5.printStackTrace();
        }
    }

    protected boolean checkUrlEncoded(String string2) {
        try {
            String string3 = string2;
            return TextUtils.equals((CharSequence)string3, (CharSequence)URLDecoder.decode(string3, "UTF-8")) ^ true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createStreaming(String string2) {
        int n2;
        int n3;
        MediaExtractorWrapper mediaExtractorWrapper;
        Object object;
        block17: {
            Logging.i(TAG, "Try to decode audio file : " + string2);
            this.mRetryCount = 0;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                Logging.w(TAG, "Fail to open, empty url");
                return false;
            }
            if (!URLUtil.isNetworkUrl((String)string2) || (object = this.checkUrlEncoded(string2) ? string2 : MediaCodecAudioDecoder.encodeUrl(string2)) != null && MediaCodecAudioDecoder.testNetworkUrlAvailable((String)object)) break block17;
            Logging.w(TAG, "Fail to open, 404 for url");
            return false;
        }
        object = mediaExtractorWrapper;
        Object object2 = object;
        ((MediaExtractorWrapper)object2)();
        this.mExtractor = object2;
        if (!mediaExtractorWrapper.setDataSource(string2)) {
            Logging.w(TAG, "Failed to setDataSource");
            this.releaseStreaming();
            return false;
        }
        int n4 = this.mExtractor.getTrackCount();
        for (n3 = 0; n3 < n4; ++n3) {
            this.mExtractor.unselectTrack(n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            MediaFormat mediaFormat = this.mExtractor.getTrackFormat(n3);
            this.mTrackFormat = mediaFormat;
            String string3 = mediaFormat.getString("mime");
            this.mTrackFormat.setInteger("pcm-encoding", 2);
            if (!string3.contains("audio/")) continue;
            this.mExtractor.selectTrack(n3);
            MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)string3);
            this.mMediaCodec = mediaCodec;
            mediaCodec.configure(this.mTrackFormat, null, null, 0);
            break;
        }
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            MediaCodecAudioDecoder mediaCodecAudioDecoder = this;
            mediaCodecAudioDecoder.mChannels = mediaCodecAudioDecoder.mTrackFormat.getInteger("channel-count");
            n2 = mediaCodecAudioDecoder.mTrackFormat.getInteger("sample-rate");
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when creating aac audio file decoder");
            exception.printStackTrace();
            return false;
        }
        this.mSampleRate = n2;
        if (n2 == 22050) {
            this.mSampleRate = 22000;
        } else if (n2 == 11025) {
            this.mSampleRate = 11000;
        }
        this.mFileLength = this.mTrackFormat.getLong("durationUs");
        return true;
    }

    public boolean selectTrack(int n2) {
        if (this.mExtractor == null) {
            return false;
        }
        return this.createStreaming(n2, this.getCurrentFilePosition());
    }

    public int getTrackNum() {
        MediaExtractorWrapper mediaExtractorWrapper = this.mExtractor;
        if (mediaExtractorWrapper == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = mediaExtractorWrapper.getTrackCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.mExtractor.getTrackFormat(i2).getString("mime").contains("audio/")) continue;
            ++n2;
        }
        return n2;
    }

    public int getChannelCount() {
        return this.mChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    public void setCurrentFilePosition(long l2) {
        this.mExtractor.seekTo(l2, 2);
    }

    public boolean getDecodeDataReadyFlag() {
        return this.mDecodedDataReady;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseStreaming() {
        if (this.mMediaCodec == null) ** GOTO lbl17
        try {
            this.mMediaCodec.stop();
        }
        catch (Exception var1_1) {
            Logging.e("MediaCodec Audio Decoder", "Media decoder stop failed", var1_1);
        }
        try {
            this.mMediaCodec.release();
            ** GOTO lbl16
        }
        catch (Exception var1_2) {
            try {
                Logging.e("MediaCodec Audio Decoder", "Media decoder release failed", var1_2);
lbl16:
                // 2 sources

                this.mMediaCodec = null;
lbl17:
                // 2 sources

                if (this.mExtractor != null) {
                    this.mExtractor.release();
                    this.mExtractor = null;
                }
            }
            catch (Exception v0) {
                Logging.e("MediaCodec Audio Decoder", "Error when releasing audio file stream");
                v0.printStackTrace();
            }
        }
        v1 = this;
        v1.eoOutputStream = false;
        v1.eoInputStream = false;
    }

    public void rewindStreaming() {
        try {
            MediaCodecAudioDecoder mediaCodecAudioDecoder = this;
            mediaCodecAudioDecoder.mExtractor.seekTo(0L, 1);
            mediaCodecAudioDecoder.mMediaCodec.flush();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Error when rewinding audio file stream");
            exception.printStackTrace();
        }
        MediaCodecAudioDecoder mediaCodecAudioDecoder = this;
        mediaCodecAudioDecoder.eoInputStream = false;
        mediaCodecAudioDecoder.eoOutputStream = false;
        mediaCodecAudioDecoder.mDecodedDataReady = false;
    }

    /*
     * Exception decompiling
     */
    public boolean decodeFrame() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[CASE]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkAACSupported() {
        block15: {
            block14: {
                var0_1 = true;
                if (Build.VERSION.SDK_INT < 21) break block14;
                var1_2 = new MediaCodecList(1).getCodecInfos();
                var2_4 = var1_2.length;
                for (var3_6 = 0; var3_6 < var2_4; ++var3_6) {
                    var4_8 = var1_2[var3_6];
                    if (var4_8.isEncoder()) continue;
                    if (!var4_8.getName().toLowerCase().contains("nvidia")) continue;
                    while (true) {
                        var0_1 = false;
                        break block15;
                        break;
                    }
                }
                break block15;
            }
            try {
                var1_3 = MediaCodecList.getCodecCount();
            }
            catch (Exception v0) {
                Logging.e("MediaCodec Audio Decoder", "Error when checking aac codec availability");
                v0.printStackTrace();
                return false;
            }
            for (var2_5 = 0; var2_5 < var1_3; ++var2_5) {
                var3_7 = MediaCodecList.getCodecInfoAt((int)var2_5);
                if (var3_7.isEncoder()) continue;
                if (var3_7.getName().toLowerCase().contains("nvidia")) ** continue;
            }
        }
        return var0_1;
    }

    public boolean createAACStreaming(int n2) {
        block4: {
            MediaFormat mediaFormat;
            MediaCodecAudioDecoder mediaCodecAudioDecoder;
            MediaCodecAudioDecoder mediaCodecAudioDecoder2;
            try {
                MediaCodecAudioDecoder mediaCodecAudioDecoder3 = this;
                mediaCodecAudioDecoder2 = mediaCodecAudioDecoder3;
                mediaCodecAudioDecoder = mediaCodecAudioDecoder3;
                mediaCodecAudioDecoder3.mAACDecoder = MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
                mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)1);
            }
            catch (Exception exception) {
                Logging.e(TAG, "Error when creating aac decode stream");
                exception.printStackTrace();
                return false;
            }
            mediaFormat.setInteger("sample-rate", n2);
            mediaFormat.setInteger("channel-count", 1);
            mediaFormat.setByteBuffer("csd-0", ByteBuffer.wrap(new byte[]{18, -120}));
            mediaCodecAudioDecoder.mAACDecoder.configure(mediaFormat, null, null, 0);
            if (mediaCodecAudioDecoder2.mAACDecoder == null) break block4;
            this.mAACDecoder.start();
        }
        return true;
    }

    public void releaseAACStreaming() {
        block3: {
            if (this.mAACDecoder == null) break block3;
            try {
                MediaCodecAudioDecoder mediaCodecAudioDecoder = this;
                mediaCodecAudioDecoder.mAACDecoder.stop();
                mediaCodecAudioDecoder.mAACDecoder.release();
                mediaCodecAudioDecoder.mAACDecoder = null;
            }
            catch (Exception exception) {
                Logging.e(TAG, "Error when releasing aac decode stream");
                exception.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int decodeAACFrame(byte[] var1_1) {
        block21: {
            var2_3 = 0;
            var3_4 = this.mAACDecoder.dequeueInputBuffer(200L);
            if (var3_4 < 0) ** GOTO lbl29
            if (Build.VERSION.SDK_INT < 21) break block21;
            v0 = this.mAACDecoder.getInputBuffer(var3_4);
lbl9:
            // 2 sources

            while (true) {
                var4_5 = v0;
                ** GOTO lbl16
                break;
            }
        }
        v0 = this.mAACDecoder.getInputBuffers()[var3_4];
        ** continue;
lbl16:
        // 1 sources

        v1 = this;
        v2 = var4_5;
        v3 /* !! */  = var1_1 /* !! */ ;
        var4_5.clear();
        v2.put(v3 /* !! */ );
        v4 = v1.mAACDecoder;
        var1_2 = 0;
        v4.queueInputBuffer(var3_4, var1_2, var1_1 /* !! */ .length, 0L, 0);
lbl29:
        // 2 sources

        v5 = this;
        var1_1 /* !! */  = (byte[])v6;
        v6 = new MediaCodec.BufferInfo();
        var3_4 = v5.mAACDecoder.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_1 /* !! */ , 0L);
        switch (var3_4) {
            default: {
                if (var3_4 < 0) break;
                if (Build.VERSION.SDK_INT < 21) ** GOTO lbl45
                v7 = this.mAACDecoder.getOutputBuffer(var3_4);
lbl41:
                // 2 sources

                while (true) {
                    var4_5 = v7;
                    ** GOTO lbl47
                    break;
                }
lbl45:
                // 2 sources

                v7 = this.mAACDecoder.getOutputBuffers()[var3_4];
                ** continue;
lbl47:
                // 1 sources

                v8 = this;
                v9 = v8;
                v10 = v8;
                v11 = var4_5;
                var2_3 = var1_1 /* !! */ .size;
                try {
                    this.mAACOutputBuffer.position(0);
                }
                catch (Exception v12) {
                    Logging.e("MediaCodec Audio Decoder", "Error when decoding aac stream");
                    v12.printStackTrace();
                }
                v11.limit(var2_3);
                v9.mAACOutputBuffer.put(var4_5);
                v10.mAACDecoder.releaseOutputBuffer(var3_4, false);
                break;
            }
            case -3: 
            case -2: 
            case -1: 
        }
        return var2_3;
    }

    private class MediaExtractorWrapper {
        private final MediaExtractor mMediaExtractor;
        private volatile boolean mPrepared;
        private final Handler mHandler;
        private final String threadName = "MediaExtractor-" + new Random().nextInt();
        private final CountDownLatch countDownLatch;

        MediaExtractorWrapper() {
            HandlerThread handlerThread;
            MediaCodecAudioDecoder.this = handlerThread;
            new HandlerThread(this.threadName).start();
            this.mHandler = new Handler(MediaCodecAudioDecoder.this.getLooper());
            this.mMediaExtractor = new MediaExtractor();
            this.countDownLatch = new CountDownLatch(1);
        }

        private boolean setDataSource(final String string2) throws InterruptedException {
            MediaExtractorWrapper mediaExtractorWrapper = object;
            String string3 = string2;
            Logging.d(MediaCodecAudioDecoder.TAG, "setDataSource()");
            final boolean bl = string3.startsWith(MediaCodecAudioDecoder.PREFIX_ASSETS);
            final boolean bl2 = string3.startsWith(MediaCodecAudioDecoder.PREFIX_DOCUMENT);
            mediaExtractorWrapper.mHandler.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Logging.d(MediaCodecAudioDecoder.TAG, "setDataSource in thread " + MediaExtractorWrapper.this.threadName);
                    try {
                        if (bl && MediaCodecAudioDecoder.this.mContext != null) {
                            AssetFileDescriptor assetFileDescriptor;
                            1 v0 = this;
                            AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor = v0.MediaCodecAudioDecoder.this.mContext.getAssets().openFd(string2.substring(8));
                            FileDescriptor fileDescriptor = assetFileDescriptor2.getFileDescriptor();
                            long l2 = assetFileDescriptor2.getStartOffset();
                            long l3 = assetFileDescriptor2.getLength();
                            v0.MediaExtractorWrapper.this.mMediaExtractor.setDataSource(fileDescriptor, l2, l3);
                        } else if (bl2 && MediaCodecAudioDecoder.this.mContext != null) {
                            1 v2 = this;
                            Uri uri = Uri.parse((String)v2.string2);
                            FileDescriptor fileDescriptor = v2.MediaCodecAudioDecoder.this.mContext.getContentResolver().openFileDescriptor(uri, "r").getFileDescriptor();
                            v2.MediaExtractorWrapper.this.mMediaExtractor.setDataSource(fileDescriptor);
                        } else {
                            MediaExtractorWrapper.this.mMediaExtractor.setDataSource(string2);
                        }
                        MediaExtractorWrapper.access$402(MediaExtractorWrapper.this, true);
                    }
                    catch (Exception exception) {
                        Logging.w(MediaCodecAudioDecoder.TAG, "setDataSource fail");
                    }
                    MediaExtractorWrapper.this.countDownLatch.countDown();
                }
            });
            Object object = TimeUnit.MILLISECONDS;
            mediaExtractorWrapper.countDownLatch.await(6000L, (TimeUnit)((Object)object));
            return mediaExtractorWrapper.mPrepared;
        }

        static /* synthetic */ boolean access$402(MediaExtractorWrapper mediaExtractorWrapper, boolean bl) {
            mediaExtractorWrapper.mPrepared = bl;
            return bl;
        }

        void release() {
            Logging.d(MediaCodecAudioDecoder.TAG, "release()");
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (MediaExtractorWrapper.this.mMediaExtractor != null) {
                        MediaExtractorWrapper.this.mMediaExtractor.release();
                    }
                    MediaExtractorWrapper.this.mHandler.getLooper().quit();
                    Logging.d(MediaCodecAudioDecoder.TAG, "mediaExtractor released in thread " + MediaExtractorWrapper.this.threadName);
                }
            });
        }

        int getTrackCount() {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            return mediaExtractorWrapper.mMediaExtractor.getTrackCount();
        }

        void selectTrack(int n2) {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            mediaExtractorWrapper.mMediaExtractor.selectTrack(n2);
        }

        void unselectTrack(int n2) {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            mediaExtractorWrapper.mMediaExtractor.unselectTrack(n2);
        }

        void seekTo(long l2, int n2) {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            mediaExtractorWrapper.mMediaExtractor.seekTo(l2, n2);
        }

        int readSampleData(ByteBuffer byteBuffer, int n2) {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            return mediaExtractorWrapper.mMediaExtractor.readSampleData(byteBuffer, n2);
        }

        long getSampleTime() {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            return mediaExtractorWrapper.mMediaExtractor.getSampleTime();
        }

        int getSampleFlags() {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            return mediaExtractorWrapper.mMediaExtractor.getSampleFlags();
        }

        void advance() {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            mediaExtractorWrapper.mMediaExtractor.advance();
        }

        MediaFormat getTrackFormat(int n2) {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            mediaExtractorWrapper.checkPrepared();
            return mediaExtractorWrapper.mMediaExtractor.getTrackFormat(n2);
        }

        void checkPrepared() {
            if (this.mPrepared) {
                return;
            }
            throw new IllegalStateException("mMediaExtractor hasn't prepared");
        }
    }
}

