/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class MediaCodecAudioEncoder {
    private MediaCodec mMediaCodec = null;
    private MediaFormat mTrackFormat = null;
    private String mCodecString = null;
    private File outputFile = null;
    private BufferedOutputStream outputStream = null;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mAACEncoder = null;
    private MediaFormat mAACFormat = null;
    private ByteBuffer[] mAACInputBuffers;
    private ByteBuffer[] mAACOutputBuffers;
    private ByteBuffer mAACEncodedBuffer = ByteBuffer.allocateDirect(1024);
    private String TAG = "MediaCodec Audio Encoder";

    private void addADTStoPacket(byte[] byArray, int n2) {
        byte[] byArray2 = byArray;
        byArray2[0] = -1;
        byArray2[1] = -7;
        byArray[2] = (byte)84;
        byArray[3] = (byte)(64 + (n2 >> 11));
        byArray[4] = (byte)((n2 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n2 & 7) << 5) + 31);
        byArray[6] = -4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void touch(File file) {
        if (file.exists()) return;
        try {
            file.createNewFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    public boolean createStreaming(String var1_1, int var2_2, int var3_4, int var4_5) {
        block25: {
            block26: {
                block22: {
                    block23: {
                        block24: {
                            v0 = var1_1;
                            v1 = v0;
                            Logging.i(this.TAG, "Recording aac with fs = " + var2_2 + ", ch = " + var3_4 + ", quality = " + var4_5);
                            v2 = v0.length();
                            {
                                catch (Exception v3) {
                                    Logging.e(this.TAG, "Error when creating aac file encoder");
                                    v3.printStackTrace();
                                    return false;
                                }
                            }
                            var5_6 = v1.substring(v2 - 3);
                            if (var5_6.equalsIgnoreCase("3gp")) break block22;
                            if (var5_6.equalsIgnoreCase("amr")) break block22;
                            if (!var5_6.equalsIgnoreCase("aac")) break block23;
                            if (var4_5 != 0) {
                                var4_5 = var4_5 != 1 ? 50000 : 25000;
                                break block24;
                            }
                            var4_5 = 16000;
                        }
                        v4 = this;
                        v5 = v4;
                        v6 = v4;
                        v7 = v4;
                        v8 = v4;
                        v4.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                        v9 = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)var2_2, (int)var3_4);
                        this.mTrackFormat = v9;
                        v9.setInteger("aac-profile", 2);
                        v6.mTrackFormat.setInteger("sample-rate", var2_2);
                        v7.mTrackFormat.setInteger("channel-count", var3_4);
                        v8.mTrackFormat.setInteger("bitrate", var4_5);
                        v5.mCodecString = "audio/mp4a-latm";
                        ** GOTO lbl62
                    }
                    return false;
                }
                if (var2_2 != 8000) break block26;
                v10 = this;
                this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/3gpp");
                v11 = MediaFormat.createAudioFormat((String)"audio/3gpp", (int)var2_2, (int)var3_4);
                this.mTrackFormat = v11;
                v11.setInteger("bitrate", 12200);
                v10.mCodecString = "audio/3gpp";
                ** GOTO lbl62
            }
            if (var2_2 != 16000) ** GOTO lbl62
            v12 = this;
            this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/amr-wb");
            v13 = MediaFormat.createAudioFormat((String)"audio/amr-wb", (int)var2_2, (int)var3_4);
            this.mTrackFormat = v13;
            v13.setInteger("bitrate", 23850);
            v12.mCodecString = "audio/amr-wb";
lbl62:
            // 4 sources

            v14 = this;
            v14.mMediaCodec.configure(this.mTrackFormat, null, null, 1);
            if (v14.mMediaCodec == null) ** GOTO lbl67
            this.mMediaCodec.start();
lbl67:
            // 2 sources

            v15 = this;
            v16 = v15;
            v17 = v15;
            v18 = v15;
            v19 = v15;
            var2_3 = v20;
            v16.outputFile = new File((String)var1_1);
            v17.touch(var2_3);
            try {
                v18.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                Logging.i(v19.TAG, "outputStream initialized");
                ** GOTO lbl83
            }
            catch (Exception v21) {
                v21.printStackTrace();
lbl83:
                // 2 sources

                if (this.mCodecString != "audio/3gpp") ** GOTO lbl97
            }
            v22 = this;
            v23 = new byte[6];
            var1_1 = v23;
            v23[0] = 35;
            v23[1] = 33;
            v23[2] = 65;
            v23[3] = 77;
            v23[4] = 82;
            v23[5] = 10;
            v22.outputStream.write((byte[])var1_1);
            break block25;
lbl97:
            // 1 sources

            if (this.mCodecString != "audio/amr-wb") break block25;
            v24 = this;
            v25 = new byte[9];
            var1_1 = v25;
            v25[0] = 35;
            v25[1] = 33;
            v25[2] = 65;
            v25[3] = 77;
            v25[4] = 82;
            v25[5] = 45;
            v25[6] = 87;
            v25[7] = 66;
            v25[8] = 10;
            v24.outputStream.write((byte[])var1_1);
        }
        return true;
    }

    public void setChannelCount(int n2) {
        try {
            this.mTrackFormat.setInteger("channel-count", n2);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder channel count");
            exception.printStackTrace();
        }
    }

    public void setSampleRate(int n2) {
        try {
            this.mTrackFormat.setInteger("sample-rate", n2);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder sample rate");
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                MediaCodecAudioEncoder mediaCodecAudioEncoder = this;
                mediaCodecAudioEncoder.mMediaCodec.stop();
                mediaCodecAudioEncoder.mMediaCodec.release();
                mediaCodecAudioEncoder.mMediaCodec = null;
            }
            if (this.outputStream == null) return;
            MediaCodecAudioEncoder mediaCodecAudioEncoder = this;
            mediaCodecAudioEncoder.outputStream.flush();
            mediaCodecAudioEncoder.outputStream.close();
            mediaCodecAudioEncoder.outputStream = null;
            return;
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac file encoder");
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void encodeFrame(byte[] var1_1) {
        block32: {
            var2_4 = this.mMediaCodec.dequeueInputBuffer(2000L);
            if (var2_4 == -1) ** GOTO lbl31
            if (Build.VERSION.SDK_INT < 21) break block32;
            v0 /* !! */  = this.mMediaCodec.getInputBuffer(var2_4);
lbl8:
            // 2 sources

            while (true) {
                var3_5 = v0 /* !! */ ;
                ** GOTO lbl18
                break;
            }
        }
        var3_5 = this.mMediaCodec.getInputBuffers();
        this.mInputBuffers = var3_5;
        v0 /* !! */  = var3_5[var2_4];
        ** continue;
lbl18:
        // 1 sources

        v1 = this;
        v2 = var3_5;
        v3 = var1_1;
        var3_5.clear();
        v2.put(v3);
        v4 = v1.mMediaCodec;
        var1_2 = 0;
        v4.queueInputBuffer(var2_4, var1_2, var1_1.length, 0L, 0);
lbl31:
        // 2 sources

        v5 = this;
        var1_3 = v6;
        v6 = new MediaCodec.BufferInfo();
        v7 = v5.mMediaCodec.dequeueOutputBuffer(var1_3, 0L);
        while ((var2_4 = v7) >= 0) {
            block34: {
                block33: {
                    var3_7 = var1_3.size;
                    if (Build.VERSION.SDK_INT < 21) break block33;
                    v8 /* !! */  = this.mMediaCodec.getOutputBuffer(var2_4);
lbl43:
                    // 2 sources

                    while (true) {
                        var4_8 /* !! */  = v8 /* !! */ ;
                        ** GOTO lbl53
                        break;
                    }
                }
                var4_8 /* !! */  = this.mMediaCodec.getOutputBuffers();
                this.mOutputBuffers = var4_8 /* !! */ ;
                v8 /* !! */  = var4_8 /* !! */ [var2_4];
                ** continue;
lbl53:
                // 1 sources

                v9 = this;
                v10 = var4_8 /* !! */ ;
                v11 = var1_3;
                var4_8 /* !! */ .position(var1_3.offset);
                v12 = v11.offset;
                v10.limit(v12 + var3_7);
                if (v9.mCodecString != "audio/mp4a-latm") ** GOTO lbl80
                var4_9 = var3_7 + 7;
                var5_10 = new byte[var4_9];
                this.addADTStoPacket(var5_10, var4_9);
                var4_8 /* !! */ .get(var5_10, 7, var3_7);
                var4_8 /* !! */ .position(var1_3.offset);
                v13 = this.outputStream;
                v13.write(var5_10, 0, var4_9);
                ** GOTO lbl101
lbl80:
                // 1 sources

                if (this.mCodecString == "audio/3gpp") break block34;
                if (this.mCodecString != "audio/amr-wb") ** GOTO lbl101
            }
            v14 = this;
            v15 = var4_8 /* !! */ ;
            v16 = var1_3;
            v17 = var4_8 /* !! */ ;
            v18 = new byte[var3_7];
            var4_8 /* !! */  = (ByteBuffer[])v18;
            v17.get(v18, 0, var3_7);
            v15.position(v16.offset);
            v19 = v14.outputStream;
            try {
                v19.write((byte[])var4_8 /* !! */ , 0, var3_7);
lbl101:
                // 3 sources

                v20 = this;
                v20.mMediaCodec.releaseOutputBuffer(var2_4, false);
                v7 = v20.mMediaCodec.dequeueOutputBuffer(var1_3, 0L);
            }
            catch (Exception v21) {
                Logging.e(this.TAG, "Error when encoding aac file");
                v21.printStackTrace();
                break;
            }
        }
    }

    public boolean createAACStreaming(int n2, int n3, int n4) {
        block4: {
            MediaFormat mediaFormat;
            MediaCodecAudioEncoder mediaCodecAudioEncoder;
            MediaCodecAudioEncoder mediaCodecAudioEncoder2;
            MediaCodecAudioEncoder mediaCodecAudioEncoder3;
            MediaCodecAudioEncoder mediaCodecAudioEncoder4;
            MediaCodecAudioEncoder mediaCodecAudioEncoder5;
            try {
                MediaCodecAudioEncoder mediaCodecAudioEncoder6 = this;
                mediaCodecAudioEncoder5 = mediaCodecAudioEncoder6;
                mediaCodecAudioEncoder4 = mediaCodecAudioEncoder6;
                mediaCodecAudioEncoder3 = mediaCodecAudioEncoder6;
                mediaCodecAudioEncoder2 = mediaCodecAudioEncoder6;
                mediaCodecAudioEncoder = mediaCodecAudioEncoder6;
                Logging.i(mediaCodecAudioEncoder6.TAG, "Encoding aac with fs = " + n2 + ", bitrate = " + n4);
                mediaCodecAudioEncoder6.mAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
            }
            catch (Exception exception) {
                Logging.e(this.TAG, "Error when creating aac encode stream");
                exception.printStackTrace();
                return false;
            }
            this.mAACFormat = mediaFormat;
            mediaFormat.setInteger("aac-profile", 2);
            mediaCodecAudioEncoder2.mAACFormat.setInteger("sample-rate", n2);
            mediaCodecAudioEncoder.mAACFormat.setInteger("channel-count", n3);
            mediaCodecAudioEncoder4.mAACFormat.setInteger("bitrate", n4);
            mediaCodecAudioEncoder3.mAACEncoder.configure(this.mAACFormat, null, null, 1);
            if (mediaCodecAudioEncoder5.mAACEncoder == null) break block4;
            this.mAACEncoder.start();
        }
        return true;
    }

    public boolean setAACEncodeBitrate(int n2) {
        block3: {
            MediaCodecAudioEncoder mediaCodecAudioEncoder = this;
            Logging.w(mediaCodecAudioEncoder.TAG, "Set hw aac bitrate = " + n2);
            try {
                if (mediaCodecAudioEncoder.mAACEncoder == null) break block3;
            }
            catch (Exception exception) {
                Logging.e(this.TAG, "Error when setting aac encode bitrate");
                exception.printStackTrace();
                return false;
            }
            MediaCodecAudioEncoder mediaCodecAudioEncoder2 = this;
            mediaCodecAudioEncoder2.mAACEncoder.stop();
            mediaCodecAudioEncoder2.mAACFormat.setInteger("bitrate", n2);
            mediaCodecAudioEncoder2.mAACEncoder.configure(this.mAACFormat, null, null, 1);
            mediaCodecAudioEncoder2.mAACEncoder.start();
        }
        return true;
    }

    public void releaseAACStreaming() {
        block3: {
            if (this.mAACEncoder == null) break block3;
            try {
                MediaCodecAudioEncoder mediaCodecAudioEncoder = this;
                mediaCodecAudioEncoder.mAACEncoder.stop();
                mediaCodecAudioEncoder.mAACEncoder.release();
                mediaCodecAudioEncoder.mAACEncoder = null;
            }
            catch (Exception exception) {
                Logging.e(this.TAG, "Error when releasing aac encode stream");
                exception.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int encodeAACFrame(byte[] var1_1) {
        block25: {
            block28: {
                block27: {
                    block26: {
                        block24: {
                            var2_3 = 0;
                            var3_4 = this.mAACEncoder.dequeueInputBuffer(2000L);
                            if (var3_4 == -1) ** GOTO lbl32
                            if (Build.VERSION.SDK_INT < 21) break block24;
                            v0 /* !! */  = this.mAACEncoder.getInputBuffer(var3_4);
lbl9:
                            // 2 sources

                            while (true) {
                                var4_5 = v0 /* !! */ ;
                                ** GOTO lbl19
                                break;
                            }
                        }
                        var4_5 = this.mAACEncoder.getInputBuffers();
                        this.mAACInputBuffers = var4_5;
                        v0 /* !! */  = var4_5[var3_4];
                        ** continue;
lbl19:
                        // 1 sources

                        v1 = this;
                        v2 = var4_5;
                        v3 /* !! */  = var1_1 /* !! */ ;
                        var4_5.clear();
                        v2.put(v3 /* !! */ );
                        v4 = v1.mAACEncoder;
                        var1_2 = 0;
                        v4.queueInputBuffer(var3_4, var1_2, var1_1 /* !! */ .length, 0L, 0);
lbl32:
                        // 2 sources

                        v5 = this;
                        var1_1 /* !! */  = (byte[])v6;
                        v6 = new MediaCodec.BufferInfo();
                        var3_4 = v5.mAACEncoder.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_1 /* !! */ , 0L);
                        if (var3_4 < 0) break block25;
                        var4_6 = var1_1 /* !! */ .size;
                        if (Build.VERSION.SDK_INT < 21) break block26;
                        v7 /* !! */  = this.mAACEncoder.getOutputBuffer(var3_4);
lbl44:
                        // 2 sources

                        while (true) {
                            var5_7 = v7 /* !! */ ;
                            ** GOTO lbl54
                            break;
                        }
                    }
                    var5_7 = this.mAACEncoder.getOutputBuffers();
                    this.mAACOutputBuffers = var5_7;
                    v7 /* !! */  = var5_7[var3_4];
                    ** continue;
lbl54:
                    // 1 sources

                    if ((var1_1 /* !! */ .flags & 2) != 2) break block27;
                    var2_3 = 0;
                    break block28;
                }
                var2_3 = var1_1 /* !! */ .size;
            }
            v8 = this;
            v9 = v8;
            v10 = v8;
            v11 = v8;
            v12 = var5_7;
            v13 /* !! */  = var1_1 /* !! */ ;
            var5_7.position(var1_1 /* !! */ .offset);
            v14 = v13 /* !! */ .offset;
            v12.limit(v14 + var4_6);
            v10.mAACEncodedBuffer.position(0);
            v11.mAACEncodedBuffer.put((ByteBuffer)var5_7);
            try {
                v9.mAACEncoder.releaseOutputBuffer(var3_4, false);
            }
            catch (Exception v15) {
                Logging.e(this.TAG, "Error when encoding aac stream");
                v15.printStackTrace();
            }
        }
        return var2_3;
    }
}

