/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.internal.Logging;
import java.util.StringTokenizer;

class VivoHardwareEarback
implements IHardwareEarback {
    private static final String TAG = "VivoHardwareEarback Java";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private AudioManager mAudioManager;
    private Context mContext;

    public VivoHardwareEarback(Context context) {
        VivoHardwareEarback vivoHardwareEarback = this;
        vivoHardwareEarback.mAudioManager = null;
        vivoHardwareEarback.mContext = null;
        vivoHardwareEarback.mContext = context;
        vivoHardwareEarback.initialize();
    }

    @Override
    public void initialize() {
        Context context = this.mContext;
        if (context == null) {
            Logging.e(TAG, "mContext should not be null!");
            return;
        }
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        if (((VivoHardwareEarback)((Object)string2)).mAudioManager == null) {
            return false;
        }
        if (Build.MANUFACTURER.trim().contains("vivo")) {
            int n2;
            StringTokenizer stringTokenizer;
            String string2 = ((VivoHardwareEarback)((Object)string2)).mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer stringTokenizer2 = stringTokenizer;
            if (2 != new StringTokenizer(string2, "=").countTokens()) {
                return false;
            }
            if (stringTokenizer2.nextToken().equals(KEY_MIC_TYPE) && (1 == (n2 = Integer.parseInt(stringTokenizer2.nextToken())) || n2 == 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int setHardwareEarbackVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (15 < n2) {
            n2 = 15;
        }
        if (((VivoHardwareEarback)((Object)stringBuilder2)).mAudioManager != null) {
            StringBuilder stringBuilder;
            VivoHardwareEarback vivoHardwareEarback = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder().append(KEY_VOL_MIC).append("=").append(n2);
            vivoHardwareEarback.mAudioManager.setParameters(stringBuilder2.toString());
            return 0;
        }
        return -1;
    }

    @Override
    public synchronized int enableEarbackFeature(boolean bl) {
        return -1;
    }

    @Override
    public void destroy() {
        VivoHardwareEarback vivoHardwareEarback = this;
        vivoHardwareEarback.mAudioManager = null;
        vivoHardwareEarback.mContext = null;
    }

    protected void finalize() throws Throwable {
        VivoHardwareEarback vivoHardwareEarback = this;
        vivoHardwareEarback.destroy();
        super.finalize();
    }
}

