/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.util.Log;
import android.view.Surface;

public final class EglCore {
    private static final String TAG = "GDPGlUtil";
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay;
    private EGLContext mEGLContext;
    private EGLConfig mEGLConfig;
    private int mGlVersion;

    public EglCore() {
        this(null, 0);
    }

    public EglCore(EGLContext object, int n2) {
        Object object2 = EGL14.EGL_NO_DISPLAY;
        EglCore eglCore = this;
        eglCore.mEGLDisplay = object2;
        eglCore.mEGLContext = EGL14.EGL_NO_CONTEXT;
        eglCore.mEGLConfig = null;
        eglCore.mGlVersion = -1;
        if (object2 == EGL14.EGL_NO_DISPLAY) {
            if (object == null) {
                object = EGL14.EGL_NO_CONTEXT;
            }
            this.mEGLDisplay = object2 = EGL14.eglGetDisplay((int)0);
            if (object2 != EGL14.EGL_NO_DISPLAY) {
                int[] nArray = new int[2];
                if (EGL14.eglInitialize((EGLDisplay)object2, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                    if ((n2 & 2) != 0 && (object2 = this.getConfig(n2, 3)) != null) {
                        int[] nArray2 = new int[3];
                        Object object3 = nArray2;
                        nArray2[0] = 12440;
                        nArray2[1] = 3;
                        nArray2[2] = 12344;
                        object3 = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)object2, (EGLContext)object, (int[])object3, (int)0);
                        if (EGL14.eglGetError() == 12288) {
                            EglCore eglCore2 = this;
                            eglCore2.mEGLConfig = object2;
                            eglCore2.mEGLContext = (EGLContext)object3;
                            eglCore2.mGlVersion = 3;
                        }
                    }
                    if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
                        EGLConfig eGLConfig = this.getConfig(n2, 2);
                        if (eGLConfig != null) {
                            EglCore eglCore3 = this;
                            EglCore eglCore4 = this;
                            int[] nArray3 = new int[3];
                            object2 = nArray3;
                            nArray3[0] = 12440;
                            nArray3[1] = 2;
                            nArray3[2] = 12344;
                            object = EGL14.eglCreateContext((EGLDisplay)eglCore4.mEGLDisplay, (EGLConfig)eGLConfig, (EGLContext)object, (int[])object2, (int)0);
                            eglCore4.checkEglError("eglCreateContext");
                            eglCore3.mEGLConfig = eGLConfig;
                            eglCore3.mEGLContext = object;
                            eglCore3.mGlVersion = 2;
                        } else {
                            throw new RuntimeException("Unable to find a suitable EGLConfig");
                        }
                    }
                    object = new int[1];
                    EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])object, (int)0);
                    Log.d((String)TAG, (String)("EGLContext created, client version " + (int)object[0]));
                    return;
                }
                this.mEGLDisplay = null;
                throw new RuntimeException("unable to initialize EGL14");
            }
            throw new RuntimeException("unable to get EGL14 display");
        }
        throw new RuntimeException("EGL already set up");
    }

    private EGLConfig getConfig(int n2, int n3) {
        int[] nArray;
        int n4 = 4;
        if (n3 >= 3) {
            n4 = 68;
        }
        int[] nArray2 = new int[13];
        int[] nArray3 = nArray2;
        nArray2[0] = 12324;
        nArray2[1] = 8;
        nArray2[2] = 12323;
        nArray2[3] = 8;
        nArray2[4] = 12322;
        nArray2[5] = 8;
        nArray2[6] = 12321;
        nArray2[7] = 8;
        nArray2[8] = 12352;
        nArray2[9] = n4;
        nArray2[10] = 12344;
        nArray2[11] = 0;
        nArray2[12] = 12344;
        if ((n2 & 1) != 0) {
            nArray3[10] = 12610;
            nArray3[11] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])nArray3, (int)0, (EGLConfig[])(this = new EGLConfig[1]), (int)0, (int)1, (int[])(nArray = new int[1]), (int)0)) {
            Log.w((String)TAG, (String)("unable to find RGB8888 / " + n3 + " EGLConfig"));
            return null;
        }
        return this[0];
    }

    public static void logCurrent(String string2) {
        EGLDisplay eGLDisplay = EGL14.eglGetCurrentDisplay();
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        Log.i((String)TAG, (String)("Current EGL (" + string2 + "): display=" + eGLDisplay + ", context=" + eGLContext + ", surface=" + EGL14.eglGetCurrentSurface((int)12377)));
    }

    private void checkEglError(String string2) {
        int n2 = EGL14.eglGetError();
        if (n2 == 12288) {
            return;
        }
        throw new RuntimeException(string2 + ": EGL error: 0x" + Integer.toHexString(n2));
    }

    public void release() {
        EGLDisplay eGLDisplay = this.mEGLDisplay;
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EglCore eglCore = this;
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)eglCore.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)eglCore.mEGLDisplay);
        }
        EglCore eglCore = this;
        eglCore.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        eglCore.mEGLContext = EGL14.EGL_NO_CONTEXT;
        eglCore.mEGLConfig = null;
    }

    protected void finalize() throws Throwable {
        block4: {
            try {
                if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) break block4;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            EglCore eglCore = this;
            Log.w((String)TAG, (String)"WARNING: EglCore was not explicitly released -- state may be leaked");
            eglCore.release();
        }
        super.finalize();
    }

    public void releaseSurface(EGLSurface eGLSurface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public EGLSurface createWindowSurface(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + object);
        }
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 12344;
        object = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)object, (int[])nArray2, (int)0);
        this.checkEglError("eglCreateWindowSurface");
        if (object != null) {
            return object;
        }
        throw new RuntimeException("surface was null");
    }

    public EGLSurface createOffscreenSurface(int n2, int n3) {
        int[] nArray = new int[5];
        int[] nArray2 = nArray;
        nArray[0] = 12375;
        nArray[1] = n2;
        nArray[2] = 12374;
        nArray[3] = n3;
        nArray[4] = 12344;
        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])nArray2, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eGLSurface != null) {
            return eGLSurface;
        }
        throw new RuntimeException("surface was null");
    }

    public void makeCurrent(EGLSurface eGLSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Log.d((String)TAG, (String)"NOTE: makeCurrent w/o display");
        }
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)this.mEGLContext)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed");
    }

    public void makeCurrent(EGLSurface eGLSurface, EGLSurface eGLSurface2) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Log.d((String)TAG, (String)"NOTE: makeCurrent w/o display");
        }
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface2, (EGLContext)this.mEGLContext)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent(draw,read) failed");
    }

    public void makeNothingCurrent() {
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        if (EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed");
    }

    public boolean swapBuffers(EGLSurface eGLSurface) {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface);
    }

    public void setPresentationTime(EGLSurface eGLSurface, long l2) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (long)l2);
    }

    public boolean isCurrent(EGLSurface eGLSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eGLSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    public int querySurface(EGLSurface eGLSurface, int n2) {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (int)n2, (int[])nArray, (int)0);
        return nArray[0];
    }

    public String queryString(int n2) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)n2);
    }

    public int getGlVersion() {
        return this.mGlVersion;
    }
}

