/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Log;
import io.agora.rtc.gdp.EglCore;
import io.agora.rtc.gdp.GlUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EglSurfaceBase {
    protected static final String TAG = "GDPGlUtil";
    protected EglCore mEglCore;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private int mWidth = -1;
    private int mHeight = -1;

    protected EglSurfaceBase(EglCore eglCore) {
        this.mEglCore = eglCore;
    }

    public void createWindowSurface(Object object) {
        if (this.mEGLSurface == EGL14.EGL_NO_SURFACE) {
            this.mEGLSurface = this.mEglCore.createWindowSurface(object);
            return;
        }
        throw new IllegalStateException("surface already created");
    }

    public void createOffscreenSurface(int n2, int n3) {
        if (this.mEGLSurface == EGL14.EGL_NO_SURFACE) {
            this.mEGLSurface = this.mEglCore.createOffscreenSurface(n2, n3);
            this.mWidth = n2;
            this.mHeight = n3;
            return;
        }
        throw new IllegalStateException("surface already created");
    }

    public int getWidth() {
        int n2 = this.mWidth;
        if (n2 < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return n2;
    }

    public int getHeight() {
        int n2 = this.mHeight;
        if (n2 < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return n2;
    }

    public void releaseEglSurface() {
        this.mEglCore.releaseSurface(this.mEGLSurface);
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    public void makeCurrent() {
        this.mEglCore.makeCurrent(this.mEGLSurface);
    }

    public void makeCurrentReadFrom(EglSurfaceBase eglSurfaceBase) {
        EglSurfaceBase eglSurfaceBase2 = eglSurfaceBase2.mEGLSurface;
        eglSurfaceBase2.mEglCore.makeCurrent((EGLSurface)eglSurfaceBase2, eglSurfaceBase.mEGLSurface);
    }

    public boolean swapBuffers() {
        boolean bl = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!bl) {
            Log.d((String)TAG, (String)"WARNING: swapBuffers() failed");
        }
        return bl;
    }

    public void setPresentationTime(long l2) {
        this.mEglCore.setPresentationTime(this.mEGLSurface, l2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveFrame(File object) throws IOException {
        void var0_4;
        BufferedOutputStream bufferedOutputStream;
        block8: {
            Bitmap bitmap;
            int n2;
            int n3;
            BufferedOutputStream bufferedOutputStream2;
            if (!this.mEglCore.isCurrent(this.mEGLSurface)) {
                throw new RuntimeException("Expected EGL context/surface is not current");
            }
            object = ((File)object).toString();
            int n22 = this.getWidth();
            int n32 = this.getHeight();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n22 * n32 * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)n22, (int)n32, (int)6408, (int)5121, (Buffer)byteBuffer);
            GlUtil.checkGlError("glReadPixels");
            byteBuffer.rewind();
            Object var4_8 = null;
            bufferedOutputStream = bufferedOutputStream2;
            try {
                n3 = n22;
                n2 = n32;
                bufferedOutputStream(new FileOutputStream((String)object));
            }
            catch (Throwable throwable) {
                bufferedOutputStream = var4_8;
                break block8;
            }
            try {
                Bitmap bitmap2 = Bitmap.createBitmap((int)n3, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = bitmap2;
                bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
                bitmap2.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)bufferedOutputStream);
            }
            catch (Throwable throwable) {
                break block8;
            }
            {
                bitmap.recycle();
            }
            bufferedOutputStream2.close();
            Log.d((String)TAG, (String)("Saved " + n22 + "x" + n32 + " frame as '" + (String)object + "'"));
            return;
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.close();
        }
        throw var0_4;
    }
}

