/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IntentFilter;
import android.opengl.GLES20;
import android.os.BatteryManager;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.gdp.EglCore;
import io.agora.rtc.gdp.OffscreenSurface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class GDPAndroid {
    private static String TAG = "GDPAndroid";
    private static final int DEVICEINFO_UNKNOWN = -1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string2 = file.getName();
            if (string2.startsWith("cpu")) {
                for (int i2 = 3; i2 < string2.length(); ++i2) {
                    if (Character.isDigit(string2.charAt(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final List<String> CPU_TEMP_FILE_PATHS = Arrays.asList("/sys/devices/system/cpu/cpu0/cpufreq/cpu_temp", "/sys/devices/system/cpu/cpu0/cpufreq/FakeShmoo_cpu_temp", "/sys/class/thermal/thermal_zone0/temp", "/sys/class/i2c-adapter/i2c-4/4-004c/temperature", "/sys/devices/platform/tegra-i2c.3/i2c-4/4-004c/temperature", "/sys/devices/platform/omap/omap_temp_sensor.0/temperature", "/sys/devices/platform/tegra_tmon/temp1_input", "/sys/kernel/debug/tegra_thermal/temp_tj", "/sys/devices/platform/s5p-tmu/temperature", "/sys/class/thermal/thermal_zone1/temp", "/sys/class/hwmon/hwmon0/device/temp1_input", "/sys/devices/virtual/thermal/thermal_zone1/temp", "/sys/devices/virtual/thermal/thermal_zone0/temp", "/sys/class/thermal/thermal_zone3/temp", "/sys/class/thermal/thermal_zone4/temp", "/sys/class/hwmon/hwmonX/temp1_input", "/sys/devices/platform/s5p-tmu/curr_temp");
    private Context mAppContext = null;
    private String mGpuVendor = "unkown";
    private String mGpuRenderer = "unkown";

    private boolean isEGL14SupportedHere() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void gatherGlInfo() {
        OffscreenSurface offscreenSurface;
        EglCore eglCore;
        EglCore eglCore2 = eglCore;
        eglCore = new EglCore(null, 2);
        OffscreenSurface offscreenSurface2 = offscreenSurface;
        GDPAndroid gDPAndroid = this;
        OffscreenSurface offscreenSurface3 = offscreenSurface2;
        offscreenSurface3(eglCore2, 1, 1);
        offscreenSurface3.makeCurrent();
        gDPAndroid.mGpuVendor = GLES20.glGetString((int)7936);
        gDPAndroid.mGpuRenderer = GLES20.glGetString((int)7937);
        offscreenSurface.release();
        eglCore.release();
    }

    private int getBatteryLevel() {
        IntentFilter intentFilter;
        if (Build.VERSION.SDK_INT >= 21) {
            return ((BatteryManager)gDPAndroid.mAppContext.getSystemService("batterymanager")).getIntProperty(4);
        }
        GDPAndroid gDPAndroid = intentFilter;
        intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        gDPAndroid = new ContextWrapper(gDPAndroid.mAppContext).registerReceiver(null, (IntentFilter)gDPAndroid);
        return gDPAndroid.getIntExtra("level", -1) * 100 / gDPAndroid.getIntExtra("scale", -1);
    }

    private static int getNumberOfCPUCores() {
        int n2;
        block7: {
            block6: {
                if (Build.VERSION.SDK_INT <= 10) {
                    return 1;
                }
                n2 = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
                if (n2 != -1) break block6;
                n2 = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n2 != -1) break block7;
            try {
                n2 = GDPAndroid.getCoresFromCPUFileList();
                break block7;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {}
            n2 = -1;
        }
        Log.i((String)TAG, (String)("cores:" + n2));
        return n2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getCoresFromFileInfo(String object) {
        FileInputStream fileInputStream;
        block15: {
            void var0_4;
            block14: {
                int n2;
                BufferedReader bufferedReader;
                FileInputStream fileInputStream2;
                Object var1_6 = null;
                fileInputStream = fileInputStream2;
                try {
                    fileInputStream2 = new FileInputStream((String)object);
                }
                catch (Throwable throwable) {
                    fileInputStream = var1_6;
                    break block14;
                }
                catch (IOException iOException) {
                    fileInputStream = var1_6;
                    break block15;
                }
                object = bufferedReader;
                try {
                    String string2 = new BufferedReader(new InputStreamReader(fileInputStream)).readLine();
                    ((BufferedReader)object).close();
                    n2 = GDPAndroid.getCoresFromFileString(string2);
                }
                catch (Throwable throwable) {
                    break block14;
                }
                catch (IOException iOException) {
                    break block15;
                }
                try {
                    ((InputStream)fileInputStream2).close();
                    return n2;
                }
                catch (IOException iOException) {}
                return n2;
            }
            if (fileInputStream == null) throw var0_4;
            try {
                ((InputStream)fileInputStream).close();
                throw var0_4;
            }
            catch (IOException iOException) {}
            throw var0_4;
        }
        int n3 = -1;
        if (fileInputStream == null) return n3;
        try {
            ((InputStream)fileInputStream).close();
            return n3;
        }
        catch (IOException iOException) {}
        return n3;
    }

    private static int getCoresFromFileString(String string2) {
        if (string2 != null && string2.matches("0-[\\d]+$")) {
            return Integer.valueOf(string2.substring(2)) + 1;
        }
        return -1;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }

    /*
     * Unable to fully structure code
     */
    private static int getCPUMaxFreqKHz() {
        block30: {
            var0 = -1;
            var1_2 = 0;
            while (true) {
                block27: {
                    block28: {
                        if (var1_2 >= GDPAndroid.getNumberOfCPUCores()) break;
                        var2_4 = "/sys/devices/system/cpu/cpu" + var1_2 + "/cpufreq/cpuinfo_max_freq";
                        var3_8 = v0;
                        if (!new File(var2_4).exists()) break block27;
                        if (!var3_8.canRead()) break block27;
                        var2_5 = 128;
                        var4_10 = new byte[128];
                        var5_11 = v1;
                        v2 = var4_10;
                        var5_11(var3_8);
                        v1.read(v2);
                        var3_9 = 0;
                        while (true) {
                            if (!Character.isDigit(var4_10[var3_9]) || var3_9 >= var2_5) break;
                            ++var3_9;
                            continue;
                            break;
                        }
                        var2_6 = Integer.parseInt(new String(var4_10, 0, var3_9));
                        if (var2_6 <= var0) break block28;
                        try {
                            var0 = var2_6;
                        }
                        catch (Throwable var0_1) {
                            var5_11.close();
                            throw var0_1;
                        }
                        catch (NumberFormatException v3) {
                            ** continue;
                        }
                    }
lbl36:
                    // 2 sources

                    while (true) {
                        var5_11.close();
                        break;
                    }
                }
                ++var1_2;
            }
            if (var0 == -1) {
                block29: {
                    var1_3 = v4;
                    v4 = new FileInputStream("/proc/cpuinfo");
                    var2_7 = GDPAndroid.parseFileForValue("cpu MHz", var1_3) * 1000;
                    if (var2_7 > var0) break block29;
                    var2_7 = var0;
                    {
                        catch (Throwable v5) {
                            var1_3.close();
                            throw v5;
                        }
                    }
                }
                var1_3.close();
                break block30;
            }
            var2_7 = var0;
            break block30;
            {
                catch (IOException v6) {
                    var2_7 = -1;
                }
            }
        }
        Log.i((String)GDPAndroid.TAG, (String)("max freq:" + var2_7));
        return var2_7;
    }

    /*
     * Loose catch block
     */
    private static long getTotalMemory(Context object) {
        FileInputStream fileInputStream;
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memoryInfo;
            Context context = object;
            object = memoryInfo;
            memoryInfo = new ActivityManager.MemoryInfo();
            ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)object);
            Log.i((String)TAG, (String)("total mem:" + ((ActivityManager.MemoryInfo)object).totalMem));
            return ((ActivityManager.MemoryInfo)object).totalMem;
        }
        long l2 = -1L;
        object = fileInputStream;
        try {
            fileInputStream = new FileInputStream("/proc/meminfo");
        }
        catch (IOException iOException) {}
        l2 = (long)GDPAndroid.parseFileForValue("MemTotal", (FileInputStream)object) * 1024L;
        {
            catch (Throwable throwable) {
                ((FileInputStream)object).close();
                throw throwable;
            }
        }
        fileInputStream.close();
        Log.i((String)TAG, (String)("total mem:" + l2));
        return l2;
    }

    private static int parseFileForValue(String string2, FileInputStream object) {
        FileInputStream fileInputStream = object;
        byte[] byArray = new byte[1024];
        object = byArray;
        int n2 = fileInputStream.read(byArray);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            if (object[i2] != 10 && i2 != 0) continue;
            try {
                if (object[i2] == 10) {
                    // empty if block
                }
                n3 = ++i2;
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            catch (IOException iOException) {}
            while (n3 < n2) {
                int n4 = n3++;
                int n5 = n4 - i2;
                if (object[n4] != string2.charAt(n5)) continue block8;
                if (n5 != string2.length() - 1) continue;
                return GDPAndroid.extractValue((byte[])object, n3);
            }
            continue;
            break;
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n2) {
        while (n2 < byArray.length && byArray[n2] != 10) {
            if (Character.isDigit(byArray[n2])) {
                int n3;
                for (n3 = n2 + 1; n3 < byArray.length && Character.isDigit(byArray[n3]); ++n3) {
                }
                int n4 = n3 - n2;
                return Integer.parseInt(new String(byArray, 0, n2, n4));
            }
            ++n2;
        }
        return -1;
    }

    private double readOneLine(File object) {
        Object object2 = "";
        if (((File)object).exists() && ((File)object).canRead()) {
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2 = fileInputStream;
            fileInputStream = new FileInputStream((File)object);
            object = inputStreamReader;
            inputStreamReader = new InputStreamReader(fileInputStream2);
            BufferedReader bufferedReader2 = bufferedReader;
            Object object3 = object;
            FileInputStream fileInputStream3 = fileInputStream2;
            BufferedReader bufferedReader3 = bufferedReader2;
            bufferedReader3((Reader)object);
            object2 = bufferedReader3.readLine();
            try {
                fileInputStream3.close();
                ((InputStreamReader)object3).close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            double d2 = -100000.0;
            try {
                d2 = Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {}
            return d2;
        }
        return -100000.0;
    }

    private boolean isTemperatureValid(double d2) {
        return d2 >= -30.0 && d2 <= 250.0;
    }

    public boolean initGDP(Context context) {
        this.mAppContext = context;
        if (this.isEGL14SupportedHere()) {
            this.gatherGlInfo();
        }
        return true;
    }

    public int getCpuCores() {
        return GDPAndroid.getNumberOfCPUCores();
    }

    public int getCpuClock() {
        return GDPAndroid.getCPUMaxFreqKHz();
    }

    public String getCpuVendor() {
        return Build.HARDWARE;
    }

    public int getRam() {
        return (int)(GDPAndroid.getTotalMemory(this.mAppContext) / 1024L);
    }

    public String getGpuVendor() {
        return this.mGpuVendor;
    }

    public String getGpuRenderer() {
        return this.mGpuRenderer;
    }

    public int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    public String getDeviceName() {
        return Build.MODEL;
    }

    public int getBattery() {
        return this.getBatteryLevel();
    }

    public boolean checkBackground() {
        Object object;
        Object object2 = (ActivityManager)((GDPAndroid)object).mAppContext.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 21) {
            object = object2.getRunningAppProcesses();
            if (!object.isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (((ActivityManager.RunningAppProcessInfo)object.next()).importance != 100) continue;
                    return false;
                }
            }
        } else {
            object = ((GDPAndroid)object).mAppContext.getPackageName();
            if (!(object2 = object2.getRunningTasks(1)).isEmpty() && (object2 = ((ActivityManager.RunningTaskInfo)object2.get((int)0)).topActivity) != null) {
                return ((String)object).equals(object2.getPackageName()) ^ true;
            }
        }
        return true;
    }

    public int getCpuTemperature() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < CPU_TEMP_FILE_PATHS.size(); ++i2) {
            GDPAndroid gDPAndroid = this;
            String string2 = CPU_TEMP_FILE_PATHS.get(i2);
            Double d3 = gDPAndroid.readOneLine(new File(string2));
            if (gDPAndroid.isTemperatureValid(d3)) {
                d2 = d3;
                Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string2));
                break;
            }
            if (!this.isTemperatureValid(d3 / 1000.0)) continue;
            d2 = d3 / 1000.0;
            Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string2));
            break;
        }
        return (int)(d2 * 1000.0);
    }
}

