/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.view.Surface;
import io.agora.rtc.gl.EglBase10;
import io.agora.rtc.gl.EglBase14;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;

public abstract class EglBase {
    private static List<String> glFlushBuggyDevices = Arrays.asList("Redmi 4A", "Redmi 5A");
    public static final Object lock = new Object();
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_RECORDABLE_ANDROID = 12610;
    public static final int[] CONFIG_PLAIN = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344};
    public static final int[] CONFIG_RGBA = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
    public static final int[] CONFIG_PIXEL_BUFFER = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12339, 1, 12344};
    public static final int[] CONFIG_PIXEL_RGBA_BUFFER = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12339, 1, 12344};
    public static final int[] CONFIG_RECORDABLE = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12344};

    public static EglBase create(Context context, int[] nArray) {
        EglBase eglBase;
        if (EglBase14.isEGL14Supported() && (context == null || context instanceof EglBase14.Context)) {
            EglBase14 eglBase14;
            eglBase = eglBase14;
            eglBase14 = new EglBase14((EglBase14.Context)context, nArray);
        } else {
            EglBase10 eglBase10;
            eglBase = eglBase10;
            eglBase10 = new EglBase10((EglBase10.Context)context, nArray);
        }
        return eglBase;
    }

    public static EglBase create() {
        return EglBase.create(null, CONFIG_PLAIN);
    }

    public static EglBase create(Context context) {
        return EglBase.create(context, CONFIG_PLAIN);
    }

    public static EglBase createEgl10(int[] nArray) {
        return new EglBase10(null, nArray);
    }

    public static EglBase createEgl10(javax.microedition.khronos.egl.EGLContext eGLContext, int[] nArray) {
        EglBase10.Context context;
        EglBase10.Context context2 = context;
        context = new EglBase10.Context(eGLContext);
        return new EglBase10(context2, nArray);
    }

    public static EglBase createEgl14(int[] nArray) {
        return new EglBase14(null, nArray);
    }

    public static EglBase createEgl14(EGLContext eGLContext, int[] nArray) {
        EglBase14.Context context;
        EglBase14.Context context2 = context;
        context = new EglBase14.Context(eGLContext);
        return new EglBase14(context2, nArray);
    }

    public static Context getCurrentContext() {
        if (EglBase14.isEGL14Supported()) {
            EGLContext eGLContext = EGL14.eglGetCurrentContext();
            return new EglBase14.Context(eGLContext);
        }
        javax.microedition.khronos.egl.EGLContext eGLContext = ((EGL10)javax.microedition.khronos.egl.EGLContext.getEGL()).eglGetCurrentContext();
        return new EglBase10.Context(eGLContext);
    }

    public static boolean isGlFlushBuggyDevice() {
        Iterator<String> iterator = glFlushBuggyDevices.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equalsIgnoreCase(Build.MODEL)) continue;
            return true;
        }
        return false;
    }

    public static void addGlFlushBuggyDevices(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(glFlushBuggyDevices);
        arrayList.addAll(list);
        glFlushBuggyDevices = arrayList;
    }

    public abstract void createSurface(Surface var1);

    public abstract void createSurface(SurfaceTexture var1);

    public abstract void createDummyPbufferSurface();

    public abstract void createPbufferSurface(int var1, int var2);

    public abstract Context getEglBaseContext();

    public abstract boolean hasSurface();

    public abstract int surfaceWidth();

    public abstract int surfaceHeight();

    public abstract void releaseSurface();

    public abstract void release();

    public abstract void makeCurrent();

    public abstract void detachCurrent();

    public abstract void swapBuffers();

    public abstract void swapBuffers(long var1);

    public static interface Context {
        public long getNativeEglContext();

        public Object getRealEglContext();

        public int getEglType();
    }

    public static interface EglType {
        public static final int EGL10 = 0;
        public static final int EGL14 = 1;
    }
}

