/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.Logging;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglBase10
extends EglBase {
    private static final String TAG = "EglBase10";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private final EGL10 egl;
    private EGLContext eglContext;
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface;

    public EglBase10(Context context, int[] nArray) {
        EglBase10 eglBase10 = eglBase103;
        EglBase10 eglBase102 = eglBase103;
        eglBase102.eglSurface = EGL10.EGL_NO_SURFACE;
        Logging.i(TAG, "create, this: " + eglBase103 + ", shared: " + context);
        eglBase102.egl = (EGL10)EGLContext.getEGL();
        EglBase10 eglBase103 = eglBase102.getEglDisplay();
        eglBase102.eglDisplay = eglBase103;
        eglBase103 = eglBase102.getEglConfig((EGLDisplay)eglBase103, nArray);
        eglBase102.eglConfig = eglBase103;
        eglBase10.eglContext = eglBase10.createEglContext(context, eglBase102.eglDisplay, (EGLConfig)eglBase103);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        EglBase10 eglBase10 = this;
        eglBase10.checkIsNotReleased();
        if (!eglBase10.hasSurface()) {
            EglBase10 eglBase102 = this;
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            EglBase10 eglBase103 = this;
            EGLDisplay eGLDisplay = eglBase103.eglDisplay;
            eglBase102.eglSurface = eglBase102.egl.eglCreateWindowSurface(eGLDisplay, eglBase103.eglConfig, object, nArray2);
            if (eglBase102.hasSurface()) {
                return;
            }
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL10.EGL_NO_DISPLAY && this.eglContext != EGL10.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay != EGL10.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (this.egl.eglInitialize(eGLDisplay, nArray)) {
                return eGLDisplay;
            }
            throw new RuntimeException("Unable to initialize EGL10: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Unable to get EGL10 display: 0x" + Integer.toHexString(this.egl.eglGetError()));
    }

    private EGLConfig getEglConfig(EGLDisplay eGLDisplay, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (eglBase10.egl.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, 1, nArray2)) {
            if (nArray2[0] > 0) {
                EglBase10 eglBase10 = eGLConfigArray[0];
                if (eglBase10 != null) {
                    return eglBase10;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(eglBase10.egl.eglGetError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EGLContext createEglContext(Context context, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        if (context != null && context.eglContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        Object object = nArray;
        nArray[0] = 12440;
        nArray[1] = 2;
        nArray[2] = 12344;
        context = context == null ? EGL10.EGL_NO_CONTEXT : context.eglContext;
        EglBase10 eglBase10 = this;
        Object object2 = EglBase.lock;
        synchronized (object2) {
            block8: {
                object = eglBase10.egl.eglCreateContext(eGLDisplay, eGLConfig, (EGLContext)context, object);
                if (eglBase10.egl.eglGetError() == 12288) break block8;
                EglBase10 eglBase102 = this;
                int[] nArray2 = new int[3];
                object = nArray2;
                nArray2[0] = 12440;
                nArray2[1] = 3;
                nArray2[2] = 12344;
                object = eglBase102.egl.eglCreateContext(eGLDisplay, eGLConfig, (EGLContext)context, object);
            }
            // MONITOREXIT @DISABLED, blocks:[4, 5] lbl26 : MonitorExitStatement: MONITOREXIT : object2
            if (object == EGL10.EGL_NO_CONTEXT) throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return object;
        }
    }

    @Override
    public void createSurface(Surface surface) {
        FakeSurfaceHolder fakeSurfaceHolder;
        FakeSurfaceHolder fakeSurfaceHolder2 = fakeSurfaceHolder;
        class FakeSurfaceHolder
        implements SurfaceHolder {
            private final Surface surface;

            FakeSurfaceHolder(Surface surface) {
                this.surface = surface;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int n2) {
            }

            public void setFixedSize(int n2, int n3) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int n2) {
            }

            public void setKeepScreenOn(boolean bl) {
            }

            public Canvas lockCanvas() {
                return null;
            }

            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }

            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        fakeSurfaceHolder = new FakeSurfaceHolder(surface);
        this.createSurfaceInternal(fakeSurfaceHolder2);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n2, int n3) {
        EglBase10 eglBase10 = this;
        eglBase10.checkIsNotReleased();
        if (!eglBase10.hasSurface()) {
            EglBase10 eglBase102 = this;
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n2;
            nArray[2] = 12374;
            nArray[3] = n3;
            nArray[4] = 12344;
            EglBase10 eglBase103 = this;
            EGLDisplay eGLDisplay = eglBase103.eglDisplay;
            eglBase102.eglSurface = eglBase102.egl.eglCreatePbufferSurface(eGLDisplay, eglBase103.eglConfig, nArray2);
            if (eglBase102.hasSurface()) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n2 + "x" + n3 + ": 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        EglBase10 eglBase10 = eglBase10.eglSurface;
        return eglBase10 != null && !eglBase10.equals(EGL10.EGL_NO_SURFACE);
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EglBase10 eglBase10 = eglBase102;
        EglBase10 eglBase102 = eglBase10.eglDisplay;
        eglBase102.egl.eglQuerySurface((EGLDisplay)eglBase102, eglBase10.eglSurface, 12375, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EglBase10 eglBase10 = eglBase102;
        EglBase10 eglBase102 = eglBase10.eglDisplay;
        eglBase102.egl.eglQuerySurface((EGLDisplay)eglBase102, eglBase10.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        if (eglBase103.hasSurface()) {
            EglBase10 eglBase10 = eglBase103;
            EglBase10 eglBase102 = eglBase103;
            EglBase10 eglBase103 = eglBase102.eglDisplay;
            eglBase10.egl.eglDestroySurface((EGLDisplay)eglBase103, eglBase102.eglSurface);
            eglBase10.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    @Override
    public void release() {
        EglBase10 eglBase10 = this;
        Logging.i(TAG, "release, this: " + this);
        eglBase10.checkIsNotReleased();
        eglBase10.releaseSurface();
        eglBase10.detachCurrent();
        EglBase10 eglBase102 = this;
        EGLDisplay eGLDisplay = eglBase102.eglDisplay;
        eglBase10.egl.eglDestroyContext(eGLDisplay, eglBase102.eglContext);
        eglBase10.egl.eglTerminate(this.eglDisplay);
        eglBase10.eglContext = EGL10.EGL_NO_CONTEXT;
        eglBase10.eglDisplay = EGL10.EGL_NO_DISPLAY;
        eglBase10.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase10 eglBase10 = this;
        eglBase10.checkIsNotReleased();
        if (!eglBase10.hasSurface()) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            EGL10 eGL10 = this.egl;
            EglBase10 eglBase102 = this;
            EglBase10 eglBase103 = eglBase102;
            EglBase10 eglBase104 = eglBase102;
            EglBase10 eglBase105 = eglBase102;
            EGLDisplay eGLDisplay = eglBase102.eglDisplay;
            EGLSurface eGLSurface = eglBase103.eglSurface;
            EGLSurface eGLSurface2 = eglBase104.eglSurface;
            EGLContext eGLContext = eglBase105.eglContext;
            if (!eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface2, eGLContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase10 eglBase10 = eglBase104;
        eglBase10.checkIsNotReleased();
        if (eglBase10.hasSurface()) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL10 eGL10 = eglBase104.egl;
                EglBase10 eglBase102 = eglBase104;
                EglBase10 eglBase103 = eglBase102;
                EglBase10 eglBase104 = eglBase102.eglDisplay;
                eGL10.eglSwapBuffers((EGLDisplay)eglBase104, eglBase103.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    @Override
    public void swapBuffers(long l2) {
        this.swapBuffers();
    }

    public static class Context
    implements EglBase.Context {
        private final EGLContext eglContext;

        public Context(EGLContext eGLContext) {
            this.eglContext = eGLContext;
        }

        @Override
        public long getNativeEglContext() {
            return 0L;
        }

        @Override
        public Object getRealEglContext() {
            return this.eglContext;
        }

        @Override
        public int getEglType() {
            return 0;
        }
    }
}

