/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.Logging;

@TargetApi(value=18)
public class EglBase14
extends EglBase {
    private static final String TAG = "EglBase14";
    private static final int EGLExt_SDK_VERSION = 18;
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private EGLContext eglContext;
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface;

    public static boolean isEGL14Supported() {
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("SDK version: ").append(CURRENT_SDK_VERSION).append(". isEGL14Supported: ");
        boolean bl = CURRENT_SDK_VERSION >= 18;
        Log.d((String)string2, (String)stringBuilder.append(bl).toString());
        return CURRENT_SDK_VERSION >= 18;
    }

    public EglBase14(Context context, int[] nArray) {
        EglBase14 eglBase14 = eglBase143;
        Context context2 = context;
        EglBase14 eglBase142 = eglBase143;
        eglBase142.eglSurface = EGL14.EGL_NO_SURFACE;
        Logging.i(TAG, "create, this: " + eglBase143 + ", shared: " + context);
        context = EglBase14.getEglDisplay();
        eglBase143.eglDisplay = context;
        EglBase14 eglBase143 = EglBase14.getEglConfig((EGLDisplay)context, nArray);
        eglBase142.eglConfig = eglBase143;
        eglBase14.eglContext = EglBase14.createEglContext(context2, eglBase142.eglDisplay, (EGLConfig)eglBase143);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        EglBase14 eglBase14 = this;
        eglBase14.checkIsNotReleased();
        if (!eglBase14.hasSurface()) {
            EglBase14 eglBase142 = this;
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            eglBase142.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eglBase142.eglDisplay, (EGLConfig)this.eglConfig, (Object)object, (int[])nArray2, (int)0);
            if (eglBase142.hasSurface()) {
                return;
            }
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY && this.eglContext != EGL14.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    private static EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                return eGLDisplay;
            }
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
    }

    private static EGLConfig getEglConfig(EGLDisplay eGLConfig, int[] nArray) {
        if (EGL14.eglChooseConfig((EGLDisplay)eGLConfig, (int[])nArray, (int)0, (EGLConfig[])(eGLConfig = new EGLConfig[1]), (int)0, (int)1, (int[])(nArray = new int[1]), (int)0)) {
            if (nArray[0] > 0) {
                if ((eGLConfig = eGLConfig[0]) != null) {
                    return eGLConfig;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EGLContext createEglContext(Context context, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        if (context != null && context.egl14Context == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        Object object = nArray;
        nArray[0] = 12440;
        nArray[1] = 2;
        nArray[2] = 12344;
        context = context == null ? EGL14.EGL_NO_CONTEXT : context.egl14Context;
        int[] nArray2 = object;
        Object object2 = EglBase.lock;
        object = object2;
        synchronized (object2) {
            block8: {
                EGLContext eGLContext;
                block7: {
                    eGLContext = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)context, (int[])nArray2, (int)0);
                    if (EGL14.eglGetError() == 12288) break block7;
                    eGLContext = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)context, (int[])new int[]{12440, 3, 12344}, (int)0);
                }
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                if (eGLContext == EGL14.EGL_NO_CONTEXT) break block8;
                return eGLContext;
            }
            throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n2, int n3) {
        EglBase14 eglBase14 = this;
        eglBase14.checkIsNotReleased();
        if (!eglBase14.hasSurface()) {
            EglBase14 eglBase142 = this;
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n2;
            nArray[2] = 12374;
            nArray[3] = n3;
            nArray[4] = 12344;
            eglBase142.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eglBase142.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray2, (int)0);
            if (eglBase142.hasSurface()) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n2 + "x" + n3 + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        EglBase14 eglBase14 = eglBase14.eglSurface;
        return eglBase14 != null && !eglBase14.equals(EGL14.EGL_NO_SURFACE);
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        if (this.hasSurface()) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    @Override
    public void release() {
        EglBase14 eglBase14 = this;
        Logging.i(TAG, "release, this: " + this);
        eglBase14.checkIsNotReleased();
        eglBase14.releaseSurface();
        eglBase14.detachCurrent();
        EGL14.eglDestroyContext((EGLDisplay)eglBase14.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)eglBase14.eglDisplay);
        eglBase14.eglContext = EGL14.EGL_NO_CONTEXT;
        eglBase14.eglDisplay = EGL14.EGL_NO_DISPLAY;
        eglBase14.eglConfig = null;
        Logging.i(TAG, "release done, this: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase14 eglBase14 = eglBase145;
        eglBase14.checkIsNotReleased();
        if (!eglBase14.hasSurface()) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            EGLDisplay eGLDisplay = eglBase145.eglDisplay;
            EglBase14 eglBase142 = eglBase145;
            EglBase14 eglBase143 = eglBase142;
            EglBase14 eglBase144 = eglBase142;
            EglBase14 eglBase145 = eglBase142.eglSurface;
            EGLSurface eGLSurface = eglBase144.eglSurface;
            EGLContext eGLContext = eglBase143.eglContext;
            if (!EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eglBase145, (EGLSurface)eGLSurface, (EGLContext)eGLContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        EglBase14 eglBase14 = object;
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)eglBase14.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase14 eglBase14 = this;
        eglBase14.checkIsNotReleased();
        if (eglBase14.hasSurface()) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers(long l2) {
        EglBase14 eglBase14 = this;
        eglBase14.checkIsNotReleased();
        if (eglBase14.hasSurface()) {
            Object object = EglBase.lock;
            EglBase14 eglBase142 = this;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)eglBase142.eglDisplay, (EGLSurface)this.eglSurface, (long)l2);
                EGL14.eglSwapBuffers((EGLDisplay)eglBase142.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    public static class Context
    implements EglBase.Context {
        private final EGLContext egl14Context;

        public Context(EGLContext eGLContext) {
            this.egl14Context = eGLContext;
        }

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            return CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
        }

        @Override
        public Object getRealEglContext() {
            return this.egl14Context;
        }

        @Override
        public int getEglType() {
            return 1;
        }
    }
}

