/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.VideoFrameDrawer;
import io.agora.rtc.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EglRenderer {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    private static final int MAX_SURFACE_CLEAR_COUNT = 3;
    private final String name;
    private final Object handlerLock;
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners;
    private final Object fpsReductionLock;
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer;
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix;
    private final Object frameLock;
    private VideoFrame pendingFrame;
    private final Object layoutLock;
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock;
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final Runnable logStatisticsRunnable;
    private final EglSurfaceCreation eglSurfaceCreationRunnable;

    public EglRenderer(String string2) {
        EglSurfaceCreation eglSurfaceCreation;
        Runnable runnable;
        Object object;
        Object object2;
        Object object3;
        Matrix matrix;
        VideoFrameDrawer videoFrameDrawer;
        Object object4;
        ArrayList arrayList;
        Object object5;
        Object object6 = object5;
        object5 = new Object();
        this.handlerLock = object6;
        object6 = arrayList;
        arrayList = new ArrayList();
        this.frameListeners = object6;
        object6 = object4;
        object4 = new Object();
        this.fpsReductionLock = object6;
        object6 = videoFrameDrawer;
        videoFrameDrawer = new VideoFrameDrawer();
        this.frameDrawer = object6;
        object6 = matrix;
        matrix = new Matrix();
        this.drawMatrix = object6;
        object6 = object3;
        object3 = new Object();
        this.frameLock = object6;
        object6 = object2;
        object2 = new Object();
        this.layoutLock = object6;
        object6 = object;
        object = new Object();
        this.statisticsLock = object6;
        object6 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 v0 = this;
                v0.EglRenderer.this.logStatistics();
                Object object = v0.EglRenderer.this.handlerLock;
                synchronized (object) {
                    block5: {
                        if (v0.EglRenderer.this.renderThreadHandler == null) break block5;
                        1 v2 = this;
                        v2.EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                        v2.EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                    }
                    return;
                }
            }
        };
        this.logStatisticsRunnable = object6;
        object6 = eglSurfaceCreation;
        eglSurfaceCreation = new EglSurfaceCreation();
        this.eglSurfaceCreationRunnable = object6;
        this.name = string2;
    }

    private void createEglSurfaceInternal(Object object) {
        EglRenderer eglRenderer = this;
        eglRenderer.eglSurfaceCreationRunnable.setSurface(object);
        eglRenderer.postToRenderThread(eglRenderer.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l2) {
        Object object = this.statisticsLock;
        EglRenderer eglRenderer = this;
        synchronized (object) {
            eglRenderer.statisticsStartTimeNs = l2;
            eglRenderer.framesReceived = 0;
            eglRenderer.framesDropped = 0;
            eglRenderer.framesRendered = 0;
            eglRenderer.renderTimeNs = 0L;
            eglRenderer.renderSwapBufferTimeNs = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block5: {
                if (eglRenderer.renderThreadHandler == null) break block5;
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    private void clearSurfaceOnRenderThread(float f2, float f3, float f4, float f5) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null && eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderFrameOnRenderThread() {
        block24: {
            block30: {
                block28: {
                    v0 = this;
                    var1_1 = v0.frameLock;
                    synchronized (var1_1) {
                        if (v0.pendingFrame == null) {
                            return;
                        }
                        var2_4 = this.pendingFrame;
                        this.pendingFrame = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                        var1_1 = this.eglBase;
                        if (var1_1 == null || !var1_1.hasSurface()) break block24;
                        v1 = this;
                        var1_1 = v1.fpsReductionLock;
                    }
                    synchronized (var1_1) {
                        block27: {
                            block26: {
                                block25: {
                                    if (v1.minRenderPeriodNs == 0x7FFFFFFFFFFFFFFFL) break block25;
                                    if (this.minRenderPeriodNs <= 0L) break block26;
                                    var3_5 = System.nanoTime();
                                    break block27;
                                }
lbl26:
                                // 2 sources

                                while (true) {
                                    var3_6 = false;
                                    ** GOTO lbl41
                                    break;
                                }
                            }
lbl30:
                            // 2 sources

                            while (true) {
                                var3_6 = true;
                                ** GOTO lbl41
                                break;
                            }
                        }
                        if (var3_5 < this.nextFrameTimeNs) {
                            this.logD("Skipping frame rendering - fps reduction is active.");
                            ** continue;
                        }
                        var5_8 = this.nextFrameTimeNs + this.minRenderPeriodNs;
                        {
                            this.nextFrameTimeNs = var5_8;
                            this.nextFrameTimeNs = Math.max(var5_8, var3_5);
                            ** continue;
lbl41:
                            // 2 sources

                            v4 = this;
                            v5 = v4;
                            v6 = v4;
                            v7 = var2_4;
                        }
                    }
                    var4_9 = System.nanoTime();
                    var1_2 = (float)v7.getRotatedWidth() / (float)var2_4.getRotatedHeight();
                    var6_10 = v5.layoutLock;
                    synchronized (var6_10) {
                        if (v6.layoutAspectRatio != 0.0f) {
                        }
                        ** GOTO lbl57
                        {
                            block29: {
                                var7_14 = this.layoutAspectRatio;
                                break block29;
lbl57:
                                // 1 sources

                                var7_14 = var1_2;
                            }
                            // MONITOREXIT @DISABLED, blocks:[5, 11] lbl59 : MonitorExitStatement: MONITOREXIT : var6_10
                            if (!(var1_2 > var7_14)) break block28;
                        }
                    }
                    var1_2 = var7_14 / var1_2;
                    var6_11 = 1.0f;
                    break block30;
                }
                v9 = var1_2;
                var1_2 = 1.0f;
                var6_11 = v9 / var7_14;
            }
            v10 = this;
            v10.drawMatrix.reset();
            v10.drawMatrix.preTranslate(0.5f, 0.5f);
            if (v10.mirror) {
                this.drawMatrix.preScale(-1.0f, 1.0f);
            }
            v11 = this;
            v11.drawMatrix.preScale(var1_2, var6_11);
            v11.drawMatrix.preTranslate(-0.5f, -0.5f);
            if (var3_6) {
                v12 = this;
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
                v13 = this;
                var1_3 = v13.drawer;
                var3_7 = v13.drawMatrix;
                var6_12 = v13.eglBase.surfaceWidth();
                var7_15 = v13.eglBase.surfaceHeight();
                v12.frameDrawer.drawFrame(var2_4, (RendererCommon.GlDrawer)var1_3, var3_7, 0, 0, var6_12, var7_15);
                var6_13 = System.nanoTime();
                v12.eglBase.swapBuffers();
                var8_16 = System.nanoTime();
                var1_3 = v12.statisticsLock;
                v14 = this;
                synchronized (var1_3) {
                    ++v14.framesRendered;
                    v15 = v14.renderTimeNs;
                    {
                        v14.renderTimeNs = v15 + (var8_16 - var4_9);
                        {
                            v14.renderSwapBufferTimeNs = v14.renderSwapBufferTimeNs + (var8_16 - var6_13);
                        }
                    }
                }
            }
            var2_4.release();
            return;
        }
        this.logD("Dropping frame - No surface");
        var2_4.release();
    }

    private String averageTimeAsString(long l2, int n2) {
        return n2 <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l2 / (long)n2) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logStatistics() {
        long l2 = System.nanoTime();
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.statisticsLock;
        synchronized (object) {
            long l3 = l2 - eglRenderer.statisticsStartTimeNs;
            if (l3 <= 0L) {
                return;
            }
            Object object2 = object;
            EglRenderer eglRenderer2 = this;
            long l4 = l2;
            EglRenderer eglRenderer3 = this;
            EglRenderer eglRenderer4 = eglRenderer3;
            float f2 = (float)((long)eglRenderer3.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l3;
            StringBuilder stringBuilder = new StringBuilder().append("Duration: ").append(TimeUnit.NANOSECONDS.toMillis(l3)).append(" ms. Frames received: ").append(this.framesReceived).append(". Dropped: ").append(this.framesDropped).append(". Rendered: ").append(this.framesRendered).append(". Render fps: ");
            Locale locale = Locale.US;
            String string2 = "%.1f";
            Object[] objectArray = new Object[1];
            int n2 = 0;
            objectArray[n2] = Float.valueOf(f2);
            EglRenderer eglRenderer5 = this;
            long l5 = eglRenderer5.renderTimeNs;
            int n3 = eglRenderer5.framesRendered;
            StringBuilder stringBuilder2 = stringBuilder.append(String.format(locale, string2, objectArray)).append(". Average render time: ").append(eglRenderer5.averageTimeAsString(l5, n3)).append(". Average swapBuffer time: ");
            EglRenderer eglRenderer6 = this;
            l5 = eglRenderer6.renderSwapBufferTimeNs;
            int n4 = eglRenderer6.framesRendered;
            eglRenderer4.logD(stringBuilder2.append(eglRenderer6.averageTimeAsString(l5, n4)).append(".").toString());
            eglRenderer2.resetStatistics(l4);
            // ** MonitorExit[v1] (shouldn't be in output)
            return;
        }
    }

    private void logD(String string2) {
        Log.d((String)TAG, (String)(this.name + string2));
    }

    static /* synthetic */ EglBase access$002(EglRenderer eglRenderer, EglBase eglBase) {
        eglRenderer.eglBase = eglBase;
        return eglBase;
    }

    static /* synthetic */ RendererCommon.GlDrawer access$702(EglRenderer eglRenderer, RendererCommon.GlDrawer glDrawer) {
        eglRenderer.drawer = glDrawer;
        return glDrawer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void init(final EglBase.Context var1_1, final int[] var2_2, RendererCommon.GlDrawer var3_3) {
        v0 = this;
        var4_4 = v0.handlerLock;
        synchronized (var4_4) {
            if (v0.renderThreadHandler != null) ** GOTO lbl27
            v2 = var4_4;
            v3 = this;
            v4 = v3;
            v5 = v3;
            this.logD("Initializing EglRenderer");
            v3.drawer = var3_3;
            var3_3 = v6;
            new HandlerThread(this.name + "EglRenderer").start();
            this.renderThreadHandler = new Handler(var3_3.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    if (var1_1 == null) {
                        2 v0 = this;
                        v0.EglRenderer.this.logD("EglBase.create context");
                        EglRenderer.access$002(v0.EglRenderer.this, EglBase.create(var1_1, var2_2));
                    } else {
                        2 v1 = this;
                        v1.EglRenderer.this.logD("EglBase.create shared context");
                        EglRenderer.access$002(v1.EglRenderer.this, EglBase.create(var1_1, var2_2));
                    }
                }
            });
            v5.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            v4.resetStatistics(System.nanoTime());
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl27:
            // 1 sources

            v7 = v8;
            v9 = v8;
            v7(this.name + "Already initialized");
            throw v9;
        }
    }

    public EglBase.Context getEglContext() {
        return this.eglBase.getEglBaseContext();
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        CountDownLatch countDownLatch;
        EglRenderer eglRenderer = this;
        eglRenderer.logD("Releasing.");
        Object object = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Object object2 = eglRenderer.handlerLock;
        synchronized (object2) {
            if (eglRenderer.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            EglRenderer eglRenderer2 = this;
            EglRenderer eglRenderer3 = eglRenderer2;
            EglRenderer eglRenderer4 = eglRenderer2;
            Object object3 = object2;
            EglRenderer eglRenderer5 = this;
            CountDownLatch countDownLatch2 = object;
            EglRenderer eglRenderer6 = this;
            EglRenderer eglRenderer7 = eglRenderer6;
            EglRenderer eglRenderer8 = eglRenderer6;
            eglRenderer6.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    if (EglRenderer.this.drawer != null) {
                        3 v0 = this;
                        v0.EglRenderer.this.drawer.release();
                        EglRenderer.access$702(v0.EglRenderer.this, null);
                    }
                    3 v1 = this;
                    v1.EglRenderer.this.frameDrawer.release();
                    if (v1.EglRenderer.this.eglBase != null) {
                        3 v2 = this;
                        v2.EglRenderer.this.logD("eglBase detach and release.");
                        v2.EglRenderer.this.eglBase.detachCurrent();
                        v2.EglRenderer.this.eglBase.release();
                        EglRenderer.access$002(v2.EglRenderer.this, null);
                    }
                }
            });
            {
                final Looper looper = eglRenderer8.renderThreadHandler.getLooper();
                eglRenderer7.renderThreadHandler.post(new Runnable((CountDownLatch)object){
                    final /* synthetic */ CountDownLatch val$eglCleanupBarrier;
                    {
                        this.val$eglCleanupBarrier = countDownLatch;
                    }

                    @Override
                    public void run() {
                        4 v0 = this;
                        v0.EglRenderer.this.logD("Quitting render thread.");
                        v0.looper.quit();
                        v0.val$eglCleanupBarrier.countDown();
                    }
                });
            }
            {
                ThreadUtils.awaitUninterruptibly(countDownLatch2);
                eglRenderer5.renderThreadHandler = null;
                // ** MonitorExit[v5] (shouldn't be in output)
                object = eglRenderer3.frameLock;
            }
            synchronized (object) {
                if (eglRenderer4.pendingFrame != null) {
                    this.pendingFrame.release();
                    this.pendingFrame = null;
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl38 : MonitorExitStatement: MONITOREXIT : var1_1
                this.logD("Releasing done.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block13: {
                StackTraceElement[] stackTraceElementArray;
                block12: {
                    block11: {
                        if (eglRenderer.renderThreadHandler != null) break block11;
                        stackTraceElementArray = null;
                        break block12;
                    }
                    stackTraceElementArray = this.renderThreadHandler.getLooper().getThread();
                }
                if (stackTraceElementArray != null) {
                    stackTraceElementArray = stackTraceElementArray.getStackTrace();
                    if (stackTraceElementArray.length <= 0) break block13;
                    this.logD("EglRenderer stack trace:");
                    int n2 = stackTraceElementArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        this.logD(stackTraceElementArray[i2].toString());
                        continue;
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setMirror: " + bl);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.mirror = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f2) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setLayoutAspectRatio: " + f2);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setFpsReduction(float var1_1) {
        v0 = this;
        v0.logD("setFpsReduction: " + var1_1);
        var2_2 = v0.fpsReductionLock;
        synchronized (var2_2) {
            var3_3 = v0.minRenderPeriodNs;
            if (!(var1_1 <= 0.0f)) ** GOTO lbl13
            this.minRenderPeriodNs = 0x7FFFFFFFFFFFFFFFL;
            ** GOTO lbl17
lbl13:
            // 1 sources

            v2 = this;
            v3 = TimeUnit.SECONDS.toNanos(1L);
            v2.minRenderPeriodNs = (long)(v3 / var1_1);
lbl17:
            // 2 sources

            if (this.minRenderPeriodNs == var3_3) ** GOTO lbl20
            this.nextFrameTimeNs = System.nanoTime();
lbl20:
            // 2 sources

            return;
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f2) {
        this.addFrameListener(frameListener, f2, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f2, glDrawer, false);
    }

    public void addFrameListener(final FrameListener frameListener, final float f2, final RendererCommon.GlDrawer glDrawer, final boolean bl) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                RendererCommon.GlDrawer glDrawer2 = frameListener2.glDrawer;
                if (glDrawer2 == null) {
                    glDrawer2 = frameListener2.EglRenderer.this.drawer;
                }
                5 v0 = frameListener2;
                FrameListener frameListener2 = v0.frameListener;
                float f22 = v0.f2;
                boolean bl2 = v0.bl;
                frameListener2.EglRenderer.this.frameListeners.add(new FrameListenerAndParams(frameListener2, f22, glDrawer2, bl2));
            }
        };
        this.postToRenderThread(runnable2);
    }

    public void removeFrameListener(final FrameListener frameListener) {
        if (Thread.currentThread() != this.renderThreadHandler.getLooper().getThread()) {
            Runnable runnable;
            CountDownLatch countDownLatch;
            final CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch2(1);
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    6 v0 = this;
                    v0.countDownLatch2.countDown();
                    Iterator iterator = v0.EglRenderer.this.frameListeners.iterator();
                    while (iterator.hasNext()) {
                        if (((FrameListenerAndParams)iterator.next()).listener != frameListener) continue;
                        iterator.remove();
                    }
                }
            };
            this.postToRenderThread(runnable2);
            ThreadUtils.awaitUninterruptibly(countDownLatch);
            return;
        }
        throw new RuntimeException("removeFrameListener must not be called on the render thread.");
    }

    public void renderFrame(VideoFrame videoFrame) {
        this.onFrame(videoFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onFrame(VideoFrame object) {
        EglRenderer eglRenderer = this;
        Object object2 = eglRenderer.statisticsLock;
        // MONITORENTER : object2
        ++this.framesReceived;
        // MONITOREXIT : object2
        Object object3 = eglRenderer.handlerLock;
        // MONITORENTER : object3
        if (eglRenderer.renderThreadHandler == null) {
            this.logD("Dropping frame - Not initialized or already released.");
            // MONITOREXIT : object3
            return;
        }
        EglRenderer eglRenderer2 = this;
        EglRenderer eglRenderer3 = eglRenderer2;
        object2 = eglRenderer2.frameLock;
        {
            catch (Throwable throwable) {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        boolean bl = eglRenderer3.pendingFrame != null;
        if (bl) {
            this.pendingFrame.release();
        }
        boolean bl2 = bl;
        Object object4 = object3;
        EglRenderer eglRenderer4 = this;
        this.pendingFrame = object;
        ((VideoFrame)object).retain();
        // MONITOREXIT : object2
        ThreadUtils.invokeAtFrontUninterruptibly(eglRenderer4.renderThreadHandler, new Runnable(){

            @Override
            public void run() {
                EglRenderer.this.renderFrameOnRenderThread();
            }
        });
        // MONITOREXIT : object4
        if (!bl2) return;
        object = this.statisticsLock;
        // MONITORENTER : object
        ++this.framesDropped;
        // MONITOREXIT : object
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object2
            throw throwable;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void releaseEglSurface(final Runnable var1_1) {
        v0 = this;
        v0.eglSurfaceCreationRunnable.setSurface(null);
        var2_2 = v0.handlerLock;
        synchronized (var2_2) {
            if (v0.renderThreadHandler == null) ** GOTO lbl18
            v2 = var2_2;
            v3 = this;
            v3.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
            v3.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    if (EglRenderer.this.eglBase != null) {
                        8 v0 = this;
                        v0.EglRenderer.this.eglBase.detachCurrent();
                        v0.EglRenderer.this.eglBase.releaseSurface();
                    }
                    var1_1.run();
                }
            });
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl18:
            // 1 sources

            // MONITOREXIT @DISABLED, blocks:[2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
            var1_1.run();
            return;
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearImage(final float f2, final float f3, final float f4, final float f5) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            if (eglRenderer.renderThreadHandler == null) {
                return;
            }
            Object object2 = object;
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    9 v0 = this;
                    float f22 = v0.f2;
                    float f32 = v0.f3;
                    float f42 = v0.f4;
                    float f52 = v0.f5;
                    EglRenderer.this.clearSurfaceOnRenderThread(f22, f32, f42, f52);
                }
            });
            {
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            block4: {
                if (this.surface == null || EglRenderer.this.eglBase == null || EglRenderer.this.eglBase.hasSurface()) break block4;
                Object object = this.surface;
                if (object instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else {
                    if (!(object instanceof SurfaceTexture)) {
                        throw new IllegalStateException("Invalid surface: " + this.surface);
                    }
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f2;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

