/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlShader;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.internal.ATrace;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class GlRectDrawer
implements RendererCommon.GlDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mTexCoordinate = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mPosCoordinate = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    private void drawRectangle(int n2, int n3, int n4, int n5) {
        GLES20.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
        ATrace.beginSection("glDrawArrays");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        ATrace.endSection();
    }

    private void prepareShader(String string2, float[] fArray) {
        block7: {
            Object object;
            block3: {
                block5: {
                    block6: {
                        block4: {
                            Shader shader;
                            block2: {
                                if (!((GlRectDrawer)object4).shaders.containsKey(string2)) break block2;
                                object = object4 = ((GlRectDrawer)object4).shaders.get(string2);
                                break block3;
                            }
                            object = shader;
                            ((Shader)object)(string2);
                            ((GlRectDrawer)object4).shaders.put(string2, (Shader)object);
                            shader.glShader.useProgram();
                            ATrace.beginSection("initShaderUniforms");
                            if (!YUV_FRAGMENT_SHADER_STRING.equals(string2)) break block4;
                            Object object2 = object;
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("y_tex"), (int)0);
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("u_tex"), (int)1);
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("v_tex"), (int)2);
                            break block5;
                        }
                        if (!RGB_FRAGMENT_SHADER_STRING.equals(string2)) break block6;
                        GLES20.glUniform1i((int)((Shader)object).glShader.getUniformLocation("rgb_tex"), (int)0);
                        break block5;
                    }
                    if (!OES_FRAGMENT_SHADER_STRING.equals(string2)) break block7;
                    GLES20.glUniform1i((int)((Shader)object).glShader.getUniformLocation("oes_tex"), (int)0);
                }
                Object object3 = object;
                GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
                ATrace.endSection();
                ATrace.beginSection("initVertexShaderAttrs");
                Object object4 = FULL_RECTANGLE_BUF;
                ((Shader)object3).glShader.setVertexAttribArray("in_pos", 2, (FloatBuffer)object4);
                object4 = FULL_RECTANGLE_TEX_BUF;
                ((Shader)object3).glShader.setVertexAttribArray("in_tc", 2, (FloatBuffer)object4);
                ATrace.endSection();
            }
            Object object5 = object;
            ((Shader)object5).glShader.useProgram();
            GLES20.glUniformMatrix4fv((int)((Shader)object5).texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
            return;
        }
        throw new IllegalStateException("Unknown fragment shader: " + string2);
    }

    private void prepareShader(String string2, float[] fArray, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        block7: {
            Object object;
            block3: {
                block5: {
                    block6: {
                        block4: {
                            Shader shader;
                            block2: {
                                if (!((GlRectDrawer)this).shaders.containsKey(string2)) break block2;
                                object = this = ((GlRectDrawer)this).shaders.get(string2);
                                break block3;
                            }
                            object = shader;
                            ((Shader)object)(string2);
                            ((GlRectDrawer)this).shaders.put(string2, (Shader)object);
                            shader.glShader.useProgram();
                            if (string2 != YUV_FRAGMENT_SHADER_STRING) break block4;
                            Object object2 = object;
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("y_tex"), (int)0);
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("u_tex"), (int)1);
                            GLES20.glUniform1i((int)((Shader)object2).glShader.getUniformLocation("v_tex"), (int)2);
                            break block5;
                        }
                        if (string2 != RGB_FRAGMENT_SHADER_STRING) break block6;
                        GLES20.glUniform1i((int)((Shader)object).glShader.getUniformLocation("rgb_tex"), (int)0);
                        break block5;
                    }
                    if (string2 != OES_FRAGMENT_SHADER_STRING) break block7;
                    GLES20.glUniform1i((int)((Shader)object).glShader.getUniformLocation("oes_tex"), (int)0);
                }
                GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            }
            Object object3 = object;
            ((Shader)object3).glShader.useProgram();
            ((Shader)object3).glShader.setVertexAttribArray("in_pos", 2, floatBuffer2);
            ((Shader)object3).glShader.setVertexAttribArray("in_tc", 2, floatBuffer);
            GLES20.glUniformMatrix4fv((int)((Shader)object3).texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
            return;
        }
        throw new IllegalStateException("Unknown fragment shader: " + string2);
    }

    private float[] ComputeVertexAttribArray(int n2, int n3, int n4, int n5) {
        float f2;
        float f3;
        float f4 = (float)n4 / (float)n5;
        float f5 = n2;
        float f6 = n3;
        if (f3 / f2 >= f4) {
            f4 = (f5 - f6 * f4) / 2.0f / f5;
            f5 = 1.0f - f4;
            return new float[]{f4, 0.0f, f5, 0.0f, f4, 1.0f, f5, 1.0f};
        }
        f4 = (f6 - f5 / f4) / 2.0f / f6;
        return new float[]{0.0f, f4, 1.0f, f4, 0.0f, f4 = 1.0f - f4, 1.0f, f4};
    }

    private float[] ComputePosVertexAttribArray(int n2, int n3, int n4, int n5) {
        float f2 = n3 == n5 ? -1.0f : (float)(n3 - n5) * 2.0f / (float)n3 - 1.0f;
        float f3 = n2 == n4 ? 1.0f : (float)n4 * 2.0f / (float)n2 - 1.0f;
        return new float[]{-1.0f, f2, f3, f2, -1.0f, 1.0f, f3, 1.0f};
    }

    @Override
    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        GlRectDrawer glRectDrawer = this;
        ATrace.beginSection("prepareShader");
        glRectDrawer.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray);
        ATrace.endSection();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        glRectDrawer.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        GlRectDrawer glRectDrawer = this;
        ATrace.beginSection("prepareShader");
        glRectDrawer.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray);
        ATrace.endSection();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        glRectDrawer.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, fArray);
        int n8 = 0;
        while (n8 < 3) {
            int n9 = n8++;
            GLES20.glActiveTexture((int)(n9 + 33984));
            GLES20.glBindTexture((int)3553, (int)nArray[n9]);
        }
        this.drawRectangle(n4, n5, n6, n7);
        for (int i2 = 0; i2 < 3; ++i2) {
            GLES20.glActiveTexture((int)(i2 + 33984));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ((GlRectDrawer)((Object)floatBuffer)).mTexCoordinate = GlUtil.createFloatBuffer(((GlRectDrawer)((Object)floatBuffer)).ComputeVertexAttribArray(n3, n4, n9, n10));
        ((GlRectDrawer)((Object)floatBuffer)).mPosCoordinate = n9 == n7 && n10 == n8 ? FULL_RECTANGLE_BUF : GlUtil.createFloatBuffer(((GlRectDrawer)((Object)floatBuffer)).ComputePosVertexAttribArray(n7, n8, n9, n10));
        GlRectDrawer glRectDrawer = floatBuffer;
        FloatBuffer floatBuffer = glRectDrawer.mTexCoordinate;
        FloatBuffer floatBuffer2 = glRectDrawer.mPosCoordinate;
        glRectDrawer.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray, floatBuffer, floatBuffer2);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        glRectDrawer.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Object object = ((GlRectDrawer)((Object)floatBuffer)).ComputeVertexAttribArray(n3, n4, n9, n10);
        ((GlRectDrawer)((Object)floatBuffer)).mPosCoordinate = n9 == n7 && n10 == n8 ? FULL_RECTANGLE_BUF : GlUtil.createFloatBuffer(((GlRectDrawer)((Object)floatBuffer)).ComputePosVertexAttribArray(n7, n8, n9, n10));
        GlRectDrawer glRectDrawer = floatBuffer;
        FloatBuffer floatBuffer = GlUtil.createFloatBuffer(object);
        glRectDrawer.mTexCoordinate = floatBuffer;
        object = glRectDrawer.mPosCoordinate;
        glRectDrawer.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray, floatBuffer, (FloatBuffer)object);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        glRectDrawer.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void release() {
        Iterator<Shader> iterator = this.shaders.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String string2) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, string2);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

