/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.util.Log;
import io.agora.rtc.gl.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    private static int compileShader(int n2, String object) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            int n4 = n3;
            GLES20.glShaderSource((int)n4, (String)object);
            GLES20.glCompileShader((int)n4);
            int[] nArray = new int[1];
            object = nArray;
            object[0] = false;
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])object, (int)0);
            if (nArray[0] == 1) {
                GlUtil.checkNoGLES2Error("compileShader");
                return n3;
            }
            Log.e((String)TAG, (String)("Could not compile shader " + n2 + ":" + GLES20.glGetShaderInfoLog((int)n3)));
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n3));
        }
        throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
    }

    public GlShader(String string2, String string3) {
        int n2;
        int n3 = GlShader.compileShader(35633, string2);
        int n4 = GlShader.compileShader(35632, string3);
        this.program = n2 = GLES20.glCreateProgram();
        if (n2 != 0) {
            GlShader glShader = this;
            GLES20.glAttachShader((int)n2, (int)n3);
            GLES20.glAttachShader((int)glShader.program, (int)n4);
            GLES20.glLinkProgram((int)glShader.program);
            int[] nArray = new int[]{0};
            GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] == 1) {
                GLES20.glDeleteShader((int)n3);
                GLES20.glDeleteShader((int)n4);
                GlUtil.checkNoGLES2Error("Creating GlShader");
                return;
            }
            Log.e((String)TAG, (String)("Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program)));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
    }

    public int getAttribLocation(String string2) {
        int n2 = this.program;
        if (n2 != -1) {
            if ((n2 = GLES20.glGetAttribLocation((int)n2, (String)string2)) >= 0) {
                return n2;
            }
            throw new RuntimeException("Could not locate '" + string2 + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    public void setVertexAttribArray(String string2, int n2, FloatBuffer floatBuffer) {
        this.setVertexAttribArray(string2, n2, 0, floatBuffer);
    }

    public void setVertexAttribArray(String string2, int n2, int n3, FloatBuffer floatBuffer) {
        if (this.program != -1) {
            int n4 = this.getAttribLocation(string2);
            GLES20.glEnableVertexAttribArray((int)n4);
            GLES20.glVertexAttribPointer((int)n4, (int)n2, (int)5126, (boolean)false, (int)n3, (Buffer)floatBuffer);
            GlUtil.checkNoGLES2Error("setVertexAttribArray");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public int getUniformLocation(String string2) {
        int n2 = this.program;
        if (n2 != -1) {
            if ((n2 = GLES20.glGetUniformLocation((int)n2, (String)string2)) >= 0) {
                return n2;
            }
            throw new RuntimeException("Could not locate uniform '" + string2 + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    public void useProgram() {
        int n2 = this.program;
        if (n2 != -1) {
            GLES20.glUseProgram((int)n2);
            GlUtil.checkNoGLES2Error("glUseProgram");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public void release() {
        Log.d((String)TAG, (String)"Deleting shader.");
        int n2 = this.program;
        if (n2 != -1) {
            GLES20.glDeleteProgram((int)n2);
            this.program = -1;
        }
    }
}

