/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlUtil;

public class GlTextureFrameBuffer {
    private final int frameBufferId;
    private final int textureId;
    private final int pixelFormat;
    private int width;
    private int height;

    public GlTextureFrameBuffer(int n2) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("Invalid pixel format: " + n2);
            }
            case 6407: 
            case 6408: 
            case 6409: 
        }
        GlTextureFrameBuffer glTextureFrameBuffer = this;
        glTextureFrameBuffer.pixelFormat = n2;
        glTextureFrameBuffer.textureId = GlUtil.generateTexture(3553);
        glTextureFrameBuffer.width = 0;
        glTextureFrameBuffer.height = 0;
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        glTextureFrameBuffer.frameBufferId = nArray[0];
    }

    public void setSize(int n2, int n3) {
        if (n2 != 0 && n3 != 0) {
            if (n2 == this.width && n3 == this.height) {
                return;
            }
            GlTextureFrameBuffer glTextureFrameBuffer = this;
            glTextureFrameBuffer.width = n2;
            glTextureFrameBuffer.height = n3;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)glTextureFrameBuffer.textureId);
            int n4 = glTextureFrameBuffer.pixelFormat;
            GLES20.glTexImage2D((int)3553, (int)0, (int)n4, (int)n2, (int)n3, (int)0, (int)n4, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)0);
            GlUtil.checkNoGLES2Error("GlTextureFrameBuffer setSize");
            GLES20.glBindFramebuffer((int)36160, (int)glTextureFrameBuffer.frameBufferId);
            n4 = glTextureFrameBuffer.textureId;
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n4, (int)0);
            n4 = GLES20.glCheckFramebufferStatus((int)36160);
            if (n4 == 36053) {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                return;
            }
            throw new IllegalStateException("Framebuffer not complete, status: " + n4);
        }
        throw new IllegalArgumentException("Invalid size: " + n2 + "x" + n3);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void release() {
        GlTextureFrameBuffer glTextureFrameBuffer = this;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = this.textureId;
        GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = this.frameBufferId;
        GLES20.glDeleteFramebuffers((int)1, (int[])nArray2, (int)0);
        glTextureFrameBuffer.width = 0;
        glTextureFrameBuffer.height = 0;
    }
}

