/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import io.agora.rtc.gl.VideoFrame;
import java.nio.ByteBuffer;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final Runnable releaseCallback;
    private final Object refCountLock;
    private int refCount;

    private JavaI420Buffer(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, Runnable runnable) {
        Object object;
        Object object2 = object;
        object = new Object();
        v1.refCountLock = object2;
        v1.width = n2;
        v1.height = n3;
        v1.dataY = byteBuffer;
        v1.dataU = byteBuffer2;
        v1.dataV = byteBuffer3;
        v1.strideY = n4;
        v1.strideU = n5;
        v1.strideV = n6;
        v1.releaseCallback = runnable;
        v1.refCount = 1;
    }

    public static JavaI420Buffer wrap(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, Runnable runnable) {
        if (byteBuffer != null && byteBuffer2 != null && byteBuffer3 != null) {
            if (byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect()) {
                int n7 = n3;
                byteBuffer = byteBuffer.slice();
                byteBuffer2 = byteBuffer2.slice();
                byteBuffer3 = byteBuffer3.slice();
                int n8 = (n7 + 1) / 2;
                int n9 = n4 * n7;
                int n10 = n5 * n8;
                n8 = n6 * n8;
                if (byteBuffer.capacity() >= n9) {
                    if (byteBuffer2.capacity() >= n10) {
                        if (byteBuffer3.capacity() >= n8) {
                            return new JavaI420Buffer(n2, n3, byteBuffer, n4, byteBuffer2, n5, byteBuffer3, n6, runnable);
                        }
                        throw new IllegalArgumentException("V-buffer must be at least " + n8 + " bytes.");
                    }
                    throw new IllegalArgumentException("U-buffer must be at least " + n10 + " bytes.");
                }
                throw new IllegalArgumentException("Y-buffer must be at least " + n9 + " bytes.");
            }
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        throw new IllegalArgumentException("Data buffers cannot be null.");
    }

    public static JavaI420Buffer createYUV(byte[] byArray, int n2, int n3) {
        if (byArray != null && byArray.length != 0) {
            JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n2, n3);
            ByteBuffer byteBuffer = javaI420Buffer.getDataY();
            ByteBuffer byteBuffer2 = javaI420Buffer.getDataU();
            ByteBuffer byteBuffer3 = javaI420Buffer.getDataV();
            int n4 = n3;
            n3 = (n3 + 1) / 2;
            int n5 = n4 * javaI420Buffer.getStrideY();
            int n6 = n3 * javaI420Buffer.getStrideU();
            int n7 = n3 * javaI420Buffer.getStrideV();
            byteBuffer.put(byArray, 0, n5);
            byteBuffer2.put(byArray, n5, n6);
            byteBuffer3.put(byArray, n5 + n6, n7);
            return javaI420Buffer;
        }
        return null;
    }

    public static JavaI420Buffer allocate(int n2, int n3) {
        ByteBuffer byteBuffer;
        int n4 = (n3 + 1) / 2;
        int n5 = (n2 + 1) / 2;
        int n6 = n2 * n3;
        int n7 = n6 + 0;
        int n8 = n5 * n4;
        int n9 = n7 + n8;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n6 + n5 * 2 * n4);
        ByteBuffer byteBuffer3 = byteBuffer = byteBuffer2;
        ByteBuffer byteBuffer4 = byteBuffer;
        ByteBuffer byteBuffer5 = byteBuffer;
        ByteBuffer byteBuffer6 = byteBuffer;
        byteBuffer.position(0);
        byteBuffer6.limit(n7);
        byteBuffer = byteBuffer6.slice();
        byteBuffer5.position(n7);
        byteBuffer4.limit(n9);
        ByteBuffer byteBuffer7 = byteBuffer4.slice();
        byteBuffer3.position(n9);
        byteBuffer2.limit(n9 + n8);
        ByteBuffer byteBuffer8 = byteBuffer2.slice();
        return new JavaI420Buffer(n2, n3, byteBuffer, n2, byteBuffer7, n5, byteBuffer8, n5, null);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        JavaI420Buffer javaI420Buffer = this;
        javaI420Buffer.retain();
        return javaI420Buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            int n2 = this.refCount;
            this.refCount = n2 + 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release() {
        JavaI420Buffer javaI420Buffer = this;
        Object object = javaI420Buffer.refCountLock;
        synchronized (object) {
            int n2 = javaI420Buffer.refCount - 1;
            {
                this.refCount = n2;
                if (n2 == 0 && this.releaseCallback != null) {
                    this.releaseCallback.run();
                }
                return;
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        return VideoFrame.cropAndScaleI420(this, n2, n3, n4, n5, n6, n7);
    }
}

