/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.TextureBufferPool;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.util.concurrent.Callable;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private static final boolean VERBOSE = false;
    private final String name;
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter;
    private final TextureBufferPool textureBufferPool;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private boolean isOesTextureInUse = false;
    private boolean isQuitting = false;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            2 v0 = this;
            Logging.i(SurfaceTextureHelper.TAG, "Setting listener to " + SurfaceTextureHelper.this.pendingListener);
            SurfaceTextureHelper surfaceTextureHelper = v0.SurfaceTextureHelper.this;
            SurfaceTextureHelper.access$202(surfaceTextureHelper, surfaceTextureHelper.pendingListener);
            SurfaceTextureHelper.access$102(v0.SurfaceTextureHelper.this, null);
            if (v0.SurfaceTextureHelper.this.hasPendingTexture) {
                2 v2 = this;
                v2.SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.access$302(v2.SurfaceTextureHelper.this, false);
            }
        }
    };

    public static SurfaceTextureHelper create(final String string2, final EglBase.Context context, final int n2) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string2).start();
        final Handler handler2 = handler;
        handler = new Handler(handlerThread2.getLooper());
        Logging.d(TAG, "create thread: " + string2 + " id: " + handlerThread2.getThreadId());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<SurfaceTextureHelper>(){

            @Override
            public SurfaceTextureHelper call() {
                String string22;
                1 v6;
                1 v5;
                1 v4;
                SurfaceTextureHelper surfaceTextureHelper;
                SurfaceTextureHelper surfaceTextureHelper2;
                try {
                    SurfaceTextureHelper surfaceTextureHelper3;
                    surfaceTextureHelper2 = surfaceTextureHelper3;
                    surfaceTextureHelper = surfaceTextureHelper3;
                    1 v3 = this;
                    v4 = v3;
                    v5 = v3;
                    v6 = v3;
                    string22 = v3.string2;
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper.TAG, string2 + " create failure", runtimeException);
                    return null;
                }
                EglBase.Context context2 = v4.context;
                Handler handler = v5.handler2;
                int n22 = v6.n2;
                surfaceTextureHelper2(string22, context2, handler, n22);
                return surfaceTextureHelper;
            }
        });
    }

    private SurfaceTextureHelper(final String string2, EglBase.Context object, Handler handler, int n2) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            YuvConverter yuvConverter;
            SurfaceTextureHelper surfaceTextureHelper = this;
            SurfaceTextureHelper surfaceTextureHelper2 = this;
            Logging.i(TAG, string2 + " create, this: " + this + ", shared: " + object);
            this.name = string2;
            this.handler = handler;
            this.eglBase = EglBase.create((EglBase.Context)object, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                this.eglBase.createDummyPbufferSurface();
                surfaceTextureHelper2.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "SurfaceTextureHelper: failed to create pbufferSurface!!");
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            object = yuvConverter;
            surfaceTextureHelper2.yuvConverter = new YuvConverter();
            EglBase eglBase = surfaceTextureHelper2.eglBase;
            surfaceTextureHelper.textureBufferPool = TextureBufferPool.createWithinGlThread(string2, n2, 6407, handler, eglBase, (YuvConverter)object);
            surfaceTextureHelper.oesTextureId = GlUtil.generateTexture(36197);
            this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    3 v0 = this;
                    SurfaceTextureHelper.access$302(v0.SurfaceTextureHelper.this, true);
                    v0.SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }, handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        SurfaceTextureHelper surfaceTextureHelper = this;
        // MONITORENTER : object
        try {
            surfaceTextureHelper.surfaceTexture.updateTexImage();
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object
            try {
                throw throwable;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "SurfaceTextureHelper: failed to updateTexImage!!");
            }
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isOesTextureInUse && this.listener != null) {
                SurfaceTextureHelper surfaceTextureHelper = this;
                surfaceTextureHelper.isOesTextureInUse = true;
                surfaceTextureHelper.hasPendingTexture = false;
                surfaceTextureHelper.updateTexImage();
                float[] fArray = new float[16];
                surfaceTextureHelper.surfaceTexture.getTransformMatrix(fArray);
                long l2 = surfaceTextureHelper.surfaceTexture.getTimestamp();
                surfaceTextureHelper.listener.onTextureFrameAvailable(this.oesTextureId, fArray, l2);
                return;
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void release() {
        Logging.i(TAG, this.name + " release, this: " + this);
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isOesTextureInUse && !this.textureBufferPool.anyTextureInUse() && this.isQuitting) {
                SurfaceTextureHelper surfaceTextureHelper = this;
                surfaceTextureHelper.yuvConverter.release();
                surfaceTextureHelper.textureBufferPool.dispose();
                int[] nArray = new int[1];
                int[] nArray2 = nArray;
                nArray[0] = this.oesTextureId;
                GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
                surfaceTextureHelper.surfaceTexture.release();
                surfaceTextureHelper.eglBase.release();
                surfaceTextureHelper.handler.getLooper().quit();
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$202(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.listener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$102(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.pendingListener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ boolean access$302(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.hasPendingTexture = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.isOesTextureInUse = bl;
        return bl;
    }

    static /* synthetic */ boolean access$702(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.isQuitting = bl;
        return bl;
    }

    public EglBase.Context getEglContext() {
        return this.eglBase.getEglBaseContext();
    }

    public void startListening(OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = onTextureFrameAvailableListener;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        SurfaceTextureHelper surfaceTextureHelper = this;
        Logging.i(TAG, this.name + " stopListening()");
        surfaceTextureHelper.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(surfaceTextureHelper.handler, new Runnable(){

            @Override
            public void run() {
                4 v0 = this;
                SurfaceTextureHelper.access$202(v0.SurfaceTextureHelper.this, null);
                SurfaceTextureHelper.access$102(v0.SurfaceTextureHelper.this, null);
            }
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                5 v0 = this;
                SurfaceTextureHelper.access$602(v0.SurfaceTextureHelper.this, false);
                if (v0.SurfaceTextureHelper.this.isQuitting) {
                    if (!SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                        SurfaceTextureHelper.this.release();
                    }
                } else {
                    SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public void dispose() {
        Logging.i(TAG, this.name + " dispose(), this: " + this);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                6 v0 = this;
                SurfaceTextureHelper.access$702(v0.SurfaceTextureHelper.this, true);
                if (!v0.SurfaceTextureHelper.this.isOesTextureInUse && !SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                    SurfaceTextureHelper.this.release();
                } else {
                    Logging.i(SurfaceTextureHelper.TAG, SurfaceTextureHelper.this.name + " not release yet, this: " + SurfaceTextureHelper.this + " isOesTextureInUse: " + SurfaceTextureHelper.this.isOesTextureInUse);
                }
            }
        });
    }

    public VideoFrame.I420Buffer textureToYuv(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() == this.oesTextureId) {
            final VideoFrame.I420Buffer[] i420BufferArray = new VideoFrame.I420Buffer[1];
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    i420BufferArray[0] = SurfaceTextureHelper.this.yuvConverter.convert(textureBuffer);
                }
            });
            return i420BufferArray[0];
        }
        throw new IllegalStateException("textureToYuv called with unexpected textureId");
    }

    public VideoFrame.TextureBuffer textureCopy(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() == this.oesTextureId) {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() {
                    return SurfaceTextureHelper.this.textureBufferPool.textureCopy(textureBuffer, new Runnable(){

                        @Override
                        public void run() {
                            SurfaceTextureHelper.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (SurfaceTextureHelper.this.isQuitting && !SurfaceTextureHelper.this.isOesTextureInUse && !SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                                        SurfaceTextureHelper.this.release();
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        throw new IllegalStateException("textureCopy called with unexpected textureId");
    }

    public VideoFrame.TextureBuffer createTextureBuffer(int n2, int n3, Matrix matrix) {
        Runnable runnable;
        SurfaceTextureHelper surfaceTextureHelper = this;
        EglBase.Context context = surfaceTextureHelper.getEglContext();
        VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.OES;
        int n4 = surfaceTextureHelper.oesTextureId;
        Handler handler = surfaceTextureHelper.handler;
        YuvConverter yuvConverter = surfaceTextureHelper.yuvConverter;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.returnTextureFrame();
            }
        };
        return new TextureBufferImpl(context, n2, n3, type, n4, matrix, handler, yuvConverter, runnable2);
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }
}

