/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.TextureConverter;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.AGraphicBufferEx;
import java.util.concurrent.Callable;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private static final boolean VERBOSE = false;
    private final EglBase.Context eglContext;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final Runnable releaseCallback;
    private final Object refCountLock;
    private final int sequence;
    private int refCount;
    private AGraphicBufferEx aGraphicBufferEx;
    private TextureConverter textureConverter;
    private int oesTextureId;

    public TextureBufferImpl(EglBase.Context context, int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, Runnable runnable, int n5) {
        Object object;
        Object object2 = object;
        object = new Object();
        v1.refCountLock = object2;
        v1.eglContext = context;
        v1.width = n2;
        v1.height = n3;
        v1.type = type;
        v1.id = n4;
        v1.transformMatrix = matrix;
        v1.toI420Handler = handler;
        v1.yuvConverter = yuvConverter;
        v1.releaseCallback = runnable;
        v1.refCount = 1;
        v1.oesTextureId = -1;
        v1.sequence = n5;
    }

    public TextureBufferImpl(EglBase.Context context, int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, Runnable runnable) {
        this(context, n2, n3, type, n4, matrix, handler, yuvConverter, runnable, -1);
    }

    private AGraphicBufferEx copyToAGraphicBufferEx() {
        int n2 = 3553;
        int n3 = 1;
        if (this.getType() == VideoFrame.TextureBuffer.Type.OES) {
            n2 = 36197;
            n3 = 0;
        }
        if (this.textureConverter == null) {
            this.textureConverter = new TextureConverter(this.getTextureId(), n2, n3);
        }
        if (this.oesTextureId < 0) {
            this.oesTextureId = this.textureConverter.getOneTexture(36197);
        }
        if (this.aGraphicBufferEx == null) {
            AGraphicBufferEx aGraphicBufferEx;
            AGraphicBufferEx aGraphicBufferEx2 = aGraphicBufferEx;
            TextureBufferImpl textureBufferImpl = this;
            EglBase.Context context = textureBufferImpl.getEglBaseContext();
            int n4 = textureBufferImpl.getWidth();
            int n5 = textureBufferImpl.getHeight();
            Handler handler = textureBufferImpl.toI420Handler;
            int n6 = textureBufferImpl.oesTextureId;
            Matrix matrix = textureBufferImpl.getTransformMatrix();
            Runnable runnable = textureBufferImpl.releaseCallback;
            aGraphicBufferEx = new AGraphicBufferEx(context, n4, n5, handler, n6, matrix, runnable);
            this.aGraphicBufferEx = aGraphicBufferEx2;
        }
        TextureBufferImpl textureBufferImpl = this;
        textureBufferImpl.textureConverter.convert(36197, this.oesTextureId);
        return textureBufferImpl.aGraphicBufferEx;
    }

    private void releaseAGraphicBufferEx() {
        Object object = this.textureConverter;
        if (object != null) {
            ((TextureConverter)object).release();
            this.textureConverter = null;
        }
        if ((object = this.aGraphicBufferEx) != null) {
            ((AGraphicBufferEx)object).releaseNativeBuffer();
            this.aGraphicBufferEx = null;
        }
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public int getTextureType() {
        return this.type == VideoFrame.TextureBuffer.Type.OES ? 11 : 10;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    @Override
    public long getNativeEglContext() {
        EglBase.Context context = ((TextureBufferImpl)((Object)context)).eglContext;
        return context != null ? context.getNativeEglContext() : 0L;
    }

    @Override
    public float[] getGlTransformMatrix() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public Object getRealEglContext() {
        return this.eglContext.getRealEglContext();
    }

    @Override
    public int getEglType() {
        return this.eglContext.getEglType();
    }

    @Override
    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    @Override
    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isValidNativeBuffer() {
        return false;
    }

    @Override
    public long getNativeBuffer() {
        return 0L;
    }

    @Override
    public boolean isNativeBufferSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @Override
    public VideoFrame.TextureBuffer toTextureBuffer() {
        return this;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public String infoString() {
        return this.toString();
    }

    @Override
    public VideoFrame.TextureBuffer toAGraphicBufferEx() {
        if (this.isNativeBufferSupported()) {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() throws Exception {
                    return TextureBufferImpl.this.copyToAGraphicBufferEx();
                }
            });
        }
        throw new IllegalStateException("mini api level 26 is needed, curr: " + Build.VERSION.SDK_INT);
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.I420Buffer>(){

            @Override
            public VideoFrame.I420Buffer call() throws Exception {
                return TextureBufferImpl.this.yuvConverter.convert(TextureBufferImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            int n2 = this.refCount;
            this.refCount = n2 + 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release() {
        TextureBufferImpl textureBufferImpl = this;
        Object object = textureBufferImpl.refCountLock;
        synchronized (object) {
            int n2 = textureBufferImpl.refCount - 1;
            {
                this.refCount = n2;
                if (n2 == 0 && this.releaseCallback != null) {
                    TextureBufferImpl textureBufferImpl2 = this;
                    textureBufferImpl2.releaseAGraphicBufferEx();
                    textureBufferImpl2.releaseCallback.run();
                }
                return;
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        int n8 = n2;
        matrix2();
        n2 = this.height;
        n3 = n2 - (n3 + n5);
        matrix2.preTranslate((float)n8 / (float)this.width, (float)n3 / (float)n2);
        matrix2.preScale((float)n4 / (float)this.width, (float)n5 / (float)this.height);
        return this.applyTransformMatrix(matrix, n6, n7);
    }

    @Override
    public VideoFrame.TextureBuffer rotate(int n2) {
        int n3 = n2 != 90 && n2 != 270 ? 0 : 1;
        int n4 = n3 != 0 ? this.height : this.width;
        n3 = n3 != 0 ? this.width : this.height;
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preRotate((float)n2);
        matrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(matrix, n4, n3);
    }

    @Override
    public VideoFrame.TextureBuffer flip(boolean bl) {
        TextureBufferImpl textureBufferImpl = this;
        int n2 = textureBufferImpl.width;
        return this.applyTransformMatrix(RendererCommon.convertMatrixToAndroidGraphicsMatrix(bl ? RendererCommon.verticalFlipMatrix() : RendererCommon.horizontalFlipMatrix()), n2, textureBufferImpl.height);
    }

    public VideoFrame.TextureBuffer applyTransformMatrix(Matrix object, int n2, int n3) {
        Runnable runnable;
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix2(this.transformMatrix);
        matrix.preConcat(object);
        this.retain();
        TextureBufferImpl textureBufferImpl = this;
        object = textureBufferImpl.eglContext;
        VideoFrame.TextureBuffer.Type type = textureBufferImpl.type;
        int n4 = textureBufferImpl.id;
        Handler handler = textureBufferImpl.toI420Handler;
        YuvConverter yuvConverter = textureBufferImpl.yuvConverter;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        };
        int n5 = textureBufferImpl.sequence;
        return new TextureBufferImpl((EglBase.Context)object, n2, n3, type, n4, matrix2, handler, yuvConverter, runnable2, n5);
    }

    public String toString() {
        return "TextureBufferImpl{eglContext=" + this.eglContext + ", " + this.width + "x" + this.height + ", type=" + (Object)((Object)this.type) + ", seq=" + this.sequence + ", id=" + this.id + ", refCount=" + this.refCount + '}';
    }
}

