/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class TextureBufferPool {
    private static final boolean VERBOSE = false;
    private static final String TAG = "TextureBufferPool";
    private static final AtomicInteger nextSeq = new AtomicInteger(0);
    private final String name;
    private final Handler handler;
    private final boolean ownGlThread;
    private final EglBase eglBase;
    private final EglBase.Context eglContext;
    private final YuvConverter yuvConverter;
    private final GlRectDrawer drawer;
    private final boolean shrinkPool;
    private final int glPixelFormat;
    private final int maxBufferCnt;
    private final int keepBufferCnt;
    private final ArrayList<TextureInfo> textureInfoList = new ArrayList();
    private boolean isQuitting = false;
    private int dropCount = 0;

    public static TextureBufferPool create(final String string2, final EglBase.Context context, final int n2) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string2).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<TextureBufferPool>(){

            /*
             * Exception decompiling
             */
            @Override
            public TextureBufferPool call() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public static TextureBufferPool createWithinGlThread(String string2, int n2, int n3, Handler handler, EglBase eglBase, YuvConverter yuvConverter) {
        return new TextureBufferPool(string2, n2, n3, handler, false, eglBase, yuvConverter);
    }

    private TextureBufferPool(String string2, int n2, int n3, Handler handler, boolean bl, EglBase eglBase, YuvConverter yuvConverter) {
        this.shrinkPool = true;
        Logging.i(TAG, string2 + " init buffer pool, ownGlThread: " + bl + " cnt: " + n2);
        this.name = string2;
        this.maxBufferCnt = Math.max(n2, 1);
        this.keepBufferCnt = Math.min(this.maxBufferCnt, 3);
        this.glPixelFormat = n3;
        this.handler = handler;
        this.ownGlThread = bl;
        this.eglBase = eglBase;
        if (yuvConverter == null) {
            YuvConverter yuvConverter2;
            yuvConverter = yuvConverter2;
            yuvConverter2 = new YuvConverter();
        }
        TextureBufferPool textureBufferPool = this;
        this.yuvConverter = yuvConverter;
        textureBufferPool.eglContext = eglBase.getEglBaseContext();
        textureBufferPool.drawer = new GlRectDrawer();
    }

    private VideoFrame.TextureBuffer doTextureCopy(int n2, VideoFrame.TextureBuffer.Type object, int n3, int n4, Matrix matrix, final Runnable runnable) {
        Runnable runnable2;
        TextureBufferImpl textureBufferImpl;
        final TextureInfo textureInfo = this.acquireTextureFramebuffer();
        if (textureInfo == null) {
            return null;
        }
        ATrace.beginSection("setupTextureFrameBuffer");
        boolean bl = this.setupTextureFrameBuffer(textureInfo, n3, n4);
        ATrace.endSection();
        if (!bl) {
            this.releaseTextureFramebuffer(textureInfo);
            return null;
        }
        GLES20.glBindFramebuffer((int)36160, (int)textureInfo.frameBufferId);
        ATrace.beginSection("drawTexture");
        this.drawTexture(n2, (VideoFrame.TextureBuffer.Type)((Object)object), n3, n4);
        ATrace.endSection();
        ATrace.beginSection("flush");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glFlush();
        ATrace.endSection();
        VideoFrame.TextureBuffer[] textureBufferArray = new VideoFrame.TextureBuffer[1];
        final VideoFrame.TextureBuffer[] textureBufferArray2 = textureBufferArray;
        object = textureBufferImpl;
        TextureBufferPool textureBufferPool = this;
        Object object2 = this.eglContext;
        VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.RGB;
        int n5 = textureInfo.textureId;
        Handler handler = textureBufferPool.handler;
        YuvConverter yuvConverter = textureBufferPool.yuvConverter;
        EglBase.Context context = object2;
        object2 = runnable2;
        runnable2 = new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        1 v0 = this;
                        4 var1_1 = v0.this;
                        var1_1.TextureBufferPool.this.releaseTextureFramebuffer(var1_1.textureInfo);
                        if (v0.TextureBufferPool.this.isQuitting && !TextureBufferPool.this.anyTextureInUse()) {
                            Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no buffer in flight");
                            TextureBufferPool.this.release();
                        }
                        if ((this = runnable) != null) {
                            this.run();
                        }
                    }
                });
            }
        };
        int n6 = nextSeq.getAndIncrement();
        textureBufferImpl = new TextureBufferImpl(context, n3, n4, type, n5, matrix, handler, yuvConverter, (Runnable)object2, n6);
        textureBufferArray[0] = object;
        return textureBufferArray[0];
    }

    private TextureInfo acquireTextureFramebuffer() {
        TextureInfo textureInfo2;
        Object object;
        block3: {
            object = null;
            for (TextureInfo textureInfo2 : this.textureInfoList) {
                if (textureInfo2.inUse) continue;
                break block3;
            }
            textureInfo2 = object;
        }
        if (textureInfo2 == null) {
            TextureInfo textureInfo3;
            if (this.textureInfoList.size() >= this.maxBufferCnt) {
                int n2;
                this.dropCount = n2 = this.dropCount + 1;
                ATrace.traceCounter("Drop@TexPool", n2);
                return null;
            }
            int n3 = GlUtil.generateTexture(3553);
            object = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])object, (int)0);
            textureInfo2 = textureInfo3;
            textureInfo3 = new TextureInfo(n3, (int)object[0]);
            this.textureInfoList.add(textureInfo2);
        }
        textureInfo2.inUse = true;
        return textureInfo2;
    }

    private void releaseTextureFramebuffer(TextureInfo textureInfo) {
        textureInfo.inUse = false;
        int n2 = ((TextureBufferPool)object).textureInfoList.indexOf(textureInfo);
        if (n2 < 0) {
            Logging.e(TAG, "texture info not found!");
        } else if (n2 >= ((TextureBufferPool)object).keepBufferCnt) {
            TextureBufferPool textureBufferPool = object;
            int[] nArray = new int[1];
            Object object = nArray;
            nArray[0] = textureInfo.textureId;
            GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
            int[] nArray2 = new int[1];
            object = nArray2;
            nArray2[0] = textureInfo.frameBufferId;
            GLES20.glDeleteFramebuffers((int)1, (int[])object, (int)0);
            textureBufferPool.textureInfoList.remove(n2);
        }
    }

    private boolean setupTextureFrameBuffer(TextureInfo textureInfo, int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            if (textureInfo.specified && textureInfo.width == n2 && textureInfo.height == n3) {
                return true;
            }
            TextureInfo textureInfo2 = textureInfo;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureInfo.textureId);
            ATrace.beginSection("glTexImage2D");
            int n4 = this.glPixelFormat;
            GLES20.glTexImage2D((int)3553, (int)0, (int)n4, (int)n2, (int)n3, (int)0, (int)n4, (int)5121, null);
            ATrace.endSection();
            GlUtil.checkNoGLES2Error("TextureBufferPool.glTexImage2D");
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)textureInfo2.frameBufferId);
            ATrace.beginSection("glFramebufferTexture2D");
            n4 = textureInfo2.textureId;
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n4, (int)0);
            ATrace.endSection();
            n4 = GLES20.glCheckFramebufferStatus((int)36160);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            if (n4 != 36053) {
                Logging.w(TAG, "Framebuffer not complete, status: " + n4);
                return false;
            }
            TextureInfo textureInfo3 = textureInfo;
            textureInfo3.specified = true;
            textureInfo3.width = n2;
            textureInfo3.height = n3;
            return true;
        }
        Logging.w(TAG, "Invalid size: " + n2 + "x" + n3);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawTexture(int n2, VideoFrame.TextureBuffer.Type type, int n3, int n4) {
        GLES20.glClear((int)16384);
        int n5 = 5.$SwitchMap$io$agora$rtc$gl$VideoFrame$TextureBuffer$Type[type.ordinal()];
        if (n5 != 1) {
            if (n5 != 2) throw new RuntimeException("Unknown texture type.");
            this.drawer.drawRgb(n2, GlUtil.IDENTITY_MATRIX, n3, n4, 0, 0, n3, n4);
        } else {
            this.drawer.drawOes(n2, GlUtil.IDENTITY_MATRIX, n3, n4, 0, 0, n3, n4);
        }
        GlUtil.checkNoGLES2Error("TextureBufferPool.drawFrameBuffer");
    }

    private void release() {
        Logging.i(TAG, this.name + " release()");
        if (!this.textureInfoList.isEmpty()) {
            int n2 = this.textureInfoList.size();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                TextureInfo textureInfo = this.textureInfoList.get(i2);
                nArray[i2] = textureInfo.textureId;
                nArray2[i2] = textureInfo.frameBufferId;
            }
            Logging.d(TAG, this.name + ": delete textures " + Arrays.toString(nArray));
            GLES20.glDeleteTextures((int)n2, (int[])nArray, (int)0);
            GLES20.glDeleteFramebuffers((int)1, (int[])nArray2, (int)0);
            this.textureInfoList.clear();
        }
        TextureBufferPool textureBufferPool = this;
        textureBufferPool.drawer.release();
        if (textureBufferPool.ownGlThread) {
            EglBase eglBase = this.eglBase;
            if (eglBase != null) {
                eglBase.release();
            }
            this.handler.getLooper().quit();
        }
    }

    public static VideoFrame.TextureBuffer makeTextureBuffer(EglBase.Context object, int n2, int n3, int n4, int n5, float[] object2, Handler handler, YuvConverter yuvConverter, Runnable runnable) {
        TextureBufferImpl textureBufferImpl;
        if (object2 == null) {
            Matrix matrix;
            object2 = matrix;
            matrix = new Matrix();
        } else {
            object2 = RendererCommon.convertMatrixToAndroidGraphicsMatrix(object2);
        }
        if (object == null) {
            object = EglBase.getCurrentContext();
        }
        TextureBufferImpl textureBufferImpl2 = textureBufferImpl;
        EglBase.Context context = object;
        object = TextureBufferPool.agoraFrameTypeToTextureBufferType(n2);
        n2 = nextSeq.getAndIncrement();
        textureBufferImpl2(context, n4, n5, (VideoFrame.TextureBuffer.Type)((Object)object), n3, (Matrix)object2, handler, yuvConverter, runnable, n2);
        return textureBufferImpl2;
    }

    public static VideoFrame.TextureBuffer.Type agoraFrameTypeToTextureBufferType(int n2) {
        return n2 == 11 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB;
    }

    static /* synthetic */ boolean access$302(TextureBufferPool textureBufferPool, boolean bl) {
        textureBufferPool.isQuitting = bl;
        return bl;
    }

    public VideoFrame.TextureBuffer textureCopy(VideoFrame.TextureBuffer object, Runnable runnable) {
        if (object == null) {
            return null;
        }
        VideoFrame.TextureBuffer textureBuffer = object;
        int n2 = textureBuffer.getTextureId();
        object = textureBuffer.getType();
        int n3 = textureBuffer.getWidth();
        int n4 = textureBuffer.getHeight();
        Matrix matrix = textureBuffer.getTransformMatrix();
        return this.textureCopy(n2, (VideoFrame.TextureBuffer.Type)((Object)object), n3, n4, matrix, runnable);
    }

    public VideoFrame.TextureBuffer textureCopy(final int n2, final VideoFrame.TextureBuffer.Type type, final int n3, final int n4, final Matrix matrix, final Runnable runnable) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() throws Exception {
                2 v0 = this;
                int n22 = v0.n2;
                VideoFrame.TextureBuffer.Type type2 = v0.type;
                int n32 = v0.n3;
                int n42 = v0.n4;
                Matrix matrix2 = v0.matrix;
                Runnable runnable2 = v0.runnable;
                return TextureBufferPool.this.doTextureCopy(n22, type2, n32, n42, matrix2, runnable2);
            }
        });
    }

    public void dispose() {
        Logging.i(TAG, this.name + " dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                3 v0 = this;
                TextureBufferPool.access$302(v0.TextureBufferPool.this, true);
                if (!v0.TextureBufferPool.this.anyTextureInUse()) {
                    Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no more buffer in flight");
                    TextureBufferPool.this.release();
                }
            }
        });
    }

    boolean anyTextureInUse() {
        Iterator<TextureInfo> iterator = ((TextureBufferPool)((Object)iterator)).textureInfoList.iterator();
        while (iterator.hasNext()) {
            if (!((TextureInfo)iterator.next()).inUse) continue;
            return true;
        }
        return false;
    }

    private static class TextureInfo {
        int textureId;
        int frameBufferId;
        boolean inUse;
        boolean specified;
        int width;
        int height;

        public TextureInfo(int n2, int n3) {
            this.textureId = n2;
            this.frameBufferId = n3;
            this.inUse = false;
            this.specified = false;
            this.width = 0;
            this.height = 0;
        }

        public String toString() {
            return "TextureInfo{textureId=" + this.textureId + ", frameBufferId=" + this.frameBufferId + ", inUse=" + this.inUse + ", specified=" + this.specified + ", width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

