/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class TextureConverter {
    public static final int CV_TYPE_OES2OES = 0;
    public static final int CV_TYPE_2D2OES = 1;
    public static final int CV_TYPE_OES22D = 2;
    private static final String VERTEX_SHADER_STRING = "#version 300 es\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nin vec4 aPosition;\nin vec4 aTextureCoord;\nout vec2 vTextureCoord;\nvoid main() {\ngl_Position = uMVPMatrix * aPosition;\nvTextureCoord = (uSTMatrix * aTextureCoord).st;\n}\n";
    private static final String TEXTURE_2D2OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    private static final String TEXTURE_OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\nin vec2 vTextureCoord;\nuniform samplerExternalOES uTextureSampler;\nout vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    private static final String TEXTURE_OES2OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    static final int COORDS_PER_VERTEX = 3;
    static final float[] rectCoords = new float[]{-1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f};
    static final float[] textureCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private final int mProgram;
    private int mPositionHandle;
    private int mTextureCoordHandle;
    private int mMVPMatrixHandle;
    private int mSTMatrixHandle;
    private int mTextureHandle;
    private float[] mMVPMatrix;
    private float[] mSTMatrix;
    private final int vertexCount;
    private final int vertexStride;
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureCoordBuffer;
    private int mTextureID;
    private int mTextureTarget;
    private int[] mFrameBuffer;

    public TextureConverter(int n2, int n3, int n4) {
        TextureConverter textureConverter = this;
        float[] fArray = new float[16];
        TextureConverter textureConverter2 = this;
        textureConverter2.mMVPMatrix = fArray;
        textureConverter2.mSTMatrix = new float[16];
        textureConverter2.vertexCount = rectCoords.length / 3;
        textureConverter2.vertexStride = 12;
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.setIdentityM((float[])textureConverter.mSTMatrix, (int)0);
        textureConverter.vertexBuffer = textureConverter.arrayToBuffer(rectCoords);
        textureConverter.textureCoordBuffer = textureConverter.arrayToBuffer(textureCoords);
        this.mTextureID = n2;
        this.mTextureTarget = n3;
        int n5 = this.loadShader(35633, VERTEX_SHADER_STRING);
        n3 = n4 != 0 ? (n4 != 1 ? (n4 != 2 ? this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n") : this.loadShader(35632, TEXTURE_OES_FRAGMENT_SHADER_STRING)) : this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n")) : this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n");
        TextureConverter textureConverter3 = this;
        this.mProgram = textureConverter3.createProgram(n5, n3);
        textureConverter3.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        textureConverter3.mTextureCoordHandle = GLES20.glGetAttribLocation((int)textureConverter3.mProgram, (String)"aTextureCoord");
        textureConverter3.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)textureConverter3.mProgram, (String)"uMVPMatrix");
        textureConverter3.mSTMatrixHandle = GLES20.glGetUniformLocation((int)textureConverter3.mProgram, (String)"uSTMatrix");
        textureConverter3.mTextureHandle = GLES20.glGetUniformLocation((int)textureConverter3.mProgram, (String)"uTextureSampler");
    }

    private void draw() {
        TextureConverter textureConverter = object2;
        GLES20.glUseProgram((int)textureConverter.mProgram);
        GLES20.glEnableVertexAttribArray((int)textureConverter.mPositionHandle);
        Object object = ((TextureConverter)object2).vertexBuffer;
        GLES20.glVertexAttribPointer((int)textureConverter.mPositionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)object);
        GLES20.glEnableVertexAttribArray((int)textureConverter.mTextureCoordHandle);
        object = ((TextureConverter)object2).textureCoordBuffer;
        GLES20.glVertexAttribPointer((int)textureConverter.mTextureCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)textureConverter.mTextureTarget, (int)((TextureConverter)object2).mTextureID);
        GLES20.glUniform1i((int)textureConverter.mTextureHandle, (int)3);
        object = ((TextureConverter)object2).mMVPMatrix;
        GLES20.glUniformMatrix4fv((int)textureConverter.mMVPMatrixHandle, (int)1, (boolean)false, (float[])object, (int)0);
        Object object2 = ((TextureConverter)object2).mSTMatrix;
        GLES20.glUniformMatrix4fv((int)textureConverter.mSTMatrixHandle, (int)1, (boolean)false, (float[])object2, (int)0);
        int n2 = textureConverter.vertexCount;
        GLES20.glDrawArrays((int)5, (int)0, (int)n2);
        GLES20.glDisableVertexAttribArray((int)textureConverter.mPositionHandle);
    }

    private void beginRenderTarget(int n2, int n3) {
        if (this.mFrameBuffer == null) {
            int[] nArray = new int[1];
            this.mFrameBuffer = nArray;
            GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
            this.checkGlError();
        }
        TextureConverter textureConverter = this;
        GLES20.glBindFramebuffer((int)36160, (int)textureConverter.mFrameBuffer[0]);
        textureConverter.checkGlError();
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)n2, (int)n3, (int)0);
        textureConverter.checkFramebufferStatus();
    }

    private void endRenderTarget() {
        TextureConverter textureConverter = this;
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)textureConverter.mTextureTarget, (int)0);
        textureConverter.checkGlError();
    }

    private int createProgram(int ... nArray) {
        int n2 = GLES20.glCreateProgram();
        if (n2 == 0) {
            return n2;
        }
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            GLES20.glAttachShader((int)n2, (int)nArray[i2]);
        }
        GLES20.glLinkProgram((int)n2);
        nArray = new int[1];
        GLES20.glGetProgramiv((int)n2, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            GLES20.glDeleteProgram((int)n2);
            n2 = 0;
        }
        return n2;
    }

    private int loadShader(int n2, String string2) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 == 0) {
            return n3;
        }
        int n4 = n3;
        GLES20.glShaderSource((int)n4, (String)string2);
        GLES20.glCompileShader((int)n4);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            GLES20.glDeleteShader((int)n3);
            n3 = 0;
        }
        return n3;
    }

    private void checkGlError() {
        if (GLES20.glGetError() != 0) {
            new Throwable();
        }
    }

    private void checkFramebufferStatus() {
        int n2 = GLES20.glCheckFramebufferStatus((int)36160);
        if (n2 != 36053) {
            String string2 = "";
            if (n2 != 36054) {
                if (n2 != 36055) {
                    if (n2 != 36057) {
                        if (n2 == 36061) {
                            string2 = "GL_FRAMEBUFFER_UNSUPPORTED";
                        }
                    } else {
                        string2 = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    }
                } else {
                    string2 = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                }
            } else {
                string2 = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
            }
            throw new RuntimeException(string2 + " : 0x" + Integer.toHexString(n2));
        }
    }

    private FloatBuffer arrayToBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public int getOneTexture(int n2) {
        int[] nArray = new int[1];
        Object object = nArray;
        int n3 = n2;
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        GLES20.glBindTexture((int)n3, (int)object[0]);
        GLES20.glTexParameterf((int)n3, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n3, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n3, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n3, (int)10243, (float)33071.0f);
        return nArray[0];
    }

    public void convert(int n2, int n3) {
        TextureConverter textureConverter = this;
        textureConverter.beginRenderTarget(n2, n3);
        textureConverter.draw();
        GLES20.glFinish();
        textureConverter.endRenderTarget();
    }

    public void release() {
        Object object = ((TextureConverter)object).mFrameBuffer;
        if (((TextureConverter)object).mFrameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])object, (int)0);
        }
    }
}

