/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TextureTransformer {
    private static final String TAG = "TextureTransformer";
    public static final float[] IDENTITY_MATRIX = new float[16];
    private final ThreadUtils.ThreadChecker threadChecker;
    private final GlTextureFrameBuffer[] textureFrameBuffer;
    private final GlRectDrawer drawer;
    private final int maxBufferSlot;
    private final Map<Integer, Integer> textureId2SlotMap;
    private final ConcurrentLinkedQueue<Integer> freeSlots;

    public TextureTransformer(int n2) {
        GlRectDrawer glRectDrawer;
        TextureTransformer textureTransformer = glRectDrawer2;
        textureTransformer.threadChecker = new ThreadUtils.ThreadChecker();
        textureTransformer.textureId2SlotMap = new HashMap<Integer, Integer>();
        textureTransformer.freeSlots = new ConcurrentLinkedQueue();
        textureTransformer.threadChecker.checkIsOnValidThread();
        ((TextureTransformer)((Object)glRectDrawer2)).maxBufferSlot = Math.max(n2, 1);
        ((TextureTransformer)((Object)glRectDrawer2)).textureFrameBuffer = new GlTextureFrameBuffer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            GlTextureFrameBuffer glTextureFrameBuffer;
            TextureTransformer textureTransformer2 = glRectDrawer2;
            Object object = glTextureFrameBuffer;
            glTextureFrameBuffer = new GlTextureFrameBuffer(6408);
            textureTransformer2.textureFrameBuffer[i2] = object;
            object = ((TextureTransformer)((Object)glRectDrawer2)).textureFrameBuffer[i2].getTextureId();
            textureTransformer2.textureId2SlotMap.put((Integer)object, i2);
            textureTransformer2.freeSlots.offer(i2);
        }
        TextureTransformer textureTransformer3 = glRectDrawer2;
        GlRectDrawer glRectDrawer2 = glRectDrawer;
        glRectDrawer = new GlRectDrawer();
        textureTransformer3.drawer = glRectDrawer2;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int copy(int n2, int n3, int n4, int n5) {
        TextureTransformer textureTransformer = this;
        textureTransformer.threadChecker.checkIsOnValidThread();
        Integer n6 = textureTransformer.freeSlots.poll();
        if (n6 == null) {
            return -1;
        }
        TextureTransformer textureTransformer2 = this;
        textureTransformer2.textureFrameBuffer[n6].setSize(n4, n5);
        GLES20.glBindFramebuffer((int)36160, (int)textureTransformer2.textureFrameBuffer[n6].getFrameBufferId());
        GlUtil.checkNoGLES2Error("TextureHelper.glBindFramebuffer");
        GLES20.glClear((int)16384);
        if (n3 != 10) {
            if (n3 != 11) throw new RuntimeException("Unknown texture type.");
            this.drawer.drawOes(n2, IDENTITY_MATRIX, n4, n5, 0, 0, n4, n5);
        } else {
            this.drawer.drawRgb(n2, IDENTITY_MATRIX, n4, n5, 0, 0, n4, n5);
        }
        GlUtil.checkNoGLES2Error("TextureHelper.draw");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
        n2 = this.textureFrameBuffer[n6].getTextureId();
        this.freeSlots.offer(this.textureId2SlotMap.get(n2));
        return n2;
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        for (int i2 = 0; i2 < this.maxBufferSlot; ++i2) {
            this.textureFrameBuffer[i2].release();
        }
        this.drawer.release();
    }
}

