/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.RgbaBuffer;
import io.agora.rtc.gl.VideoFrame;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class VideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    private VideoFrame lastI420Frame;
    private VideoFrame lastRgbaFrame;
    private final Matrix renderMatrix = new Matrix();
    private final RGBAUploader rgbaUploader = new RGBAUploader();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix object, int n2, int n3, int n4, int n5, int n6, int n7) {
        void var8_9;
        void var7_8;
        void var6_7;
        void var5_6;
        void var4_5;
        void var3_4;
        Matrix matrix = new Matrix(textureBuffer.getTransformMatrix());
        matrix.preConcat(object);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        int n8 = 1.$SwitchMap$io$agora$rtc$gl$VideoFrame$TextureBuffer$Type[textureBuffer.getType().ordinal()];
        if (n8 != 1) {
            if (n8 != 2) throw new RuntimeException("Unknown texture type.");
            glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
            return;
        } else {
            glDrawer.drawOes(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
        }
    }

    private static int distance(float f2, float f3, float f4, float f5) {
        return (int)Math.round(Math.hypot(f4 - f2, f5 - f3));
    }

    private void calculateTransformedRenderSize(int n2, int n3, Matrix matrix) {
        if (matrix == null) {
            VideoFrameDrawer videoFrameDrawer = this;
            videoFrameDrawer.renderWidth = n2;
            videoFrameDrawer.renderHeight = n3;
            return;
        }
        matrix.mapPoints(((VideoFrameDrawer)this).dstPoints, srcPoints);
        for (int i2 = 0; i2 < 3; ++i2) {
            float[] fArray = ((VideoFrameDrawer)this).dstPoints;
            int n4 = i2 * 2;
            int n5 = n4 + 0;
            fArray[n5] = ((VideoFrameDrawer)this).dstPoints[n5] * (float)n2;
            fArray[++n4] = ((VideoFrameDrawer)this).dstPoints[n4] * (float)n3;
        }
        VideoFrameDrawer videoFrameDrawer = this;
        Object object = this = (Object)videoFrameDrawer.dstPoints;
        Object object2 = object[1];
        Object object3 = object[2];
        Object object4 = object[3];
        videoFrameDrawer.renderWidth = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], (float)object2, (float)object3, (float)object4);
        float[] fArray = videoFrameDrawer.dstPoints;
        float f2 = fArray[1];
        object3 = fArray[4];
        object4 = fArray[5];
        videoFrameDrawer.renderHeight = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], f2, (float)object3, (float)object4);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        VideoFrame videoFrame2 = videoFrame;
        int n2 = videoFrame2.getRotatedWidth();
        int n3 = videoFrame2.getRotatedHeight();
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, n2, n3);
    }

    public void drawFrame(VideoFrame object, RendererCommon.GlDrawer glDrawer, Matrix matrix, int n2, int n3, int n4, int n5) {
        Object object2;
        VideoFrame videoFrame = object;
        int n6 = videoFrame.getRotatedWidth();
        ((VideoFrameDrawer)object2).calculateTransformedRenderSize(n6, videoFrame.getRotatedHeight(), matrix);
        n6 = ((VideoFrame)object).getBuffer() instanceof VideoFrame.TextureBuffer;
        VideoFrameDrawer videoFrameDrawer = object2;
        boolean bl = ((VideoFrame)object).getBuffer() instanceof RgbaBuffer;
        videoFrameDrawer.renderMatrix.reset();
        videoFrameDrawer.renderMatrix.preTranslate(0.5f, 0.5f);
        if (n6 == 0) {
            ((VideoFrameDrawer)object2).renderMatrix.preScale(1.0f, -1.0f);
        }
        VideoFrameDrawer videoFrameDrawer2 = object2;
        videoFrameDrawer2.renderMatrix.preRotate((float)((VideoFrame)object).getRotation());
        videoFrameDrawer2.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (matrix != null) {
            ((VideoFrameDrawer)object2).renderMatrix.preConcat(matrix);
        }
        if (n6 != 0) {
            VideoFrameDrawer videoFrameDrawer3 = object2;
            VideoFrameDrawer videoFrameDrawer4 = object2;
            videoFrameDrawer4.lastI420Frame = null;
            videoFrameDrawer4.lastRgbaFrame = null;
            object2 = (VideoFrame.TextureBuffer)((VideoFrame)object).getBuffer();
            object = videoFrameDrawer3.renderMatrix;
            int n7 = videoFrameDrawer3.renderWidth;
            int n8 = videoFrameDrawer3.renderHeight;
            VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)object2, (Matrix)object, n7, n8, n2, n3, n4, n5);
        } else if (bl) {
            if (object != ((VideoFrameDrawer)object2).lastRgbaFrame) {
                ((VideoFrameDrawer)object2).lastRgbaFrame = object;
                RgbaBuffer rgbaBuffer = (RgbaBuffer)((VideoFrame)object).getBuffer();
                object = rgbaBuffer.getBuffer();
                int n9 = rgbaBuffer.getWidth();
                n6 = rgbaBuffer.getHeight();
                ((VideoFrameDrawer)object2).rgbaUploader.uploadData((ByteBuffer)object, n9, n6);
                rgbaBuffer.release();
            }
            VideoFrameDrawer videoFrameDrawer5 = object2;
            int n10 = videoFrameDrawer5.rgbaUploader.getTextureId();
            object = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(videoFrameDrawer5.renderMatrix);
            int n11 = videoFrameDrawer5.renderWidth;
            int n12 = videoFrameDrawer5.renderHeight;
            glDrawer.drawRgb(n10, (float[])object, n11, n12, n2, n3, n4, n5);
        } else {
            if (object != ((VideoFrameDrawer)object2).lastI420Frame) {
                ((VideoFrameDrawer)object2).lastI420Frame = object;
                VideoFrame.I420Buffer i420Buffer = ((VideoFrame)object).getBuffer().toI420();
                ((VideoFrameDrawer)object2).yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
            }
            VideoFrameDrawer videoFrameDrawer6 = object2;
            object2 = videoFrameDrawer6.yuvUploader.getYuvTextures();
            object = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(videoFrameDrawer6.renderMatrix);
            int n13 = videoFrameDrawer6.renderWidth;
            int n14 = videoFrameDrawer6.renderHeight;
            glDrawer.drawYuv((int[])object2, (float[])object, n13, n14, n2, n3, n4, n5);
        }
    }

    public void release() {
        VideoFrameDrawer videoFrameDrawer = this;
        videoFrameDrawer.yuvUploader.release();
        videoFrameDrawer.lastI420Frame = null;
        videoFrameDrawer.rgbaUploader.release();
        videoFrameDrawer.lastRgbaFrame = null;
    }

    private static class RGBAUploader {
        private int mTextureId = 0;
        private ByteBuffer mData;

        private RGBAUploader() {
        }

        public int uploadData(ByteBuffer byteBuffer, int n2, int n3) {
            ((RGBAUploader)((Object)byteBuffer2)).mData = byteBuffer;
            if (((RGBAUploader)((Object)byteBuffer2)).mTextureId == 0) {
                ((RGBAUploader)((Object)byteBuffer2)).mTextureId = GlUtil.generateTexture(3553);
            }
            RGBAUploader rGBAUploader = byteBuffer2;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)rGBAUploader.mTextureId);
            ByteBuffer byteBuffer2 = rGBAUploader.mData;
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)6408, (int)5121, (Buffer)byteBuffer2);
            GlUtil.checkNoGLES2Error("glTexImage2D");
            return rGBAUploader.mTextureId;
        }

        public int getTextureId() {
            return this.mTextureId;
        }

        public void release() {
            ((RGBAUploader)object).mData = null;
            int n2 = ((RGBAUploader)object).mTextureId;
            if (n2 != 0) {
                RGBAUploader rGBAUploader = object;
                int[] nArray = new int[1];
                Object object = nArray;
                nArray[0] = n2;
                GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
                rGBAUploader.mTextureId = 0;
            }
        }
    }

    private static class YuvUploader {
        private ByteBuffer copyBuffer;
        private int[] yuvTextures;

        private YuvUploader() {
        }

        public int[] uploadYuvData(int n2, int n3, int[] nArray, ByteBuffer[] byteBufferArray) {
            ByteBuffer byteBuffer;
            int[] nArray2 = new int[3];
            int[] nArray3 = nArray2;
            nArray3[0] = n2;
            nArray2[1] = n2 /= 2;
            nArray2[2] = n2;
            int[] nArray4 = new int[3];
            int[] nArray5 = nArray4;
            nArray5[0] = n3;
            nArray4[1] = n3 /= 2;
            nArray4[2] = n3;
            n3 = 0;
            for (int i2 = 0; i2 < 3; ++i2) {
                if (nArray[i2] <= nArray3[i2]) continue;
                n3 = Math.max(n3, nArray3[i2] * nArray5[i2]);
            }
            if (n3 > 0 && ((byteBuffer = this.copyBuffer) == null || byteBuffer.capacity() < n3)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n3);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n3 = 0; n3 < 3; ++n3) {
                    this.yuvTextures[n3] = GlUtil.generateTexture(3553);
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                GLES20.glActiveTexture((int)(n3 + 33984));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n3]);
                ByteBuffer byteBuffer2 = nArray[n3] == nArray3[n3] ? byteBufferArray[n3] : this.copyBuffer;
                int n4 = nArray3[n3];
                int n5 = nArray5[n3];
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n4, (int)n5, (int)0, (int)6409, (int)5121, (Buffer)byteBuffer2);
            }
            return this.yuvTextures;
        }

        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            YuvUploader yuvUploader = object;
            VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
            int[] nArray = new int[3];
            Object object = nArray;
            object[0] = i420Buffer.getStrideY();
            object[1] = i420Buffer.getStrideU();
            nArray[2] = i420Buffer.getStrideV();
            ByteBuffer[] byteBufferArray = new ByteBuffer[3];
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray2[0] = i420Buffer.getDataY();
            byteBufferArray2[1] = i420Buffer.getDataU();
            byteBufferArray[2] = i420Buffer.getDataV();
            int n2 = i420Buffer2.getWidth();
            return yuvUploader.uploadYuvData(n2, i420Buffer2.getHeight(), (int[])object, byteBufferArray2);
        }

        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            YuvUploader yuvUploader = this;
            yuvUploader.copyBuffer = null;
            int[] nArray = yuvUploader.yuvTextures;
            if (yuvUploader.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

