/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlShader;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class YuvConverter {
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String OES_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private static final String RGB_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker;
    private final GlTextureFrameBuffer textureFrameBuffer;
    private VideoFrame.TextureBuffer.Type shaderTextureType;
    private GlShader shader;
    private int texMatrixLoc;
    private int xUnitLoc;
    private int coeffsLoc;
    private boolean released;
    private long nativeHanlder;

    public YuvConverter() {
        GlTextureFrameBuffer glTextureFrameBuffer;
        ThreadUtils.ThreadChecker threadChecker;
        ThreadUtils.ThreadChecker threadChecker2 = threadChecker;
        YuvConverter yuvConverter = glTextureFrameBuffer2;
        threadChecker2();
        yuvConverter.threadChecker = threadChecker2;
        yuvConverter.released = false;
        yuvConverter.nativeHanlder = 0L;
        threadChecker.checkIsOnValidThread();
        GlTextureFrameBuffer glTextureFrameBuffer2 = glTextureFrameBuffer;
        glTextureFrameBuffer = new GlTextureFrameBuffer(6408);
        v3.textureFrameBuffer = glTextureFrameBuffer2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initShader(VideoFrame.TextureBuffer.Type type) {
        String string2;
        int n2;
        GlShader glShader = ((YuvConverter)object).shader;
        if (glShader != null) {
            glShader.release();
        }
        if ((n2 = 1.$SwitchMap$io$agora$rtc$gl$VideoFrame$TextureBuffer$Type[type.ordinal()]) != 1) {
            if (n2 != 2) throw new IllegalArgumentException("Unsupported texture type.");
            string2 = RGB_FRAGMENT_SHADER;
        } else {
            string2 = OES_FRAGMENT_SHADER;
        }
        YuvConverter yuvConverter = object;
        yuvConverter.shaderTextureType = type;
        ((YuvConverter)object).shader = new GlShader(VERTEX_SHADER, string2);
        ((YuvConverter)object).shader.useProgram();
        yuvConverter.texMatrixLoc = yuvConverter.shader.getUniformLocation("texMatrix");
        yuvConverter.xUnitLoc = yuvConverter.shader.getUniformLocation("xUnit");
        yuvConverter.coeffsLoc = yuvConverter.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)yuvConverter.shader.getUniformLocation("tex"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        Object object = DEVICE_RECTANGLE;
        yuvConverter.shader.setVertexAttribArray("in_pos", 2, (FloatBuffer)object);
        object = TEXTURE_RECTANGLE;
        yuvConverter.shader.setVertexAttribArray("in_tc", 2, (FloatBuffer)object);
    }

    private void convert(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, float[] fArray, VideoFrame.TextureBuffer.Type type) {
        YuvConverter yuvConverter = object;
        yuvConverter.threadChecker.checkIsOnValidThread();
        if (!yuvConverter.released) {
            if (type != ((YuvConverter)object).shaderTextureType) {
                ((YuvConverter)object).initShader(type);
            }
            ((YuvConverter)object).shader.useProgram();
            if (n4 % 8 == 0) {
                if (n4 >= n2) {
                    int n6 = n3;
                    int n7 = n2;
                    int n8 = (n7 + 3) / 4;
                    int n9 = (n7 + 7) / 8;
                    int n10 = (n6 + 1) / 2;
                    int n11 = n6 + n10;
                    int n12 = n4 * n11;
                    if (byteBuffer.capacity() >= n12) {
                        YuvConverter yuvConverter2 = object;
                        YuvConverter yuvConverter3 = object;
                        YuvConverter yuvConverter4 = object;
                        float[] fArray2 = RendererCommon.multiplyMatrices(fArray, RendererCommon.verticalFlipMatrix());
                        int n13 = n4 / 4;
                        yuvConverter4.textureFrameBuffer.setSize(n13, n11);
                        GLES20.glBindFramebuffer((int)36160, (int)yuvConverter4.textureFrameBuffer.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        GLES20.glActiveTexture((int)33984);
                        GLES20.glBindTexture((int)type.getGlTarget(), (int)n5);
                        GLES20.glUniformMatrix4fv((int)yuvConverter3.texMatrixLoc, (int)1, (boolean)false, (float[])fArray2, (int)0);
                        GLES20.glViewport((int)0, (int)0, (int)n8, (int)n3);
                        float f2 = n2;
                        float f3 = fArray2[0] / f2;
                        GLES20.glUniform2f((int)yuvConverter3.xUnitLoc, (float)f3, (float)(fArray2[1] / f2));
                        GLES20.glUniform4f((int)yuvConverter3.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        GLES20.glViewport((int)0, (int)n3, (int)n9, (int)n10);
                        float f4 = fArray2[0] * 2.0f / f2;
                        GLES20.glUniform2f((int)yuvConverter3.xUnitLoc, (float)f4, (float)(fArray2[1] * 2.0f / f2));
                        GLES20.glUniform4f((int)yuvConverter3.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        GLES20.glViewport((int)(n4 / 8), (int)n3, (int)n9, (int)n10);
                        GLES20.glUniform4f((int)yuvConverter2.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
                        GLES20.glDrawArrays((int)5, (int)0, (int)4);
                        int n14 = -1;
                        if (yuvConverter2.GPUFBOValid()) {
                            if (((YuvConverter)object).nativeHanlder == 0L) {
                                ((YuvConverter)object).nativeHanlder = ((YuvConverter)object).GPUFBOInit(n13, n11);
                            }
                            YuvConverter yuvConverter5 = object;
                            long l2 = ((YuvConverter)object).nativeHanlder;
                            Object object = byteBuffer.array();
                            n14 = yuvConverter5.GPUFBOReadFrame(l2, (byte[])object, n13, n11);
                        }
                        if (n14 != 0) {
                            GLES20.glReadPixels((int)0, (int)0, (int)n13, (int)n11, (int)6408, (int)5121, (Buffer)byteBuffer);
                        }
                        GlUtil.checkNoGLES2Error("YuvConverter.convert");
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glBindTexture((int)3553, (int)0);
                        GLES20.glBindTexture((int)type.getGlTarget(), (int)0);
                        return;
                    }
                    throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
                }
                throw new IllegalArgumentException("Invalid stride, must >= width");
            }
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        throw new IllegalStateException("YuvConverter.convert called on released object");
    }

    private native long GPUFBOInit(int var1, int var2);

    private native boolean GPUFBOValid();

    private native void GPUFBORelease(long var1);

    private native int GPUFBOReadFrame(long var1, byte[] var3, int var4, int var5);

    private native void GPUFBOResetFirstInit(long var1);

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer object) {
        int n2 = object.getWidth();
        int n3 = object.getHeight();
        int n4 = (n2 + 7) / 8 * 8;
        int n5 = n3;
        int n6 = (n5 + 1) / 2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4 * (n5 + n6 + 1));
        VideoFrame.TextureBuffer textureBuffer = object;
        int n7 = textureBuffer.getTextureId();
        object = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix());
        VideoFrame.TextureBuffer.Type type = textureBuffer.getType();
        this.convert(byteBuffer, n2, n3, n4, n7, (float[])object, type);
        n7 = n4 * n3 + 0;
        int n8 = n7 + n4 / 2;
        ByteBuffer byteBuffer2 = byteBuffer;
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.position(0);
        byteBuffer3.limit(n7);
        ByteBuffer byteBuffer4 = byteBuffer3.slice();
        byteBuffer.position(n7);
        int n9 = n4 * n6;
        byteBuffer2.limit(n7 + n9);
        ByteBuffer byteBuffer5 = byteBuffer2.slice();
        byteBuffer.position(n8);
        byteBuffer.limit(n8 + n9);
        ByteBuffer byteBuffer6 = byteBuffer.slice();
        return JavaI420Buffer.wrap(n2, n3, byteBuffer4, n4, byteBuffer5, n4, byteBuffer6, n4, null);
    }

    @Deprecated
    void convert(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, float[] fArray) {
        YuvConverter yuvConverter = object;
        Object object = VideoFrame.TextureBuffer.Type.OES;
        yuvConverter.convert(byteBuffer, n2, n3, n4, n5, fArray, (VideoFrame.TextureBuffer.Type)((Object)object));
    }

    public void release() {
        YuvConverter yuvConverter = this;
        yuvConverter.threadChecker.checkIsOnValidThread();
        yuvConverter.released = true;
        GlShader glShader = yuvConverter.shader;
        if (glShader != null) {
            glShader.release();
        }
        YuvConverter yuvConverter2 = this;
        yuvConverter2.textureFrameBuffer.release();
        if (yuvConverter2.GPUFBOValid()) {
            YuvConverter yuvConverter3 = this;
            yuvConverter3.GPUFBORelease(yuvConverter3.nativeHanlder);
        }
    }
}

