/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import io.agora.rtc.internal.AudioRoutingListener;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private static final int HEADSET = 0;
    private static final int EARPIECE = 1;
    private static final int SPEAKER = 3;
    private static final int STOP = 4;
    private static final int BLUETOOTH = 5;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET_A2DP = 2;
    private static final int EVT_BT_SCO = 3;
    private static final int EVT_BT_HEADSET_HFP = 4;
    public static final int CMD_DEFAULT_DEVICE = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    public static final int EVT_USING_COMM_PARAMETERS = 112;
    public static final int EVT_USING_NORM_PARAMETERS = 113;
    public static final int EVT_AUDIO_ADM_ROUTING_UPDATE = 114;
    public static final int EVT_UNINITIALIZE = 200;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 3000;
    private static final int BLUETOOTH_RESET_BT_DELAY = 3000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 5;
    private WeakReference<Context> mContext;
    private EventHandler mEventHandler;
    private WeakReference<AudioRoutingListener> mListener;
    AudioManager am;
    private HeadsetBroadcastReceiver mHeadsetReceiver;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothA2dp mBtA2dp;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private AudioRouteState mState;
    private StopState mStopState;
    private SpeakerState mSpeakerState;
    private EarpieceState mEarpieceState;
    private BTState mBTState;
    private HeadsetState mHeadsetState;
    private AudioDeviceList mAvailDevices;
    private int mTargetRoute;
    private boolean mIsBTHeadsetPlugged;
    private boolean mVideoDisabled;
    private boolean mMuteLocal;
    private boolean mMuteRemotes;
    private boolean mPhoneInCall;
    private boolean mHfpEnable;
    private boolean mA2dpEnable;
    private int mStreamType;
    private int mChannelProfile;
    private int mBtScoState;
    private int dynamic_timeout;
    private int mScoConnectionAttemps;
    private int mLastNotifiedRouting;
    private final Runnable TryConnectBtScoRunnable;
    private final Runnable TrytoResetBTRunnable;

    private void checkNeedResetBT() {
        this.mEventHandler.postDelayed(this.TrytoResetBTRunnable, 3000L);
    }

    private void startTimer() {
        AudioRoutingController audioRoutingController = this;
        audioRoutingController.dynamic_timeout += 3000;
        Logging.d(TAG, "audio route start bluetooth timer " + this.dynamic_timeout + ", times:" + this.mScoConnectionAttemps);
        audioRoutingController.mEventHandler.postDelayed(this.TryConnectBtScoRunnable, 3000L);
    }

    private void cancelTimer() {
        Logging.d(TAG, "cancel bluetooth timer");
        this.dynamic_timeout = 0;
        this.mScoConnectionAttemps = 0;
        this.mEventHandler.removeCallbacks(this.TryConnectBtScoRunnable);
    }

    public AudioRoutingController(Context context, AudioRoutingListener audioRoutingListener) {
        AudioRoutingController audioRoutingController = this;
        audioRoutingController.am = null;
        audioRoutingController.mStopState = null;
        audioRoutingController.mSpeakerState = null;
        audioRoutingController.mEarpieceState = null;
        audioRoutingController.mBTState = null;
        audioRoutingController.mHeadsetState = null;
        audioRoutingController.mTargetRoute = -1;
        audioRoutingController.mIsBTHeadsetPlugged = false;
        audioRoutingController.mVideoDisabled = true;
        audioRoutingController.mMuteLocal = false;
        audioRoutingController.mMuteRemotes = false;
        audioRoutingController.mPhoneInCall = false;
        audioRoutingController.mHfpEnable = false;
        audioRoutingController.mA2dpEnable = false;
        audioRoutingController.mStreamType = 0;
        audioRoutingController.mChannelProfile = 1;
        audioRoutingController.mBtScoState = 3;
        audioRoutingController.dynamic_timeout = 0;
        audioRoutingController.mLastNotifiedRouting = -1;
        audioRoutingController.TryConnectBtScoRunnable = new Runnable(){

            @Override
            public void run() {
                AudioRoutingController.this.tryToConnectBtSco();
            }
        };
        audioRoutingController.TrytoResetBTRunnable = new Runnable(){

            @Override
            public void run() {
                if (!AudioRoutingController.this.am.isBluetoothA2dpOn() && !AudioRoutingController.this.am.isBluetoothScoOn()) {
                    AudioRoutingController.this.resetBtAdapter();
                } else {
                    Logging.d(AudioRoutingController.TAG, "reset bluetooth failed a2dp: " + AudioRoutingController.this.am.isBluetoothA2dpOn() + " sco:" + AudioRoutingController.this.am.isBluetoothScoOn());
                }
            }
        };
        audioRoutingController.mContext = new WeakReference<Context>(context);
        audioRoutingController.mListener = new WeakReference<AudioRoutingListener>(audioRoutingListener);
        audioRoutingController.am = audioRoutingController.getAudioManager();
    }

    private int routeToState(int n2) {
        int n3 = -1;
        Logging.i(TAG, "routeToState  " + n2);
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 3) {
                    if (n2 != 5) {
                        Logging.d(TAG, "unknown routing:  " + n2);
                    } else {
                        n3 = 5;
                    }
                } else {
                    n3 = 3;
                }
            } else {
                n3 = 1;
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    private void changeState(int n2) {
        block12: {
            switch (n2) {
                default: {
                    SpeakerState speakerState;
                    Logging.d(TAG, "--------------------Comming to UNKNOWN STATE----------- ");
                    if (this.mSpeakerState != null) break;
                    SpeakerState speakerState2 = speakerState;
                    speakerState = new SpeakerState();
                    this.mSpeakerState = speakerState2;
                    break;
                }
                case 5: {
                    if (this.mBTState == null) {
                        BTState bTState;
                        BTState bTState2 = bTState;
                        bTState = new BTState();
                        this.mBTState = bTState2;
                    }
                    this.mState = this.mBTState;
                    Logging.d(TAG, "--------------------Comming to BLUETOOTH--------------- ");
                    break block12;
                }
                case 4: {
                    if (this.mStopState == null) {
                        StopState stopState;
                        StopState stopState2 = stopState;
                        stopState = new StopState();
                        this.mStopState = stopState2;
                    }
                    this.mState = this.mStopState;
                    Logging.d(TAG, "--------------------Comming to STOP-------------------- ");
                    break block12;
                }
                case 3: {
                    if (this.mSpeakerState == null) {
                        SpeakerState speakerState;
                        SpeakerState speakerState3 = speakerState;
                        speakerState = new SpeakerState();
                        this.mSpeakerState = speakerState3;
                    }
                    this.mState = this.mSpeakerState;
                    Logging.d(TAG, "--------------------Comming to SPEAKER----------------- ");
                    break block12;
                }
                case 1: {
                    if (this.mEarpieceState == null) {
                        EarpieceState earpieceState;
                        EarpieceState earpieceState2 = earpieceState;
                        earpieceState = new EarpieceState();
                        this.mEarpieceState = earpieceState2;
                    }
                    this.mState = this.mEarpieceState;
                    Logging.d(TAG, "--------------------Comming to EARPIECE---------------- ");
                    break block12;
                }
                case 0: {
                    if (this.mHeadsetState == null) {
                        HeadsetState headsetState;
                        HeadsetState headsetState2 = headsetState;
                        headsetState = new HeadsetState();
                        this.mHeadsetState = headsetState2;
                    }
                    this.mState = this.mHeadsetState;
                    Logging.d(TAG, "--------------------Comming to HEADSET----------------- ");
                    break block12;
                }
            }
            this.mState = this.mSpeakerState;
        }
        this.mState.switchtoTargetRoute();
    }

    private void clearBTResource() {
        BluetoothAdapter bluetoothAdapter = this.mBTAdapter;
        if (bluetoothAdapter != null) {
            int n2 = bluetoothAdapter.getProfileConnectionState(1);
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            if (n2 != 2) {
                this.cancelTimer();
                this.mBTHeadset = null;
            }
            int n3 = this.mBTAdapter.getProfileConnectionState(2);
            this.mBTAdapter.closeProfileProxy(2, (BluetoothProfile)this.mBtA2dp);
            if (n3 != 2) {
                this.mBtA2dp = null;
            }
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        AudioRoutingController audioRoutingController = (Context)audioRoutingController.mContext.get();
        if (audioRoutingController == null) {
            return null;
        }
        return (AudioManager)audioRoutingController.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int n2) {
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)((AudioRoutingController)((Object)audioRoutingListener)).mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingChanged(n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private void notifyAudioBtProfileChanged() {
        Object object = this.mBTAdapter;
        if (object != null) {
            this.mHfpEnable = 2 == object.getProfileConnectionState(1);
            Logging.i(TAG, "BT headset  mHfpEnable " + this.mHfpEnable);
            this.mA2dpEnable = 2 == this.mBTAdapter.getProfileConnectionState(2);
            Logging.i(TAG, "BT headset  mA2dpEnable " + this.mA2dpEnable);
        } else {
            AudioRoutingController audioRoutingController = this;
            audioRoutingController.mHfpEnable = false;
            audioRoutingController.mA2dpEnable = false;
        }
        object = (AudioRoutingListener)this.mListener.get();
        if (object != null) {
            AudioRoutingController audioRoutingController = this;
            int n2 = 0;
            n2 = audioRoutingController.mHfpEnable | n2;
            int n3 = audioRoutingController.mA2dpEnable ? 2 : 0;
            object.onAudioBtProfileChanged(n2 |= n3);
            Logging.i(TAG, "BT headset  btProfile " + n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private void changeStateByPriority() {
        if (this.getBtDeviceList() > 0) {
            AudioRoutingController audioRoutingController = this;
            audioRoutingController.checkNeedResetBT();
            if (audioRoutingController.mStreamType == 0) {
                this.enableBtSco();
            }
            this.changeState(5);
        } else {
            AudioDeviceList audioDeviceList = this.mAvailDevices;
            if (audioDeviceList.mHeadSetRoute != -1) {
                this.changeState(0);
            } else {
                int n2 = audioDeviceList.mForcedRoute;
                if (n2 != -1) {
                    this.changeState(n2);
                } else {
                    this.changeState(audioDeviceList.mDefaultRoute);
                }
            }
        }
    }

    private void enableBtSco() {
        if (!this.am.isBluetoothScoAvailableOffCall()) {
            return;
        }
        if (!this.am.isBluetoothScoOn()) {
            AudioRoutingController audioRoutingController = this;
            audioRoutingController.am.startBluetoothSco();
            audioRoutingController.am.setBluetoothScoOn(true);
        }
    }

    private void disableBtSco() {
        if (!this.am.isBluetoothScoAvailableOffCall()) {
            return;
        }
        if (this.am.isBluetoothScoOn()) {
            AudioRoutingController audioRoutingController = this;
            audioRoutingController.am.setBluetoothScoOn(false);
            audioRoutingController.am.stopBluetoothSco();
        }
    }

    private void resetBtAdapter() {
        AudioRoutingController audioRoutingController = this;
        Context context = (Context)audioRoutingController.mContext.get();
        if (audioRoutingController.mBTAdapter == null) {
            return;
        }
        if (!this.hasPermission(context, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        this.mBTAdapter.disable();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            Logging.e(TAG, "resetBtAdapter failed:", exception);
        }
        this.mBTAdapter.enable();
        Logging.i(TAG, "resetBtAdapter Happened!");
    }

    private String modeAsString(int n2) {
        String string2;
        switch (n2) {
            default: {
                string2 = "Unknown " + n2;
                break;
            }
            case 3: {
                string2 = "MODE_IN_COMMUNICATION";
                break;
            }
            case 2: {
                string2 = "MODE_IN_CALL";
                break;
            }
            case 1: {
                string2 = "MODE_RINGTONE";
                break;
            }
            case 0: {
                string2 = "MODE_NORMAL";
            }
        }
        return string2;
    }

    private String btStateAsString(int n2) {
        String string2;
        switch (n2) {
            default: {
                string2 = "Unknown " + n2;
                break;
            }
            case 3: {
                string2 = "SCO_DISCONNECTED";
                break;
            }
            case 2: {
                string2 = "SCO_DISCONNECTING";
                break;
            }
            case 1: {
                string2 = "SCO_CONNECTED";
                break;
            }
            case 0: {
                string2 = "SCO_CONNECTING";
            }
        }
        return string2;
    }

    private void tryToConnectBtSco() {
        if (this.mBTHeadset == null) {
            Logging.w(TAG, "no bluetooth profile connected");
            return;
        }
        AudioRoutingController audioRoutingController = this;
        ++audioRoutingController.mScoConnectionAttemps;
        boolean bl = audioRoutingController.isBtScoConnected();
        if (audioRoutingController.mScoConnectionAttemps < 5) {
            this.startTimer();
            AudioRoutingController audioRoutingController2 = this;
            Logging.d(TAG, "Attemp trying sco connected: " + bl + "  times:" + this.mScoConnectionAttemps + "[" + audioRoutingController2.btStateAsString(audioRoutingController2.mBtScoState) + "]");
            if (!bl) {
                AudioRoutingController audioRoutingController3 = this;
                audioRoutingController3.disableBtSco();
                audioRoutingController3.enableBtSco();
                if (audioRoutingController3.mScoConnectionAttemps == 4) {
                    this.resetBtAdapter();
                }
                Logging.e(TAG, "start bluetooth sco on ? " + this.am.isBluetoothScoOn() + ",audiomode:" + this.am.getMode());
            } else {
                this.cancelTimer();
            }
        } else {
            AudioRoutingController audioRoutingController4 = this;
            Logging.e(TAG, "start bluetooth sco timeout, actual routing: ");
            audioRoutingController4.cancelTimer();
            if (audioRoutingController4.mListener.get() != null) {
                ((AudioRoutingListener)this.mListener.get()).onAudioRoutingError(1030);
            }
            if (bl) {
                Logging.e(TAG, "BT sco has already connect ");
            } else {
                AudioDeviceList audioDeviceList = this.mAvailDevices;
                int n2 = audioDeviceList.mHeadSetRoute;
                if (n2 != -1) {
                    this.changeState(n2);
                } else {
                    n2 = audioDeviceList.mForcedRoute;
                    if (n2 != -1) {
                        this.changeState(n2);
                    } else {
                        this.changeState(audioDeviceList.mDefaultRoute);
                    }
                }
            }
        }
    }

    private void connectBTSco() {
        Object object = null;
        Class<?> clazz = this.mBTHeadset.getClass();
        try {
            object = clazz.getMethod("connectAudio", new Class[0]).invoke((Object)this.mBTHeadset, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        if (((Boolean)object).booleanValue()) {
            Logging.d(TAG, "SCO connected successfully ");
        } else {
            Logging.d(TAG, "SCO connected failed ");
        }
    }

    private void disConnectBTSco() {
        Class<?> clazz = this.mBTHeadset.getClass();
        try {
            clazz.getMethod("disconnectAudio", new Class[0]).invoke((Object)this.mBTHeadset, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private boolean isBtScoConnected() {
        List list = this.mBTHeadset.getConnectedDevices();
        if (list.size() > 0) {
            list = (BluetoothDevice)list.get(0);
            Object object = null;
            if (Build.VERSION.SDK_INT <= 26) {
                Class<?> clazz = this.mBTHeadset.getClass();
                try {
                    object = clazz.getMethod("isAudioOn", new Class[0]).invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            if (!(this.mBTHeadset.isAudioConnected((BluetoothDevice)list) || object != null && ((Boolean)object).booleanValue())) {
                Logging.d(TAG, "SCO is not connected with " + list.getName());
                return false;
            }
            Logging.d(TAG, "SCO connected with " + list.getName());
            return true;
        }
        Logging.w(TAG, "no bluetooth device connected.");
        return false;
    }

    private boolean sysRouteToBt() {
        boolean bl = true;
        Context context = (Context)this.mContext.get();
        if (Build.VERSION.SDK_INT >= 24 && context != null) {
            bl = ((MediaRouter)context.getSystemService("media_router")).getSelectedRoute(1).getDeviceType() == 3;
        }
        return bl;
    }

    private int getBtDeviceList() {
        if (!bluetoothHeadset.mA2dpEnable && !bluetoothHeadset.mHfpEnable) {
            return 0;
        }
        BluetoothHeadset bluetoothHeadset = bluetoothHeadset.mBTHeadset;
        if (bluetoothHeadset != null && (bluetoothHeadset = bluetoothHeadset.getConnectedDevices()) != null && bluetoothHeadset.size() > 0) {
            for (BluetoothDevice bluetoothDevice : bluetoothHeadset) {
                if (bluetoothDevice == null) continue;
                Logging.i(TAG, "device name: " + bluetoothDevice.getName());
            }
        }
        return 1;
    }

    private String getAudioRouteDesc(int n2) {
        switch (n2) {
            default: {
                return "Unknown";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 3: {
                return "Speakerphone";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 1: {
                return "Earpiece";
            }
            case 0: {
                return "Headset";
            }
            case -1: 
        }
        return "UNSET";
    }

    private String getEventDesc(int n2) {
        if (n2 != 11) {
            if (n2 != 112) {
                if (n2 != 113) {
                    switch (n2) {
                        default: {
                            return "unkown event";
                        }
                        case 4: {
                            return "bt hfp connect/disconnect event";
                        }
                        case 3: {
                            return "sco connect/disconnect event";
                        }
                        case 2: {
                            return "bt a2dp connect/disconnect event";
                        }
                        case 1: 
                    }
                    return "headset connect/disconnect event";
                }
                return "music stream event";
            }
            return "communication stream event";
        }
        return "set forcespeakerphone event";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int setTargetRouteByPriority() {
        block9: {
            block8: {
                try {
                    if (this.mAvailDevices.mBTRoute == -1) break block8;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "fatal error setTargetRouteByPriority", exception);
                    return -1;
                }
                if (!this.isBTConnected()) break block8;
                if (!this.sysRouteToBt()) break block8;
                return 5;
            }
            if (this.mAvailDevices.mHeadSetRoute == -1) break block9;
            if (!this.isHeadSetConnected()) break block9;
            return 0;
        }
        if (this.mAvailDevices.mForcedRoute == -1) return this.mAvailDevices.mDefaultRoute;
        return this.mAvailDevices.mForcedRoute;
    }

    private boolean isHeadSetConnected() {
        AudioRoutingController audioRoutingController = audioRoutingController.am;
        if (audioRoutingController == null) {
            return false;
        }
        return audioRoutingController.isWiredHeadsetOn();
    }

    private boolean isBTConnected() {
        if (this.mBTAdapter == null) {
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return 2 == (this.mBTAdapter = BluetoothAdapter.getDefaultAdapter()).getProfileConnectionState(1) || 2 == this.mBTAdapter.getProfileConnectionState(2);
        {
        }
    }

    private boolean isSpeakerEnable() {
        AudioRoutingController audioRoutingController = audioRoutingController.am;
        if (audioRoutingController == null) {
            return true;
        }
        return audioRoutingController.isSpeakerphoneOn();
    }

    static /* synthetic */ BluetoothHeadset access$200(AudioRoutingController audioRoutingController) {
        return audioRoutingController.mBTHeadset;
    }

    static /* synthetic */ int access$302(AudioRoutingController audioRoutingController, int n2) {
        audioRoutingController.mBtScoState = n2;
        return n2;
    }

    static /* synthetic */ int access$502(AudioRoutingController audioRoutingController, int n2) {
        audioRoutingController.mTargetRoute = n2;
        return n2;
    }

    static /* synthetic */ boolean access$802(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mVideoDisabled = bl;
        return bl;
    }

    static /* synthetic */ boolean access$902(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mMuteLocal = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1002(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mMuteRemotes = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2102(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mPhoneInCall = bl;
        return bl;
    }

    static /* synthetic */ int access$2202(AudioRoutingController audioRoutingController, int n2) {
        audioRoutingController.mStreamType = n2;
        return n2;
    }

    static /* synthetic */ BluetoothHeadset access$202(AudioRoutingController audioRoutingController, BluetoothHeadset bluetoothHeadset) {
        audioRoutingController.mBTHeadset = bluetoothHeadset;
        return bluetoothHeadset;
    }

    static /* synthetic */ BluetoothA2dp access$3402(AudioRoutingController audioRoutingController, BluetoothA2dp bluetoothA2dp) {
        audioRoutingController.mBtA2dp = bluetoothA2dp;
        return bluetoothA2dp;
    }

    static /* synthetic */ boolean access$3002(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mHfpEnable = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1902(AudioRoutingController audioRoutingController, boolean bl) {
        audioRoutingController.mA2dpEnable = bl;
        return bl;
    }

    public void sendEvent(int n2, int n3) {
        Logging.d(TAG, "sendEvent: [" + audioRoutingController2.getEventDesc(n2) + "], Parameters: " + n3 + "... " + (Object)((Object)audioRoutingController2.mEventHandler));
        EventHandler eventHandler = audioRoutingController2.mEventHandler;
        if (eventHandler != null) {
            AudioRoutingController audioRoutingController = audioRoutingController2;
            AudioRoutingController audioRoutingController2 = eventHandler.obtainMessage(n2, n3, 0);
            audioRoutingController.mEventHandler.sendMessage((Message)audioRoutingController2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int initialize() {
        block37: {
            block39: {
                block34: {
                    block38: {
                        block36: {
                            block35: {
                                Logging.i("AudioRoute", "initialize +");
                                this.mAvailDevices = new AudioDeviceList();
                                new AudioDeviceList().mDefaultRoute = -1;
                                new AudioDeviceList().mForcedRoute = -1;
                                new AudioDeviceList().mHeadSetRoute = -1;
                                new AudioDeviceList().mBTRoute = -1;
                                var1_2 = (Context)this.mContext.get();
                                if (var1_2 == null || this.am == null) break block37;
                                var2_3 /* !! */  = Looper.myLooper();
                                if (var2_3 /* !! */  != null) {
                                    var3_7 = v0;
                                    v0 = new EventHandler(var2_3 /* !! */ );
                                    this.mEventHandler = var3_7;
                                } else {
                                    var2_3 /* !! */  = Looper.getMainLooper();
                                    if (var2_3 /* !! */  != null) {
                                        var3_8 = v1;
                                        v1 = new EventHandler(var2_3 /* !! */ );
                                        this.mEventHandler = var3_8;
                                    } else {
                                        this.mEventHandler = null;
                                    }
                                }
                                if (this.mHeadsetReceiver == null) {
                                    var2_3 /* !! */  = v2;
                                    v2 = new HeadsetBroadcastReceiver();
                                    this.mHeadsetReceiver = var2_3 /* !! */ ;
                                }
                                v3 = this;
                                v3.changeState(4);
                                if (!v3.mHeadsetReceiver.getRegistered()) {
                                    var1_2.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
                                    this.mHeadsetReceiver.setRegistered(true);
                                }
                                if (Build.VERSION.SDK_INT < 11) {
                                    var2_4 = Process.myUid();
                                    if (var1_2.checkPermission("android.permission.BLUETOOTH", Process.myPid(), var2_4) != 0) {
                                        Logging.w("AudioRoute", "do not support BT monitoring on this device");
                                        return 0;
                                    }
                                }
                                if (this.mBTHeadsetListener != null) {
                                    Logging.w("AudioRoute", "Bluetooth service Listener already been initialized");
                                } else {
                                    try {
                                        this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                                            public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
                                                Logging.i(AudioRoutingController.TAG, "onServiceConnected " + n2 + " =? headset(" + 1 + ")");
                                                if (n2 == 1) {
                                                    Logging.i(AudioRoutingController.TAG, "on BT service connected: " + n2 + " " + bluetoothProfile);
                                                    AudioRoutingController.access$202(AudioRoutingController.this, (BluetoothHeadset)bluetoothProfile);
                                                } else if (n2 == 2) {
                                                    AudioRoutingController.access$3402(AudioRoutingController.this, (BluetoothA2dp)bluetoothProfile);
                                                }
                                            }

                                            public void onServiceDisconnected(int n2) {
                                                Logging.i(AudioRoutingController.TAG, "onServiceDisconnected " + n2 + " =? headset(" + 1 + ")");
                                                if (n2 == 1) {
                                                    3 v0 = this;
                                                    v0.AudioRoutingController.this.am.setBluetoothScoOn(false);
                                                    v0.AudioRoutingController.this.am.stopBluetoothSco();
                                                    v0.AudioRoutingController.this.cancelTimer();
                                                    AudioRoutingController.access$202(v0.AudioRoutingController.this, null);
                                                    AudioRoutingController.access$3002(v0.AudioRoutingController.this, false);
                                                } else if (n2 == 2) {
                                                    3 v1 = this;
                                                    AudioRoutingController.access$1902(v1.AudioRoutingController.this, false);
                                                    AudioRoutingController.access$3402(v1.AudioRoutingController.this, null);
                                                }
                                            }
                                        };
                                    }
                                    catch (Exception var2_5) {
                                        Logging.e("AudioRoute", "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + var2_5.getMessage());
                                    }
                                }
                                if (!this.hasPermission(var1_2, "android.permission.BLUETOOTH")) {
                                    Logging.w("AudioRoute", "lacks BLUETOOTH permission");
                                    return 0;
                                }
                                if (this.mBTHeadsetReceiver != null) ** GOTO lbl52
                                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
lbl52:
                                // 2 sources

                                var2_6 = BluetoothAdapter.getDefaultAdapter();
                                this.mBTAdapter = var2_6;
                                if (var2_6 == null) break block34;
                                if (this.mBTHeadsetListener == null) break block34;
                                v4 = this;
                                v5 = var2_6;
                                v6 = this;
                                var2_6 = var1_2.getApplicationContext();
                                v5.getProfileProxy((Context)var2_6, v6.mBTHeadsetListener, 1);
                                v7 = v4.mBTAdapter;
                                v8 = this;
                                var2_6 = var1_2.getApplicationContext();
                                v7.getProfileProxy((Context)var2_6, v8.mBTHeadsetListener, 2);
                                if (2 != this.mBTAdapter.getProfileConnectionState(1)) break block35;
                                this.mHfpEnable = true;
                            }
                            if (2 != this.mBTAdapter.getProfileConnectionState(2)) break block36;
                            this.mA2dpEnable = true;
                        }
                        Logging.i("AudioRoute", "BT headset setup: mA2dpEnable = " + this.mA2dpEnable + " mHfpEnable " + this.mHfpEnable + " " + this.mBTHeadset);
                        var2_6 = v9;
                        new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED").addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
                        var2_6.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
                        var2_6.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
                        var2_6.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                        if (this.mBTHeadsetReceiver.getRegistered()) ** GOTO lbl109
                        var1_2 = var1_2.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, (IntentFilter)var2_6);
                        this.mBTHeadsetReceiver.setRegistered(true);
                        if (var1_2 == null) ** GOTO lbl109
                        if (!TextUtils.equals((CharSequence)var1_2.getAction(), (CharSequence)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) ** GOTO lbl109
                        if (var1_2.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0) == 1) ** GOTO lbl105
                        Logging.i("AudioRoute", "initial Bluetooth SCO device unconnected");
                        this.mBtScoState = 3;
                        break block38;
lbl105:
                        // 1 sources

                        v10 = this;
                        Logging.i("AudioRoute", "initial Bluetooth SCO device connected");
                        v10.mBtScoState = 1;
                        v10.mAvailDevices.mBTRoute = 5;
                    }
                    this.getBtDeviceList();
                    break block39;
                }
                try {
                    Logging.e("AudioRoute", "initialize: failed to get bluetooth adapter!!");
                    return 0;
                }
                catch (Exception var0_1) {
                    Logging.e("AudioRoute", "unable to create BluetoothHeadsetBroadcastReceiver, err:" + var0_1.getMessage());
                }
            }
            Logging.i("AudioRoute", "initialize -");
            return 0;
        }
        Logging.e("AudioRoute", "Initilize Failed cause of invalid context or invalid audiomanager");
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninitializeHandle() {
        AudioRoutingController audioRoutingController = this;
        Logging.d(TAG, "uninitialize in eventhandler");
        try {
            audioRoutingController.clearBTResource();
            Context context = (Context)audioRoutingController.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            AudioRoutingController audioRoutingController2 = this;
            audioRoutingController2.mHeadsetReceiver = null;
            audioRoutingController2.mBTHeadsetReceiver = null;
            return;
        }
        catch (Exception exception) {
            Logging.e(TAG, "AudioRoutingController uninitialize fail: ", exception);
        }
    }

    public void uninitialize() {
        this.sendEvent(200, 0);
    }

    public void startMonitoring(int n2, int n3) {
        AudioRoutingController audioRoutingController = this;
        Context cfr_ignored_0 = (Context)audioRoutingController.mContext.get();
        Logging.i(TAG, "--------------Comming to startMonitoring--------------------");
        audioRoutingController.notifyAudioBtProfileChanged();
        audioRoutingController.changeAvailDevices(10, n2);
        this.mChannelProfile = n3;
        if (this.mAvailDevices.mDefaultRoute == -1) {
            if (n3 == 0 && this.isAudioOnly()) {
                AudioRoutingController audioRoutingController2 = this;
                audioRoutingController2.changeAvailDevices(10, 1);
                audioRoutingController2.am.setSpeakerphoneOn(false);
            } else {
                AudioRoutingController audioRoutingController3 = this;
                audioRoutingController3.changeAvailDevices(10, 3);
                audioRoutingController3.am.setSpeakerphoneOn(false);
                audioRoutingController3.am.setSpeakerphoneOn(true);
            }
        }
        this.mTargetRoute = -1;
        if (this.getBtDeviceList() > 0) {
            this.mAvailDevices.mBTRoute = 5;
            this.checkNeedResetBT();
        }
        AudioRoutingController audioRoutingController4 = this;
        int n4 = audioRoutingController4.setTargetRouteByPriority();
        Logging.i(TAG, "mDefaultRoute: ," + this.mAvailDevices.mDefaultRoute + "  mAvailDevices.mForcedRoute :" + this.mAvailDevices.mForcedRoute);
        AudioRoutingController audioRoutingController5 = this;
        AudioRoutingController audioRoutingController6 = this;
        Logging.i(TAG, "mBtRoute: " + audioRoutingController5.getAudioRouteDesc(audioRoutingController5.mAvailDevices.mBTRoute) + ",mAvailDevices.mHeadSetRoute :" + audioRoutingController6.getAudioRouteDesc(audioRoutingController6.mAvailDevices.mHeadSetRoute));
        audioRoutingController4.changeState(n4);
    }

    public void stopMonitoring() {
        Logging.i(TAG, "Stop Mornitor State process");
        this.changeState(4);
    }

    public void clearListenerNativeHandle() {
        Logging.d(TAG, "clearListenerNativeHandle");
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)((AudioRoutingController)((Object)audioRoutingListener)).mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingDestroyed();
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    public void changeAvailDevices(int n2, int n3) {
        if (n2 != 1) {
            if (n2 != 2 && n2 != 4) {
                if (n2 != 10) {
                    if (n2 != 11) {
                        Logging.i(TAG, "No device changed!");
                    } else {
                        this.mAvailDevices.mForcedRoute = n3 == 0 ? 1 : 3;
                    }
                } else {
                    this.mAvailDevices.mDefaultRoute = n3;
                }
            } else {
                this.mAvailDevices.mBTRoute = this.mA2dpEnable | this.mHfpEnable ? 5 : -1;
            }
        } else if (n3 >= 0) {
            AudioDeviceList audioDeviceList = this.mAvailDevices;
            int n4 = n3 > 0 ? 2 : 0;
            audioDeviceList.mHeadSetRoute = n4;
        } else {
            this.mAvailDevices.mHeadSetRoute = -1;
        }
        Logging.i(TAG, "event device changed!" + n2 + "  mAvailDevices.mDefaultRoute" + this.mAvailDevices.mDefaultRoute);
    }

    protected boolean hasPermission(Context context, String string2) {
        return context.checkPermission(string2, Process.myPid(), Process.myUid()) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void muteAudioStream(boolean bl) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                if (bl) {
                    this.am.adjustStreamVolume(3, -100, 0);
                    return;
                }
                this.am.adjustStreamVolume(3, 100, 0);
                return;
            }
            if (bl) {
                this.am.setStreamMute(3, true);
                return;
            }
            this.am.setStreamMute(3, false);
            return;
        }
        catch (Exception exception) {
            Logging.e(TAG, "muteAudioStream: " + exception);
        }
    }

    private class HeadsetState
    extends AudioRouteBaseState {
        private HeadsetState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            HeadsetState headsetState = this;
            super.headSetPlugInProcess(n2, n3);
            if (headsetState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At HeadSet Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            HeadsetState headsetState = this;
            super.headSetPlugOutProcess(n2, n3);
            if (headsetState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At BT HeadSet headSetPlugOutProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                AudioRoutingController.this.changeState(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController audioRoutingController = AudioRoutingController.this;
                audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mForcedRoute);
            } else {
                AudioRoutingController audioRoutingController = AudioRoutingController.this;
                audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            HeadsetState headsetState = this;
            super.btPlugInProcess(n2, n3);
            if (headsetState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At BT HeadSet headSetPlugOutProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            super.btPlugOutProcess(n2, n3);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            HeadsetState headsetState = this;
            super.btScoConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoConnectProcess Nothing to-do");
            headsetState.AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            super.btScoDisConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoDisConnectProcess Nothing to-do");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute) {
                HeadsetState headsetState = this;
                AudioRoutingController audioRoutingController = headsetState.AudioRoutingController.this;
                AudioRoutingController.access$502(audioRoutingController, ((AudioRoutingController)audioRoutingController).mAvailDevices.mHeadSetRoute);
                headsetState.AudioRoutingController.this.am.setSpeakerphoneOn(false);
                headsetState.AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController audioRoutingController2 = headsetState.AudioRoutingController.this;
                audioRoutingController2.notifyAudioRoutingChanged(audioRoutingController2.mTargetRoute);
                AudioRoutingController audioRoutingController3 = AudioRoutingController.this;
                Logging.i(AudioRoutingController.TAG, "At HeadSet State switchtoTargetRoute:  " + audioRoutingController3.getAudioRouteDesc(audioRoutingController3.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class BTState
    extends AudioRouteBaseState {
        private BTState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            BTState bTState = this;
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet connect event param = " + n3);
            super.headSetPlugInProcess(n2, n3);
            if (bTState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            if (AudioRoutingController.this.mStreamType == 0) {
                AudioRoutingController.this.disableBtSco();
            }
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            super.headSetPlugOutProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet disconnect,Nothting need todo ");
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            BTState bTState = this;
            super.btPlugInProcess(n2, n3);
            bTState.AudioRoutingController.this.notifyAudioRoutingChanged(5);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            BTState bTState = this;
            super.btPlugOutProcess(n2, n3);
            if (bTState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            if (AudioRoutingController.this.getBtDeviceList() > 0 && AudioRoutingController.this.sysRouteToBt()) {
                BTState bTState2 = this;
                bTState2.AudioRoutingController.this.changeState(5);
                bTState2.AudioRoutingController.this.notifyAudioRoutingChanged(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute != -1) {
                AudioRoutingController.this.changeState(0);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController audioRoutingController = AudioRoutingController.this;
                audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mForcedRoute);
            } else {
                Logging.i(AudioRoutingController.TAG, "At BTState Process btPlugOutProcess default device:" + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
                AudioRoutingController audioRoutingController = AudioRoutingController.this;
                audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            BTState bTState = this;
            super.btScoConnectProcess(n2, n3);
            if (bTState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            BTState bTState2 = this;
            bTState2.AudioRoutingController.this.am.setSpeakerphoneOn(false);
            bTState2.AudioRoutingController.this.am.setBluetoothScoOn(true);
            Logging.i(AudioRoutingController.TAG, "At BTState Process SCO Connect,Nothing todo since already in BT State");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            BTState bTState = this;
            Logging.i(AudioRoutingController.TAG, "At BTState Process BT SCO DisConnect");
            super.btScoDisConnectProcess(n2, n3);
            if (bTState.AudioRoutingController.this.am.getMode() == 3) {
                if (AudioRoutingController.this.mHfpEnable && AudioRoutingController.this.sysRouteToBt()) {
                    BTState bTState2 = this;
                    AudioRoutingController audioRoutingController = bTState2.AudioRoutingController.this;
                    audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mDefaultRoute);
                    bTState2.AudioRoutingController.this.changeState(5);
                } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute != -1) {
                    AudioRoutingController.this.changeState(0);
                } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                    AudioRoutingController audioRoutingController = AudioRoutingController.this;
                    audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mForcedRoute);
                } else {
                    AudioRoutingController audioRoutingController = AudioRoutingController.this;
                    audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mDefaultRoute);
                }
            } else if (AudioRoutingController.this.mA2dpEnable && AudioRoutingController.this.sysRouteToBt()) {
                AudioRoutingController.this.changeState(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute != -1) {
                AudioRoutingController.this.changeState(0);
            } else {
                AudioRoutingController audioRoutingController = AudioRoutingController.this;
                audioRoutingController.changeState(((AudioRoutingController)audioRoutingController).mAvailDevices.mDefaultRoute);
            }
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            BTState bTState = this;
            super.commStreamEvtProcess(n2, n3);
            bTState.AudioRoutingController.this.enableBtSco();
            bTState.AudioRoutingController.this.startTimer();
            bTState.AudioRoutingController.this.am.setMode(3);
            Logging.i(AudioRoutingController.TAG, "At BTState Process CommStream mode =" + AudioRoutingController.this.am.getMode());
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            BTState bTState = this;
            super.musicStreamEvtProcess(n2, n3);
            bTState.AudioRoutingController.this.cancelTimer();
            bTState.AudioRoutingController.this.disableBtSco();
            Logging.i(AudioRoutingController.TAG, "At BTState Process MusicStream mode =" + AudioRoutingController.this.am.getMode());
        }

        @Override
        public void switchtoTargetRoute() {
            if (5 != AudioRoutingController.this.mTargetRoute) {
                BTState bTState = this;
                AudioRoutingController.access$502(bTState.AudioRoutingController.this, 5);
                bTState.AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController audioRoutingController = bTState.AudioRoutingController.this;
                audioRoutingController.notifyAudioRoutingChanged(audioRoutingController.mTargetRoute);
                AudioRoutingController audioRoutingController2 = AudioRoutingController.this;
                Logging.i(AudioRoutingController.TAG, "At BT State switchtoTargetRoute:  " + audioRoutingController2.getAudioRouteDesc(audioRoutingController2.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class EarpieceState
    extends AudioRouteBaseState {
        private EarpieceState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            EarpieceState earpieceState = this;
            super.headSetPlugInProcess(n2, n3);
            if (earpieceState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            EarpieceState earpieceState2 = this;
            earpieceState2.AudioRoutingController.this.muteAudioStream(true);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process HeadSet connect event param = " + n3);
            earpieceState2.AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            EarpieceState earpieceState = this;
            super.btPlugInProcess(n2, n3);
            if (earpieceState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.changeState(5);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process BT connect event");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            EarpieceState earpieceState = this;
            super.forceSpkProcess(n2, n3);
            if (earpieceState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process ForceSpeaker event param =  " + n3);
            if (!AudioRoutingController.this.isSpeakerEnable()) {
                EarpieceState earpieceState2 = this;
                earpieceState2.AudioRoutingController.this.am.setSpeakerphoneOn(true);
                earpieceState2.AudioRoutingController.this.changeState(3);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At Earpiece Process SCO connect event,Nothing to-do");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (1 != AudioRoutingController.this.mTargetRoute) {
                EarpieceState earpieceState = this;
                AudioRoutingController.access$502(earpieceState.AudioRoutingController.this, 1);
                earpieceState.AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController audioRoutingController = earpieceState.AudioRoutingController.this;
                audioRoutingController.notifyAudioRoutingChanged(audioRoutingController.mTargetRoute);
                AudioRoutingController audioRoutingController2 = AudioRoutingController.this;
                Logging.i(AudioRoutingController.TAG, "At Earpiece State switchtoTargetRoute: " + audioRoutingController2.getAudioRouteDesc(audioRoutingController2.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class SpeakerState
    extends AudioRouteBaseState {
        private SpeakerState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            SpeakerState speakerState = this;
            super.headSetPlugInProcess(n2, n3);
            if (speakerState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            SpeakerState speakerState = this;
            super.btPlugInProcess(n2, n3);
            if (speakerState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process BT connect event");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            SpeakerState speakerState = this;
            super.forceEarpieceProcess(n2, n3);
            if (speakerState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process ForceEarpiece event param =  " + n3);
            AudioRoutingController.this.changeState(1);
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            SpeakerState speakerState = this;
            super.forceSpkProcess(n2, n3);
            if (speakerState.AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process ForceSpeaker event param =  " + n3);
            if (!AudioRoutingController.this.isSpeakerEnable()) {
                SpeakerState speakerState2 = this;
                Logging.i(AudioRoutingController.TAG, "At SpeakerState Process audio mode =  " + speakerState2.AudioRoutingController.this.am.getMode());
                speakerState2.AudioRoutingController.this.am.setSpeakerphoneOn(true);
                speakerState2.AudioRoutingController.this.changeState(3);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process SCO connect event,Nothing to-do");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != 3) {
                SpeakerState speakerState = this;
                AudioRoutingController.access$502(speakerState.AudioRoutingController.this, 3);
                speakerState.AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController audioRoutingController = speakerState.AudioRoutingController.this;
                audioRoutingController.notifyAudioRoutingChanged(audioRoutingController.mTargetRoute);
                AudioRoutingController audioRoutingController2 = AudioRoutingController.this;
                Logging.i(AudioRoutingController.TAG, "At Speaker State switchtoTargetRoute: " + audioRoutingController2.getAudioRouteDesc(audioRoutingController2.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class StopState
    extends AudioRouteBaseState {
        private StopState() {
        }

        @Override
        public void switchtoTargetRoute() {
            StopState stopState = this;
            Logging.i(AudioRoutingController.TAG, "Coming to Stop state, switchtoTargetRoute");
            stopState.AudioRoutingController.this.cancelTimer();
            stopState.AudioRoutingController.this.disableBtSco();
            AudioDeviceList audioDeviceList = stopState.AudioRoutingController.this.mAvailDevices;
            int n2 = stopState.AudioRoutingController.this.getBtDeviceList() > 0 ? 5 : -1;
            StopState stopState2 = this;
            audioDeviceList.mBTRoute = n2;
            audioDeviceList = stopState2.AudioRoutingController.this.mAvailDevices;
            n2 = stopState2.AudioRoutingController.this.isHeadSetConnected() ? 0 : -1;
            audioDeviceList.mHeadSetRoute = n2;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute = -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute = -1;
            AudioRoutingController.access$502(AudioRoutingController.this, -1);
        }
    }

    private abstract class AudioRouteBaseState
    implements AudioRouteState {
        private AudioRouteBaseState() {
        }

        @Override
        public void switchtoTargetRoute() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            AudioRoutingController audioRoutingController = AudioRoutingController.this;
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugin event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + audioRoutingController.getAudioRouteDesc(((AudioRoutingController)audioRoutingController).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            AudioRoutingController audioRoutingController = AudioRoutingController.this;
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugout event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + audioRoutingController.getAudioRouteDesc(((AudioRoutingController)audioRoutingController).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            AudioRouteBaseState audioRouteBaseState = this;
            audioRouteBaseState.AudioRoutingController.this.notifyAudioBtProfileChanged();
            audioRouteBaseState.AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugin event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            AudioRouteBaseState audioRouteBaseState = this;
            audioRouteBaseState.AudioRoutingController.this.notifyAudioBtProfileChanged();
            audioRouteBaseState.AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugout event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Connect event ");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            AudioRouteBaseState audioRouteBaseState = this;
            audioRouteBaseState.AudioRoutingController.this.notifyAudioBtProfileChanged();
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = audioRouteBaseState.AudioRoutingController.this.getBtDeviceList() > 0 ? 5 : -1;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Disconnect, bt route: " + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute);
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceEarpiece event ");
        }

        @Override
        public void phoneChangeEvtProcess(int n2, int n3) {
            AudioRoutingController audioRoutingController = ((AudioRouteBaseState)((Object)audioRoutingController)).AudioRoutingController.this;
            n2 = n3 > 0 ? 1 : 0;
            AudioRoutingController.access$2102(audioRoutingController, n2 != 0);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Phone state change event " + n3);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.access$2202(AudioRoutingController.this, 0);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Communication stream event ");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.access$2202(AudioRoutingController.this, 3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Music stream event");
        }
    }

    private static interface AudioRouteState {
        public void switchtoTargetRoute();

        public void headSetPlugInProcess(int var1, int var2);

        public void headSetPlugOutProcess(int var1, int var2);

        public void btPlugInProcess(int var1, int var2);

        public void btPlugOutProcess(int var1, int var2);

        public void btScoConnectProcess(int var1, int var2);

        public void btScoDisConnectProcess(int var1, int var2);

        public void forceSpkProcess(int var1, int var2);

        public void forceEarpieceProcess(int var1, int var2);

        public void phoneChangeEvtProcess(int var1, int var2);

        public void commStreamEvtProcess(int var1, int var2);

        public void musicStreamEvtProcess(int var1, int var2);
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            block23: {
                int n2;
                int n3;
                block21: {
                    block22: {
                        n3 = message.what;
                        n2 = message.arg1;
                        if (n3 == 22) break block21;
                        if (n3 == 200) break block22;
                        switch (n3) {
                            default: {
                                switch (n3) {
                                    default: {
                                        switch (n3) {
                                            default: {
                                                break;
                                            }
                                            case 114: {
                                                EventHandler eventHandler = object;
                                                AudioRoutingController audioRoutingController = eventHandler.AudioRoutingController.this;
                                                n3 = audioRoutingController.routeToState(audioRoutingController.mTargetRoute);
                                                if (n2 != eventHandler.AudioRoutingController.this.mTargetRoute && n3 != -1) {
                                                    Object object = object;
                                                    AudioRoutingController.access$502(object.AudioRoutingController.this, n2);
                                                    object.AudioRoutingController.this.changeState(n3);
                                                    break;
                                                }
                                                break block23;
                                            }
                                            case 113: {
                                                object.AudioRoutingController.this.mState.musicStreamEvtProcess(n3, n2);
                                                break;
                                            }
                                            case 112: {
                                                object.AudioRoutingController.this.mState.commStreamEvtProcess(n3, n2);
                                                break;
                                            }
                                        }
                                        break block23;
                                    }
                                    case 14: {
                                        Object object = object.AudioRoutingController.this;
                                        n2 = n2 > 0 ? 1 : 0;
                                        AudioRoutingController.access$802((AudioRoutingController)object, n2 != 0);
                                        break;
                                    }
                                    case 13: {
                                        Object object = object.AudioRoutingController.this;
                                        n2 = n2 > 0 ? 1 : 0;
                                        AudioRoutingController.access$1002((AudioRoutingController)object, n2 != 0);
                                        break;
                                    }
                                    case 12: {
                                        Object object = object.AudioRoutingController.this;
                                        n2 = n2 > 0 ? 1 : 0;
                                        AudioRoutingController.access$902((AudioRoutingController)object, n2 != 0);
                                        break;
                                    }
                                    case 11: {
                                        if (n2 == 0) {
                                            object.AudioRoutingController.this.mState.forceEarpieceProcess(n3, n2);
                                            break;
                                        }
                                        object.AudioRoutingController.this.mState.forceSpkProcess(n3, n2);
                                        break;
                                    }
                                }
                                break block23;
                            }
                            case 3: {
                                if (n2 == 1) {
                                    object.AudioRoutingController.this.mState.btScoConnectProcess(n3, n2);
                                    break;
                                }
                                object.AudioRoutingController.this.mState.btScoDisConnectProcess(n3, n2);
                                break;
                            }
                            case 2: 
                            case 4: {
                                if (n2 == 1) {
                                    object.AudioRoutingController.this.mState.btPlugInProcess(n3, n2);
                                    break;
                                }
                                object.AudioRoutingController.this.mState.btPlugOutProcess(n3, n2);
                                break;
                            }
                            case 1: {
                                if (n2 >= 0) {
                                    object.AudioRoutingController.this.mState.headSetPlugInProcess(n3, n2);
                                    break;
                                }
                                object.AudioRoutingController.this.mState.headSetPlugOutProcess(n3, n2);
                                break;
                            }
                        }
                        break block23;
                    }
                    object.AudioRoutingController.this.uninitializeHandle();
                    break block23;
                }
                object.AudioRoutingController.this.mState.phoneChangeEvtProcess(n3, n2);
            }
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        /*
         * Exception decompiling
         */
        public void onReceive(Context var1_4, Intent var2_10) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[CASE], 29[SWITCH]], but top level block is 17[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && intent.hasExtra("state")) {
                int n2 = intent.getIntExtra("state", -1);
                if (n2 == 1) {
                    if (intent.getIntExtra("microphone", -1) == 1) {
                        Logging.i(AudioRoutingController.TAG, "Receive Event Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                    } else {
                        Logging.i(AudioRoutingController.TAG, "Receive Event Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                    }
                } else if (n2 == 0) {
                    Logging.i(AudioRoutingController.TAG, "Receive Event Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                } else {
                    Logging.i(AudioRoutingController.TAG, "Receive Event Headset unknown event detected, state=" + n2);
                }
            }
        }
    }

    public static class AudioDeviceList {
        public int mForcedRoute;
        public int mDefaultRoute;
        public int mHeadSetRoute;
        public int mBTRoute;
    }
}

