/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import io.agora.rtc.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.PowerConnectionReceiver;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.utils.CameraUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

class CommonUtility {
    private static final String TAG = "CommonUtility";
    private static WeakReference<Application> mApplication;
    private static final int VIDEO_SOURCE_TYPE_NULL = 0;
    private static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    private static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private static final String PREFIX_URI = "content://";
    private WeakReference<Context> mContext;
    private volatile boolean mAccessible;
    private AgoraPhoneStateListener mPhoneStateListener;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver;
    private BroadcastReceiver mOrientationObserver;
    private PowerConnectionReceiver mPowerConnectionReceiver;
    private long mBridgeHandle;
    private int mMobileType;
    private int batteryPercentage;
    private int mOrientation;
    private boolean mLocalVideoEnabled;
    private int mVideoSourceType;
    private OrientationEventListener mOrientationListener;
    private String localIp;
    private boolean shouldGetIp;

    public CommonUtility(Context context, long l2) {
        CommonUtility commonUtility = this;
        this.mAccessible = false;
        this.mPhoneStateListener = null;
        this.mConnectionBroadcastReceiver = null;
        this.mOrientationObserver = null;
        this.mPowerConnectionReceiver = null;
        this.mBridgeHandle = 0L;
        this.mMobileType = -1;
        this.batteryPercentage = 255;
        this.mOrientation = -1;
        this.mLocalVideoEnabled = false;
        this.mVideoSourceType = 1;
        this.mOrientationListener = null;
        this.localIp = null;
        this.shouldGetIp = true;
        this.mContext = new WeakReference<Context>(context);
        commonUtility.mBridgeHandle = l2;
        try {
            commonUtility.mPhoneStateListener = new AgoraPhoneStateListener();
            ((TelephonyManager)context.getSystemService("phone")).listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception exception) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", exception);
        }
        CommonUtility commonUtility2 = this;
        commonUtility2.monitorConnectionEvent(true);
        commonUtility2.monitorPowerChange(true);
        this.monitorOrientationChange(context, true);
        this.mAccessible = true;
        Logging.i(TAG, "[init] done!");
    }

    public static boolean canGetDefaultContext() {
        boolean bl = false;
        if (Looper.myLooper() == Looper.getMainLooper() || Build.VERSION.SDK_INT >= 18) {
            bl = true;
        }
        return bl;
    }

    public static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    public static byte[] getContextInfo(Context context) {
        RtcEngineMessage.PAndroidContextInfo pAndroidContextInfo;
        if (context == null) {
            return null;
        }
        RtcEngineMessage.PAndroidContextInfo pAndroidContextInfo2 = pAndroidContextInfo;
        pAndroidContextInfo2();
        pAndroidContextInfo2.device = DeviceUtils.buildDeviceId();
        pAndroidContextInfo2.deviceInfo = DeviceUtils.getDeviceInfo();
        pAndroidContextInfo2.systemInfo = DeviceUtils.getSystemInfo();
        pAndroidContextInfo2.configDir = CommonUtility.getAppPrivateStorageDir(context);
        pAndroidContextInfo2.dataDir = context.getCacheDir().getAbsolutePath();
        pAndroidContextInfo.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        pAndroidContextInfo.androidID = "";
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.device)) {
            pAndroidContextInfo2.device = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.deviceInfo)) {
            pAndroidContextInfo2.deviceInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.systemInfo)) {
            pAndroidContextInfo2.systemInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.configDir)) {
            pAndroidContextInfo2.configDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.dataDir)) {
            pAndroidContextInfo2.dataDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.pluginDir)) {
            pAndroidContextInfo2.pluginDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo2.androidID)) {
            pAndroidContextInfo2.androidID = "";
        }
        return pAndroidContextInfo2.marshall();
    }

    private static String getAndroidID(Context context) {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getLocalHostList() {
        v0 = Collections.list(NetworkInterface.getNetworkInterfaces());
        var0 = v1;
        v1 = new ArrayList();
        var1_1 = v0.iterator();
        block15: while (true) {
            if (!var1_1.hasNext()) break;
            var2_3 = (NetworkInterface)var1_1.next();
            if (var2_3.getName().startsWith("usb")) continue;
            var2_3 = Collections.list(var2_3.getInetAddresses()).iterator();
            while (true) {
                if (var2_3.hasNext()) ** break;
                continue block15;
                var3_4 = CommonUtility.inetAddressToIpAddress((InetAddress)var2_3.next());
                if (var3_4 == null) continue;
                var0.add(var3_4);
            }
            break;
        }
        try {
            ** if (var0.isEmpty()) goto lbl-1000
        }
        catch (Exception v3) {}
lbl-1000:
        // 1 sources

        {
            v2 = var0;
            var0 = new String[var0.size()];
            var1_2 = 0;
            var2_3 = v2.iterator();
            while (true) {
                if (!var2_3.hasNext()) break;
                var0[var1_2] = (String)var2_3.next();
                ++var1_2;
                continue;
                break;
            }
            return var0;
        }
lbl-1000:
        // 1 sources

        {
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalHost() {
        try {
            for (Object object : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (((NetworkInterface)object).getName().startsWith("usb")) continue;
                object = Collections.list(((NetworkInterface)object).getInetAddresses()).iterator();
                while (object.hasNext()) {
                    String string2 = CommonUtility.inetAddressToIpAddress((InetAddress)object.next());
                    if (string2 == null || string2.isEmpty()) continue;
                    return string2;
                }
            }
            return null;
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSimulatorProperty() {
        int n2 = 0;
        String string2 = "";
        String string3 = Build.MANUFACTURER;
        try {
            string2 = CommonUtility.getSystemProperty("ro.hardware");
            if (string2 == null || string2.toLowerCase().equals("intel")) {
                n2 = 1;
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "get property hardware fail.");
        }
        Logging.i(TAG, "hardware = " + string2 + ", suspectCount = " + n2);
        try {
            String string4 = System.getProperty("os.arch");
            if (string4 == null || string4.toLowerCase().equals("i686") && !string3.toLowerCase().contains("asus")) {
                Logging.i(TAG, "arch = " + string4 + ", suspectCount = " + ++n2);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "get property arch fail.");
        }
        if (Build.VERSION.SDK_INT > 28) {
            if (string2.toLowerCase().contains("ttvm") || string2.toLowerCase().contains("nox")) {
                n2 += 10;
            }
            try {
                string2 = CommonUtility.getSystemProperty("ro.build.flavor");
                if (string2 == null || string2.contains("vbox") || string2.contains("sdk_gphone")) {
                    Logging.i(TAG, "buildFlavor = " + string2 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property buildFlavor fail.");
            }
            try {
                string2 = CommonUtility.getSystemProperty("ro.product.board");
                if (string2 == null || string2.contains("android") | string2.contains("goldfish")) {
                    Logging.i(TAG, "productBoard = " + string2 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property productBoard fail.");
            }
            try {
                string2 = CommonUtility.getSystemProperty("ro.board.platform");
                if (string2 == null || string2.contains("android")) {
                    Logging.i(TAG, "boardPlatform = " + string2 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property boardPlatform fail.");
            }
        }
        if (n2 <= 0) return false;
        return true;
    }

    private void updateViewOrientation() {
        if (this.mContext.get() != null && this.mAccessible) {
            Display display = ((WindowManager)((Context)this.mContext.get()).getSystemService("window")).getDefaultDisplay();
            if (display == null) {
                Logging.e(TAG, "[updateViewOrientation] display is null!");
                return;
            }
            int n2 = display.getRotation();
            if (n2 == this.mOrientation) {
                return;
            }
            switch (n2) {
                default: {
                    break;
                }
                case 3: {
                    CommonUtility commonUtility = this;
                    commonUtility.mOrientation = 3;
                    commonUtility.nativeNotifyOrientationChange(commonUtility.mBridgeHandle, 3);
                    break;
                }
                case 2: {
                    CommonUtility commonUtility = this;
                    commonUtility.mOrientation = 2;
                    commonUtility.nativeNotifyOrientationChange(commonUtility.mBridgeHandle, 2);
                    break;
                }
                case 1: {
                    CommonUtility commonUtility = this;
                    commonUtility.mOrientation = 1;
                    commonUtility.nativeNotifyOrientationChange(commonUtility.mBridgeHandle, 1);
                    break;
                }
                case 0: {
                    CommonUtility commonUtility = this;
                    commonUtility.mOrientation = 0;
                    commonUtility.nativeNotifyOrientationChange(commonUtility.mBridgeHandle, 0);
                }
            }
            return;
        }
        Logging.e(TAG, "[updateViewOrientation] mContext is null or mAccessible is false!");
    }

    private void checkOrientation(int n2) {
        if (n2 != -1 && this.mAccessible) {
            if (n2 > 340 || n2 < 20 || n2 > 70 && n2 < 110 || n2 > 160 && n2 < 200 || n2 > 250 && n2 < 290) {
                this.updateViewOrientation();
            }
            if (n2 <= 340 && n2 >= 20) {
                if (n2 > 70 && n2 < 110) {
                    CommonUtility commonUtility = this;
                    commonUtility.nativeNotifyGravityOriChange(commonUtility.mBridgeHandle, 180);
                } else if (n2 > 160 && n2 < 200) {
                    CommonUtility commonUtility = this;
                    commonUtility.nativeNotifyGravityOriChange(commonUtility.mBridgeHandle, 90);
                } else if (n2 > 250 && n2 < 290) {
                    CommonUtility commonUtility = this;
                    commonUtility.nativeNotifyGravityOriChange(commonUtility.mBridgeHandle, 0);
                }
            } else {
                CommonUtility commonUtility = this;
                commonUtility.nativeNotifyGravityOriChange(commonUtility.mBridgeHandle, 270);
            }
            return;
        }
    }

    private void monitorOrientationChange(Context context, boolean bl) {
        if (bl) {
            CommonUtility commonUtility = this;
            commonUtility.enableOrientationListener(context);
            commonUtility.regiseterBroadcaster(context);
        } else {
            CommonUtility commonUtility = this;
            commonUtility.disableOrientationListener();
            commonUtility.unregisterBroadcaster(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enableOrientationListener(Context context) {
        try {
            if (this.mOrientationListener == null) {
                this.mOrientationListener = new OrientationEventListener(context, 2){

                    public void onOrientationChanged(int n2) {
                        if (n2 == -1) {
                            return;
                        }
                        CommonUtility.this.checkOrientation(n2);
                    }
                };
            }
            this.mOrientationListener.enable();
            Logging.i(TAG, "[enableOrientationListener] done!");
            return;
        }
        catch (Exception exception) {
            Logging.e(TAG, "Unable to create OrientationEventListener, ", exception);
        }
    }

    private void disableOrientationListener() {
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener != null) {
            orientationEventListener.disable();
            this.mOrientationListener = null;
            Logging.i(TAG, "[disableOrientationListener] done!");
        } else {
            Logging.e(TAG, "[disableOrientationListener] mOrientationListener is null!");
        }
    }

    private void regiseterBroadcaster(Context context) {
        CommonUtility commonUtility;
        IntentFilter intentFilter;
        if (context == null) {
            return;
        }
        commonUtility2.mOrientationObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED") && CommonUtility.this.mAccessible) {
                    CommonUtility.this.updateViewOrientation();
                }
            }
        };
        CommonUtility commonUtility2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.CONFIGURATION_CHANGED");
        context.registerReceiver(commonUtility.mOrientationObserver, (IntentFilter)commonUtility2);
        Logging.i(TAG, "[regiseterBroadcaster] done!");
    }

    private void unregisterBroadcaster(Context context) {
        if (context != null && (this = this.mOrientationObserver) != null) {
            context.unregisterReceiver((BroadcastReceiver)this);
            Logging.i(TAG, "[unregisterBroadcaster] done!");
            return;
        }
    }

    private AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private static String getSystemProperty(String string2) throws Exception {
        Object[] objectArray = Class.forName("android.os.SystemProperties");
        Object[] objectArray2 = objectArray;
        Class[] classArray = new Class[1];
        Class[] classArray2 = classArray;
        classArray[0] = String.class;
        Object[] objectArray3 = objectArray2;
        Object[] objectArray4 = new Object[1];
        objectArray2 = objectArray4;
        objectArray4[0] = string2;
        return (String)objectArray.getMethod("get", classArray2).invoke((Object)objectArray3, objectArray2);
    }

    private static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int n2 = Process.myUid();
        return context.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), n2) == 0;
    }

    private RtcEngineMessage.MediaNetworkInfo doGetNetworkInfo(Context object) {
        if (object != null && commonUtility.mAccessible) {
            String string2;
            RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo;
            RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo2 = mediaNetworkInfo;
            mediaNetworkInfo = new RtcEngineMessage.MediaNetworkInfo();
            if (!CommonUtility.checkAccessNetworkState(object)) {
                mediaNetworkInfo2.ssid = "";
                mediaNetworkInfo2.bssid = "";
                mediaNetworkInfo2.rssi = 0;
                mediaNetworkInfo2.signalLevel = 0;
                mediaNetworkInfo2.frequency = 0;
                mediaNetworkInfo2.linkspeed = 0;
                return mediaNetworkInfo2;
            }
            if (commonUtility.shouldGetIp) {
                string2 = CommonUtility.getLocalHost();
                if (string2 != null) {
                    mediaNetworkInfo2.localIp4 = string2;
                }
                CommonUtility commonUtility = commonUtility;
                commonUtility.localIp = string2;
                commonUtility.shouldGetIp = false;
            } else {
                string2 = commonUtility.localIp;
                if (string2 != null) {
                    mediaNetworkInfo2.localIp4 = string2;
                }
            }
            string2 = Connectivity.getNetworkInfo(object);
            mediaNetworkInfo2.networkType = Connectivity.getNetworkType((NetworkInfo)string2);
            if (string2 != null) {
                mediaNetworkInfo2.networkSubtype = string2.getSubtype();
            }
            mediaNetworkInfo2.dnsList = Connectivity.getDnsList();
            if (mediaNetworkInfo2.networkType == 2) {
                if (!CommonUtility.checkAccessWifiState(object)) {
                    mediaNetworkInfo2.ssid = "";
                    mediaNetworkInfo2.bssid = "";
                    mediaNetworkInfo2.rssi = 0;
                    mediaNetworkInfo2.signalLevel = 0;
                    mediaNetworkInfo2.frequency = 0;
                    mediaNetworkInfo2.linkspeed = 0;
                    return mediaNetworkInfo2;
                }
                CommonUtility commonUtility = (WifiManager)object.getSystemService("wifi");
                if ((object = commonUtility.getDhcpInfo()) != null && (object = CommonUtility.intToInetAddress(object.gateway)) != null) {
                    mediaNetworkInfo2.gatewayIp4 = object.getHostAddress();
                }
                if ((commonUtility = commonUtility.getConnectionInfo()) != null) {
                    RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo3 = mediaNetworkInfo2;
                    mediaNetworkInfo3.ssid = "";
                    mediaNetworkInfo3.bssid = "";
                    mediaNetworkInfo2.rssi = commonUtility.getRssi();
                    mediaNetworkInfo2.signalLevel = WifiManager.calculateSignalLevel((int)mediaNetworkInfo2.rssi, (int)5);
                    mediaNetworkInfo2.linkspeed = commonUtility.getLinkSpeed();
                    if (Build.VERSION.SDK_INT >= 21) {
                        int n2;
                        mediaNetworkInfo2.frequency = n2 = commonUtility.getFrequency();
                        if (n2 >= 5000) {
                            mediaNetworkInfo2.networkSubtype = 101;
                        } else if (n2 >= 2400) {
                            mediaNetworkInfo2.networkSubtype = 100;
                        }
                    }
                }
            } else {
                object = commonUtility.mPhoneStateListener;
                if (object != null) {
                    try {
                        mediaNetworkInfo2.rssi = object.getRssi();
                        mediaNetworkInfo2.signalLevel = commonUtility.mPhoneStateListener.getLevel();
                        mediaNetworkInfo2.asu = commonUtility.mPhoneStateListener.getAsuLevel();
                    }
                    catch (Exception exception) {}
                }
            }
            return mediaNetworkInfo2;
        }
        return null;
    }

    private static String inetAddressToIpAddress(InetAddress inetAddress) {
        if (!inetAddress.isLoopbackAddress()) {
            if (inetAddress instanceof Inet4Address) {
                return ((Inet4Address)inetAddress).getHostAddress();
            }
            boolean cfr_ignored_0 = inetAddress instanceof Inet6Address;
        }
        return null;
    }

    private static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int n2 = Process.myUid();
        return context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), n2) == 0;
    }

    private static InetAddress intToInetAddress(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n2 & 0xFF);
        byArray2[1] = (byte)(n2 >> 8 & 0xFF);
        byArray2[2] = (byte)(n2 >> 16 & 0xFF);
        byArray[3] = (byte)(n2 >> 24 & 0xFF);
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private void checkVoipPermissions(Context context, String string2) throws SecurityException {
        if (context != null && context.checkPermission(string2, Process.myPid(), Process.myUid()) == 0) {
            return;
        }
        throw new SecurityException(string2 + " is not granted");
    }

    private void checkVoipPermissions(Context context) throws SecurityException {
        CommonUtility commonUtility = this;
        this.checkVoipPermissions(context, "android.permission.INTERNET");
        this.checkVoipPermissions(context, "android.permission.RECORD_AUDIO");
        commonUtility.checkVoipPermissions(context, "android.permission.MODIFY_AUDIO_SETTINGS");
        if (commonUtility.mVideoSourceType == 1 && this.mLocalVideoEnabled) {
            CameraUtils.checkCameraPermission(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int checkVoipPermissions(Context context, int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                return -2;
            }
            try {
                this.checkVoipPermissions(context, "android.permission.INTERNET");
                return 0;
            }
            catch (SecurityException securityException) {
                Logging.e(TAG, "Do not have Internet permission!");
                return -9;
            }
        }
        try {
            this.checkVoipPermissions(context);
            return 0;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "Do not have enough permission! ", securityException);
            return -9;
        }
    }

    /*
     * Exception decompiling
     */
    private String getAssetsCacheFile(Context var1_5, String var2_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[SIMPLE_IF_TAKEN]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private native void nativeAudioRoutingPhoneChanged(long var1, boolean var3, int var4, int var5);

    private native int nativeNotifyNetworkChange(long var1, byte[] var3);

    private native int nativeNotifyOrientationChange(long var1, int var3);

    private native int nativeNotifyGravityOriChange(long var1, int var3);

    public void destroy() {
        CommonUtility commonUtility = this;
        commonUtility.mAccessible = false;
        Context context = (Context)commonUtility.mContext.get();
        if (commonUtility.mPhoneStateListener != null && context != null) {
            ((TelephonyManager)context.getSystemService("phone")).listen((PhoneStateListener)this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
        CommonUtility commonUtility2 = this;
        CommonUtility commonUtility3 = this;
        commonUtility3.monitorConnectionEvent(false);
        commonUtility3.monitorPowerChange(false);
        commonUtility2.monitorOrientationChange(context, false);
        commonUtility2.mContext.clear();
        Logging.i(TAG, "[destroy] done!");
    }

    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context != null && this.mAccessible) {
            if (CommonUtility.checkAccessNetworkState(context)) {
                return Connectivity.getNetworkType(context);
            }
            return -1;
        }
        return -1;
    }

    public byte[] getNetworkInfo() {
        Context context = (Context)((CommonUtility)this).mContext.get();
        if (context != null && ((CommonUtility)this).mAccessible) {
            if ((this = ((CommonUtility)this).doGetNetworkInfo(context)) != null) {
                return ((RtcEngineMessage.MediaNetworkInfo)this).marshall();
            }
            return null;
        }
        return null;
    }

    public int getBatteryLifePercent() {
        if ((Context)this.mContext.get() != null && this.mAccessible) {
            return this.batteryPercentage;
        }
        return 255;
    }

    public void onPhoneStateChanged(boolean bl, int n2, int n3) {
        if (this.mBridgeHandle != 0L && this.mAccessible) {
            CommonUtility commonUtility = this;
            commonUtility.nativeAudioRoutingPhoneChanged(commonUtility.mBridgeHandle, bl, n2, n3);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void monitorConnectionEvent(boolean bl) {
        block9: {
            Context context;
            if (bl) {
                Context context2;
                if (this.mConnectionBroadcastReceiver != null) return;
                try {
                    this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
                    context2 = (Context)this.mContext.get();
                    if (context2 == null) return;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", exception);
                    return;
                }
                if (this.mConnectionBroadcastReceiver == null) return;
                context2.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                return;
            }
            try {
                context = (Context)this.mContext.get();
                if (context == null) break block9;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (this.mConnectionBroadcastReceiver == null) break block9;
            context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
        }
        this.mConnectionBroadcastReceiver = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void monitorPowerChange(boolean bl) {
        block10: {
            Context context;
            if (bl) {
                IntentFilter intentFilter;
                Context context2;
                if (commonUtility2.mPowerConnectionReceiver != null) return;
                try {
                    commonUtility2.mPowerConnectionReceiver = new PowerConnectionReceiver(commonUtility2);
                    context2 = (Context)commonUtility2.mContext.get();
                    if (context2 == null) return;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "Unable to create PowerConnectionReceiver, ", exception);
                    return;
                }
                if (commonUtility2.mPowerConnectionReceiver == null) return;
                Context context3 = context2;
                CommonUtility commonUtility = commonUtility2;
                CommonUtility commonUtility2 = intentFilter;
                new IntentFilter().addAction("android.intent.action.BATTERY_CHANGED");
                context3.registerReceiver((BroadcastReceiver)commonUtility.mPowerConnectionReceiver, (IntentFilter)commonUtility2);
                return;
            }
            try {
                context = (Context)commonUtility2.mContext.get();
                if (context == null) break block10;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (commonUtility2.mPowerConnectionReceiver == null) break block10;
            context.unregisterReceiver((BroadcastReceiver)commonUtility2.mPowerConnectionReceiver);
        }
        commonUtility2.mPowerConnectionReceiver = null;
    }

    public void notifyNetworkChange() {
        if ((Context)this.mContext.get() != null && this.mAccessible) {
            this.shouldGetIp = true;
            byte[] byArray = this.getNetworkInfo();
            if (byArray != null && this.mAccessible) {
                CommonUtility commonUtility = this;
                commonUtility.nativeNotifyNetworkChange(commonUtility.mBridgeHandle, byArray);
                return;
            }
            return;
        }
    }

    public void onPowerChange(int n2) {
        if ((Context)this.mContext.get() != null && this.mAccessible) {
            this.batteryPercentage = n2;
            return;
        }
    }

    public int getFrontCameraIndex(Context context) {
        return DeviceUtils.selectFrontCamera(context);
    }

    public int getNumberOfCameras(Context context) {
        return DeviceUtils.getNumberOfCameras(context);
    }

    public int isSimulator() {
        String string2;
        String string3;
        int n2;
        block10: {
            n2 = 0;
            string3 = "";
            string2 = "";
            string2 = Build.MANUFACTURER;
            if (!string2.toLowerCase().contains("netease")) break block10;
            n2 = 1;
        }
        try {
            Logging.i(TAG, "manufacturer = " + string2);
        }
        catch (Exception exception) {
            Logging.e(TAG, "get manufacturer info fail.");
        }
        if (this.isSimulatorProperty()) {
            ++n2;
        }
        if (Build.VERSION.SDK_INT > 28) {
            if ("nokia".equalsIgnoreCase(string2) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
                return 0;
            }
            if (n2 > 0 && !string2.toLowerCase().contains("welldo")) {
                return 1;
            }
        } else if ((string3.toLowerCase().equals("unknown") || n2 > 0) && !string2.toLowerCase().contains("welldo")) {
            return 1;
        }
        return 0;
    }

    public int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    public int isSpeakerphoneEnabled(Context context) {
        if (context == null) {
            return 0;
        }
        return this.getAudioManager(context).isSpeakerphoneOn() ? 1 : 0;
    }

    public void updateLocalVideoEnableState(boolean bl) {
        Logging.d(TAG, "updateLocalVideoEnableState: " + bl);
        this.mLocalVideoEnabled = bl;
    }

    public void updateVideoSourceType(int n2) {
        Logging.d(TAG, "updateVideoSourceType: " + n2);
        this.mVideoSourceType = n2;
    }

    private class AgoraPhoneStateListener
    extends PhoneStateListener {
        private SignalStrength mSignalStrenth;
        private boolean phoneStatusNeedResume = false;

        private int invokeMethod(String object) {
            block4: {
                try {
                    if (this.mSignalStrenth == null) break block4;
                }
                catch (Exception exception) {}
                object = this.mSignalStrenth.getClass().getDeclaredMethod((String)object, new Class[0]);
                if (object == null) break block4;
                return (Integer)((Method)object).invoke((Object)this.mSignalStrenth, new Object[0]);
            }
            return 0;
        }

        public int getRssi() {
            int n2 = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                n2 = this.invokeMethod("getDbm");
            }
            return n2;
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            int n2 = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                n2 = this.invokeMethod("getAsuLevel");
            }
            return n2;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            if ((Context)CommonUtility.this.mContext.get() != null && CommonUtility.this.mAccessible) {
                super.onSignalStrengthsChanged(signalStrength);
                this.mSignalStrenth = signalStrength;
                return;
            }
        }

        public void onCallStateChanged(int n2, String string2) {
            if ((Context)CommonUtility.this.mContext.get() != null && CommonUtility.this.mAccessible) {
                super.onCallStateChanged(n2, string2);
                if (n2 != 0) {
                    if (n2 != 1) {
                        if (n2 == 2) {
                            Logging.i(TAG, "system phone call start");
                            this.phoneStatusNeedResume = true;
                            CommonUtility.this.onPhoneStateChanged(false, 22, 2);
                        }
                    } else {
                        Logging.i(TAG, "system phone call ring");
                        this.phoneStatusNeedResume = true;
                        CommonUtility.this.onPhoneStateChanged(false, 22, 1);
                    }
                } else if (this.phoneStatusNeedResume) {
                    this.phoneStatusNeedResume = false;
                    Logging.i(TAG, "system phone call end delay 1000ms");
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommonUtility.this.onPhoneStateChanged(true, 22, 0);
                            }
                            catch (Exception exception) {
                                Logging.e(TAG, "fail to resume ", exception);
                            }
                        }
                    }, 1000L);
                }
                return;
            }
        }
    }

    public static class MobileType {
        public static final int Unknown = -1;
        public static final int Gsm = 0;
        public static final int Cdma = 1;
        public static final int Wcdma = 2;
        public static final int Lte = 3;
    }
}

