/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

class Connectivity {
    public static final int Network_UNKNOWN = -1;
    public static final int Network_DISCONNECTED = 0;
    public static final int Network_LAN = 1;
    public static final int Network_WIFI = 2;
    public static final int Network_2G = 3;
    public static final int Network_3G = 4;
    public static final int Network_4G = 5;
    public static final int Network_5G = 6;
    public static final int Network_SubType_WIFI_2P4G = 100;
    public static final int Network_SubType_WIFI_5G = 101;

    Connectivity() {
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        return ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
    }

    public static boolean isConnected(Context context) {
        return (context = Connectivity.getNetworkInfo(context)) != null && context.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        return (context = Connectivity.getNetworkInfo(context)) != null && context.isConnected() && context.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        return (context = Connectivity.getNetworkInfo(context)) != null && context.isConnected() && context.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        return (context = Connectivity.getNetworkInfo(context)) != null && context.isConnected() && Connectivity.isConnectionFast(context.getType(), context.getSubtype());
    }

    public static boolean isConnectionFast(int n2, int n3) {
        if (n2 == 1) {
            return true;
        }
        if (n2 == 0) {
            switch (n3) {
                default: {
                    return false;
                }
                case 15: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 3: 
            }
            return true;
        }
        return false;
    }

    public static int getNetworkType(NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 0;
        }
        int n2 = networkInfo.getType();
        if (n2 == 1) {
            return 2;
        }
        if (n2 != 0) {
            return -1;
        }
        int n3 = networkInfo.getSubtype();
        if (n3 != 20) {
            switch (n3) {
                default: {
                    return -1;
                }
                case 13: {
                    return 5;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return 4;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
            }
            return 3;
        }
        return 6;
    }

    public static int getNetworkType(Context context) {
        return Connectivity.getNetworkType(Connectivity.getNetworkInfo(context));
    }

    public static ArrayList<String> getDnsList() {
        ArrayList<String> arrayList;
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = clazz.getMethod("get", classArray);
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n2 = 4;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        try {
            stringArray[0] = "net.dns1";
            stringArray[1] = "net.dns2";
            stringArray[2] = "net.dns3";
            stringArray[3] = "net.dns4";
        }
        catch (Exception exception) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method2 = method;
            String string2 = stringArray2[i2];
            string2 = (String)method2.invoke(null, string2);
            if (string2 == null) continue;
            if ("".equals(string2)) continue;
            if (arrayList2.contains(string2)) continue;
            arrayList2.add(string2);
        }
        return arrayList2;
    }
}

