/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.Context;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.CameraUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceUtils {
    public static final int DEVICE_INFO_UNKNOWN = -1;
    private static final String TAG = "DeviceUtils";
    private static final String[] H264_HW_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string2 = file.getName();
            if (string2.startsWith("cpu")) {
                for (int i2 = 3; i2 < string2.length(); ++i2) {
                    if (Character.isDigit(string2.charAt(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static String buildDeviceId() {
        String string2 = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        Matcher matcher = Pattern.compile(".*[A-Z][A-M][0-9]$").matcher(Build.ID);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            string2 = "yeshen/simulator/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return string2;
    }

    public static String getDeviceInfo() {
        String string2 = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.HARDWARE;
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    public static String getSystemInfo() {
        return "Android/" + Build.VERSION.RELEASE;
    }

    public static int selectFrontCamera(Context context) {
        return CameraUtils.selectFrontCamera(context);
    }

    public static int getNumberOfCameras(Context context) {
        return CameraUtils.getNumberOfCameras(context);
    }

    public static int getRecommendedEncoderType() {
        if (Arrays.asList(H264_HW_BLACKLIST).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return 1;
        }
        if (Build.VERSION.SDK_INT <= 18) {
            return 1;
        }
        return 0;
    }

    public static int getNumberOfCPUCores() {
        int n2;
        block7: {
            block6: {
                if (Build.VERSION.SDK_INT <= 10) {
                    return 1;
                }
                n2 = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
                if (n2 != -1) break block6;
                n2 = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n2 != -1) break block7;
            try {
                n2 = DeviceUtils.getCoresFromCPUFileList();
                break block7;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {}
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCpuName() {
        block22: {
            block21: {
                var0 /* !! */  = null;
                var1_6 = v0;
                try {
                    v0 = new FileReader("/proc/cpuinfo");
                    break block21;
                }
                catch (Throwable var1_8) {
                }
                catch (IOException var1_9) {
                    // empty catch block
                    ** GOTO lbl-1000
                }
lbl11:
                // 2 sources

                while (true) {
                    if (var0 /* !! */  == null) throw var1_6;
                    try {
                        var0 /* !! */ .close();
                        throw var1_6;
                    }
                    catch (IOException var0_5) {
                        Logging.e("DeviceUtils", "failed to close proc file", var0_5);
                    }
                    throw var1_6;
                }
            }
            var0 /* !! */  = new BufferedReader((Reader)var1_6).readLine().split(":\\s+", 2);
            for (var2_11 = 0; var2_11 < var0 /* !! */ .length; ++var2_11) {
            }
            v1 = var1_6;
            var1_6.close();
            var0 /* !! */  = var0 /* !! */ [1];
            try {
                v1.close();
                return var0 /* !! */ ;
            }
            catch (IOException var1_7) {
                Logging.e("DeviceUtils", "failed to close proc file", var1_7);
            }
            return var0 /* !! */ ;
            catch (Throwable var0_1) {
                var0 /* !! */  = var1_6;
                var1_6 = var0_1;
                ** continue;
            }
            catch (IOException var0_2) {
                var0 /* !! */  = var1_6;
                var1_6 = var0_2;
            }
            catch (FileNotFoundException var0_3) {
                var0 /* !! */  = var1_6;
                var1_6 = var0_3;
                ** GOTO lbl-1000
            }
lbl-1000:
            // 2 sources

            {
                Logging.e("DeviceUtils", "getCpuName failed,", (Throwable)var1_6);
                if (var0 /* !! */  == null) return null;
            }
            try {}
            catch (IOException var0_4) {
                Logging.e("DeviceUtils", "failed to close proc file", var0_4);
                return null;
            }
            break block22;
            catch (FileNotFoundException var1_10) {
                // empty catch block
                ** GOTO lbl-1000
            }
        }
        var0 /* !! */ .close();
        return null;
lbl-1000:
        // 2 sources

        {
            Logging.e("DeviceUtils", "getCpuName failed, no /proc/cpuinfo found in system", (Throwable)var1_6);
            if (var0 /* !! */  == null) return null;
        }
        {
            var0 /* !! */ .close();
            return null;
        }
    }

    public static String getCpuABI() {
        return Build.CPU_ABI;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getCoresFromFileInfo(String string2) {
        FileInputStream fileInputStream;
        block14: {
            void var0_4;
            block13: {
                int n2;
                FileInputStream fileInputStream2;
                Object var1_6 = null;
                fileInputStream = fileInputStream2;
                try {
                    fileInputStream2 = new FileInputStream(string2);
                }
                catch (Throwable throwable) {
                    fileInputStream = var1_6;
                    break block13;
                }
                catch (IOException iOException) {
                    fileInputStream = var1_6;
                    break block14;
                }
                try {
                    String string3 = new BufferedReader(new InputStreamReader(fileInputStream)).readLine();
                    ((InputStream)fileInputStream).close();
                    n2 = DeviceUtils.getCoresFromFileString(string3);
                }
                catch (Throwable throwable) {
                    break block13;
                }
                catch (IOException iOException) {
                    break block14;
                }
                try {
                    ((InputStream)fileInputStream2).close();
                    return n2;
                }
                catch (IOException iOException) {
                    Logging.e(TAG, "close file stream", iOException);
                }
                return n2;
            }
            if (fileInputStream == null) throw var0_4;
            try {
                ((InputStream)fileInputStream).close();
                throw var0_4;
            }
            catch (IOException iOException) {
                Logging.e(TAG, "close file stream", iOException);
            }
            throw var0_4;
        }
        int n3 = -1;
        if (fileInputStream == null) return n3;
        try {
            ((InputStream)fileInputStream).close();
            return n3;
        }
        catch (IOException iOException) {
            Logging.e(TAG, "close file stream", iOException);
        }
        return n3;
    }

    private static int getCoresFromFileString(String string2) {
        if (string2 != null && string2.matches("0-[\\d]+$")) {
            return Integer.valueOf(string2.substring(2)) + 1;
        }
        return -1;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu").listFiles(CPU_FILTER).length;
    }

    /*
     * Unable to fully structure code
     */
    public static int getCPUMaxFreqKHz() {
        block29: {
            var0 = -1;
            var1_2 = 0;
            while (true) {
                block26: {
                    block27: {
                        if (var1_2 >= DeviceUtils.getNumberOfCPUCores()) break;
                        var2_4 = "/sys/devices/system/cpu/cpu" + var1_2 + "/cpufreq/cpuinfo_max_freq";
                        var3_8 = v0;
                        if (!new File(var2_4).exists()) break block26;
                        var2_5 = 128;
                        var4_10 = new byte[128];
                        var5_11 = v1;
                        v2 = var4_10;
                        var5_11(var3_8);
                        v1.read(v2);
                        var3_9 = 0;
                        while (true) {
                            if (!Character.isDigit(var4_10[var3_9]) || var3_9 >= var2_5) break;
                            ++var3_9;
                            continue;
                            break;
                        }
                        var2_6 = Integer.parseInt(new String(var4_10, 0, var3_9));
                        if (var2_6 <= var0) break block27;
                        try {
                            var0 = var2_6;
                        }
                        catch (Throwable var0_1) {
                            var5_11.close();
                            throw var0_1;
                        }
                        catch (NumberFormatException v3) {
                            ** continue;
                        }
                    }
lbl34:
                    // 2 sources

                    while (true) {
                        var5_11.close();
                        break;
                    }
                }
                ++var1_2;
            }
            if (var0 == -1) {
                block28: {
                    var1_3 = v4;
                    v4 = new FileInputStream("/proc/cpuinfo");
                    var2_7 = DeviceUtils.parseFileForValue("cpu MHz", var1_3) * 1000;
                    if (var2_7 > var0) break block28;
                    var2_7 = var0;
                    {
                        catch (Throwable v5) {
                            var1_3.close();
                            throw v5;
                        }
                    }
                }
                var1_3.close();
                break block29;
            }
            var2_7 = var0;
            break block29;
            {
                catch (IOException v6) {
                    var2_7 = -1;
                }
            }
        }
        return var2_7;
    }

    private static int parseFileForValue(String string2, FileInputStream object) {
        FileInputStream fileInputStream = object;
        byte[] byArray = new byte[1024];
        object = byArray;
        int n2 = fileInputStream.read(byArray);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            if (object[i2] != 10 && i2 != 0) continue;
            try {
                if (object[i2] == 10) {
                    // empty if block
                }
                n3 = ++i2;
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            catch (IOException iOException) {}
            while (n3 < n2) {
                int n4 = n3++;
                int n5 = n4 - i2;
                if (object[n4] != string2.charAt(n5)) continue block8;
                if (n5 != string2.length() - 1) continue;
                return DeviceUtils.extractValue((byte[])object, n3);
            }
            continue;
            break;
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n2) {
        while (n2 < byArray.length && byArray[n2] != 10) {
            if (Character.isDigit(byArray[n2])) {
                int n3;
                for (n3 = n2 + 1; n3 < byArray.length && Character.isDigit(byArray[n3]); ++n3) {
                }
                int n4 = n3 - n2;
                return Integer.parseInt(new String(byArray, 0, n2, n4));
            }
            ++n2;
        }
        return -1;
    }
}

