/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class Marshallable {
    public static final int PROTO_PACKET_SIZE = 8192;
    private ByteBuffer mBuffer;

    public Marshallable() {
        Marshallable marshallable = this;
        this.mBuffer = ByteBuffer.allocate(8192);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        marshallable.mBuffer.position(2);
    }

    public byte[] marshall() {
        short s2 = (short)this.mBuffer.position();
        this.mBuffer.putShort(0, s2);
        byte[] byArray = new byte[s2];
        Marshallable marshallable = this;
        marshallable.mBuffer.position(0);
        marshallable.mBuffer.get(byArray);
        return byArray;
    }

    public void marshall(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    public void unmarshall(byte[] byArray) {
        this.mBuffer = ByteBuffer.wrap(byArray);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.popShort();
    }

    public void unmarshall(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public void pushBool(Boolean bl) {
        byte by = bl.booleanValue();
        this.mBuffer.put(by);
    }

    public Boolean popBool() {
        return this.mBuffer.get() == 1;
    }

    public void pushByte(byte by) {
        this.mBuffer.put(by);
    }

    public byte popByte() {
        return this.mBuffer.get();
    }

    public void pushBytes(byte[] byArray) {
        Marshallable marshallable = this;
        marshallable.mBuffer.putShort((short)byArray.length);
        marshallable.mBuffer.put(byArray);
    }

    public byte[] popBytes() {
        short s2 = this.mBuffer.getShort();
        byte[] byArray = new byte[]{};
        if (s2 > 0) {
            byArray = new byte[s2];
            this.mBuffer.get(byArray);
        }
        return byArray;
    }

    public void pushBytes32(byte[] byArray) {
        Marshallable marshallable = this;
        marshallable.mBuffer.putInt(byArray.length);
        marshallable.mBuffer.put(byArray);
    }

    public byte[] popBytes32() {
        int n2 = this.mBuffer.getInt();
        byte[] byArray = null;
        if (n2 > 0) {
            byArray = new byte[n2];
            this.mBuffer.get(byArray);
        }
        return byArray;
    }

    public byte[] popAll() {
        byte[] byArray = new byte[this.mBuffer.remaining()];
        this.mBuffer.get(byArray);
        return byArray;
    }

    public void pushShort(short s2) {
        this.mBuffer.putShort(s2);
    }

    public short popShort() {
        return this.mBuffer.getShort();
    }

    public void pushInt(int n2) {
        this.mBuffer.putInt(n2);
    }

    public void pushDouble(double d2) {
        this.mBuffer.putDouble(d2);
    }

    public int popInt() {
        return this.mBuffer.getInt();
    }

    public void pushInt64(long l2) {
        this.mBuffer.putLong(l2);
    }

    public long popInt64() {
        return this.mBuffer.getLong();
    }

    public void pushString16(String string2) {
        if (string2 == null) {
            this.mBuffer.putShort((short)0);
            return;
        }
        this.mBuffer.putShort((short)string2.getBytes().length);
        if (string2.getBytes().length > 0) {
            this.mBuffer.put(string2.getBytes());
        }
    }

    public String popString16() {
        short s2 = ((Marshallable)object).mBuffer.getShort();
        if (s2 > 0) {
            Marshallable marshallable = object;
            Object object = new byte[s2];
            marshallable.mBuffer.get((byte[])object);
            try {
                return new String((byte[])object, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return "";
    }

    public String popString16UTF8() {
        short s2 = ((Marshallable)object).mBuffer.getShort();
        if (s2 > 0) {
            Marshallable marshallable = object;
            Object object = new byte[s2];
            marshallable.mBuffer.get((byte[])object);
            try {
                return new String((byte[])object, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return "";
    }

    public void pushStringArray(ArrayList<String> arrayList) {
        if (arrayList == null) {
            this.pushInt(0);
            return;
        }
        int n2 = arrayList.size();
        this.pushShort((short)n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushBytes(arrayList.get(i2).getBytes());
        }
    }

    public void pushIntArray(int[] nArray) {
        if (nArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = nArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushInt(nArray[i2]);
        }
    }

    public void pushIntArray(Integer[] integerArray) {
        if (integerArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = integerArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushInt(integerArray[i2]);
        }
    }

    public int[] popIntArray() {
        int n2 = this.popInt();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.popInt();
        }
        return nArray;
    }

    public void pushShortArray(short[] sArray) {
        if (sArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = sArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushShort(sArray[i2]);
        }
    }

    public short[] popShortArray() {
        int n2 = this.popInt();
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = this.popShort();
        }
        return sArray;
    }

    public void clear() {
        this.mBuffer.position(10);
    }
}

