/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.RtcChannel;
import io.agora.rtc.internal.EncryptionConfig;
import io.agora.rtc.internal.RtcEngineImpl;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.AgoraDefaultRender;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.models.ChannelMediaOptions;
import io.agora.rtc.models.ClientRoleOptions;
import io.agora.rtc.models.DataStreamConfig;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import java.util.Map;

public class RtcChannelImpl
extends RtcChannel {
    private long mNativeHandle = 0L;
    private boolean mInitialized = false;
    private RtcEngineImpl mRtcEngineImpl = null;
    private boolean mJoined = false;

    private native String nativeRtcChannelChannelId(long var1);

    private native String nativeRtcChannelGetCallId(long var1);

    private native int nativeRtcChannelJoinChannel(long var1, String var3, String var4, int var5, Object var6);

    private native int nativeRtcChannelLeaveChannel(long var1);

    private native int nativeRtcChannelMuteLocalAudioStream(long var1, boolean var3);

    private native int nativeRtcChannelMuteLocalVideoStream(long var1, boolean var3);

    private native int nativeRtcChannelJoinChannelWithUserAccount(long var1, String var3, String var4, Object var5);

    private native int nativeRtcChannelPublish(long var1);

    private native int nativeRtcChannelUnpublish(long var1);

    private native int nativeRtcChannelRenewToken(long var1, String var3);

    private native int nativeRtcChannelSetEncryptionSecret(long var1, String var3);

    private native int nativeRtcChannelSetEncryptionMode(long var1, String var3);

    private native int nativeRtcChannelEnableEncryption(long var1, boolean var3, int var4, String var5, byte[] var6);

    private native int nativeRtcChannelRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeRtcChannelSetClientRole(long var1, int var3);

    private native int nativeRtcChannelSetClientRoleOptions(long var1, int var3, Object var4);

    private native int nativeRtcChannelSetRemoteUserPriority(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteVoicePosition(long var1, int var3, double var4, double var6);

    private native int nativeRtcChannelSetRemoteRenderMode(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteRenderModeWithMirrorMode(long var1, int var3, int var4, int var5);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteAudioStream(long var1, int var3, boolean var4);

    private native int nativeRtcChannelAdjustUserPlaybackSignalVolume(long var1, int var3, int var4);

    private native int nativeRtcChannelMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteVideoStream(long var1, int var3, boolean var4);

    private native int nativeRtcChannelSetRemoteVideoStreamType(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteDefaultVideoStreamType(long var1, int var3);

    private native int nativeRtcChannelCreateDataStream(long var1, boolean var3, boolean var4);

    private native int nativeRtcChannelCreateDataStream2(long var1, boolean var3, boolean var4);

    private native int nativeRtcChannelSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeRtcChannelAddPublishStreamUrl(long var1, String var3, boolean var4);

    private native int nativeRtcChannelRemovePublishStreamUrl(long var1, String var3);

    private native int nativeRtcChannelSetLiveTranscoding(long var1, byte[] var3);

    private native int nativeRtcChannelAddInjectStreamUrl(long var1, String var3, byte[] var4);

    private native int nativeRtcChannelRemoveInjectStreamUrl(long var1, String var3);

    private native int nativeRtcChannelStartChannelMediaRelay(long var1, byte[] var3);

    private native int nativeRtcChannelUpdateChannelMediaRelay(long var1, byte[] var3);

    private native int nativeRtcChannelStopChannelMediaRelay(long var1);

    private native int nativeRtcChannelPauseAllChannelMediaRelay(long var1);

    private native int nativeRtcChannelResumeAllChannelMediaRelay(long var1);

    private native int nativeRtcChannelGetConncetionState(long var1);

    private native int nativeRtcChannelAddRemoteVideoRender(long var1, int var3, IVideoSink var4, int var5);

    private native int nativeRtcChannelEnableRemoteSuperResolution(long var1, int var3, boolean var4);

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public boolean hasJoined() {
        return this.mJoined;
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void onEngineDestroy() {
        RtcChannelImpl rtcChannelImpl = this;
        rtcChannelImpl.mNativeHandle = 0L;
        rtcChannelImpl.mInitialized = false;
    }

    public int initialize(RtcEngineImpl rtcEngineImpl, long l2) {
        RtcChannelImpl rtcChannelImpl = this;
        rtcChannelImpl.mRtcEngineImpl = rtcEngineImpl;
        rtcChannelImpl.mNativeHandle = l2;
        rtcChannelImpl.mInitialized = true;
        return 0;
    }

    @Override
    public String channelId() {
        if (!this.mInitialized) {
            return "";
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelChannelId(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public String getCallId() {
        if (!this.mInitialized) {
            return "";
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelGetCallId(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int destroy() {
        if (this.mInitialized) {
            this.mInitialized = false;
            return this.mRtcEngineImpl.destroyRtcChannel(this.channelId());
        }
        return -7;
    }

    @Override
    public int getConnectionState() {
        if (!this.mInitialized) {
            return 1;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelGetConncetionState(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int enableRemoteSuperResolution(int n2, boolean bl) {
        if (!this.mInitialized) {
            return 1;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelEnableRemoteSuperResolution(rtcChannelImpl.mNativeHandle, n2, bl);
    }

    @Override
    public int joinChannel(String string2, String string3, int n2, ChannelMediaOptions channelMediaOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        if (this.mRtcEngineImpl.getContext() == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        RtcChannelImpl rtcChannelImpl = this;
        rtcChannelImpl.mRtcEngineImpl.onRtcChannelJoinChannel();
        rtcChannelImpl.mJoined = true;
        return rtcChannelImpl.nativeRtcChannelJoinChannel(rtcChannelImpl.mNativeHandle, string2, string3, n2, channelMediaOptions);
    }

    @Override
    public int joinChannelWithUserAccount(String string2, String string3, ChannelMediaOptions channelMediaOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        if (this.mRtcEngineImpl.getContext() == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        RtcChannelImpl rtcChannelImpl = this;
        rtcChannelImpl.mRtcEngineImpl.onRtcChannelJoinChannel();
        rtcChannelImpl.mJoined = true;
        return rtcChannelImpl.nativeRtcChannelJoinChannelWithUserAccount(rtcChannelImpl.mNativeHandle, string2, string3, channelMediaOptions);
    }

    @Override
    public int leaveChannel() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        rtcChannelImpl.mJoined = false;
        rtcChannelImpl.mRtcEngineImpl.onRtcChannelLeaveChannel();
        return rtcChannelImpl.nativeRtcChannelLeaveChannel(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int muteLocalAudioStream(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteLocalAudioStream(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int muteLocalVideoStream(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteLocalVideoStream(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int publish() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelPublish(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int unpublish() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelUnpublish(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int renewToken(String string2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelRenewToken(rtcChannelImpl.mNativeHandle, string2);
    }

    @Override
    public int setEncryptionSecret(String string2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetEncryptionSecret(rtcChannelImpl.mNativeHandle, string2);
    }

    @Override
    public int setEncryptionMode(String string2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetEncryptionMode(rtcChannelImpl.mNativeHandle, string2);
    }

    @Override
    public int enableEncryption(boolean bl, EncryptionConfig object) {
        if (!this.mInitialized) {
            return -7;
        }
        EncryptionConfig encryptionConfig = object;
        long l2 = this.mNativeHandle;
        int n2 = encryptionConfig.encryptionMode.getValue();
        object = encryptionConfig.encryptionKey;
        byte[] byArray = encryptionConfig.encryptionKdfSalt;
        return this.nativeRtcChannelEnableEncryption(l2, bl, n2, (String)object, byArray);
    }

    @Override
    public int registerMediaMetadataObserver(IMetadataObserver iMetadataObserver, int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelRegisterMediaMetadataObserver(rtcChannelImpl.mNativeHandle, iMetadataObserver, n2);
    }

    @Override
    public int setClientRole(int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetClientRole(rtcChannelImpl.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2, ClientRoleOptions clientRoleOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetClientRoleOptions(rtcChannelImpl.mNativeHandle, n2, clientRoleOptions);
    }

    @Override
    public int setRemoteUserPriority(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetRemoteUserPriority(rtcChannelImpl.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteVoicePosition(int n2, double d2, double d3) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetRemoteVoicePosition(rtcChannelImpl.mNativeHandle, n2, d2, d3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3, int n4) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetRemoteRenderModeWithMirrorMode(rtcChannelImpl.mNativeHandle, n2, n3, n4);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteAllRemoteAudioStreams(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int muteRemoteAudioStream(int n2, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteRemoteAudioStream(rtcChannelImpl.mNativeHandle, n2, bl);
    }

    @Override
    public int adjustUserPlaybackSignalVolume(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelAdjustUserPlaybackSignalVolume(rtcChannelImpl.mNativeHandle, n2, n3);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteAllRemoteVideoStreams(rtcChannelImpl.mNativeHandle, bl);
    }

    @Override
    public int muteRemoteVideoStream(int n2, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelMuteRemoteVideoStream(rtcChannelImpl.mNativeHandle, n2, bl);
    }

    @Override
    public int setRemoteVideoStreamType(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetRemoteVideoStreamType(rtcChannelImpl.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSetRemoteDefaultVideoStreamType(rtcChannelImpl.mNativeHandle, n2);
    }

    @Override
    public int createDataStream(boolean bl, boolean bl2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelCreateDataStream(rtcChannelImpl.mNativeHandle, bl, bl2);
    }

    @Override
    public int createDataStream(DataStreamConfig dataStreamConfig) {
        if (!this.mInitialized) {
            return -7;
        }
        DataStreamConfig dataStreamConfig2 = dataStreamConfig;
        long l2 = this.mNativeHandle;
        boolean bl = dataStreamConfig2.ordered;
        boolean bl2 = dataStreamConfig2.syncWithAudio;
        return this.nativeRtcChannelCreateDataStream2(l2, bl, bl2);
    }

    @Override
    public int sendStreamMessage(int n2, byte[] byArray) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelSendStreamMessage(rtcChannelImpl.mNativeHandle, n2, byArray);
    }

    @Override
    public int addPublishStreamUrl(String string2, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelAddPublishStreamUrl(rtcChannelImpl.mNativeHandle, string2, bl);
    }

    @Override
    public int removePublishStreamUrl(String string2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelRemovePublishStreamUrl(rtcChannelImpl.mNativeHandle, string2);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding liveTranscoding) {
        if (!((RtcChannelImpl)object).mInitialized) {
            return -7;
        }
        if (liveTranscoding == null) {
            return -2;
        }
        if (liveTranscoding.getUsers() != null) {
            for (LiveTranscoding.TranscodingUser transcodingUser : liveTranscoding.getUsers()) {
                if (transcodingUser.width > 0 && transcodingUser.height > 0) continue;
                throw new IllegalArgumentException("transcoding user's width and height must be >0");
            }
        }
        RtcChannelImpl rtcChannelImpl = object;
        Object object = new RtcEngineMessage.PLiveTranscoding().marshall(liveTranscoding);
        return rtcChannelImpl.nativeRtcChannelSetLiveTranscoding(rtcChannelImpl.mNativeHandle, (byte[])object);
    }

    @Override
    public int addInjectStreamUrl(String string2, LiveInjectStreamConfig liveInjectStreamConfig) {
        if (!((RtcChannelImpl)object).mInitialized) {
            return -7;
        }
        if (string2 != null && liveInjectStreamConfig != null) {
            RtcChannelImpl rtcChannelImpl = object;
            Object object = new RtcEngineMessage.PInjectStreamConfig().marshall(liveInjectStreamConfig);
            return rtcChannelImpl.nativeRtcChannelAddInjectStreamUrl(rtcChannelImpl.mNativeHandle, string2, (byte[])object);
        }
        return -2;
    }

    @Override
    public int removeInjectStreamUrl(String string2) {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelRemoveInjectStreamUrl(rtcChannelImpl.mNativeHandle, string2);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (!((RtcChannelImpl)object).mInitialized) {
            return -7;
        }
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null) {
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
                return -2;
            }
            RtcChannelImpl rtcChannelImpl = object;
            Object object = new RtcEngineMessage.PChannelMediaRelayConfiguration().marshall(channelMediaRelayConfiguration);
            return rtcChannelImpl.nativeRtcChannelStartChannelMediaRelay(rtcChannelImpl.mNativeHandle, (byte[])object);
        }
        return -2;
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (!((RtcChannelImpl)object).mInitialized) {
            return -7;
        }
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null) {
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
                return -2;
            }
            RtcChannelImpl rtcChannelImpl = object;
            Object object = new RtcEngineMessage.PChannelMediaRelayConfiguration().marshall(channelMediaRelayConfiguration);
            return rtcChannelImpl.nativeRtcChannelUpdateChannelMediaRelay(rtcChannelImpl.mNativeHandle, (byte[])object);
        }
        return -2;
    }

    @Override
    public int stopChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelStopChannelMediaRelay(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int pauseAllChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelPauseAllChannelMediaRelay(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int resumeAllChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelResumeAllChannelMediaRelay(rtcChannelImpl.mNativeHandle);
    }

    @Override
    public int setRemoteVideoRenderer(int n2, IVideoSink iVideoSink) {
        if (!this.mInitialized) {
            return -7;
        }
        int n3 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        RtcChannelImpl rtcChannelImpl = this;
        return rtcChannelImpl.nativeRtcChannelAddRemoteVideoRender(rtcChannelImpl.mNativeHandle, n2, iVideoSink, n3);
    }
}

