/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.wifi.WifiManager;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import io.agora.rtc.IAudioEffectManager;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ILogWriter;
import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.IRtcChannelEventHandler;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.IVideoEncodedFrameObserver;
import io.agora.rtc.IVideoFrameObserver;
import io.agora.rtc.RtcChannel;
import io.agora.rtc.RtcEngineConfig;
import io.agora.rtc.RtcEngineEx;
import io.agora.rtc.audio.AgoraRhythmPlayerConfig;
import io.agora.rtc.audio.AudioParams;
import io.agora.rtc.audio.AudioRecordingConfiguration;
import io.agora.rtc.audio.HardwareEarbackController;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.CommonUtility;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.EncryptionConfig;
import io.agora.rtc.internal.LastmileProbeConfig;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.RtcChannelImpl;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.AgoraDefaultRender;
import io.agora.rtc.mediaio.AgoraDefaultSource;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.models.ChannelMediaOptions;
import io.agora.rtc.models.ClientRoleOptions;
import io.agora.rtc.models.DataStreamConfig;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.AgoraVideoFrame;
import io.agora.rtc.video.BeautyOptions;
import io.agora.rtc.video.CameraCapturerConfiguration;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoEncoderConfiguration;
import io.agora.rtc.video.VirtualBackgroundSource;
import io.agora.rtc.video.WatermarkOptions;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RtcEngineImpl
extends RtcEngineEx
implements IAudioEffectManager {
    private static final String TAG = "RtcEngine";
    public static final int VIDEO_SOURCE_TYPE_NULL = 0;
    public static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    public static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private static boolean sLibLoaded = false;
    static float[] sMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private int mVideoSourceType;
    private boolean mLocalVideoEnabled;
    private boolean mUseLocalView;
    private int mExAudioSourceSampleRate;
    private int mExAudioSourceChannels;
    private int mExAudioSinkChannels;
    private int mExAudioSinkSampleRate;
    private long lastOrientationTs;
    private int mTotalRotation;
    private long mNativeHandle;
    private final ConcurrentHashMap<IRtcEngineEventHandler, Integer> mRtcHandlers;
    private RtcChannelImpl mDefaultRtcChannel;
    private final LinkedList<RtcChannelImpl> mRtcChannels;
    private IRtcEngineEventHandler.RtcStats mRtcStats;
    IRtcEngineEventHandler.AgoraFacePositionInfo[] faceRectArr;
    private WifiManager.WifiLock mWifiLock;
    private int mChannelProfile;
    private int mClientRole;
    private WeakReference<Context> mContext;
    private IntentFilter filter;
    private BroadcastReceiver mUsbStateChangeReceiver;

    private void checkVoipPermissions(Context context, String string2) throws SecurityException {
        if (context != null && context.checkPermission(string2, Process.myPid(), Process.myUid()) == 0) {
            return;
        }
        throw new SecurityException(string2 + " is not granted");
    }

    public static synchronized void loadNativeLibrary() {
        System.loadLibrary("agora-core");
        System.loadLibrary("agora-ffmpeg");
        System.loadLibrary("agora-fdkaac");
        System.loadLibrary("agora-mpg123");
        System.loadLibrary("agora-soundtouch");
        System.loadLibrary("agora-rtc-sdk");
        try {
            System.loadLibrary("agora_fd_extension");
            Logging.i(TAG, "libagora_fd_extension module loaded.");
        }
        catch (Throwable throwable) {}
        try {
            System.loadLibrary("agora_super_resolution_extension");
            Logging.i(TAG, "Agora super resolution module loaded.");
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "Agora super resolution module load failed.");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                System.loadLibrary("agora-agb");
                Logging.i(TAG, "agora agb module loaded.");
            }
            catch (Throwable throwable) {}
        }
        try {
            System.loadLibrary("agora_segmentation_extension");
            Logging.i(TAG, "Agora segmentation module loaded.");
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "Agora segmentation module load failed.");
        }
        try {
            System.loadLibrary("agora_ai_denoise_extension");
            Logging.i(TAG, "AgoraAI Denoise module loaded.");
        }
        catch (Throwable throwable) {}
        try {
            System.loadLibrary("agora_jnd_extension");
            Logging.i(TAG, "libagora_jnd_extension module loaded.");
        }
        catch (Throwable throwable) {}
        try {
            System.loadLibrary("agora_dav1d_extension");
            Logging.i(TAG, "AgoraDav1d module loaded.");
        }
        catch (Throwable throwable) {}
    }

    public static synchronized boolean initializeNativeLibs() {
        if (!sLibLoaded) {
            RtcEngineImpl.loadNativeLibrary();
            sLibLoaded = RtcEngineImpl.nativeClassInit() == 0;
        }
        return sLibLoaded;
    }

    public static boolean checkIfInUIThread(String string2) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            Logging.i(TAG, string2 + " in UI Thread");
            return true;
        }
        Logging.i(TAG, string2 + " not in UI Thread");
        return false;
    }

    private void refresh_device_list() {
        RtcEngineImpl.nativeDeviceChanged(this.mNativeHandle);
    }

    private void initDeviceNotify(Context context) {
        RtcEngineImpl rtcEngineImpl = rtcEngineImpl2;
        rtcEngineImpl.filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        rtcEngineImpl.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        rtcEngineImpl.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        rtcEngineImpl.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        rtcEngineImpl.filter.addAction("android.hardware.usb.action.USB_STATE");
        RtcEngineImpl rtcEngineImpl2 = rtcEngineImpl.mUsbStateChangeReceiver;
        context.registerReceiver((BroadcastReceiver)rtcEngineImpl2, rtcEngineImpl.filter);
    }

    private void unRegisterBroadcstReceiver(Context context) {
        context.unregisterReceiver(this.mUsbStateChangeReceiver);
    }

    public RtcEngineImpl(Context context, String string2, IRtcEngineEventHandler iRtcEngineEventHandler) throws Exception {
        Context context2 = context;
        this.mVideoSourceType = 1;
        this.mLocalVideoEnabled = false;
        this.mUseLocalView = false;
        this.mExAudioSourceSampleRate = 0;
        this.mExAudioSourceChannels = 0;
        this.mExAudioSinkChannels = -1;
        this.mExAudioSinkSampleRate = -1;
        this.lastOrientationTs = 0L;
        this.mTotalRotation = 1000;
        this.mNativeHandle = 0L;
        this.mRtcHandlers = new ConcurrentHashMap();
        this.mDefaultRtcChannel = null;
        this.mRtcChannels = new LinkedList();
        this.mRtcStats = null;
        this.mWifiLock = null;
        this.mChannelProfile = 1;
        this.mClientRole = 2;
        this.filter = new IntentFilter();
        this.mUsbStateChangeReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(object) || "android.hardware.usb.action.USB_ACCESSORY_ATTACHED".equals(object)) {
                    Logging.i(RtcEngineImpl.TAG, "device attached");
                    RtcEngineImpl.this.refresh_device_list();
                }
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(object) || "android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(object)) {
                    Logging.i(RtcEngineImpl.TAG, "device detached");
                    RtcEngineImpl.this.refresh_device_list();
                }
            }
        };
        this.mContext = new WeakReference<Context>(context);
        this.addHandler(iRtcEngineEventHandler);
        HardwareEarbackController.getInstance(context2).isHardwareEarbackSupported();
        this.mNativeHandle = this.nativeObjectInit(context2, string2, "", "", "", "", "", "");
        this.initDeviceNotify(context);
        this.setParameter("che.android_app_external_storage_path", CommonUtility.getAppPrivateStorageDir(context));
    }

    public RtcEngineImpl(RtcEngineConfig rtcEngineConfig) throws Exception {
        this.mVideoSourceType = 1;
        this.mLocalVideoEnabled = false;
        this.mUseLocalView = false;
        this.mExAudioSourceSampleRate = 0;
        this.mExAudioSourceChannels = 0;
        this.mExAudioSinkChannels = -1;
        this.mExAudioSinkSampleRate = -1;
        this.lastOrientationTs = 0L;
        this.mTotalRotation = 1000;
        this.mNativeHandle = 0L;
        this.mRtcHandlers = new ConcurrentHashMap();
        this.mDefaultRtcChannel = null;
        this.mRtcChannels = new LinkedList();
        this.mRtcStats = null;
        this.mWifiLock = null;
        this.mChannelProfile = 1;
        this.mClientRole = 2;
        this.filter = new IntentFilter();
        this.mUsbStateChangeReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mContext = new WeakReference<Context>(rtcEngineConfig.mContext);
        this.addHandler(rtcEngineConfig.mEventHandler);
        this.mNativeHandle = this.nativeObjectInitWithConfig(rtcEngineConfig);
        this.initDeviceNotify(rtcEngineConfig.mContext);
    }

    private int setVideoRotateCapturedFrames(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return super.setParameterObject("che.video.local.rotate_video", RtcEngineImpl.formatString("{\"degree\":%d,\"rotation\":%d}", objectArray3));
    }

    /*
     * Exception decompiling
     */
    private String getAssetsCacheFile(Context var1_1, String var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doMonitorSystemEvent(Context context) {
        if (context == null) {
            return;
        }
        int n2 = Process.myUid();
        if (context.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), n2) != 0) {
            return;
        }
        if (Connectivity.getNetworkType(context) != 2) {
            return;
        }
        int n3 = Process.myUid();
        if (context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), n3) != 0) {
            return;
        }
        RtcEngineImpl rtcEngineImpl = rtcEngineImpl.mWifiLock;
        if (rtcEngineImpl != null) {
            rtcEngineImpl.acquire();
            Logging.i(TAG, "hp connection mode detected");
        }
    }

    private int doCheckPermission(Context context) {
        try {
            this.checkVoipPermissions(context, "android.permission.INTERNET");
            return 0;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "can't join channel because no permission");
            return -9;
        }
    }

    private void doJoinChannelCheck(Context context) {
        if (this.joinChannelFirstTimeOrAllChannelLeft()) {
            RtcEngineImpl rtcEngineImpl = this;
            rtcEngineImpl.doMonitorSystemEvent(context);
            rtcEngineImpl.doCheckPermission(context);
        }
    }

    private void doLeaveChannelCheck() {
        if (this.joinChannelFirstTimeOrAllChannelLeft()) {
            this.doStopMonitorSystemEvent();
        }
    }

    private void doStopMonitorSystemEvent() {
        WifiManager.WifiLock wifiLock = this.mWifiLock;
        if (wifiLock != null && wifiLock.isHeld()) {
            this.mWifiLock.release();
            Logging.i(TAG, "hp connection mode ended");
        }
    }

    private int switchCamera(CameraCapturerConfiguration.CAMERA_DIRECTION cAMERA_DIRECTION) {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        long l2 = this.mNativeHandle;
        int n2 = cAMERA_DIRECTION.getValue();
        return this.nativeSwitchCameraByDirection(l2, n2);
    }

    private static String formatString(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    private void onLogEvent(int n2, String string2) {
    }

    private void onApiCallExecuted(byte[] object, IRtcEngineEventHandler object2) {
        IRtcEngineEventHandler iRtcEngineEventHandler = object2;
        RtcEngineMessage.PApiCallExecuted pApiCallExecuted = new RtcEngineMessage.PApiCallExecuted();
        pApiCallExecuted.unmarshall((byte[])object);
        int n2 = pApiCallExecuted.error;
        object = pApiCallExecuted.api;
        object2 = pApiCallExecuted.result;
        iRtcEngineEventHandler.onApiCallExecuted(n2, (String)object, (String)object2);
    }

    private void onFirstRemoteVideoDecoded(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteVideoDecoded pFirstRemoteVideoDecoded = new RtcEngineMessage.PFirstRemoteVideoDecoded();
        pFirstRemoteVideoDecoded.unmarshall(byArray);
        int n2 = pFirstRemoteVideoDecoded.uid;
        int n3 = pFirstRemoteVideoDecoded.width;
        int n4 = pFirstRemoteVideoDecoded.height;
        int n5 = pFirstRemoteVideoDecoded.elapsed;
        iRtcEngineEventHandler.onFirstRemoteVideoDecoded(n2, n3, n4, n5);
    }

    private void onCameraFocusAreaChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCameraFocusAreaChanged pCameraFocusAreaChanged;
        RtcEngineMessage.PCameraFocusAreaChanged pCameraFocusAreaChanged2 = pCameraFocusAreaChanged;
        pCameraFocusAreaChanged2();
        pCameraFocusAreaChanged.unmarshall(byArray);
        RtcEngineMessage.PCameraFocusAreaChanged pCameraFocusAreaChanged3 = pCameraFocusAreaChanged2;
        int n2 = pCameraFocusAreaChanged3.x;
        int n3 = pCameraFocusAreaChanged3.y;
        int n4 = n2;
        int n5 = n2 + pCameraFocusAreaChanged2.width;
        n2 = n3 + pCameraFocusAreaChanged2.height;
        iRtcEngineEventHandler.onCameraFocusAreaChanged(new Rect(n4, n3, n5, n2));
    }

    private void onCameraExposureAreaChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCameraExposureAreaChanged pCameraExposureAreaChanged;
        RtcEngineMessage.PCameraExposureAreaChanged pCameraExposureAreaChanged2 = pCameraExposureAreaChanged;
        pCameraExposureAreaChanged2();
        pCameraExposureAreaChanged.unmarshall(byArray);
        RtcEngineMessage.PCameraExposureAreaChanged pCameraExposureAreaChanged3 = pCameraExposureAreaChanged2;
        int n2 = pCameraExposureAreaChanged3.x;
        int n3 = pCameraExposureAreaChanged3.y;
        int n4 = n2;
        int n5 = n2 + pCameraExposureAreaChanged2.width;
        n2 = n3 + pCameraExposureAreaChanged2.height;
        iRtcEngineEventHandler.onCameraExposureAreaChanged(new Rect(n4, n3, n5, n2));
    }

    private void onFacePositionChanged(byte[] objectArray, IRtcEngineEventHandler agoraFacePositionInfoArray) {
        RtcEngineMessage.PFaceDetectValue pFaceDetectValue;
        RtcEngineMessage.PFaceDetectValue pFaceDetectValue2;
        if (objectArray == null) {
            return;
        }
        RtcEngineMessage.PFaceDetectValue pFaceDetectValue3 = pFaceDetectValue2 = pFaceDetectValue;
        pFaceDetectValue3();
        pFaceDetectValue3.unmarshall((byte[])objectArray);
        this.faceRectArr = null;
        objectArray = pFaceDetectValue.rectArr;
        if (pFaceDetectValue.rectArr != null && objectArray.length > 0) {
            this.faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[objectArray.length];
            int n2 = 0;
            while (true) {
                Object object = pFaceDetectValue2.rectArr;
                if (n2 < pFaceDetectValue2.rectArr.length) {
                    IRtcEngineEventHandler.AgoraFacePositionInfo agoraFacePositionInfo;
                    object = object[n2];
                    IRtcEngineEventHandler.AgoraFacePositionInfo agoraFacePositionInfo2 = agoraFacePositionInfo;
                    agoraFacePositionInfo2();
                    agoraFacePositionInfo2.x = object.x;
                    agoraFacePositionInfo2.y = object.y;
                    agoraFacePositionInfo2.width = object.width;
                    agoraFacePositionInfo2.height = object.height;
                    agoraFacePositionInfo.distance = pFaceDetectValue2.disArr[n2];
                    this.faceRectArr[n2] = agoraFacePositionInfo2;
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            this.faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[0];
        }
        IRtcEngineEventHandler.AgoraFacePositionInfo[] agoraFacePositionInfoArray2 = agoraFacePositionInfoArray;
        RtcEngineMessage.PFaceDetectValue pFaceDetectValue4 = pFaceDetectValue2;
        int n3 = pFaceDetectValue4.imageWidth;
        int n4 = pFaceDetectValue4.imageHeight;
        agoraFacePositionInfoArray = this.faceRectArr;
        agoraFacePositionInfoArray2.onFacePositionChanged(n3, n4, agoraFacePositionInfoArray);
    }

    private void onVideoSizeChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PVideoSizeChanged pVideoSizeChanged = new RtcEngineMessage.PVideoSizeChanged();
        pVideoSizeChanged.unmarshall(byArray);
        int n2 = pVideoSizeChanged.uid;
        int n3 = pVideoSizeChanged.width;
        int n4 = pVideoSizeChanged.height;
        int n5 = pVideoSizeChanged.rotation;
        iRtcEngineEventHandler.onVideoSizeChanged(n2, n3, n4, n5);
    }

    private void onRtcChannelFirstRemoteVideoFrame(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PFirstRemoteVideoFrame pFirstRemoteVideoFrame = new RtcEngineMessage.PFirstRemoteVideoFrame();
        pFirstRemoteVideoFrame.unmarshall(byArray);
        int n2 = pFirstRemoteVideoFrame.uid;
        int n3 = pFirstRemoteVideoFrame.width;
        int n4 = pFirstRemoteVideoFrame.height;
        int n5 = pFirstRemoteVideoFrame.elapsed;
        iRtcChannelEventHandler.onFirstRemoteVideoFrame(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onRtcChannelVideoSizeChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PVideoSizeChanged pVideoSizeChanged = new RtcEngineMessage.PVideoSizeChanged();
        pVideoSizeChanged.unmarshall(byArray);
        int n2 = pVideoSizeChanged.uid;
        int n3 = pVideoSizeChanged.width;
        int n4 = pVideoSizeChanged.height;
        int n5 = pVideoSizeChanged.rotation;
        iRtcChannelEventHandler.onVideoSizeChanged(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onRemoteAudioStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteAudioState pRemoteAudioState = new RtcEngineMessage.PRemoteAudioState();
        pRemoteAudioState.unmarshall(byArray);
        int n2 = pRemoteAudioState.uid;
        int n3 = pRemoteAudioState.state;
        int n4 = pRemoteAudioState.reason;
        int n5 = pRemoteAudioState.elapsed;
        iRtcEngineEventHandler.onRemoteAudioStateChanged(n2, n3, n4, n5);
    }

    private void onRtcChannelRemoteAudioStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteAudioState pRemoteAudioState = new RtcEngineMessage.PRemoteAudioState();
        pRemoteAudioState.unmarshall(byArray);
        int n2 = pRemoteAudioState.uid;
        int n3 = pRemoteAudioState.state;
        int n4 = pRemoteAudioState.reason;
        int n5 = pRemoteAudioState.elapsed;
        iRtcChannelEventHandler.onRemoteAudioStateChanged(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onRtcChannelAudioPublishStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PPublishAudioState pPublishAudioState = new RtcEngineMessage.PPublishAudioState();
        pPublishAudioState.unmarshall(byArray);
        int n2 = pPublishAudioState.oldstate;
        int n3 = pPublishAudioState.newstate;
        int n4 = pPublishAudioState.elapsed;
        iRtcChannelEventHandler.onAudioPublishStateChanged(rtcChannelImpl, n2, n3, n4);
    }

    private void onRtcChannelVideoPublishStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PPublishVideoState pPublishVideoState = new RtcEngineMessage.PPublishVideoState();
        pPublishVideoState.unmarshall(byArray);
        int n2 = pPublishVideoState.oldstate;
        int n3 = pPublishVideoState.newstate;
        int n4 = pPublishVideoState.elapsed;
        iRtcChannelEventHandler.onVideoPublishStateChanged(rtcChannelImpl, n2, n3, n4);
    }

    private void onRtcChannelAudioSubscribeStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PSubscribeAudioState pSubscribeAudioState = new RtcEngineMessage.PSubscribeAudioState();
        pSubscribeAudioState.unmarshall(byArray);
        int n2 = pSubscribeAudioState.uid;
        int n3 = pSubscribeAudioState.oldstate;
        int n4 = pSubscribeAudioState.newstate;
        int n5 = pSubscribeAudioState.elapsed;
        iRtcChannelEventHandler.onAudioSubscribeStateChanged(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onRtcChannelVideoSubscribeStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PSubscribeVideoState pSubscribeVideoState = new RtcEngineMessage.PSubscribeVideoState();
        pSubscribeVideoState.unmarshall(byArray);
        int n2 = pSubscribeVideoState.uid;
        int n3 = pSubscribeVideoState.oldstate;
        int n4 = pSubscribeVideoState.newstate;
        int n5 = pSubscribeVideoState.elapsed;
        iRtcChannelEventHandler.onVideoSubscribeStateChanged(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onAudioPublishStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PPublishAudioState pPublishAudioState = new RtcEngineMessage.PPublishAudioState();
        pPublishAudioState.unmarshall(byArray);
        String string2 = pPublishAudioState.channel;
        int n2 = pPublishAudioState.oldstate;
        int n3 = pPublishAudioState.newstate;
        int n4 = pPublishAudioState.elapsed;
        iRtcEngineEventHandler.onAudioPublishStateChanged(string2, n2, n3, n4);
    }

    private void onVideoPublishStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PPublishVideoState pPublishVideoState = new RtcEngineMessage.PPublishVideoState();
        pPublishVideoState.unmarshall(byArray);
        String string2 = pPublishVideoState.channel;
        int n2 = pPublishVideoState.oldstate;
        int n3 = pPublishVideoState.newstate;
        int n4 = pPublishVideoState.elapsed;
        iRtcEngineEventHandler.onVideoPublishStateChanged(string2, n2, n3, n4);
    }

    private void onAudioSubscribeStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PSubscribeAudioState pSubscribeAudioState = new RtcEngineMessage.PSubscribeAudioState();
        pSubscribeAudioState.unmarshall(byArray);
        String string2 = pSubscribeAudioState.channel;
        int n2 = pSubscribeAudioState.uid;
        int n3 = pSubscribeAudioState.oldstate;
        int n4 = pSubscribeAudioState.newstate;
        int n5 = pSubscribeAudioState.elapsed;
        iRtcEngineEventHandler.onAudioSubscribeStateChanged(string2, n2, n3, n4, n5);
    }

    private void onVideoSubscribeStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PSubscribeVideoState pSubscribeVideoState = new RtcEngineMessage.PSubscribeVideoState();
        pSubscribeVideoState.unmarshall(byArray);
        String string2 = pSubscribeVideoState.channel;
        int n2 = pSubscribeVideoState.uid;
        int n3 = pSubscribeVideoState.oldstate;
        int n4 = pSubscribeVideoState.newstate;
        int n5 = pSubscribeVideoState.elapsed;
        iRtcEngineEventHandler.onVideoSubscribeStateChanged(string2, n2, n3, n4, n5);
    }

    private void onUserSuperResolutionEnabled(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PUserSuperResolutionEnabled pUserSuperResolutionEnabled = new RtcEngineMessage.PUserSuperResolutionEnabled();
        pUserSuperResolutionEnabled.unmarshall(byArray);
        int n2 = pUserSuperResolutionEnabled.uid;
        boolean bl = pUserSuperResolutionEnabled.enabled;
        int n3 = pUserSuperResolutionEnabled.reason;
        iRtcEngineEventHandler.onUserSuperResolutionEnabled(n2, bl, n3);
    }

    private void onVirtualBackgroundSourceEnabled(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PVirtualBackgroundSourceEnabled pVirtualBackgroundSourceEnabled = new RtcEngineMessage.PVirtualBackgroundSourceEnabled();
        pVirtualBackgroundSourceEnabled.unmarshall(byArray);
        boolean bl = pVirtualBackgroundSourceEnabled.enabled;
        iRtcEngineEventHandler.onVirtualBackgroundSourceEnabled(bl, pVirtualBackgroundSourceEnabled.reason);
    }

    private void onUploadLogResult(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PUploadLogResult pUploadLogResult = new RtcEngineMessage.PUploadLogResult();
        pUploadLogResult.unmarshall(byArray);
        String string2 = pUploadLogResult.requestId;
        boolean bl = pUploadLogResult.success;
        int n2 = pUploadLogResult.reason;
        iRtcEngineEventHandler.onUploadLogResult(string2, bl, n2);
    }

    private void onRtcChannelUserSuperResolutionEnabledExt(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PUserSuperResolutionEnabled pUserSuperResolutionEnabled = new RtcEngineMessage.PUserSuperResolutionEnabled();
        pUserSuperResolutionEnabled.unmarshall(byArray);
        int n2 = pUserSuperResolutionEnabled.uid;
        boolean bl = pUserSuperResolutionEnabled.enabled;
        int n3 = pUserSuperResolutionEnabled.reason;
        iRtcChannelEventHandler.onUserSuperResolutionEnabled(rtcChannelImpl, n2, bl, n3);
    }

    private void onRemoteVideoStateChangedExt(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteVideoStateExt pRemoteVideoStateExt = new RtcEngineMessage.PRemoteVideoStateExt();
        pRemoteVideoStateExt.unmarshall(byArray);
        int n2 = pRemoteVideoStateExt.uid;
        int n3 = pRemoteVideoStateExt.state;
        int n4 = pRemoteVideoStateExt.reason;
        int n5 = pRemoteVideoStateExt.elapsed;
        iRtcEngineEventHandler.onRemoteVideoStateChanged(n2, n3, n4, n5);
    }

    private void onRtcChannelRemoteVideoStateChangedExt(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteVideoStateExt pRemoteVideoStateExt = new RtcEngineMessage.PRemoteVideoStateExt();
        pRemoteVideoStateExt.unmarshall(byArray);
        int n2 = pRemoteVideoStateExt.uid;
        int n3 = pRemoteVideoStateExt.state;
        int n4 = pRemoteVideoStateExt.reason;
        int n5 = pRemoteVideoStateExt.elapsed;
        iRtcChannelEventHandler.onRemoteVideoStateChanged(rtcChannelImpl, n2, n3, n4, n5);
    }

    private void onStreamMessage(byte[] byArray, IRtcEngineEventHandler object) {
        IRtcEngineEventHandler iRtcEngineEventHandler = object;
        RtcEngineMessage.PStreamMessage pStreamMessage = new RtcEngineMessage.PStreamMessage();
        pStreamMessage.unmarshall(byArray);
        int n2 = pStreamMessage.uid;
        int n3 = pStreamMessage.streamId;
        object = pStreamMessage.payload;
        iRtcEngineEventHandler.onStreamMessage(n2, n3, (byte[])object);
    }

    private void onRtcChannelStreamMessage(byte[] byArray, IRtcChannelEventHandler object, RtcChannelImpl rtcChannelImpl) {
        IRtcChannelEventHandler iRtcChannelEventHandler = object;
        RtcEngineMessage.PStreamMessage pStreamMessage = new RtcEngineMessage.PStreamMessage();
        pStreamMessage.unmarshall(byArray);
        int n2 = pStreamMessage.uid;
        int n3 = pStreamMessage.streamId;
        object = pStreamMessage.payload;
        iRtcChannelEventHandler.onStreamMessage(rtcChannelImpl, n2, n3, (byte[])object);
    }

    private void onStreamMessageError(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PStreamMessageError pStreamMessageError = new RtcEngineMessage.PStreamMessageError();
        pStreamMessageError.unmarshall(byArray);
        int n2 = pStreamMessageError.uid;
        int n3 = pStreamMessageError.streamId;
        int n4 = pStreamMessageError.error;
        int n5 = pStreamMessageError.missed;
        int n6 = pStreamMessageError.cached;
        iRtcEngineEventHandler.onStreamMessageError(n2, n3, n4, n5, n6);
    }

    private void onRtcChannelStreamMessageError(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PStreamMessageError pStreamMessageError = new RtcEngineMessage.PStreamMessageError();
        pStreamMessageError.unmarshall(byArray);
        int n2 = pStreamMessageError.uid;
        int n3 = pStreamMessageError.streamId;
        int n4 = pStreamMessageError.error;
        int n5 = pStreamMessageError.missed;
        int n6 = pStreamMessageError.cached;
        iRtcChannelEventHandler.onStreamMessageError(rtcChannelImpl, n2, n3, n4, n5, n6);
    }

    private void onFirstLocalVideoFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalVideoFrame pFirstLocalVideoFrame = new RtcEngineMessage.PFirstLocalVideoFrame();
        pFirstLocalVideoFrame.unmarshall(byArray);
        int n2 = pFirstLocalVideoFrame.width;
        int n3 = pFirstLocalVideoFrame.height;
        int n4 = pFirstLocalVideoFrame.elapsed;
        iRtcEngineEventHandler.onFirstLocalVideoFrame(n2, n3, n4);
    }

    private void onFirstLocalVideoFramePublished(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalVideoFramePublished pFirstLocalVideoFramePublished = new RtcEngineMessage.PFirstLocalVideoFramePublished();
        pFirstLocalVideoFramePublished.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalVideoFramePublished(pFirstLocalVideoFramePublished.elapsed);
    }

    private void onRemoteVideoStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteVideoStat pRemoteVideoStat = new RtcEngineMessage.PRemoteVideoStat();
        pRemoteVideoStat.unmarshall(byArray);
        IRtcEngineEventHandler.RemoteVideoStats remoteVideoStats = pRemoteVideoStat.stats;
        if (remoteVideoStats.uid == 0) {
            return;
        }
        iRtcEngineEventHandler.onRemoteVideoStats(remoteVideoStats);
    }

    private void onRtcChannelRemoteVideoStat(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteVideoStat pRemoteVideoStat = new RtcEngineMessage.PRemoteVideoStat();
        pRemoteVideoStat.unmarshall(byArray);
        IRtcEngineEventHandler.RemoteVideoStats remoteVideoStats = pRemoteVideoStat.stats;
        if (remoteVideoStats.uid == 0) {
            return;
        }
        iRtcChannelEventHandler.onRemoteVideoStats(rtcChannelImpl, remoteVideoStats);
    }

    private void onRemoteAudioStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteAudioStat pRemoteAudioStat = new RtcEngineMessage.PRemoteAudioStat();
        pRemoteAudioStat.unmarshall(byArray);
        IRtcEngineEventHandler.RemoteAudioStats remoteAudioStats = pRemoteAudioStat.stats;
        if (remoteAudioStats.uid == 0) {
            return;
        }
        iRtcEngineEventHandler.onRemoteAudioStats(remoteAudioStats);
    }

    private void onRtcChannelRemoteAudioStat(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteAudioStat pRemoteAudioStat = new RtcEngineMessage.PRemoteAudioStat();
        pRemoteAudioStat.unmarshall(byArray);
        IRtcEngineEventHandler.RemoteAudioStats remoteAudioStats = pRemoteAudioStat.stats;
        if (remoteAudioStats.uid == 0) {
            return;
        }
        iRtcChannelEventHandler.onRemoteAudioStats(rtcChannelImpl, remoteAudioStats);
    }

    private void onLocalAudioStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PLocalAudioStat pLocalAudioStat = new RtcEngineMessage.PLocalAudioStat();
        pLocalAudioStat.unmarshall(byArray);
        iRtcEngineEventHandler.onLocalAudioStats(pLocalAudioStat.stats);
    }

    private void onLocalVideoStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PLocalVideoStat pLocalVideoStat = new RtcEngineMessage.PLocalVideoStat();
        pLocalVideoStat.unmarshall(byArray);
        iRtcEngineEventHandler.onLocalVideoStats(pLocalVideoStat.stats);
    }

    private void onRequestAudioFileInfo(byte[] object, IRtcEngineEventHandler iRtcEngineEventHandler) {
        IRtcEngineEventHandler.AudioFileInfo audioFileInfo;
        RtcEngineMessage.PAudioFileInfo pAudioFileInfo;
        RtcEngineMessage.PAudioFileInfo pAudioFileInfo2 = pAudioFileInfo;
        pAudioFileInfo2();
        pAudioFileInfo.unmarshall((byte[])object);
        object = audioFileInfo;
        object();
        object.filePath = pAudioFileInfo2.filePath;
        audioFileInfo.durationMs = pAudioFileInfo2.durationMs;
        iRtcEngineEventHandler.onRequestAudioFileInfo((IRtcEngineEventHandler.AudioFileInfo)object, pAudioFileInfo.error);
    }

    private void onFirstRemoteVideoFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteVideoFrame pFirstRemoteVideoFrame = new RtcEngineMessage.PFirstRemoteVideoFrame();
        pFirstRemoteVideoFrame.unmarshall(byArray);
        int n2 = pFirstRemoteVideoFrame.uid;
        int n3 = pFirstRemoteVideoFrame.width;
        int n4 = pFirstRemoteVideoFrame.height;
        int n5 = pFirstRemoteVideoFrame.elapsed;
        iRtcEngineEventHandler.onFirstRemoteVideoFrame(n2, n3, n4, n5);
    }

    private void onFirstLocalAudioFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalAudioFrame pFirstLocalAudioFrame = new RtcEngineMessage.PFirstLocalAudioFrame();
        pFirstLocalAudioFrame.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalAudioFrame(pFirstLocalAudioFrame.elapsed);
    }

    private void onFirstLocalAudioFramePublished(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalAudioFramePublished pFirstLocalAudioFramePublished = new RtcEngineMessage.PFirstLocalAudioFramePublished();
        pFirstLocalAudioFramePublished.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalAudioFramePublished(pFirstLocalAudioFramePublished.elapsed);
    }

    private void onFirstRemoteAudioFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteAudioFrame pFirstRemoteAudioFrame = new RtcEngineMessage.PFirstRemoteAudioFrame();
        pFirstRemoteAudioFrame.unmarshall(byArray);
        int n2 = pFirstRemoteAudioFrame.uid;
        iRtcEngineEventHandler.onFirstRemoteAudioFrame(n2, pFirstRemoteAudioFrame.elapsed);
    }

    private void onChannelMediaRelayStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCrossChannelState pCrossChannelState = new RtcEngineMessage.PCrossChannelState();
        pCrossChannelState.unmarshall(byArray);
        int n2 = pCrossChannelState.state;
        iRtcEngineEventHandler.onChannelMediaRelayStateChanged(n2, pCrossChannelState.code);
    }

    private void onRtcChannelChannelMediaRelayStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PCrossChannelState pCrossChannelState = new RtcEngineMessage.PCrossChannelState();
        pCrossChannelState.unmarshall(byArray);
        int n2 = pCrossChannelState.state;
        int n3 = pCrossChannelState.code;
        iRtcChannelEventHandler.onChannelMediaRelayStateChanged(rtcChannelImpl, n2, n3);
    }

    private void onChannelMediaRelayEvent(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCrossChannelEvent pCrossChannelEvent = new RtcEngineMessage.PCrossChannelEvent();
        pCrossChannelEvent.unmarshall(byArray);
        iRtcEngineEventHandler.onChannelMediaRelayEvent(pCrossChannelEvent.code);
    }

    private void onRtcChannelChannelMediaRelayEvent(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PCrossChannelEvent pCrossChannelEvent = new RtcEngineMessage.PCrossChannelEvent();
        pCrossChannelEvent.unmarshall(byArray);
        iRtcChannelEventHandler.onChannelMediaRelayEvent(rtcChannelImpl, pCrossChannelEvent.code);
    }

    private void onSpeakersReport(byte[] objectArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PMediaResSpeakersReport pMediaResSpeakersReport;
        if (objectArray == null) {
            return;
        }
        RtcEngineMessage.PMediaResSpeakersReport pMediaResSpeakersReport2 = pMediaResSpeakersReport;
        new RtcEngineMessage.PMediaResSpeakersReport().unmarshall((byte[])objectArray);
        objectArray = pMediaResSpeakersReport2.speakers;
        if (pMediaResSpeakersReport2.speakers != null && objectArray.length >= 0) {
            objectArray = new IRtcEngineEventHandler.AudioVolumeInfo[objectArray.length];
            for (int i2 = 0; i2 < pMediaResSpeakersReport2.speakers.length; ++i2) {
                RtcEngineMessage.PMediaResSpeakersReport.Speaker[] speakerArray;
                RtcEngineMessage.PMediaResSpeakersReport.Speaker[] speakerArray2 = speakerArray;
                speakerArray = new IRtcEngineEventHandler.AudioVolumeInfo();
                objectArray[i2] = (byte)speakerArray2;
                speakerArray2 = pMediaResSpeakersReport2.speakers;
                objectArray[i2].uid = pMediaResSpeakersReport2.speakers[i2].uid;
                objectArray[i2].volume = speakerArray2[i2].volume;
                objectArray[i2].vad = speakerArray2[i2].vad;
                objectArray[i2].channelId = speakerArray2[i2].channelId;
            }
            iRtcEngineEventHandler.onAudioVolumeIndication((IRtcEngineEventHandler.AudioVolumeInfo[])objectArray, pMediaResSpeakersReport2.mixVolume);
        } else {
            iRtcEngineEventHandler.onAudioVolumeIndication(new IRtcEngineEventHandler.AudioVolumeInfo[0], 0);
        }
    }

    private void sendLogEvent(byte[] byArray) {
        String string2;
        RtcEngineImpl rtcEngineImpl;
        try {
            rtcEngineImpl = string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        String string3 = string2;
        string2 = new String(byArray, "ISO-8859-1");
        rtcEngineImpl.onLogEvent(0, string3);
    }

    private RtcEngineMessage.PVideoNetOptions getOptionsByVideoProfile(int n2) {
        block4: {
            byte[] byArray;
            try {
                byArray = RtcEngineImpl.nativeGetOptionsByVideoProfile(((RtcEngineImpl)object).mNativeHandle, n2);
            }
            catch (Exception exception) {}
            Object object = byArray;
            if (byArray == null) break block4;
            RtcEngineMessage.PVideoNetOptions pVideoNetOptions = new RtcEngineMessage.PVideoNetOptions();
            pVideoNetOptions.unmarshall((byte[])object);
            return pVideoNetOptions;
        }
        return null;
    }

    private int setRootContext(EglBase.Context context) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetEglBaseRootContext(rtcEngineImpl.mNativeHandle, context);
    }

    private static String inetAddressToIpAddress(InetAddress inetAddress) {
        if (!inetAddress.isLoopbackAddress()) {
            if (inetAddress instanceof Inet4Address) {
                return ((Inet4Address)inetAddress).getHostAddress();
            }
            boolean cfr_ignored_0 = inetAddress instanceof Inet6Address;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getLocalHost() {
        try {
            for (Object object : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (((NetworkInterface)object).getName().startsWith("usb")) continue;
                object = Collections.list(((NetworkInterface)object).getInetAddresses()).iterator();
                while (object.hasNext()) {
                    String string2 = RtcEngineImpl.inetAddressToIpAddress((InetAddress)object.next());
                    if (string2 == null || string2.isEmpty()) continue;
                    return string2;
                }
            }
            return null;
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean joinChannelFirstTimeOrAllChannelLeft() {
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (rtcEngineImpl.mDefaultRtcChannel != null) {
                // ** MonitorExit[this] (shouldn't be in output)
                return false;
            }
            boolean bl = true;
            Iterator iterator = this.mRtcChannels.iterator();
            do {
                if (!iterator.hasNext()) return bl;
            } while (!((RtcChannelImpl)iterator.next()).hasJoined());
            return false;
        }
    }

    private int setParameter(String string2, boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = bl;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":%b}", objectArray3));
    }

    private int setParameter(String string2, int n2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = n2;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", objectArray3));
    }

    private int setParameter(String string2, long l2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = l2;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", objectArray3));
    }

    private int setParameter(String string2, double d2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = d2;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":%f}", objectArray3));
    }

    private int setParameter(String string2, String string3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":\"%s\"}", objectArray3));
    }

    private int setParameterObject(String string2, String string3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"%s\":%s}", objectArray3));
    }

    private int adjustEffectsPlayoutVolume(int n2) {
        return this.setParameter("che.audio.set_effect_file_playout_volume", n2);
    }

    private int adjustEffectsPublishVolume(int n2) {
        return this.setParameter("che.audio.set_effect_file_publish_volume", n2);
    }

    private int getEffectsPlayoutVolume() {
        RtcEngineImpl rtcEngineImpl = this;
        int n2 = rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_effect_file_playout_volume", null);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private synchronized boolean checkStatus() {
        if (this.mNativeHandle != 0L) {
            return true;
        }
        throw new IllegalStateException("RtcEngine does not initialize or it may be destroyed");
    }

    private static native int nativeClassInit();

    private native long nativeObjectInit(Object var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    private native long nativeObjectInitWithConfig(Object var1);

    private native int nativeDestroy(long var1);

    private native int nativeSetProfile(long var1, String var3, boolean var4);

    private native int nativeSetEncryptionSecret(long var1, String var3);

    private native int nativeEnableEncryption(long var1, boolean var3, int var4, String var5, byte[] var6);

    private native int nativeSetAppType(long var1, int var3);

    private native String nativeGetProfile(long var1);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetParameters(long var1, String var3);

    private native String nativeGetParameter(long var1, String var3, String var4);

    private native int nativeGetIntParameter(long var1, String var3, String var4);

    private native int nativeJoinChannel(long var1, byte[] var3, String var4, String var5, String var6, int var7, Object var8);

    private native int nativeSwitchChannel(long var1, String var3, String var4, Object var5);

    private native int nativeLeaveChannel(long var1);

    private native int nativeRegisterLocalUserAccount(long var1, String var3, String var4);

    private native int nativeJoinChannelWithUserAccount(long var1, String var3, String var4, String var5, Object var6);

    private native int nativeGetUserInfoByUserAccount(long var1, String var3, Object var4);

    private native int nativeGetUserInfoByUid(long var1, int var3, Object var4);

    private native int nativeStartEchoTest(long var1, byte[] var3);

    private native int nativeStartEchoTestWithInterval(long var1, byte[] var3, int var4);

    private native int nativeStopEchoTest(long var1);

    private native int nativeSetCloudProxy(long var1, int var3);

    private native int nativeSwitchCamera(long var1);

    private native int nativeSwitchCameraByDirection(long var1, int var3);

    private native int nativeStartPreview(long var1);

    private native int nativeStartLastmileProbeTest(long var1, byte[] var3, boolean var4, boolean var5, int var6, int var7);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeCreateDataStream(long var1, boolean var3, boolean var4);

    private native int nativeCreateDataStream2(long var1, boolean var3, boolean var4);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeAddPublishStreamUrl(long var1, String var3, boolean var4);

    private native int nativeRemovePublishStreamUrl(long var1, String var3);

    private native int nativeSetLiveTranscoding(long var1, byte[] var3);

    private native int nativeAddInjectStreamUrl(long var1, String var3, byte[] var4);

    private native int nativeRemoveInjectStreamUrl(long var1, String var3);

    private native int nativeRenewChannelKey(long var1, String var3);

    private native int nativeRenewToken(long var1, String var3);

    static native int nativeLog(int var0, String var1);

    private native int nativeSendCustomReportMessage(long var1, String var3, String var4, String var5, String var6, int var7);

    private native int nativeSetupVideoRemote(long var1, View var3, int var4, String var5, int var6, int var7);

    private native int nativeSetupVideoLocal(long var1, View var3, int var4, int var5);

    private native int nativeSetRemoteRenderMode(long var1, int var3, int var4);

    private native int nativeSetRemoteRenderModeWithMirrorMode(long var1, int var3, int var4, int var5);

    private native int nativeSetLocalVideoMirrorMode(long var1, int var3);

    private native int nativeSetEglBaseRootContext(long var1, EglBase.Context var3);

    private native int nativeSetEGL10Context(long var1, javax.microedition.khronos.egl.EGLContext var3);

    private native int nativeSetEGL14Context(long var1, EGLContext var3);

    private native int nativeSetEGL10TextureId(long var1, int var3, javax.microedition.khronos.egl.EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetEGL14TextureId(long var1, int var3, EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetVideoProfileEx(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetAudioProfile(long var1, int var3, int var4);

    private native int nativeSetVideoEncoderConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native int nativeAddVideoWatermark(long var1, String var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private native int nativeClearVideoWatermarks(long var1);

    private native int nativeSetBeautyEffectOptions(long var1, boolean var3, int var4, float var5, float var6, float var7);

    private native int nativeEnableVirtualBackground(long var1, boolean var3, Object var4);

    private native int nativeSetRemoteUserPriority(long var1, int var3, int var4);

    private native int nativeStartChannelMediaRelay(long var1, byte[] var3);

    private native int nativeStopChannelMediaRelay(long var1);

    private native int nativePauseAllChannelMediaRelay(long var1);

    private native int nativeResumeAllChannelMediaRelay(long var1);

    private native int nativeUpdateChannelMediaRelay(long var1, byte[] var3);

    private native int nativeSetScreenCaptureContentHint(long var1, int var3);

    private native int nativeStartDumpVideoReceiveTrack(long var1, int var3, String var4);

    private native int nativeStopDumpVideoReceiveTrack(long var1);

    private native String nativeMakeQualityReportUrl(long var1, String var3, int var4, int var5, int var6);

    private native String nativeGetCallId(long var1);

    private native int nativeRate(long var1, String var3, int var4, String var5);

    private native int nativeComplain(long var1, String var3, String var4);

    private native int nativeRegisterAudioFrameObserver(long var1, Object var3);

    private native int nativeRegisterVideoEncodedFrameObserver(long var1, Object var3);

    private native int nativeRegisterVideoFrameObserver(long var1, Object var3);

    private native int nativePullAudioFrame(long var1, byte[] var3, int var4, int var5);

    private native int nativePushExternalAudioFrameRawData(long var1, byte[] var3, long var4, int var6, int var7);

    private native int nativePushExternalAudioFrameRawDataExt(long var1, byte[] var3, long var4, int var6, int var7, int var8, int var9);

    private native int nativeSetApiCallMode(long var1, int var3);

    public static native String nativeGetSdkVersion();

    public static native String nativeGetChatEngineVersion();

    public static native String nativeGetErrorDescription(int var0);

    private static native byte[] nativeGetOptionsByVideoProfile(long var0, int var2);

    private native long nativeGetHandle(long var1);

    private native String nativeUploadLogFile(long var1);

    private native int setExtVideoSource(long var1, int var3, int var4);

    private native int deliverFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13);

    private native int nativeAddVideoCapturer(long var1, IVideoSource var3, int var4);

    private native int nativeAddLocalVideoRender(long var1, IVideoSink var3, int var4);

    private native int nativeAddRemoteVideoRender(long var1, int var3, IVideoSink var4, int var5);

    private native int nativeRemoveVideoReceiveTrack(long var1, int var3);

    private native int nativeGetConncetionState(long var1);

    private native int nativeEnableRemoteSuperResolution(long var1, int var3, boolean var4);

    private native int nativeRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeSetLogWriter(long var1, Object var3);

    private native int nativeReleaseLogWriter(long var1);

    private native int nativeEnableVideo(long var1);

    private native int nativeDisableVideo(long var1);

    private native int nativeEnableAudio(long var1);

    private native int nativeDisableAudio(long var1);

    private native int nativeMuteLocalAudioStream(long var1, boolean var3);

    private native int nativeMuteLocalVideoStream(long var1, boolean var3);

    private native int nativeMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeSetDefaultAudioRoutetoSpeakerphone(long var1, boolean var3);

    private native int nativeEnableDeepLearningDenoise(long var1, boolean var3);

    private native int nativeEnableLocalAudio(long var1, boolean var3);

    private native int nativeSetEnableSpeakerphone(long var1, boolean var3);

    private native boolean nativeIsSpeakerphoneEnabled(long var1);

    private native int nativeSetChannelProfile(long var1, int var3);

    private native int nativeSetClientRole(long var1, int var3);

    private native int nativeSetClientRoleOptions(long var1, int var3, Object var4);

    private native int nativeStartAudioRecording(long var1, String var3, int var4, int var5, int var6, int var7);

    private native int nativeStopAudioRecording(long var1);

    private native int nativeSetLocalAccessPoint(long var1, ArrayList<String> var3, String var4);

    private native long nativeGetDefaultRtcChannel(long var1);

    private native long nativeCreateRtcChannel(long var1, String var3);

    private native int nativeRtcChannelRelease(long var1);

    private static native int nativeDeviceChanged(long var0);

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDestroy() {
        Object object;
        block8: {
            try {
                object = (Context)this.mContext.get();
                if (object == null) break block8;
            }
            catch (Exception exception) {
                Logging.e(exception.getMessage());
                break block8;
            }
            {
                this.unRegisterBroadcstReceiver((Context)object);
            }
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.setExternalVideoSource(false, false, true);
        rtcEngineImpl.doStopMonitorSystemEvent();
        synchronized (rtcEngineImpl) {
            if (rtcEngineImpl.mDefaultRtcChannel != null) {
                this.mDefaultRtcChannel.onEngineDestroy();
            }
            object = this.mRtcChannels.iterator();
            while (object.hasNext()) {
                ((RtcChannelImpl)object.next()).onEngineDestroy();
            }
            RtcEngineImpl rtcEngineImpl2 = this;
            RtcEngineImpl rtcEngineImpl3 = rtcEngineImpl2;
            // ** MonitorExit[v2] (shouldn't be in output)
            rtcEngineImpl2.nativeDestroy(rtcEngineImpl2.mNativeHandle);
            rtcEngineImpl3.mNativeHandle = 0L;
            return;
        }
    }

    public void reinitialize(Context context, String string2, IRtcEngineEventHandler iRtcEngineEventHandler) {
        this.addHandler(iRtcEngineEventHandler);
    }

    @Override
    public void addHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        this.mRtcHandlers.put(iRtcEngineEventHandler, 0);
    }

    @Override
    public void removeHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (this.mRtcHandlers.containsKey(iRtcEngineEventHandler)) {
            this.mRtcHandlers.remove(iRtcEngineEventHandler);
        }
    }

    @Override
    public int setupRemoteVideo(VideoCanvas videoCanvas) {
        RtcEngineImpl.checkIfInUIThread("setupRemoteVideo");
        if (videoCanvas != null) {
            String string2 = videoCanvas.channelId;
            if (string2 != null) {
                VideoCanvas videoCanvas2 = videoCanvas;
                long l2 = this.mNativeHandle;
                View view = videoCanvas2.view;
                int n2 = videoCanvas2.renderMode;
                int n3 = videoCanvas2.uid;
                int n4 = videoCanvas2.mirrorMode;
                return this.nativeSetupVideoRemote(l2, view, n2, string2, n3, n4);
            }
            VideoCanvas videoCanvas3 = videoCanvas;
            long l3 = this.mNativeHandle;
            string2 = videoCanvas3.view;
            int n5 = videoCanvas3.renderMode;
            int n6 = videoCanvas3.uid;
            int n7 = videoCanvas3.mirrorMode;
            return this.nativeSetupVideoRemote(l3, (View)string2, n5, "", n6, n7);
        }
        return -1;
    }

    @Override
    public int sendCustomReportMessage(String string2, String string3, String string4, String string5, int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSendCustomReportMessage(rtcEngineImpl.mNativeHandle, string2, string3, string4, string5, n2);
    }

    @Override
    public int setupLocalVideo(VideoCanvas videoCanvas) {
        RtcEngineImpl.checkIfInUIThread("setupLocalVideo");
        if (this.mVideoSourceType == 3) {
            return -1;
        }
        if (videoCanvas != null) {
            VideoCanvas videoCanvas2 = videoCanvas;
            this.mUseLocalView = true;
            long l2 = this.mNativeHandle;
            View view = videoCanvas2.view;
            int n2 = videoCanvas2.renderMode;
            int n3 = videoCanvas2.mirrorMode;
            this.nativeSetupVideoLocal(l2, view, n2, n3);
        } else {
            RtcEngineImpl rtcEngineImpl = this;
            rtcEngineImpl.mUseLocalView = false;
            rtcEngineImpl.nativeSetupVideoLocal(rtcEngineImpl.mNativeHandle, null, 1, 0);
        }
        return 0;
    }

    @Override
    public int setLocalRenderMode(int n2) {
        return this.setRemoteRenderMode(0, n2);
    }

    @Override
    public int setLocalRenderMode(int n2, int n3) {
        return this.setRemoteRenderMode(0, n2, n3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetRemoteRenderMode(rtcEngineImpl.mNativeHandle, (int)((long)n2 & 0xFFFFFFFFL), n3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3, int n4) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetRemoteRenderModeWithMirrorMode(rtcEngineImpl.mNativeHandle, (int)((long)n2 & 0xFFFFFFFFL), n3, n4);
    }

    @Override
    public int setLocalVideoMirrorMode(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetLocalVideoMirrorMode(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int addVideoWatermark(AgoraImage agoraImage) {
        WatermarkOptions watermarkOptions = null;
        String string2 = null;
        if (agoraImage != null) {
            WatermarkOptions.Rectangle rectangle;
            WatermarkOptions watermarkOptions2;
            string2 = agoraImage.url;
            watermarkOptions = watermarkOptions2;
            new WatermarkOptions().visibleInPreview = false;
            WatermarkOptions.Rectangle rectangle2 = rectangle;
            AgoraImage agoraImage2 = agoraImage;
            int n2 = agoraImage2.x;
            int n3 = agoraImage2.y;
            int n4 = agoraImage2.width;
            int n5 = agoraImage2.height;
            rectangle = new WatermarkOptions.Rectangle(n2, n3, n4, n5);
            new WatermarkOptions().positionInLandscapeMode = rectangle2;
            new WatermarkOptions().positionInPortraitMode = rectangle2;
        }
        return this.addVideoWatermark(string2, watermarkOptions);
    }

    @Override
    public int addVideoWatermark(String string2, WatermarkOptions watermarkOptions) {
        if (string2 != null && !TextUtils.isEmpty((CharSequence)string2) && watermarkOptions != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            WatermarkOptions.Rectangle rectangle = watermarkOptions.positionInLandscapeMode;
            if (rectangle != null) {
                WatermarkOptions.Rectangle rectangle2 = rectangle;
                n2 = rectangle2.x;
                n3 = rectangle2.y;
                n4 = rectangle2.width;
                n5 = rectangle2.height;
            }
            if ((rectangle = watermarkOptions.positionInPortraitMode) != null) {
                WatermarkOptions.Rectangle rectangle3 = rectangle;
                n6 = rectangle3.x;
                n7 = rectangle3.y;
                n8 = rectangle3.width;
                n9 = rectangle3.height;
            }
            long l2 = this.mNativeHandle;
            boolean bl = watermarkOptions.visibleInPreview;
            return this.nativeAddVideoWatermark(l2, string2, bl, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        return -2;
    }

    @Override
    public int clearVideoWatermarks() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeClearVideoWatermarks(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int enableDualStreamMode(boolean bl) {
        Object[] objectArray = new Object[2];
        objectArray[0] = bl;
        int n2 = 1;
        objectArray[n2] = bl ? 1 : 0;
        return this.setParameters(String.format("{\"rtc.dual_stream_mode\":%b,\"che.video.enableLowBitRateStream\":%d}", objectArray));
    }

    @Override
    @Deprecated
    public void monitorHeadsetEvent(boolean bl) {
        Logging.i(TAG, "enter monitorHeadsetEvent:" + bl);
    }

    @Override
    @Deprecated
    @TargetApi(value=11)
    public void monitorBluetoothHeadsetEvent(boolean bl) {
        Logging.i(TAG, "enter monitorBluetoothHeadsetEvent:" + bl);
    }

    @Override
    public boolean enableHighPerfWifiMode(boolean bl) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return false;
        }
        if (bl) {
            int n2 = Process.myUid();
            if (context.checkPermission("android.permission.WAKE_LOCK", Process.myPid(), n2) != 0) {
                this.mWifiLock = null;
                return false;
            }
            if (this.mWifiLock == null) {
                this.mWifiLock = ((WifiManager)context.getSystemService("wifi")).createWifiLock(3, "agora.voip.lock");
            }
        } else {
            this.mWifiLock = null;
        }
        return true;
    }

    public IRtcEngineEventHandler.RtcStats getRtcStats() {
        if (this.mRtcStats == null) {
            IRtcEngineEventHandler.RtcStats rtcStats;
            IRtcEngineEventHandler.RtcStats rtcStats2 = rtcStats;
            rtcStats = new IRtcEngineEventHandler.RtcStats();
            this.mRtcStats = rtcStats2;
        }
        return this.mRtcStats;
    }

    public synchronized void updateRtcStats(RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats) {
        if ((this = ((RtcEngineImpl)this).getRtcStats()) == null) {
            return;
        }
        ((IRtcEngineEventHandler.RtcStats)this).totalDuration = pMediaResRtcStats.totalDuration;
        ((IRtcEngineEventHandler.RtcStats)this).txBytes = pMediaResRtcStats.totalTxBytes;
        ((IRtcEngineEventHandler.RtcStats)this).rxBytes = pMediaResRtcStats.totalRxBytes;
        ((IRtcEngineEventHandler.RtcStats)this).txAudioBytes = pMediaResRtcStats.txAudioBytes;
        ((IRtcEngineEventHandler.RtcStats)this).txVideoBytes = pMediaResRtcStats.txVideoBytes;
        ((IRtcEngineEventHandler.RtcStats)this).rxAudioBytes = pMediaResRtcStats.rxAudioBytes;
        ((IRtcEngineEventHandler.RtcStats)this).rxVideoBytes = pMediaResRtcStats.rxVideoBytes;
        ((IRtcEngineEventHandler.RtcStats)this).txKBitRate = pMediaResRtcStats.txKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).rxKBitRate = pMediaResRtcStats.rxKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).txAudioKBitRate = pMediaResRtcStats.txAudioKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).rxAudioKBitRate = pMediaResRtcStats.rxAudioKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).txVideoKBitRate = pMediaResRtcStats.txVideoKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).rxVideoKBitRate = pMediaResRtcStats.rxVideoKBitRate;
        ((IRtcEngineEventHandler.RtcStats)this).lastmileDelay = pMediaResRtcStats.lastmileDelay;
        ((IRtcEngineEventHandler.RtcStats)this).txPacketLossRate = pMediaResRtcStats.txPacketLossRate;
        ((IRtcEngineEventHandler.RtcStats)this).rxPacketLossRate = pMediaResRtcStats.rxPacketLossRate;
        ((IRtcEngineEventHandler.RtcStats)this).users = pMediaResRtcStats.users;
        ((IRtcEngineEventHandler.RtcStats)this).cpuTotalUsage = (double)pMediaResRtcStats.cpuTotalUsage / 100.0;
        ((IRtcEngineEventHandler.RtcStats)this).cpuAppUsage = (double)pMediaResRtcStats.cpuAppUsage / 100.0;
        ((IRtcEngineEventHandler.RtcStats)this).gatewayRtt = pMediaResRtcStats.gatewayRtt;
        ((IRtcEngineEventHandler.RtcStats)this).memoryAppUsageRatio = pMediaResRtcStats.memoryAppUsageRatio;
        ((IRtcEngineEventHandler.RtcStats)this).memoryTotalUsageRatio = pMediaResRtcStats.memoryTotalUsageRatio;
        ((IRtcEngineEventHandler.RtcStats)this).memoryAppUsageInKbytes = pMediaResRtcStats.memoryAppUsageInKbytes;
        ((IRtcEngineEventHandler.RtcStats)this).videoMosValue = pMediaResRtcStats.videoMosValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannel(String string2, String string3, String string4, int n2) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doJoinChannelCheck(context);
        int n3 = rtcEngineImpl.nativeJoinChannel(rtcEngineImpl.mNativeHandle, null, string2, string3, string4, n2, null);
        synchronized (rtcEngineImpl) {
            block8: {
                if (rtcEngineImpl.mDefaultRtcChannel != null) break block8;
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n3 == 0) {
                RtcEngineImpl rtcEngineImpl2 = this;
                this.mDefaultRtcChannel.initialize(rtcEngineImpl2, rtcEngineImpl2.nativeGetDefaultRtcChannel(rtcEngineImpl2.mNativeHandle));
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannel(String string2, String string3, String string4, int n2, ChannelMediaOptions channelMediaOptions) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doJoinChannelCheck(context);
        int n3 = rtcEngineImpl.nativeJoinChannel(rtcEngineImpl.mNativeHandle, null, string2, string3, string4, n2, channelMediaOptions);
        synchronized (rtcEngineImpl) {
            block9: {
                if (rtcEngineImpl.mDefaultRtcChannel != null) break block9;
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n3 == 0) {
                RtcEngineImpl rtcEngineImpl2 = this;
                this.mDefaultRtcChannel.initialize(rtcEngineImpl2, rtcEngineImpl2.nativeGetDefaultRtcChannel(rtcEngineImpl2.mNativeHandle));
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return n3;
        }
    }

    @Override
    public int switchChannel(String string2, String string3) {
        ChannelMediaOptions channelMediaOptions;
        RtcEngineImpl rtcEngineImpl = channelMediaOptions2;
        ChannelMediaOptions channelMediaOptions2 = channelMediaOptions;
        new ChannelMediaOptions().autoSubscribeAudio = true;
        new ChannelMediaOptions().autoSubscribeVideo = true;
        return rtcEngineImpl.switchChannel(string2, string3, channelMediaOptions2);
    }

    @Override
    public int switchChannel(String string2, String string3, ChannelMediaOptions channelMediaOptions) {
        if (channelMediaOptions == null) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSwitchChannel(rtcEngineImpl.mNativeHandle, string2, string3, channelMediaOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int leaveChannel() {
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (rtcEngineImpl.mDefaultRtcChannel != null) {
                this.mDefaultRtcChannel = null;
            }
            RtcEngineImpl rtcEngineImpl2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            rtcEngineImpl2.doLeaveChannelCheck();
            return rtcEngineImpl2.nativeLeaveChannel(rtcEngineImpl2.mNativeHandle);
        }
    }

    @Override
    public int startEchoTest() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doMonitorSystemEvent(context);
        return rtcEngineImpl.nativeStartEchoTest(rtcEngineImpl.mNativeHandle, null);
    }

    @Override
    public int startEchoTest(int n2) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doMonitorSystemEvent(context);
        return rtcEngineImpl.nativeStartEchoTestWithInterval(rtcEngineImpl.mNativeHandle, null, n2);
    }

    @Override
    public int stopEchoTest() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStopEchoTest(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setCloudProxy(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetCloudProxy(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int enableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", true);
    }

    @Override
    public int disableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", false);
    }

    @Override
    public int startLastmileProbeTest(LastmileProbeConfig lastmileProbeConfig) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        LastmileProbeConfig lastmileProbeConfig2 = lastmileProbeConfig;
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doMonitorSystemEvent(context);
        long l2 = rtcEngineImpl.mNativeHandle;
        boolean bl = lastmileProbeConfig2.probeUplink;
        boolean bl2 = lastmileProbeConfig2.probeDownlink;
        int n2 = lastmileProbeConfig2.expectedUplinkBitrate;
        int n3 = lastmileProbeConfig2.expectedDownlinkBitrate;
        return this.nativeStartLastmileProbeTest(l2, null, bl, bl2, n2, n3);
    }

    @Override
    public int stopLastmileProbeTest() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStopLastmileProbeTest(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setLocalAccessPoint(ArrayList<String> arrayList, String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetLocalAccessPoint(rtcEngineImpl.mNativeHandle, arrayList, string2);
    }

    @Override
    public int enableVideo() {
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.mLocalVideoEnabled = true;
        return rtcEngineImpl.nativeEnableVideo(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int disableVideo() {
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.mLocalVideoEnabled = false;
        return rtcEngineImpl.nativeDisableVideo(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int enableLocalVideo(boolean bl) {
        objectArray2.mLocalVideoEnabled = bl;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = bl;
        objectArray2[1] = bl;
        objectArray2[2] = bl;
        objectArray[3] = bl;
        return objectArray2.setParameters(String.format("{\"rtc.video.capture\":%b,\"che.video.local.capture\":%b,\"che.video.local.render\":%b,\"che.video.local.send\":%b}", objectArray2));
    }

    @Override
    public int startPreview() {
        if (this.mVideoSourceType == 3) {
            return -4;
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStartPreview(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int stopPreview() {
        return this.setParameter("rtc.video.preview", false);
    }

    @Override
    public int enableAudio() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeEnableAudio(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int enableLocalAudio(boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeEnableLocalAudio(rtcEngineImpl.mNativeHandle, bl);
    }

    @Override
    public int disableAudio() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeDisableAudio(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int pauseAudio() {
        return this.setParameter("rtc.audio.paused", true);
    }

    @Override
    public int resumeAudio() {
        return this.setParameter("rtc.audio.paused", false);
    }

    @Override
    public int muteLocalAudioStream(boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeMuteLocalAudioStream(rtcEngineImpl.mNativeHandle, bl);
    }

    @Override
    public int muteLocalVideoStream(boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeMuteLocalVideoStream(rtcEngineImpl.mNativeHandle, bl);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean bl) {
        return this.setParameter("rtc.audio.mute_peers", bl);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean bl) {
        return this.setParameter("rtc.audio.set_default_mute_peers", bl);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeMuteAllRemoteVideoStreams(rtcEngineImpl.mNativeHandle, bl);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean bl) {
        return this.setParameter("rtc.video.set_default_mute_peers", bl);
    }

    @Override
    public int setBeautyEffectOptions(boolean bl, BeautyOptions beautyOptions) {
        if (Build.VERSION.SDK_INT < 21) {
            return -4;
        }
        if (beautyOptions == null) {
            BeautyOptions beautyOptions2;
            if (bl) {
                return -2;
            }
            beautyOptions = beautyOptions2;
            beautyOptions2 = new BeautyOptions();
        }
        BeautyOptions beautyOptions3 = beautyOptions;
        long l2 = this.mNativeHandle;
        int n2 = beautyOptions3.lighteningContrastLevel;
        float f2 = beautyOptions3.lighteningLevel;
        float f3 = beautyOptions3.smoothnessLevel;
        float f4 = beautyOptions3.rednessLevel;
        return this.nativeSetBeautyEffectOptions(l2, bl, n2, f2, f3, f4);
    }

    @Override
    public int enableVirtualBackground(boolean bl, VirtualBackgroundSource virtualBackgroundSource) {
        if (virtualBackgroundSource == null) {
            VirtualBackgroundSource virtualBackgroundSource2;
            if (bl) {
                return -2;
            }
            virtualBackgroundSource = virtualBackgroundSource2;
            virtualBackgroundSource2 = new VirtualBackgroundSource();
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeEnableVirtualBackground(rtcEngineImpl.mNativeHandle, bl, virtualBackgroundSource);
    }

    @Override
    public int muteRemoteAudioStream(int n2, boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = (long)n2 & 0xFFFFFFFFL;
        objectArray2[1] = bl;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.mute_peer\":{\"uid\":%d,\"mute\":%b}}", objectArray3));
    }

    @Override
    public int adjustUserPlaybackSignalVolume(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = (long)n2 & 0xFFFFFFFFL;
        objectArray2[1] = n3;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"che.audio.playout.uid.volume\":{\"uid\":%d,\"volume\":%d}}", objectArray3));
    }

    @Override
    public int muteRemoteVideoStream(int n2, boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = (long)n2 & 0xFFFFFFFFL;
        objectArray2[1] = bl;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"rtc.video.mute_peer\":{\"uid\":%d,\"mute\":%b}}", objectArray3));
    }

    @Override
    public int renewToken(String string2) {
        if (string2 == null) {
            return -2;
        }
        return this.setParameter("rtc.renew_token", string2);
    }

    @Override
    public int registerLocalUserAccount(String string2, String string3) {
        if (string2 != null && string3 != null) {
            RtcEngineImpl rtcEngineImpl = this;
            return rtcEngineImpl.nativeRegisterLocalUserAccount(rtcEngineImpl.mNativeHandle, string2, string3);
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannelWithUserAccount(String string2, String string3, String string4) {
        RtcEngineImpl rtcEngineImpl = this;
        int n2 = rtcEngineImpl.nativeJoinChannelWithUserAccount(rtcEngineImpl.mNativeHandle, string2, string3, string4, null);
        synchronized (rtcEngineImpl) {
            block7: {
                if (rtcEngineImpl.mDefaultRtcChannel != null) break block7;
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n2 == 0) {
                RtcEngineImpl rtcEngineImpl2 = this;
                this.mDefaultRtcChannel.initialize(rtcEngineImpl2, rtcEngineImpl2.nativeGetDefaultRtcChannel(rtcEngineImpl2.mNativeHandle));
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannelWithUserAccount(String string2, String string3, String string4, ChannelMediaOptions channelMediaOptions) {
        if (channelMediaOptions == null) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = this;
        int n2 = rtcEngineImpl.nativeJoinChannelWithUserAccount(rtcEngineImpl.mNativeHandle, string2, string3, string4, channelMediaOptions);
        synchronized (rtcEngineImpl) {
            block8: {
                if (rtcEngineImpl.mDefaultRtcChannel != null) break block8;
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n2 == 0) {
                RtcEngineImpl rtcEngineImpl2 = this;
                this.mDefaultRtcChannel.initialize(rtcEngineImpl2, rtcEngineImpl2.nativeGetDefaultRtcChannel(rtcEngineImpl2.mNativeHandle));
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return n2;
        }
    }

    @Override
    public int getUserInfoByUserAccount(String string2, UserInfo userInfo) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetUserInfoByUserAccount(rtcEngineImpl.mNativeHandle, string2, userInfo);
    }

    @Override
    public int getUserInfoByUid(int n2, UserInfo userInfo) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetUserInfoByUid(rtcEngineImpl.mNativeHandle, n2, userInfo);
    }

    @Override
    public int setDefaultAudioRoutetoSpeakerphone(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bl;
        Logging.i(String.format("API call to setDefaultAudioRoutetoSpeakerphone :%b", objectArray2));
        return super.nativeSetDefaultAudioRoutetoSpeakerphone(objectArray2.mNativeHandle, bl);
    }

    @Override
    public int setEnableSpeakerphone(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bl;
        Logging.i(String.format("API call to setEnableSpeakerphone to %b", objectArray2));
        return super.nativeSetEnableSpeakerphone(objectArray2.mNativeHandle, bl);
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeIsSpeakerphoneEnabled(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int adjustRecordingSignalVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 400) {
            n2 = 400;
        }
        return this.setParameter("che.audio.record.signal.volume", n2);
    }

    @Override
    public int adjustPlaybackSignalVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 400) {
            n2 = 400;
        }
        if (n2 < 100) {
            RtcEngineImpl rtcEngineImpl = this;
            rtcEngineImpl.setParameter("che.audio.farend.compression", 100);
            return rtcEngineImpl.setParameter("che.audio.playout.signal.volume", n2);
        }
        this.setParameter("che.audio.playout.signal.volume", 100);
        return this.setParameter("che.audio.farend.compression", (n2 - 100) / 3 * 7 + 100);
    }

    @Override
    public int setRecordingAudioFrameParameters(int n2, int n3, int n4, int n5) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray3[1] = n3;
        objectArray3[2] = n4;
        objectArray2[3] = n5;
        return super.setParameterObject("che.audio.set_capture_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", objectArray3));
    }

    @Override
    public int setPlaybackAudioFrameParameters(int n2, int n3, int n4, int n5) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray3[1] = n3;
        objectArray3[2] = n4;
        objectArray2[3] = n5;
        return super.setParameterObject("che.audio.set_render_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", objectArray3));
    }

    @Override
    public int setMixedAudioFrameParameters(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return super.setParameterObject("che.audio.set_mixed_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"samplesPerCall\":%d}", objectArray3));
    }

    @Override
    public int setHighQualityAudioParameters(boolean bl, boolean bl2, boolean bl3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = bl;
        objectArray3[1] = bl2;
        objectArray2[2] = bl3;
        return super.setParameterObject("che.audio.codec.hq", RtcEngineImpl.formatString("{\"fullband\":%b,\"stereo\":%b,\"fullBitrate\":%b}", objectArray3));
    }

    @Override
    public int enableInEarMonitoring(boolean bl) {
        return this.setParameter("che.audio.headset.monitoring", bl);
    }

    @Override
    public int enableWebSdkInteroperability(boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = bl;
        objectArray2[1] = bl;
        return objectArray.setParameters(String.format("{\"rtc.video.web_h264_interop_enable\":%b,\"che.video.web_h264_interop_enable\":%b}", objectArray3));
    }

    @Override
    public int setVideoQualityParameters(boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = bl;
        objectArray2[1] = bl;
        return objectArray.setParameters(String.format("{\"rtc.video.prefer_frame_rate\":%b,\"che.video.prefer_frame_rate\":%b}", objectArray3));
    }

    @Override
    @Deprecated
    public void setPreferHeadset(boolean bl) {
    }

    @Override
    public int enableAudioVolumeIndication(int n2, int n3, boolean bl) {
        Object[] objectArray;
        if (n2 < 0) {
            n2 = 0;
        }
        if (bl) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[3];
            objectArray = objectArray3;
            objectArray[0] = n2;
            objectArray3[1] = n3;
            objectArray3[2] = 1;
            return super.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", objectArray));
        }
        Object[] objectArray4 = objectArray;
        Object[] objectArray5 = new Object[3];
        objectArray = objectArray5;
        objectArray[0] = n2;
        objectArray5[1] = n3;
        objectArray5[2] = 0;
        return super.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", objectArray));
    }

    @Override
    @Deprecated
    public int enableAudioQualityIndication(boolean bl) {
        return this.setParameter("rtc.audio_quality_indication", bl);
    }

    @Override
    public int enableTransportQualityIndication(boolean bl) {
        return this.setParameter("rtc.transport_quality_indication", bl);
    }

    @Override
    public int playRecap() {
        return this.setParameter("che.audio.recap.start_play", true);
    }

    @Override
    public int enableRecap(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        return this.setParameter("che.audio.recap.interval", n2);
    }

    @Override
    public int setVideoProfile(int n2, boolean bl) {
        if (n2 < 0) {
            return -2;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = bl;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"rtc.video.profile\":[%d,%b]}", objectArray3));
    }

    @Override
    public int setVideoProfile(int n2, int n3, int n4, int n5) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetVideoProfileEx(rtcEngineImpl.mNativeHandle, n2, n3, n4, n5);
    }

    @Override
    public int setVideoEncoderConfiguration(VideoEncoderConfiguration videoEncoderConfiguration) {
        VideoEncoderConfiguration videoEncoderConfiguration2 = videoEncoderConfiguration;
        long l2 = this.mNativeHandle;
        VideoEncoderConfiguration.VideoDimensions videoDimensions = videoEncoderConfiguration2.dimensions;
        int n2 = videoDimensions.width;
        int n3 = videoDimensions.height;
        int n4 = videoEncoderConfiguration2.frameRate;
        int n5 = videoEncoderConfiguration2.minFrameRate;
        int n6 = videoEncoderConfiguration2.bitrate;
        int n7 = videoEncoderConfiguration2.minBitrate;
        int n8 = videoEncoderConfiguration2.orientationMode.getValue();
        int n9 = videoEncoderConfiguration2.degradationPrefer.getValue();
        int n10 = videoEncoderConfiguration2.mirrorMode;
        return this.nativeSetVideoEncoderConfiguration(l2, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    @Override
    public int setAudioProfile(int n2, int n3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetAudioProfile(rtcEngineImpl.mNativeHandle, n2, n3);
    }

    @Override
    public int monitorAudioRouteChange(boolean bl) {
        Logging.i("API call monitorAudioRouteChange:" + bl);
        return 0;
    }

    @Override
    public int switchCamera() {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSwitchCamera(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public boolean isCameraZoomSupported() {
        RtcEngineImpl rtcEngineImpl = this;
        return Boolean.valueOf(rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.zoom_supported", null));
    }

    @Override
    public boolean isCameraTorchSupported() {
        RtcEngineImpl rtcEngineImpl = this;
        return Boolean.valueOf(rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.torch_supported", null));
    }

    @Override
    public boolean isCameraFocusSupported() {
        RtcEngineImpl rtcEngineImpl = this;
        return Boolean.valueOf(rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.focus_supported", null));
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        RtcEngineImpl rtcEngineImpl = this;
        return Boolean.valueOf(rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.exposure_supported", null));
    }

    @Override
    public boolean isCameraAutoFocusFaceModeSupported() {
        RtcEngineImpl rtcEngineImpl = this;
        return Boolean.valueOf(rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.face_focus_supported", null));
    }

    @Override
    public int setCameraZoomFactor(float f2) {
        double d2 = f2;
        return this.setParameter("che.video.camera.zoom", d2);
    }

    @Override
    public float getCameraMaxZoomFactor() {
        RtcEngineImpl rtcEngineImpl = string2;
        String string2 = rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, "che.video.camera.get_max_zoom", null);
        if (string2 == null) {
            return 1.0f;
        }
        return Double.valueOf(string2).floatValue();
    }

    @Override
    public int setCameraFocusPositionInPreview(float f2, float f3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = Float.valueOf(f2);
        objectArray2[1] = Float.valueOf(f3);
        objectArray2[2] = Boolean.TRUE;
        return super.setParameterObject("che.video.camera.focus", RtcEngineImpl.formatString("{\"x\":%f,\"y\":%f,\"preview\":%b}", objectArray3));
    }

    @Override
    public int setCameraExposurePosition(float f2, float f3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = Float.valueOf(f2);
        objectArray2[1] = Float.valueOf(f3);
        objectArray2[2] = Boolean.TRUE;
        return super.setParameterObject("che.video.camera.exposure", RtcEngineImpl.formatString("{\"x\":%f,\"y\":%f,\"preview\":%b}", objectArray3));
    }

    @Override
    public int setCameraTorchOn(boolean bl) {
        return this.setParameter("che.video.camera.flash", bl);
    }

    @Override
    public int setCameraAutoFocusFaceModeEnabled(boolean bl) {
        return this.setParameter("che.video.camera.face_detection", bl);
    }

    @Override
    public int enableFaceDetection(boolean bl) {
        return this.setParameter("che.video.faceDistance", bl);
    }

    public int enableRemoteVideo(boolean bl, int n2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = bl;
        objectArray2[1] = (long)n2 & 0xFFFFFFFFL;
        return super.setParameterObject("che.video.peer.receive", RtcEngineImpl.formatString("{\"enable\":%b, \"uid\":%d}", objectArray3));
    }

    public int stopRemoteVideo(int n2) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return this.setParameter("che.video.peer.stop_video", l2);
    }

    public int stopAllRemoteVideo() {
        return this.setParameter("che.video.peer.stop_all_renders", true);
    }

    @Override
    public int startAudioRecording(String string2, int n2) {
        return this.startAudioRecording(string2, 32000, n2);
    }

    @Override
    public int selectAudioTrack(int n2) {
        if (n2 < 0) {
            return -2;
        }
        return this.setParameter("che.audio.select_audio_track", n2);
    }

    @Override
    public int getAudioTrackCount() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_audio_track_count", null);
    }

    @Override
    public int setAudioMixingDualMonoMode(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            return this.setParameter("che.audio.set_dual_mono_mode", n2);
        }
        return -2;
    }

    @Override
    public int startAudioRecording(String string2, int n2, int n3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -2;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray3[1] = n2;
        objectArray2[2] = n3;
        return super.setParameterObject("che.audio.start_recording", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"sampleRate\":%d, \"quality\":%d}", objectArray3));
    }

    @Override
    public int startAudioRecording(AudioRecordingConfiguration audioRecordingConfiguration) {
        AudioRecordingConfiguration audioRecordingConfiguration2 = audioRecordingConfiguration;
        long l2 = this.mNativeHandle;
        String string2 = audioRecordingConfiguration2.filePath;
        int n2 = audioRecordingConfiguration2.recordingQuality;
        int n3 = audioRecordingConfiguration2.recordingPosition;
        int n4 = audioRecordingConfiguration2.recordingSampleRate;
        int n5 = audioRecordingConfiguration2.recordingChannel;
        return this.nativeStartAudioRecording(l2, string2, n2, n3, n4, n5);
    }

    @Override
    public int stopAudioRecording() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStopAudioRecording(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setAudioMixingPlaybackSpeed(int n2) {
        double d2 = (double)n2 / 100.0;
        return this.setParameter("che.audio.set_audio_mixing_play_tempo", d2);
    }

    @Override
    public int startAudioMixing(String string2, boolean bl, boolean bl2, int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[5];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray3[1] = bl;
        objectArray3[2] = bl2;
        objectArray3[3] = n2;
        objectArray2[4] = n3;
        return super.setParameterObject("che.audio.start_file_as_playout", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"loopback\":%b, \"replace\":%b, \"cycle\":%d, \"startPos\": %d}", objectArray3));
    }

    @Override
    @Deprecated
    public int startAudioMixing(String string2, boolean bl, boolean bl2, int n2) {
        return this.startAudioMixing(string2, bl, bl2, n2, 0);
    }

    @Override
    public int stopAudioMixing() {
        return this.setParameter("che.audio.stop_file_as_playout", true);
    }

    @Override
    public int pauseAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", true);
    }

    @Override
    public int resumeAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", false);
    }

    @Override
    public int adjustAudioMixingVolume(int n2) {
        int n3 = this.adjustAudioMixingPlayoutVolume(n2);
        if (n3 == 0) {
            this.adjustAudioMixingPublishVolume(n2);
        }
        return n3;
    }

    @Override
    public int adjustAudioMixingPlayoutVolume(int n2) {
        return this.setParameter("che.audio.set_file_as_playout_volume", n2);
    }

    @Override
    public int adjustAudioMixingPublishVolume(int n2) {
        return this.setParameter("che.audio.set_file_as_playout_publish_volume", n2);
    }

    @Override
    public int getAudioMixingPlayoutVolume() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_file_as_playout_volume", null);
    }

    @Override
    public int getAudioMixingPublishVolume() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_file_as_playout_publish_volume", null);
    }

    @Override
    @Deprecated
    public int getAudioMixingDuration() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_mixing_file_length_ms", null);
    }

    @Override
    public int getAudioMixingCurrentPosition() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetIntParameter(rtcEngineImpl.mNativeHandle, "che.audio.get_mixing_file_played_ms", null);
    }

    @Override
    public int setAudioMixingPosition(int n2) {
        return this.setParameter("che.audio.mixing.file.position", n2);
    }

    @Override
    public int setAudioMixingPitch(int n2) {
        if (n2 <= 12 && n2 >= -12) {
            return this.setParameter("che.audio.set_playout_file_pitch_semitones", n2);
        }
        return -2;
    }

    @Override
    public int getAudioFileInfo(String string2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        return super.setParameterObject("che.audio.get_file_info", RtcEngineImpl.formatString("{\"url\":\"%s\"}", objectArray3));
    }

    @Override
    public int useExternalAudioDevice() {
        return this.setParameters("{\"che.audio.audioSampleRate\":32000, \"che.audio.external_device\":true}");
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver iAudioFrameObserver) {
        if (iAudioFrameObserver != null) {
            AudioParams audioParams;
            int n2;
            int n3;
            int n4;
            AudioParams audioParams2 = iAudioFrameObserver.getMixedAudioParams();
            if (audioParams2 != null) {
                AudioParams audioParams3 = audioParams2;
                int n5 = audioParams3.sampleRate;
                this.setMixedAudioFrameParameters(n5, audioParams3.samplesPerCall);
            }
            if ((audioParams2 = iAudioFrameObserver.getRecordAudioParams()) != null) {
                AudioParams audioParams4 = audioParams2;
                int n6 = audioParams4.sampleRate;
                n4 = audioParams4.channel;
                n3 = audioParams4.mode;
                n2 = audioParams4.samplesPerCall;
                this.setRecordingAudioFrameParameters(n6, n4, n3, n2);
            }
            if ((audioParams = iAudioFrameObserver.getPlaybackAudioParams()) != null) {
                AudioParams audioParams5 = audioParams;
                int n7 = audioParams5.sampleRate;
                n4 = audioParams5.channel;
                n3 = audioParams5.mode;
                n2 = audioParams5.samplesPerCall;
                this.setPlaybackAudioFrameParameters(n7, n4, n3, n2);
            }
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRegisterAudioFrameObserver(rtcEngineImpl.mNativeHandle, iAudioFrameObserver);
    }

    @Override
    public int registerVideoFrameObserver(IVideoFrameObserver iVideoFrameObserver) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRegisterVideoFrameObserver(rtcEngineImpl.mNativeHandle, iVideoFrameObserver);
    }

    @Override
    public int registerVideoEncodedFrameObserver(IVideoEncodedFrameObserver iVideoEncodedFrameObserver) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRegisterVideoEncodedFrameObserver(rtcEngineImpl.mNativeHandle, iVideoEncodedFrameObserver);
    }

    @Override
    public int setExternalAudioSink(boolean bl, int n2, int n3) {
        Object[] objectArray;
        if (n3 != 1 && n3 != 2) {
            return -1;
        }
        if (n2 != 8000 && n2 != 16000 && n2 != 32000 && n2 != 44100 && n2 != 48000) {
            return -2;
        }
        objectArray.mExAudioSinkChannels = n3;
        objectArray.mExAudioSinkSampleRate = n2;
        if (bl) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[5];
            objectArray = objectArray3;
            objectArray[0] = bl;
            objectArray[1] = bl;
            objectArray[2] = n2;
            objectArray3[3] = n3;
            objectArray3[4] = 0;
            return objectArray2.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b,\"che.audio.set_render_raw_audio_format\":{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d}}", objectArray));
        }
        Object[] objectArray4 = objectArray;
        Object[] objectArray5 = new Object[3];
        objectArray = objectArray5;
        objectArray[0] = bl;
        objectArray[1] = bl;
        objectArray5[2] = bl;
        return objectArray4.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b}", objectArray));
    }

    @Override
    public int pullPlaybackAudioFrame(byte[] byArray, int n2) {
        int n3 = this.mExAudioSinkChannels;
        if (n3 != 1 && n3 != 2) {
            return -1;
        }
        RtcEngineImpl rtcEngineImpl = this;
        long l2 = rtcEngineImpl.mNativeHandle;
        int n4 = rtcEngineImpl.mExAudioSinkChannels;
        return rtcEngineImpl.nativePullAudioFrame(l2, byArray, n2, n4);
    }

    @Override
    public int setExternalAudioSource(boolean bl, int n2, int n3) {
        Object[] objectArray;
        objectArray.mExAudioSourceSampleRate = n2;
        objectArray.mExAudioSourceChannels = n3;
        if (bl) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[3];
            objectArray = objectArray3;
            objectArray[0] = bl;
            objectArray[1] = n2;
            objectArray3[2] = n3;
            return objectArray2.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.set_external_source_format\":{\"sampleRate\":%d,\"channelCnt\":%d}}", objectArray));
        }
        Object[] objectArray4 = objectArray;
        Object[] objectArray5 = new Object[2];
        objectArray = objectArray5;
        objectArray[0] = bl;
        objectArray5[1] = bl;
        return objectArray4.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.external_capture\":%b}", objectArray));
    }

    @Override
    @Deprecated
    public int pushExternalAudioFrame(byte[] byArray, long l2) {
        RtcEngineImpl rtcEngineImpl = this;
        long l3 = rtcEngineImpl.mNativeHandle;
        int n2 = rtcEngineImpl.mExAudioSourceSampleRate;
        int n3 = rtcEngineImpl.mExAudioSourceChannels;
        return rtcEngineImpl.nativePushExternalAudioFrameRawData(l3, byArray, l2, n2, n3);
    }

    @Override
    public int pushExternalAudioFrame(byte[] byArray, long l2, int n2, int n3, int n4, int n5) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativePushExternalAudioFrameRawDataExt(rtcEngineImpl.mNativeHandle, byArray, l2, n2, n3, n4, n5);
    }

    @Override
    public int setExternalAudioSourceVolume(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"che.audio.set_external_source_volume\":{\"sourcePos\":%d, \"gain\":%d}}", objectArray3));
    }

    @Override
    public int setLogFile(String string2) {
        int n2 = this.setParameter("rtc.log_file", string2);
        if (n2 == 0) {
            this.getParameters("[\"rtc.log_file\"]").equals(string2);
        }
        return n2;
    }

    @Override
    public int setLogFilter(int n2) {
        return this.setParameter("rtc.log_filter", n2 & 0x80F);
    }

    @Override
    public int setLogFileSize(int n2) {
        return this.setParameter("rtc.log_size", n2);
    }

    @Override
    public String uploadLogFile() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeUploadLogFile(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setProfile(String string2, boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetProfile(rtcEngineImpl.mNativeHandle, string2, bl);
    }

    public String getProfile() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetProfile(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setAppType(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetAppType(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int setParameters(String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetParameters(rtcEngineImpl.mNativeHandle, string2);
    }

    @Override
    public String getParameters(String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetParameters(rtcEngineImpl.mNativeHandle, string2);
    }

    @Override
    public String getParameter(String string2, String string3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetParameter(rtcEngineImpl.mNativeHandle, string2, string3);
    }

    @Override
    public String makeQualityReportUrl(String string2, int n2, int n3, int n4) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeMakeQualityReportUrl(rtcEngineImpl.mNativeHandle, string2, n2, n3, n4);
    }

    @Override
    public String getCallId() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetCallId(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int rate(String string2, int n2, String string3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRate(rtcEngineImpl.mNativeHandle, string2, n2, string3);
    }

    @Override
    public int complain(String string2, String string3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeComplain(rtcEngineImpl.mNativeHandle, string2, string3);
    }

    @Override
    public int setChannelProfile(int n2) {
        if (n2 == 0) {
            this.setClientRole(1);
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetChannelProfile(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetClientRole(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2, ClientRoleOptions clientRoleOptions) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetClientRoleOptions(rtcEngineImpl.mNativeHandle, n2, clientRoleOptions);
    }

    @Override
    public int setCameraCapturerConfiguration(CameraCapturerConfiguration cameraCapturerConfiguration) {
        CameraCapturerConfiguration.CaptureDimensions captureDimensions;
        int n2 = this.setParameter("che.video.camera_capture_mode", cameraCapturerConfiguration.preference.getValue());
        if (cameraCapturerConfiguration.preference == CameraCapturerConfiguration.CAPTURER_OUTPUT_PREFERENCE.CAPTURER_OUTPUT_PREFERENCE_MANUAL && (captureDimensions = cameraCapturerConfiguration.dimensions) != null) {
            this.setParameter("che.video.capture_width", captureDimensions.width);
            this.setParameter("che.video.capture_height", cameraCapturerConfiguration.dimensions.height);
        }
        if (n2 == 0) {
            return this.switchCamera(cameraCapturerConfiguration.cameraDirection);
        }
        return n2;
    }

    @Override
    public int setRemoteVideoStreamType(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray2;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        objectArray3[0] = l2;
        objectArray3[1] = n3;
        objectArray3[2] = l2;
        objectArray2[3] = n3;
        return objectArray.setParameters(RtcEngineImpl.formatString("{\"rtc.video.set_remote_video_stream\":{\"uid\":%d,\"stream\":%d},\"che.video.setstream\":{\"uid\":%d,\"stream\":%d}}", objectArray3));
    }

    @Override
    public int setRemoteUserPriority(int n2, int n3) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetRemoteUserPriority(rtcEngineImpl.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int n2) {
        return this.setParameter("rtc.video.set_remote_default_video_stream_type", n2);
    }

    @Override
    public int setLocalPublishFallbackOption(int n2) {
        return this.setParameter("rtc.local_publish_fallback_option", n2);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int n2) {
        return this.setParameter("rtc.remote_subscribe_fallback_option", n2);
    }

    @Override
    public int setEncryptionMode(String string2) {
        return this.setParameter("rtc.encryption.mode", string2);
    }

    @Override
    public int setEncryptionSecret(String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetEncryptionSecret(rtcEngineImpl.mNativeHandle, string2);
    }

    @Override
    public int enableEncryption(boolean bl, EncryptionConfig object) {
        EncryptionConfig encryptionConfig = object;
        long l2 = this.mNativeHandle;
        int n2 = encryptionConfig.encryptionMode.getValue();
        object = encryptionConfig.encryptionKey;
        byte[] byArray = encryptionConfig.encryptionKdfSalt;
        return this.nativeEnableEncryption(l2, bl, n2, (String)object, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onEvent(int n2, byte[] byArray) {
        try {
            Iterator iterator = this.mRtcHandlers.keySet().iterator();
            while (iterator.hasNext()) {
                IRtcEngineEventHandler iRtcEngineEventHandler = (IRtcEngineEventHandler)iterator.next();
                if (iRtcEngineEventHandler == null) {
                    iterator.remove();
                    continue;
                }
                this.handleEvent(n2, byArray, iRtcEngineEventHandler);
            }
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("onEvent: " + exception.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onChannelEvent(String string2, int n2, byte[] byArray) {
        if (string2 == null) return;
        if (string2.length() <= 0) {
            return;
        }
        RtcEngineImpl rtcEngineImpl = this;
        RtcChannelImpl rtcChannelImpl = null;
        synchronized (rtcEngineImpl) {
            RtcChannelImpl rtcChannelImpl22;
            block8: {
                for (RtcChannelImpl rtcChannelImpl22 : rtcEngineImpl.mRtcChannels) {
                    if (rtcChannelImpl22.channelId() == null || !rtcChannelImpl22.channelId().equals(string2)) continue;
                    break block8;
                }
                rtcChannelImpl22 = rtcChannelImpl;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            if (rtcChannelImpl22 == null) return;
            if (!rtcChannelImpl22.isInitialized()) {
                return;
            }
            if (rtcChannelImpl22.getEventHandler() == null) {
                return;
            }
            this.handleChannelEvent(n2, byArray, rtcChannelImpl22.getEventHandler(), rtcChannelImpl22);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void handleEvent(int var1_21, byte[] var2_25, IRtcEngineEventHandler var3_36) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleChannelEvent(int n2, byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        if (iRtcChannelEventHandler != null && rtcChannelImpl != null) {
            switch (n2) {
                default: {
                    break;
                }
                case 14049: {
                    ((RtcEngineImpl)object2).onRtcChannelUserSuperResolutionEnabledExt(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14048: {
                    ((RtcEngineImpl)object2).onRtcChannelVideoSubscribeStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14047: {
                    ((RtcEngineImpl)object2).onRtcChannelAudioSubscribeStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14046: {
                    ((RtcEngineImpl)object2).onRtcChannelVideoPublishStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14045: {
                    ((RtcEngineImpl)object2).onRtcChannelAudioPublishStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14040: {
                    ((RtcEngineImpl)object2).onRtcChannelRemoteAudioStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14038: {
                    ((RtcEngineImpl)object2).onRtcChannelChannelMediaRelayEvent(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14037: {
                    ((RtcEngineImpl)object2).onRtcChannelChannelMediaRelayStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14036: {
                    ((RtcEngineImpl)object2).onRtcChannelRemoteVideoStateChangedExt(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14030: {
                    ((RtcEngineImpl)object2).onRtcChannelRemoteAudioStat(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14028: {
                    RtcEngineMessage.PConnectionState pConnectionState = new RtcEngineMessage.PConnectionState();
                    pConnectionState.unmarshall(byArray);
                    int n3 = pConnectionState.state;
                    n2 = pConnectionState.reason;
                    iRtcChannelEventHandler.onConnectionStateChanged(rtcChannelImpl, n3, n2);
                    break;
                }
                case 14023: {
                    RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                    pMediaResUserState.unmarshall(byArray);
                    int n4 = pMediaResUserState.uid;
                    n2 = pMediaResUserState.state ? 1 : 0;
                    iRtcChannelEventHandler.onRemoteSubscribeFallbackToAudioOnly(rtcChannelImpl, n4, n2 != 0);
                    break;
                }
                case 14022: {
                    RtcEngineMessage.PLocalFallbackStatus pLocalFallbackStatus = new RtcEngineMessage.PLocalFallbackStatus();
                    pLocalFallbackStatus.unmarshall(byArray);
                    iRtcChannelEventHandler.onLocalPublishFallbackToAudioOnly(rtcChannelImpl, pLocalFallbackStatus.state);
                    break;
                }
                case 14016: {
                    RtcEngineMessage.PActiveSpeaker pActiveSpeaker = new RtcEngineMessage.PActiveSpeaker();
                    pActiveSpeaker.unmarshall(byArray);
                    iRtcChannelEventHandler.onActiveSpeaker(rtcChannelImpl, pActiveSpeaker.uid);
                    break;
                }
                case 14013: {
                    ((RtcEngineImpl)object2).onRtcChannelVideoSizeChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14012: {
                    ((RtcEngineImpl)object2).onRtcChannelStreamMessageError(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14009: {
                    ((RtcEngineImpl)object2).onRtcChannelStreamMessage(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14008: {
                    iRtcChannelEventHandler.onConnectionLost(rtcChannelImpl);
                    break;
                }
                case 14004: {
                    ((RtcEngineImpl)object2).onRtcChannelRemoteVideoStat(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 14002: {
                    ((RtcEngineImpl)object2).onRtcChannelFirstRemoteVideoFrame(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                    break;
                }
                case 13013: {
                    RtcEngineMessage.PMediaResUserJoinedEvent pMediaResUserJoinedEvent = new RtcEngineMessage.PMediaResUserJoinedEvent();
                    pMediaResUserJoinedEvent.unmarshall(byArray);
                    int n5 = pMediaResUserJoinedEvent.uid;
                    n2 = pMediaResUserJoinedEvent.elapsed;
                    iRtcChannelEventHandler.onUserJoined(rtcChannelImpl, n5, n2);
                    break;
                }
                case 13010: {
                    RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats;
                    RtcEngineImpl rtcEngineImpl = object2;
                    Object object2 = pMediaResRtcStats;
                    new RtcEngineMessage.PMediaResRtcStats().unmarshall(byArray);
                    rtcEngineImpl.updateRtcStats((RtcEngineMessage.PMediaResRtcStats)object2);
                    iRtcChannelEventHandler.onRtcStats(rtcChannelImpl, rtcEngineImpl.getRtcStats());
                    break;
                }
                case 13008: {
                    RtcEngineMessage.PMediaResUserOfflineEvent pMediaResUserOfflineEvent = new RtcEngineMessage.PMediaResUserOfflineEvent();
                    pMediaResUserOfflineEvent.unmarshall(byArray);
                    int n6 = pMediaResUserOfflineEvent.uid;
                    n2 = pMediaResUserOfflineEvent.reason;
                    iRtcChannelEventHandler.onUserOffline(rtcChannelImpl, n6, n2);
                    break;
                }
                case 13007: {
                    RtcEngineMessage.PMediaResNetworkQuality pMediaResNetworkQuality = new RtcEngineMessage.PMediaResNetworkQuality();
                    pMediaResNetworkQuality.unmarshall(byArray);
                    int n7 = pMediaResNetworkQuality.uid;
                    n2 = pMediaResNetworkQuality.txQuality;
                    int n8 = pMediaResNetworkQuality.rxQuality;
                    iRtcChannelEventHandler.onNetworkQuality(rtcChannelImpl, n7, n2, n8);
                    break;
                }
                case 13006: {
                    RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats;
                    Context context = (Context)((RtcEngineImpl)object2).mContext.get();
                    if (context != null) {
                        ((RtcEngineImpl)object2).getAudioManager(context).setMode(0);
                    }
                    Object object = object2;
                    Object object2 = pMediaResRtcStats;
                    new RtcEngineMessage.PMediaResRtcStats().unmarshall(byArray);
                    ((RtcEngineImpl)object).updateRtcStats((RtcEngineMessage.PMediaResRtcStats)object2);
                    iRtcChannelEventHandler.onLeaveChannel(rtcChannelImpl, ((RtcEngineImpl)object).getRtcStats());
                    break;
                }
                case 13001: {
                    RtcEngineMessage.PMediaResJoinMedia pMediaResJoinMedia;
                    Object object2 = pMediaResJoinMedia;
                    ((RtcEngineMessage.PMediaResJoinMedia)object2)();
                    pMediaResJoinMedia.unmarshall(byArray);
                    if (pMediaResJoinMedia.firstSuccess) {
                        Object object = object2;
                        int n9 = ((RtcEngineMessage.PMediaResJoinMedia)object).uid;
                        n2 = ((RtcEngineMessage.PMediaResJoinMedia)object).elapsed;
                        iRtcChannelEventHandler.onJoinChannelSuccess(rtcChannelImpl, n9, n2);
                        break;
                    }
                    Object object = object2;
                    int n10 = ((RtcEngineMessage.PMediaResJoinMedia)object).uid;
                    n2 = ((RtcEngineMessage.PMediaResJoinMedia)object).elapsed;
                    iRtcChannelEventHandler.onRejoinChannelSuccess(rtcChannelImpl, n10, n2);
                    break;
                }
                case 1119: {
                    RtcEngineMessage.PRtmpStreamingState pRtmpStreamingState = new RtcEngineMessage.PRtmpStreamingState();
                    pRtmpStreamingState.unmarshall(byArray);
                    Object object2 = pRtmpStreamingState.url;
                    n2 = pRtmpStreamingState.state;
                    int n11 = pRtmpStreamingState.error;
                    iRtcChannelEventHandler.onRtmpStreamingStateChanged(rtcChannelImpl, (String)object2, n2, n11);
                    break;
                }
                case 1117: {
                    RtcEngineMessage.PPrivilegeWillExpire pPrivilegeWillExpire = new RtcEngineMessage.PPrivilegeWillExpire();
                    pPrivilegeWillExpire.unmarshall(byArray);
                    iRtcChannelEventHandler.onTokenPrivilegeWillExpire(rtcChannelImpl, pPrivilegeWillExpire.token);
                    break;
                }
                case 1116: {
                    RtcEngineMessage.PStreamInjectedStatus pStreamInjectedStatus = new RtcEngineMessage.PStreamInjectedStatus();
                    pStreamInjectedStatus.unmarshall(byArray);
                    Object object2 = pStreamInjectedStatus.url;
                    n2 = pStreamInjectedStatus.uid;
                    int n12 = pStreamInjectedStatus.status;
                    iRtcChannelEventHandler.onStreamInjectedStatus(rtcChannelImpl, (String)object2, n2, n12);
                    break;
                }
                case 1112: {
                    iRtcChannelEventHandler.onTranscodingUpdated(rtcChannelImpl);
                    break;
                }
                case 1109: {
                    RtcEngineMessage.PClientRoleChanged pClientRoleChanged = new RtcEngineMessage.PClientRoleChanged();
                    pClientRoleChanged.unmarshall(byArray);
                    int n13 = pClientRoleChanged.oldRole;
                    n2 = pClientRoleChanged.newRole;
                    iRtcChannelEventHandler.onClientRoleChanged(rtcChannelImpl, n13, n2);
                    break;
                }
                case 1108: {
                    iRtcChannelEventHandler.onRequestToken(rtcChannelImpl);
                    break;
                }
                case 102: {
                    RtcEngineMessage.PError pError;
                    RtcEngineMessage.PError pError2 = pError;
                    new RtcEngineMessage.PError().unmarshall(byArray);
                    int n14 = pError2.err;
                    if ((n14 == 1019 || n14 == 1052) && ((RtcEngineImpl)object2).getParameters("[\"che.audio.adm.active\"]").equals("2")) {
                        Object object = object2;
                        Logging.e(TAG, "ADM Error code " + pError2.err + " restart ADM");
                        super.setParameter("che.audio.opensl", false);
                        ((RtcEngineImpl)object).setParameters("che.audio.restart");
                    }
                    iRtcChannelEventHandler.onChannelWarning(rtcChannelImpl, pError2.err);
                    break;
                }
                case 101: {
                    RtcEngineMessage.PError pError;
                    RtcEngineMessage.PError pError3 = pError;
                    new RtcEngineMessage.PError().unmarshall(byArray);
                    int n15 = pError3.err;
                    if (n15 >= 1151 && n15 <= 1164 || (n15 = pError3.err) >= 1001 && n15 < 1033 && ((RtcEngineImpl)object2).getParameters("[\"che.audio.adm.active\"]").equals("2")) {
                        Object object = object2;
                        Logging.e(TAG, "ADM Error code " + pError3.err + " restart ADM");
                        super.setParameter("che.audio.opensl", false);
                        ((RtcEngineImpl)object).setParameters("che.audio.restart");
                    }
                    iRtcChannelEventHandler.onChannelError(rtcChannelImpl, pError3.err);
                }
            }
            return;
        }
    }

    protected AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    protected ActivityManager getActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        return (ActivityManager)context.getSystemService("activity");
    }

    @Override
    public int createDataStream(boolean bl, boolean bl2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeCreateDataStream(rtcEngineImpl.mNativeHandle, bl, bl2);
    }

    @Override
    public int createDataStream(DataStreamConfig dataStreamConfig) {
        DataStreamConfig dataStreamConfig2 = dataStreamConfig;
        long l2 = this.mNativeHandle;
        boolean bl = dataStreamConfig2.ordered;
        boolean bl2 = dataStreamConfig2.syncWithAudio;
        return this.nativeCreateDataStream2(l2, bl, bl2);
    }

    @Override
    public int sendStreamMessage(int n2, byte[] byArray) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSendStreamMessage(rtcEngineImpl.mNativeHandle, n2, byArray);
    }

    @Override
    public int updateSharedContext(javax.microedition.khronos.egl.EGLContext eGLContext) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetEGL10Context(rtcEngineImpl.mNativeHandle, eGLContext);
    }

    @Override
    public int updateSharedContext(EGLContext eGLContext) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetEGL14Context(rtcEngineImpl.mNativeHandle, eGLContext);
    }

    @Override
    public int setTextureId(int n2, javax.microedition.khronos.egl.EGLContext eGLContext, int n3, int n4, long l2) {
        RtcEngineImpl rtcEngineImpl = object;
        Object object = sMatrix;
        return rtcEngineImpl.nativeSetEGL10TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, 10, n3, n4, l2, (float[])object);
    }

    @Override
    public int setTextureId(int n2, EGLContext eGLContext, int n3, int n4, long l2) {
        RtcEngineImpl rtcEngineImpl = object;
        Object object = sMatrix;
        return rtcEngineImpl.nativeSetEGL14TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, 11, n3, n4, l2, (float[])object);
    }

    public int setTextureIdWithMatrix(int n2, javax.microedition.khronos.egl.EGLContext eGLContext, int n3, int n4, int n5, long l2, float[] fArray) {
        if (fArray == null) {
            RtcEngineImpl rtcEngineImpl = object;
            Object object = sMatrix;
            return rtcEngineImpl.nativeSetEGL10TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, (float[])object);
        }
        if (fArray.length < 16) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = object;
        return rtcEngineImpl.nativeSetEGL10TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, fArray);
    }

    public int setTextureIdWithMatrix(int n2, EGLContext eGLContext, int n3, int n4, int n5, long l2, float[] fArray) {
        if (fArray == null) {
            RtcEngineImpl rtcEngineImpl = object;
            Object object = sMatrix;
            return rtcEngineImpl.nativeSetEGL14TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, (float[])object);
        }
        if (fArray.length < 16) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = object;
        return rtcEngineImpl.nativeSetEGL14TextureId(rtcEngineImpl.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, fArray);
    }

    @Override
    public boolean isTextureEncodeSupported() {
        return DeviceUtils.getRecommendedEncoderType() == 0;
    }

    @Override
    public void setExternalVideoSource(boolean bl, boolean bl2, boolean bl3) {
        this.mVideoSourceType = bl ? 3 : 1;
        if (bl2) {
            if (bl) {
                this.setParameter("che.video.enable_external_texture_input", true);
            } else {
                this.setParameter("che.video.enable_external_texture_input", false);
                Logging.w("setExternalVideoSource: on Android, texture mode cannot be disabled once enabled.");
            }
        }
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.setExtVideoSource(rtcEngineImpl.mNativeHandle, bl ? 1 : 0, bl3 ? 1 : 0);
    }

    @Override
    public boolean pushExternalVideoFrame(AgoraVideoFrame agoraVideoFrame) {
        int n2;
        if (agoraVideoFrame != null && (n2 = agoraVideoFrame.format) != 12) {
            if (this.mVideoSourceType != 3) {
                Logging.e("pushExternalVideoFrame failed!! Call setExternalVideoSource to enable enable external video source!!");
                return false;
            }
            if (n2 != 10 && n2 != 11) {
                if (n2 > 0 && n2 <= 8 || agoraVideoFrame.format == 16) {
                    AgoraVideoFrame agoraVideoFrame2 = agoraVideoFrame;
                    long l2 = this.mNativeHandle;
                    byte[] byArray = agoraVideoFrame2.buf;
                    int n3 = agoraVideoFrame2.stride;
                    int n4 = agoraVideoFrame2.height;
                    int n5 = agoraVideoFrame2.cropLeft;
                    int n6 = agoraVideoFrame2.cropTop;
                    int n7 = agoraVideoFrame2.cropRight;
                    int n8 = agoraVideoFrame2.cropBottom;
                    int n9 = agoraVideoFrame2.rotation;
                    long l3 = agoraVideoFrame2.timeStamp;
                    int n10 = agoraVideoFrame2.format;
                    return this.deliverFrame(l2, byArray, n3, n4, n5, n6, n7, n8, n9, l3, n10) == 0;
                }
            } else {
                if (agoraVideoFrame.textureID == 0) {
                    Logging.e("pushExternalVideoFrame failed!! invalid texture ID.");
                    return false;
                }
                EGLContext eGLContext = agoraVideoFrame.eglContext14;
                if (eGLContext != null) {
                    if (this.updateSharedContext(eGLContext) == 0) {
                        AgoraVideoFrame agoraVideoFrame3 = agoraVideoFrame;
                        int n11 = agoraVideoFrame3.textureID;
                        agoraVideoFrame = agoraVideoFrame3.eglContext14;
                        int n12 = agoraVideoFrame3.format;
                        int n13 = agoraVideoFrame3.stride;
                        int n14 = agoraVideoFrame3.height;
                        long l4 = agoraVideoFrame3.timeStamp;
                        float[] fArray = agoraVideoFrame3.transform;
                        return this.setTextureIdWithMatrix(n11, (EGLContext)agoraVideoFrame, n12, n13, n14, l4, fArray) == 0;
                    }
                } else {
                    eGLContext = agoraVideoFrame.eglContext11;
                    if (eGLContext != null && this.updateSharedContext((javax.microedition.khronos.egl.EGLContext)eGLContext) == 0) {
                        AgoraVideoFrame agoraVideoFrame4 = agoraVideoFrame;
                        int n15 = agoraVideoFrame4.textureID;
                        agoraVideoFrame = agoraVideoFrame4.eglContext11;
                        int n16 = agoraVideoFrame4.format;
                        int n17 = agoraVideoFrame4.stride;
                        int n18 = agoraVideoFrame4.height;
                        long l5 = agoraVideoFrame4.timeStamp;
                        float[] fArray = agoraVideoFrame4.transform;
                        return this.setTextureIdWithMatrix(n15, (javax.microedition.khronos.egl.EGLContext)agoraVideoFrame, n16, n17, n18, l5, fArray) == 0;
                    }
                }
            }
            return false;
        }
        Logging.e("pushExternalVideoFrame failed!! invalid video frame.");
        return false;
    }

    @Override
    public int addPublishStreamUrl(String string2, boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeAddPublishStreamUrl(rtcEngineImpl.mNativeHandle, string2, bl);
    }

    @Override
    public int removePublishStreamUrl(String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRemovePublishStreamUrl(rtcEngineImpl.mNativeHandle, string2);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding liveTranscoding) {
        if (liveTranscoding == null) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = object;
        Object object = new RtcEngineMessage.PLiveTranscoding().marshall(liveTranscoding);
        return rtcEngineImpl.nativeSetLiveTranscoding(rtcEngineImpl.mNativeHandle, (byte[])object);
    }

    @Override
    public int addInjectStreamUrl(String string2, LiveInjectStreamConfig liveInjectStreamConfig) {
        if (string2 != null && liveInjectStreamConfig != null) {
            RtcEngineImpl rtcEngineImpl = object;
            Object object = new RtcEngineMessage.PInjectStreamConfig().marshall(liveInjectStreamConfig);
            return rtcEngineImpl.nativeAddInjectStreamUrl(rtcEngineImpl.mNativeHandle, string2, (byte[])object);
        }
        return -2;
    }

    @Override
    public int removeInjectStreamUrl(String string2) {
        if (string2 == null) {
            return -2;
        }
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRemoveInjectStreamUrl(rtcEngineImpl.mNativeHandle, string2);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null) {
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
                return -2;
            }
            RtcEngineImpl rtcEngineImpl = object;
            Object object = new RtcEngineMessage.PChannelMediaRelayConfiguration().marshall(channelMediaRelayConfiguration);
            return rtcEngineImpl.nativeStartChannelMediaRelay(rtcEngineImpl.mNativeHandle, (byte[])object);
        }
        return -2;
    }

    @Override
    public int stopChannelMediaRelay() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStopChannelMediaRelay(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null) {
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
                return -2;
            }
            RtcEngineImpl rtcEngineImpl = object;
            Object object = new RtcEngineMessage.PChannelMediaRelayConfiguration().marshall(channelMediaRelayConfiguration);
            return rtcEngineImpl.nativeUpdateChannelMediaRelay(rtcEngineImpl.mNativeHandle, (byte[])object);
        }
        return -2;
    }

    @Override
    public int pauseAllChannelMediaRelay() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativePauseAllChannelMediaRelay(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int resumeAllChannelMediaRelay() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeResumeAllChannelMediaRelay(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int startDumpVideoReceiveTrack(int n2, String string2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStartDumpVideoReceiveTrack(rtcEngineImpl.mNativeHandle, n2, string2);
    }

    @Override
    public int stopDumpVideoReceiveTrack() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeStopDumpVideoReceiveTrack(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public long getNativeHandle() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetHandle(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int setVideoSource(IVideoSource iVideoSource) {
        this.mVideoSourceType = iVideoSource == null ? 0 : (iVideoSource instanceof AgoraDefaultSource ? 1 : 2);
        RtcEngineImpl rtcEngineImpl = this;
        long l2 = rtcEngineImpl.mNativeHandle;
        int n2 = rtcEngineImpl.mVideoSourceType;
        return rtcEngineImpl.nativeAddVideoCapturer(l2, iVideoSource, n2);
    }

    @Override
    public int setLocalVideoRenderer(IVideoSink iVideoSink) {
        int n2 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeAddLocalVideoRender(rtcEngineImpl.mNativeHandle, iVideoSink, n2);
    }

    @Override
    public int setRemoteVideoRenderer(int n2, IVideoSink iVideoSink) {
        int n3 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeAddRemoteVideoRender(rtcEngineImpl.mNativeHandle, n2, iVideoSink, n3);
    }

    public int removeRemoteVideoTrack(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRemoveVideoReceiveTrack(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        return this;
    }

    @Override
    public int enableDeepLearningDenoise(boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeEnableDeepLearningDenoise(rtcEngineImpl.mNativeHandle, bl);
    }

    @Override
    public int enableSoundPositionIndication(boolean bl) {
        return this.setParameter("che.audio.enable_sound_position", bl);
    }

    @Override
    public int setRemoteVoicePosition(int n2, double d2, double d3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = (long)n2 & 0xFFFFFFFFL;
        objectArray3[1] = d2;
        objectArray2[2] = d3;
        return super.setParameterObject("che.audio.game_place_sound_position", RtcEngineImpl.formatString("{\"uid\":%d,\"pan\":%f,\"gain\":%f}", objectArray3));
    }

    @Override
    public int setLocalVoicePitch(double d2) {
        return this.setParameter("che.audio.morph.pitch_shift", (int)(d2 * 100.0));
    }

    @Override
    public int setLocalVoiceEqualization(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return super.setParameterObject("che.audio.morph.equalization", RtcEngineImpl.formatString("{\"index\":%d,\"gain\":%d}", objectArray3));
    }

    @Override
    public int setLocalVoiceReverb(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return super.setParameterObject("che.audio.morph.reverb", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray3));
    }

    @Override
    @Deprecated
    public int setLocalVoiceChanger(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", n2);
        }
        if (n2 > 0 && n2 < 0x100000) {
            return this.setParameter("che.audio.morph.voice_changer", n2);
        }
        if (n2 > 0x100000 && n2 < 0x200000) {
            return this.setParameter("che.audio.morph.voice_changer", n2 - 0x100000 + 6);
        }
        if (n2 > 0x200000 && n2 < 0x300000) {
            return this.setParameter("che.audio.morph.beauty_voice", n2 - 0x200000);
        }
        return -2;
    }

    @Override
    @Deprecated
    public int setLocalVoiceReverbPreset(int n2) {
        if (n2 == 0) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", n2);
        }
        if (n2 > 0 && n2 < 0x100000) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", n2 + 8);
        }
        if (n2 > 0x100000 && n2 < 0x200000) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", n2 - 0x100000);
        }
        if (n2 > 0x200000 && n2 < 0x200002) {
            return objectArray3.setParameter("che.audio.morph.virtual_stereo", n2 - 0x200000);
        }
        if (n2 > 0x300000 && n2 < 0x300002) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = 1;
            objectArray2[1] = 4;
            return super.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray3));
        }
        if (n2 > 0x400000 && n2 < 0x400002) {
            return super.setParameter("che.audio.morph.threedim_voice", 10);
        }
        return -2;
    }

    @Override
    public int setVoiceBeautifierPreset(int n2) {
        Object[] objectArray;
        if (n2 == 0) {
            return objectArray.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x1010100) {
            return objectArray.setParameter("che.audio.morph.beauty_voice", 1);
        }
        if (n2 == 0x1010200) {
            return objectArray.setParameter("che.audio.morph.beauty_voice", 2);
        }
        if (n2 == 0x1010300) {
            return objectArray.setParameter("che.audio.morph.beauty_voice", 3);
        }
        if (n2 == 0x1020100) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = 1;
            objectArray3[1] = 1;
            return super.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray));
        }
        if (n2 == 0x1020200) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[2];
            objectArray = objectArray5;
            objectArray5[0] = 2;
            objectArray5[1] = 1;
            return super.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray));
        }
        if (n2 == 0x1030100) {
            return super.setParameter("che.audio.morph.voice_changer", 7);
        }
        if (n2 == 16974336) {
            return super.setParameter("che.audio.morph.voice_changer", 8);
        }
        if (n2 == 0x1030300) {
            return super.setParameter("che.audio.morph.voice_changer", 9);
        }
        if (n2 == 16974848) {
            return super.setParameter("che.audio.morph.voice_changer", 10);
        }
        if (n2 == 16975104) {
            return super.setParameter("che.audio.morph.voice_changer", 11);
        }
        if (n2 == 16975360) {
            return super.setParameter("che.audio.morph.voice_changer", 12);
        }
        if (n2 == 16975616) {
            return super.setParameter("che.audio.morph.voice_changer", 13);
        }
        if (n2 == 16975872) {
            return super.setParameter("che.audio.morph.voice_changer", 14);
        }
        return -2;
    }

    @Override
    public int setAudioEffectPreset(int n2) {
        if (n2 == 0) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x2010100) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 1);
        }
        if (n2 == 0x2010200) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 2);
        }
        if (n2 == 33620736) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 5);
        }
        if (n2 == 33620992) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 8);
        }
        if (n2 == 33621248) {
            return objectArray3.setParameter("che.audio.morph.virtual_stereo", 1);
        }
        if (n2 == 33621504) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 15);
        }
        if (n2 == 33621760) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 5);
        }
        if (n2 == 33622016) {
            return objectArray3.setParameter("che.audio.morph.threedim_voice", 10);
        }
        if (n2 == 0x2020100) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 3);
        }
        if (n2 == 0x2020200) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 1);
        }
        if (n2 == 0x2020300) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 2);
        }
        if (n2 == 0x2020400) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 4);
        }
        if (n2 == 0x2020500) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 3);
        }
        if (n2 == 0x2020600) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 4);
        }
        if (n2 == 0x2020700) {
            return objectArray3.setParameter("che.audio.morph.voice_changer", 6);
        }
        if (n2 == 33751296) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 7);
        }
        if (n2 == 0x2030200) {
            return objectArray3.setParameter("che.audio.morph.reverb_preset", 6);
        }
        if (n2 == 33816832) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = 1;
            objectArray2[1] = 4;
            return super.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray3));
        }
        return -2;
    }

    @Override
    public int setVoiceConversionPreset(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x3010100) {
            return this.setParameter("che.audio.morph.vocal_changer", 1);
        }
        if (n2 == 50397696) {
            return this.setParameter("che.audio.morph.vocal_changer", 2);
        }
        if (n2 == 0x3010300) {
            return this.setParameter("che.audio.morph.vocal_changer", 3);
        }
        if (n2 == 50398208) {
            return this.setParameter("che.audio.morph.vocal_changer", 4);
        }
        return -2;
    }

    @Override
    public int setAudioEffectParameters(int n2, int n3, int n4) {
        if (n2 == 33816832) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n3;
            objectArray2[1] = n4;
            return super.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray3));
        }
        if (n2 == 33622016) {
            return super.setParameter("che.audio.morph.threedim_voice", n3);
        }
        return -2;
    }

    @Override
    public int setVoiceBeautifierParameters(int n2, int n3, int n4) {
        if (n2 != 0x1020100 && n2 != 0x1020200) {
            return -2;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n3;
        objectArray2[1] = n4;
        return super.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", objectArray3));
    }

    @Override
    public int setInEarMonitoringVolume(int n2) {
        return this.setParameter("che.audio.headset.monitoring.parameter", n2);
    }

    @Override
    public double getEffectsVolume() {
        return this.getEffectsPlayoutVolume();
    }

    @Override
    public int setEffectsVolume(double d2) {
        int n2 = (int)d2;
        int n3 = this.adjustEffectsPlayoutVolume(n2);
        if (n3 == 0) {
            n3 = this.adjustEffectsPublishVolume(n2);
        }
        return n3;
    }

    @Override
    public int setVolumeOfEffect(int n2, double d2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = d2;
        return super.setParameterObject("che.audio.game_adjust_effect_volume", RtcEngineImpl.formatString("{\"soundId\":%d,\"gain\":%f}", objectArray3));
    }

    @Override
    @Deprecated
    public int playEffect(int n2, String string2, int n3, double d2, double d3, double d4) {
        return this.playEffect(n2, string2, n3, d2, d3, d4, false, 0);
    }

    @Override
    @Deprecated
    public int playEffect(int n2, String string2, int n3, double d2, double d3, double d4, boolean bl) {
        return this.playEffect(n2, string2, n3, d2, d3, d4, bl, 0);
    }

    @Override
    public int playEffect(int n2, String string2, int n3, double d2, double d3, double d4, boolean bl, int n4) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[8];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray3[1] = string2;
        objectArray3[2] = n3;
        objectArray3[3] = d2;
        objectArray3[4] = d3;
        objectArray3[5] = d4;
        int n5 = 6;
        objectArray3[n5] = bl ? 1 : 0;
        objectArray2[7] = n4;
        return super.setParameterObject("che.audio.game_play_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\",\"loopCount\":%d, \"pitch\":%f,\"pan\":%f,\"gain\":%f, \"send2far\":%d, \"startPos\":%d}", objectArray2));
    }

    @Override
    public int stopEffect(int n2) {
        return this.setParameter("che.audio.game_stop_effect", n2);
    }

    @Override
    public int stopAllEffects() {
        return this.setParameter("che.audio.game_stop_all_effects", true);
    }

    @Override
    public int preloadEffect(int n2, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -2;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = n2;
        objectArray2[1] = string2;
        return super.setParameterObject("che.audio.game_preload_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\"}", objectArray3));
    }

    @Override
    public int unloadEffect(int n2) {
        return this.setParameter("che.audio.game_unload_effect", n2);
    }

    @Override
    public int pauseEffect(int n2) {
        return this.setParameter("che.audio.game_pause_effect", n2);
    }

    @Override
    public int pauseAllEffects() {
        return this.setParameter("che.audio.game_pause_all_effects", true);
    }

    @Override
    public int resumeEffect(int n2) {
        return this.setParameter("che.audio.game_resume_effect", n2);
    }

    @Override
    public int resumeAllEffects() {
        return this.setParameter("che.audio.game_resume_all_effects", true);
    }

    @Override
    public int getEffectCurrentPosition(int n2) {
        long l2 = object.mNativeHandle;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = n2;
        int n3 = super.nativeGetIntParameter(l2, "che.audio.get_effect_file_position", (String)object);
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    @Override
    public int setEffectPosition(int n2, int n3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = n2;
        objectArray2[1] = n3;
        return super.setParameterObject("che.audio.set_effect_file_position", RtcEngineImpl.formatString("{\"soundId\":%d,\"effectPos\":%d}", objectArray3));
    }

    @Override
    public int getEffectDuration(String string2) {
        long l2 = object.mNativeHandle;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = string2;
        int n2 = super.nativeGetIntParameter(l2, "che.audio.get_effect_file_duration", (String)object);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public int startRhythmPlayer(String string2, String string3, AgoraRhythmPlayerConfig agoraRhythmPlayerConfig) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[5];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray3[1] = string3;
        objectArray3[2] = agoraRhythmPlayerConfig.beatsPerMeasure;
        objectArray2[3] = agoraRhythmPlayerConfig.beatsPerMinute;
        objectArray2[4] = agoraRhythmPlayerConfig.publish ? 1 : 0;
        return super.setParameterObject("che.audio.play_rhythm", RtcEngineImpl.formatString("{\"file1\":\"%s\",\"file2\":\"%s\",\"beatsPerMeasure\":%d, \"beatsPerMinute\":%d,\"publish\":%d}", objectArray2));
    }

    @Override
    public int stopRhythmPlayer() {
        return this.setParameter("che.audio.stop_rhythm", true);
    }

    @Override
    public int configRhythmPlayer(AgoraRhythmPlayerConfig agoraRhythmPlayerConfig) {
        return this.setParameterObject("che.audio.config_rhythm", RtcEngineImpl.formatString("{\"beatsPerMeasure\":%d,\"beatsPerMinute\":%d,\"publish\":%d}", agoraRhythmPlayerConfig.beatsPerMeasure, agoraRhythmPlayerConfig.beatsPerMinute, agoraRhythmPlayerConfig.publish ? 1 : 0));
    }

    @Override
    public int setApiCallMode(int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetApiCallMode(rtcEngineImpl.mNativeHandle, n2);
    }

    @Override
    public int getConnectionState() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeGetConncetionState(rtcEngineImpl.mNativeHandle);
    }

    @Override
    public int enableRemoteSuperResolution(int n2, boolean bl) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeEnableRemoteSuperResolution(rtcEngineImpl.mNativeHandle, n2, bl);
    }

    public void finalize() {
        long l2 = this.mNativeHandle;
        if (l2 != 0L) {
            this.nativeDestroy(l2);
        }
    }

    @Override
    public int registerMediaMetadataObserver(IMetadataObserver iMetadataObserver, int n2) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeRegisterMediaMetadataObserver(rtcEngineImpl.mNativeHandle, iMetadataObserver, n2);
    }

    @Override
    public int setLogWriter(ILogWriter iLogWriter) {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeSetLogWriter(rtcEngineImpl.mNativeHandle, iLogWriter);
    }

    @Override
    public int releaseLogWriter() {
        RtcEngineImpl rtcEngineImpl = this;
        return rtcEngineImpl.nativeReleaseLogWriter(rtcEngineImpl.mNativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RtcChannel createRtcChannel(String object) {
        if (object == null) return null;
        if (((String)object).length() <= 0) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            RtcChannelImpl rtcChannelImpl;
            if (rtcEngineImpl.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(object) && this.mDefaultRtcChannel.isInitialized()) {
                // ** MonitorExit[this] (shouldn't be in output)
                return this.mDefaultRtcChannel;
            }
            for (RtcChannelImpl rtcChannelImpl2 : this.mRtcChannels) {
                if (rtcChannelImpl2.channelId() == null || !rtcChannelImpl2.channelId().equals(object) || !rtcChannelImpl2.isInitialized()) continue;
                // ** MonitorExit[this] (shouldn't be in output)
                return rtcChannelImpl2;
            }
            RtcEngineImpl rtcEngineImpl2 = this;
            long l2 = rtcEngineImpl2.nativeCreateRtcChannel(rtcEngineImpl2.mNativeHandle, (String)object);
            if (l2 == 0L) return null;
            object = rtcChannelImpl;
            RtcEngineImpl rtcEngineImpl3 = this;
            RtcEngineImpl rtcEngineImpl4 = rtcEngineImpl3;
            RtcEngineImpl rtcEngineImpl5 = rtcEngineImpl3;
            ((RtcChannelImpl)object)();
            ((RtcChannelImpl)object).initialize(this, l2);
            rtcEngineImpl4.mRtcChannels.add((RtcChannelImpl)object);
            // ** MonitorExit[v6] (shouldn't be in output)
            return rtcChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int destroyRtcChannel(String string2) {
        if (string2 == null) return -102;
        if (string2.length() <= 0) {
            return -102;
        }
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            RtcChannelImpl rtcChannelImpl;
            if (rtcEngineImpl.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(string2)) {
                // ** MonitorExit[this] (shouldn't be in output)
                return -5;
            }
            Iterator iterator = this.mRtcChannels.iterator();
            do {
                if (!iterator.hasNext()) return 0;
            } while ((rtcChannelImpl = (RtcChannelImpl)iterator.next()).channelId() == null || !rtcChannelImpl.channelId().equals(string2));
            int n2 = this.nativeRtcChannelRelease(rtcChannelImpl.getNativeHandle());
            RtcEngineImpl rtcEngineImpl2 = this;
            RtcEngineImpl rtcEngineImpl3 = rtcEngineImpl2;
            rtcEngineImpl2.mRtcChannels.remove(rtcChannelImpl);
            // ** MonitorExit[v3] (shouldn't be in output)
            return n2;
        }
    }

    public void onRtcChannelJoinChannel() {
        RtcEngineImpl rtcEngineImpl = this;
        rtcEngineImpl.doJoinChannelCheck(rtcEngineImpl.getContext());
    }

    public void onRtcChannelLeaveChannel() {
        this.doLeaveChannelCheck();
    }
}

