/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.text.TextUtils;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.internal.Marshallable;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class RtcEngineMessage {
    public static short AGORA_UI_SERVER = 0;

    public static class PUploadLogResult
    extends Marshallable {
        public String requestId;
        public boolean success;
        public int reason;

        @Override
        public void unmarshall(byte[] byArray) {
            PUploadLogResult pUploadLogResult = this;
            super.unmarshall(byArray);
            pUploadLogResult.requestId = pUploadLogResult.popString16();
            pUploadLogResult.success = pUploadLogResult.popBool();
            pUploadLogResult.reason = pUploadLogResult.popInt();
        }
    }

    public static class PUserAccountInfo
    extends Marshallable {
        public int uid;
        public String userAccount;

        @Override
        public byte[] marshall() {
            PUserAccountInfo pUserAccountInfo = this;
            pUserAccountInfo.pushInt(pUserAccountInfo.uid);
            pUserAccountInfo.pushBytes(pUserAccountInfo.userAccount.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PUserAccountInfo pUserAccountInfo = this;
            super.unmarshall(byArray);
            pUserAccountInfo.uid = pUserAccountInfo.popInt();
            pUserAccountInfo.userAccount = pUserAccountInfo.popString16UTF8();
        }
    }

    public static class PNetworkTypeChanged
    extends Marshallable {
        public int type;

        @Override
        public byte[] marshall() {
            PNetworkTypeChanged pNetworkTypeChanged = this;
            pNetworkTypeChanged.pushInt(pNetworkTypeChanged.type);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PNetworkTypeChanged pNetworkTypeChanged = this;
            super.unmarshall(byArray);
            pNetworkTypeChanged.type = pNetworkTypeChanged.popInt();
        }
    }

    public static class PConnectionState
    extends Marshallable {
        public int state;
        public int reason;

        @Override
        public byte[] marshall() {
            PConnectionState pConnectionState = this;
            pConnectionState.pushInt(pConnectionState.state);
            pConnectionState.pushInt(pConnectionState.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PConnectionState pConnectionState = this;
            super.unmarshall(byArray);
            pConnectionState.state = pConnectionState.popInt();
            pConnectionState.reason = pConnectionState.popInt();
        }
    }

    public static class PLocalAudioEnabled
    extends Marshallable {
        boolean enabled;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PLocalAudioEnabled pLocalAudioEnabled = this;
            super.unmarshall(byArray);
            pLocalAudioEnabled.enabled = pLocalAudioEnabled.popBool();
        }
    }

    public static class PLocalFallbackStatus
    extends Marshallable {
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PLocalFallbackStatus pLocalFallbackStatus = this;
            super.unmarshall(byArray);
            pLocalFallbackStatus.state = pLocalFallbackStatus.popBool();
        }
    }

    public static class PUserTransportStat
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int delay;
        public int lost;
        public int rxKBitRate;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PUserTransportStat pUserTransportStat = this;
            super.unmarshall(byArray);
            pUserTransportStat.isAudio = pUserTransportStat.popBool();
            pUserTransportStat.peer_uid = pUserTransportStat.popInt();
            pUserTransportStat.delay = pUserTransportStat.popShort();
            pUserTransportStat.lost = pUserTransportStat.popShort();
            pUserTransportStat.rxKBitRate = pUserTransportStat.popShort();
        }
    }

    public static class PCrossChannelEvent
    extends Marshallable {
        public int code;

        @Override
        public byte[] marshall() {
            PCrossChannelEvent pCrossChannelEvent = this;
            pCrossChannelEvent.pushInt(pCrossChannelEvent.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PCrossChannelEvent pCrossChannelEvent = this;
            super.unmarshall(byArray);
            pCrossChannelEvent.code = pCrossChannelEvent.popInt();
        }
    }

    public static class PCrossChannelState
    extends Marshallable {
        public int state;
        public int code;

        @Override
        public byte[] marshall() {
            PCrossChannelState pCrossChannelState = this;
            pCrossChannelState.pushInt(pCrossChannelState.state);
            pCrossChannelState.pushInt(pCrossChannelState.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PCrossChannelState pCrossChannelState = this;
            super.unmarshall(byArray);
            pCrossChannelState.state = pCrossChannelState.popInt();
            pCrossChannelState.code = pCrossChannelState.popInt();
        }
    }

    public static class PAndroidContextInfo
    extends Marshallable {
        public String device;
        public String deviceInfo;
        public String systemInfo;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String androidID;

        @Override
        public byte[] marshall() {
            PAndroidContextInfo pAndroidContextInfo = this;
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.device.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.deviceInfo.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.systemInfo.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.configDir.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.dataDir.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.pluginDir.getBytes());
            pAndroidContextInfo.pushBytes(pAndroidContextInfo.androidID.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PAndroidContextInfo pAndroidContextInfo = this;
            super.unmarshall(byArray);
            pAndroidContextInfo.device = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.deviceInfo = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.systemInfo = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.configDir = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.dataDir = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.pluginDir = pAndroidContextInfo.popString16UTF8();
            pAndroidContextInfo.androidID = pAndroidContextInfo.popString16UTF8();
        }
    }

    static class PAudioRoutingChanged
    extends Marshallable {
        int routing;

        PAudioRoutingChanged() {
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PAudioRoutingChanged pAudioRoutingChanged = this;
            super.unmarshall(byArray);
            pAudioRoutingChanged.routing = pAudioRoutingChanged.popInt();
        }
    }

    public static class PRemoteVideoStateExt
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PRemoteVideoStateExt pRemoteVideoStateExt = this;
            pRemoteVideoStateExt.pushInt(pRemoteVideoStateExt.uid);
            pRemoteVideoStateExt.pushInt(pRemoteVideoStateExt.state);
            pRemoteVideoStateExt.pushInt(pRemoteVideoStateExt.reason);
            pRemoteVideoStateExt.pushInt(pRemoteVideoStateExt.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PRemoteVideoStateExt pRemoteVideoStateExt = this;
            super.unmarshall(byArray);
            pRemoteVideoStateExt.uid = pRemoteVideoStateExt.popInt();
            pRemoteVideoStateExt.state = pRemoteVideoStateExt.popByte();
            pRemoteVideoStateExt.reason = pRemoteVideoStateExt.popByte();
            pRemoteVideoStateExt.elapsed = pRemoteVideoStateExt.popInt();
        }
    }

    public static class PRemoteAudioState
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PRemoteAudioState pRemoteAudioState = this;
            pRemoteAudioState.pushInt(pRemoteAudioState.uid);
            pRemoteAudioState.pushInt(pRemoteAudioState.state);
            pRemoteAudioState.pushInt(pRemoteAudioState.reason);
            pRemoteAudioState.pushInt(pRemoteAudioState.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PRemoteAudioState pRemoteAudioState = this;
            super.unmarshall(byArray);
            pRemoteAudioState.uid = pRemoteAudioState.popInt();
            pRemoteAudioState.state = pRemoteAudioState.popInt();
            pRemoteAudioState.reason = pRemoteAudioState.popInt();
            pRemoteAudioState.elapsed = pRemoteAudioState.popInt();
        }
    }

    public static class PVirtualBackgroundSourceEnabled
    extends Marshallable {
        public boolean enabled;
        public int reason;

        @Override
        public byte[] marshall() {
            PVirtualBackgroundSourceEnabled pVirtualBackgroundSourceEnabled = this;
            pVirtualBackgroundSourceEnabled.pushBool(pVirtualBackgroundSourceEnabled.enabled);
            pVirtualBackgroundSourceEnabled.pushInt(pVirtualBackgroundSourceEnabled.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PVirtualBackgroundSourceEnabled pVirtualBackgroundSourceEnabled = this;
            super.unmarshall(byArray);
            pVirtualBackgroundSourceEnabled.enabled = pVirtualBackgroundSourceEnabled.popBool();
            pVirtualBackgroundSourceEnabled.reason = pVirtualBackgroundSourceEnabled.popInt();
        }
    }

    public static class PUserSuperResolutionEnabled
    extends Marshallable {
        public int uid;
        public boolean enabled;
        public int reason;

        @Override
        public byte[] marshall() {
            PUserSuperResolutionEnabled pUserSuperResolutionEnabled = this;
            pUserSuperResolutionEnabled.pushInt(pUserSuperResolutionEnabled.uid);
            pUserSuperResolutionEnabled.pushBool(pUserSuperResolutionEnabled.enabled);
            pUserSuperResolutionEnabled.pushInt(pUserSuperResolutionEnabled.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PUserSuperResolutionEnabled pUserSuperResolutionEnabled = this;
            super.unmarshall(byArray);
            pUserSuperResolutionEnabled.uid = pUserSuperResolutionEnabled.popInt();
            pUserSuperResolutionEnabled.enabled = pUserSuperResolutionEnabled.popBool();
            pUserSuperResolutionEnabled.reason = pUserSuperResolutionEnabled.popInt();
        }
    }

    public static class PSubscribeVideoState
    extends Marshallable {
        public String channel;
        public int uid;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PSubscribeVideoState pSubscribeVideoState = this;
            pSubscribeVideoState.pushBytes(pSubscribeVideoState.channel.getBytes());
            pSubscribeVideoState.pushInt(pSubscribeVideoState.uid);
            pSubscribeVideoState.pushInt(pSubscribeVideoState.oldstate);
            pSubscribeVideoState.pushInt(pSubscribeVideoState.newstate);
            pSubscribeVideoState.pushInt(pSubscribeVideoState.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PSubscribeVideoState pSubscribeVideoState = this;
            super.unmarshall(byArray);
            pSubscribeVideoState.channel = pSubscribeVideoState.popString16UTF8();
            pSubscribeVideoState.uid = pSubscribeVideoState.popInt();
            pSubscribeVideoState.oldstate = pSubscribeVideoState.popInt();
            pSubscribeVideoState.newstate = pSubscribeVideoState.popInt();
            pSubscribeVideoState.elapsed = pSubscribeVideoState.popInt();
        }
    }

    public static class PSubscribeAudioState
    extends Marshallable {
        public String channel;
        public int uid;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PSubscribeAudioState pSubscribeAudioState = this;
            pSubscribeAudioState.pushBytes(pSubscribeAudioState.channel.getBytes());
            pSubscribeAudioState.pushInt(pSubscribeAudioState.uid);
            pSubscribeAudioState.pushInt(pSubscribeAudioState.oldstate);
            pSubscribeAudioState.pushInt(pSubscribeAudioState.newstate);
            pSubscribeAudioState.pushInt(pSubscribeAudioState.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PSubscribeAudioState pSubscribeAudioState = this;
            super.unmarshall(byArray);
            pSubscribeAudioState.channel = pSubscribeAudioState.popString16UTF8();
            pSubscribeAudioState.uid = pSubscribeAudioState.popInt();
            pSubscribeAudioState.oldstate = pSubscribeAudioState.popInt();
            pSubscribeAudioState.newstate = pSubscribeAudioState.popInt();
            pSubscribeAudioState.elapsed = pSubscribeAudioState.popInt();
        }
    }

    public static class PPublishVideoState
    extends Marshallable {
        public String channel;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PPublishVideoState pPublishVideoState = this;
            pPublishVideoState.pushBytes(pPublishVideoState.channel.getBytes());
            pPublishVideoState.pushInt(pPublishVideoState.oldstate);
            pPublishVideoState.pushInt(pPublishVideoState.newstate);
            pPublishVideoState.pushInt(pPublishVideoState.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PPublishVideoState pPublishVideoState = this;
            super.unmarshall(byArray);
            pPublishVideoState.channel = pPublishVideoState.popString16UTF8();
            pPublishVideoState.oldstate = pPublishVideoState.popInt();
            pPublishVideoState.newstate = pPublishVideoState.popInt();
            pPublishVideoState.elapsed = pPublishVideoState.popInt();
        }
    }

    public static class PPublishAudioState
    extends Marshallable {
        public String channel;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PPublishAudioState pPublishAudioState = this;
            pPublishAudioState.pushBytes(pPublishAudioState.channel.getBytes());
            pPublishAudioState.pushInt(pPublishAudioState.oldstate);
            pPublishAudioState.pushInt(pPublishAudioState.newstate);
            pPublishAudioState.pushInt(pPublishAudioState.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PPublishAudioState pPublishAudioState = this;
            super.unmarshall(byArray);
            pPublishAudioState.channel = pPublishAudioState.popString16UTF8();
            pPublishAudioState.oldstate = pPublishAudioState.popInt();
            pPublishAudioState.newstate = pPublishAudioState.popInt();
            pPublishAudioState.elapsed = pPublishAudioState.popInt();
        }
    }

    public static class PPrivilegeWillExpire
    extends Marshallable {
        public String token;

        @Override
        public byte[] marshall() {
            PPrivilegeWillExpire pPrivilegeWillExpire = this;
            pPrivilegeWillExpire.pushBytes(pPrivilegeWillExpire.token.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PPrivilegeWillExpire pPrivilegeWillExpire = this;
            super.unmarshall(byArray);
            pPrivilegeWillExpire.token = pPrivilegeWillExpire.popString16UTF8();
        }
    }

    public static class PStreamInjectedStatus
    extends Marshallable {
        public String url;
        public int uid;
        public int status;

        @Override
        public byte[] marshall() {
            PStreamInjectedStatus pStreamInjectedStatus = this;
            pStreamInjectedStatus.pushBytes(pStreamInjectedStatus.url.getBytes());
            pStreamInjectedStatus.pushInt(pStreamInjectedStatus.uid);
            pStreamInjectedStatus.pushInt(pStreamInjectedStatus.status);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamInjectedStatus pStreamInjectedStatus = this;
            super.unmarshall(byArray);
            pStreamInjectedStatus.url = pStreamInjectedStatus.popString16UTF8();
            pStreamInjectedStatus.uid = pStreamInjectedStatus.popInt();
            pStreamInjectedStatus.status = pStreamInjectedStatus.popInt();
        }
    }

    public static class PHostInStopped
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PHostInStopped pHostInStopped = this;
            super.unmarshall(byArray);
            pHostInStopped.uid = pHostInStopped.popInt();
        }
    }

    public static class PHostInRequest
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PHostInRequest pHostInRequest = this;
            super.unmarshall(byArray);
            pHostInRequest.uid = pHostInRequest.popInt();
        }
    }

    public static class PHostInResponse
    extends Marshallable {
        public int ownerUid;
        public boolean accepted;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PHostInResponse pHostInResponse = this;
            super.unmarshall(byArray);
            pHostInResponse.ownerUid = pHostInResponse.popInt();
            pHostInResponse.accepted = pHostInResponse.popBool();
            pHostInResponse.error = pHostInResponse.popInt();
        }
    }

    public static class PInjectStreamConfig
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 25;

        private void marshall(Marshallable marshallable, LiveInjectStreamConfig liveInjectStreamConfig) {
            Marshallable marshallable2 = marshallable;
            marshallable2.pushShort((short)0);
            marshallable2.pushShort((short)25);
            marshallable.pushInt(liveInjectStreamConfig.width);
            marshallable.pushInt(liveInjectStreamConfig.height);
            marshallable.pushInt(liveInjectStreamConfig.videoGop);
            marshallable.pushInt(liveInjectStreamConfig.videoFramerate);
            marshallable.pushInt(liveInjectStreamConfig.videoBitrate);
            marshallable.pushInt(LiveInjectStreamConfig.AudioSampleRateType.getValue(liveInjectStreamConfig.audioSampleRate));
            marshallable.pushInt(liveInjectStreamConfig.audioBitrate);
            marshallable.pushInt(liveInjectStreamConfig.audioChannels);
        }

        public byte[] marshall(LiveInjectStreamConfig liveInjectStreamConfig) {
            PInjectStreamConfig pInjectStreamConfig = this;
            pInjectStreamConfig.marshall(pInjectStreamConfig, liveInjectStreamConfig);
            return super.marshall();
        }
    }

    public static class PChannelMediaRelayConfiguration
    extends Marshallable {
        private void marshallChannelInfo(Marshallable marshallable, ChannelMediaInfo channelMediaInfo) {
            marshallable.pushString16(channelMediaInfo.channelName);
            marshallable.pushString16(channelMediaInfo.token);
            marshallable.pushInt(channelMediaInfo.uid);
        }

        private void marshall(Marshallable marshallable, ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
            this.marshallChannelInfo(marshallable, channelMediaRelayConfiguration.getSrcChannelMediaInfo());
            this.pushShort((short)channelMediaRelayConfiguration.getDestChannelMediaInfos().size());
            for (String string2 : channelMediaRelayConfiguration.getDestChannelMediaInfos().keySet()) {
                this.marshallChannelInfo(marshallable, channelMediaRelayConfiguration.getDestChannelMediaInfos().get(string2));
            }
        }

        public byte[] marshall(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
            PChannelMediaRelayConfiguration pChannelMediaRelayConfiguration = this;
            pChannelMediaRelayConfiguration.marshall(pChannelMediaRelayConfiguration, channelMediaRelayConfiguration);
            return super.marshall();
        }
    }

    public static class PLiveTranscoding
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 23;

        private void marshallUserConfig(Marshallable marshallable, LiveTranscoding.TranscodingUser transcodingUser) {
            marshallable.pushInt(transcodingUser.uid);
            marshallable.pushInt(transcodingUser.x);
            marshallable.pushInt(transcodingUser.y);
            marshallable.pushInt(transcodingUser.width);
            marshallable.pushInt(transcodingUser.height);
            marshallable.pushInt(transcodingUser.zOrder);
            marshallable.pushDouble(transcodingUser.alpha);
            marshallable.pushInt(transcodingUser.audioChannel);
        }

        private void marshallImage(Marshallable marshallable, AgoraImage agoraImage) {
            marshallable.pushString16(agoraImage.url);
            marshallable.pushInt(agoraImage.x);
            marshallable.pushInt(agoraImage.y);
            marshallable.pushInt(agoraImage.width);
            marshallable.pushInt(agoraImage.height);
        }

        private void marshall(Marshallable marshallable, LiveTranscoding object) {
            AgoraImage agoraImage;
            Marshallable marshallable2 = marshallable;
            marshallable2.pushShort((short)0);
            marshallable2.pushShort((short)23);
            marshallable.pushInt(((LiveTranscoding)object).width);
            marshallable.pushInt(((LiveTranscoding)object).height);
            marshallable.pushInt(((LiveTranscoding)object).videoGop);
            marshallable.pushInt(((LiveTranscoding)object).videoFramerate);
            marshallable.pushInt(LiveTranscoding.VideoCodecProfileType.getValue(((LiveTranscoding)object).videoCodecProfile));
            marshallable.pushInt(LiveTranscoding.VideoCodecType.getValue(((LiveTranscoding)object).videoCodecType));
            marshallable.pushInt(((LiveTranscoding)object).videoBitrate);
            if (((LiveTranscoding)object).watermark == null) {
                AgoraImage agoraImage2;
                agoraImage = agoraImage2;
                agoraImage2 = new AgoraImage();
                ((LiveTranscoding)object).watermark = agoraImage;
            }
            ((PLiveTranscoding)((Object)iterator)).marshallImage(marshallable, ((LiveTranscoding)object).watermark);
            if (((LiveTranscoding)object).backgroundImage == null) {
                AgoraImage agoraImage3;
                agoraImage = agoraImage3;
                agoraImage3 = new AgoraImage();
                ((LiveTranscoding)object).backgroundImage = agoraImage;
            }
            ((PLiveTranscoding)((Object)iterator)).marshallImage(marshallable, ((LiveTranscoding)object).backgroundImage);
            marshallable.pushBool(((LiveTranscoding)object).lowLatency);
            marshallable.pushInt(LiveTranscoding.AudioSampleRateType.getValue(((LiveTranscoding)object).audioSampleRate));
            marshallable.pushInt(((LiveTranscoding)object).audioBitrate);
            marshallable.pushInt(((LiveTranscoding)object).audioChannels);
            marshallable.pushInt(LiveTranscoding.AudioCodecProfileType.getValue(((LiveTranscoding)object).audioCodecProfile));
            marshallable.pushInt(((LiveTranscoding)object).backgroundColor & 0xFFFFFF);
            if (TextUtils.isEmpty((CharSequence)((LiveTranscoding)object).userConfigExtraInfo)) {
                ((LiveTranscoding)object).userConfigExtraInfo = "";
            }
            marshallable.pushString16(((LiveTranscoding)object).userConfigExtraInfo);
            if (TextUtils.isEmpty((CharSequence)((LiveTranscoding)object).metadata)) {
                ((LiveTranscoding)object).metadata = "";
            }
            marshallable.pushString16(((LiveTranscoding)object).metadata);
            boolean bl = false;
            if (((LiveTranscoding)object).getUsers() != null && ((LiveTranscoding)object).getUsers().size() > 0) {
                ((PLiveTranscoding)((Object)iterator)).pushShort((short)((LiveTranscoding)object).getUserCount());
                Iterator<LiveTranscoding.TranscodingUser> iterator = ((LiveTranscoding)object).getUsers().iterator();
                while (iterator.hasNext()) {
                    super.marshallUserConfig(marshallable, iterator.next());
                }
            } else {
                ((PLiveTranscoding)((Object)iterator)).pushShort((short)(bl ? 1 : 0));
            }
            ((PLiveTranscoding)((Object)iterator)).pushShort((short)((LiveTranscoding)object).getAdvancedFeatures().size());
            Iterator<Map.Entry<String, Boolean>> iterator = ((LiveTranscoding)object).getAdvancedFeatures().entrySet().iterator();
            while (iterator.hasNext()) {
                Marshallable marshallable3 = marshallable;
                object = (Map.Entry)iterator.next();
                marshallable3.pushString16((String)object.getKey());
                marshallable3.pushBool((Boolean)object.getValue());
            }
        }

        public byte[] marshall(LiveTranscoding liveTranscoding) {
            PLiveTranscoding pLiveTranscoding = this;
            pLiveTranscoding.marshall(pLiveTranscoding, liveTranscoding);
            return super.marshall();
        }
    }

    public static class PStreamUnPublished
    extends Marshallable {
        public String url;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamUnPublished pStreamUnPublished = this;
            super.unmarshall(byArray);
            pStreamUnPublished.url = pStreamUnPublished.popString16UTF8();
        }
    }

    public static class PStreamEvent
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamEvent pStreamEvent = this;
            super.unmarshall(byArray);
            pStreamEvent.url = pStreamEvent.popString16UTF8();
            pStreamEvent.error = pStreamEvent.popInt();
        }
    }

    public static class PStreamPublished
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamPublished pStreamPublished = this;
            super.unmarshall(byArray);
            pStreamPublished.url = pStreamPublished.popString16UTF8();
            pStreamPublished.error = pStreamPublished.popInt();
        }
    }

    public static class PRtmpStreamingState
    extends Marshallable {
        public String url;
        public int state;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PRtmpStreamingState pRtmpStreamingState = this;
            super.unmarshall(byArray);
            pRtmpStreamingState.url = pRtmpStreamingState.popString16UTF8();
            pRtmpStreamingState.state = pRtmpStreamingState.popInt();
            pRtmpStreamingState.error = pRtmpStreamingState.popInt();
        }
    }

    public static class PClientRoleChanged
    extends Marshallable {
        int oldRole;
        int newRole;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PClientRoleChanged pClientRoleChanged = this;
            super.unmarshall(byArray);
            pClientRoleChanged.oldRole = pClientRoleChanged.popInt();
            pClientRoleChanged.newRole = pClientRoleChanged.popInt();
        }
    }

    public static class PActiveSpeaker
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PActiveSpeaker pActiveSpeaker = this;
            super.unmarshall(byArray);
            pActiveSpeaker.uid = pActiveSpeaker.popInt();
        }
    }

    public static class PFirstLocalAudioFramePublished
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstLocalAudioFramePublished pFirstLocalAudioFramePublished = this;
            pFirstLocalAudioFramePublished.pushInt(pFirstLocalAudioFramePublished.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstLocalAudioFramePublished pFirstLocalAudioFramePublished = this;
            super.unmarshall(byArray);
            pFirstLocalAudioFramePublished.elapsed = pFirstLocalAudioFramePublished.popInt();
        }
    }

    public static class PFirstLocalAudioFrame
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstLocalAudioFrame pFirstLocalAudioFrame = this;
            pFirstLocalAudioFrame.pushInt(pFirstLocalAudioFrame.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstLocalAudioFrame pFirstLocalAudioFrame = this;
            super.unmarshall(byArray);
            pFirstLocalAudioFrame.elapsed = pFirstLocalAudioFrame.popInt();
        }
    }

    public static class PFirstRemoteAudioFrame
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstRemoteAudioFrame pFirstRemoteAudioFrame = this;
            pFirstRemoteAudioFrame.pushInt(pFirstRemoteAudioFrame.uid);
            pFirstRemoteAudioFrame.pushInt(pFirstRemoteAudioFrame.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstRemoteAudioFrame pFirstRemoteAudioFrame = this;
            super.unmarshall(byArray);
            pFirstRemoteAudioFrame.uid = pFirstRemoteAudioFrame.popInt();
            pFirstRemoteAudioFrame.elapsed = pFirstRemoteAudioFrame.popInt();
        }
    }

    public static class PStreamMessageError
    extends Marshallable {
        int uid;
        int streamId;
        int error;
        int missed;
        int cached;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamMessageError pStreamMessageError = this;
            super.unmarshall(byArray);
            pStreamMessageError.uid = pStreamMessageError.popInt();
            pStreamMessageError.streamId = pStreamMessageError.popInt();
            pStreamMessageError.error = pStreamMessageError.popInt();
            pStreamMessageError.missed = pStreamMessageError.popInt();
            pStreamMessageError.cached = pStreamMessageError.popInt();
        }
    }

    public static class PStreamMessage
    extends Marshallable {
        int uid;
        int streamId;
        byte[] payload;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PStreamMessage pStreamMessage = this;
            super.unmarshall(byArray);
            pStreamMessage.uid = pStreamMessage.popInt();
            pStreamMessage.streamId = pStreamMessage.popInt();
            pStreamMessage.payload = pStreamMessage.popBytes();
        }
    }

    public static class PApiCallExecuted
    extends Marshallable {
        public int error;
        public String api;
        public String result;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PApiCallExecuted pApiCallExecuted = this;
            super.unmarshall(byArray);
            pApiCallExecuted.error = pApiCallExecuted.popInt();
            pApiCallExecuted.api = pApiCallExecuted.popString16UTF8();
            pApiCallExecuted.result = pApiCallExecuted.popString16UTF8();
        }
    }

    public static class PError
    extends Marshallable {
        public int err;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PError pError = this;
            super.unmarshall(byArray);
            pError.err = pError.popInt();
        }
    }

    public static class PMediaEngineEvent
    extends Marshallable {
        int code;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaEngineEvent pMediaEngineEvent = this;
            super.unmarshall(byArray);
            pMediaEngineEvent.code = pMediaEngineEvent.popInt();
        }
    }

    public static class PVideoSizeChanged
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int rotation;

        @Override
        public byte[] marshall() {
            PVideoSizeChanged pVideoSizeChanged = this;
            pVideoSizeChanged.pushInt(pVideoSizeChanged.uid);
            pVideoSizeChanged.pushInt(pVideoSizeChanged.width);
            pVideoSizeChanged.pushInt(pVideoSizeChanged.height);
            pVideoSizeChanged.pushInt(pVideoSizeChanged.rotation);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PVideoSizeChanged pVideoSizeChanged = this;
            super.unmarshall(byArray);
            pVideoSizeChanged.uid = pVideoSizeChanged.popInt();
            pVideoSizeChanged.width = pVideoSizeChanged.popInt();
            pVideoSizeChanged.height = pVideoSizeChanged.popInt();
            pVideoSizeChanged.rotation = pVideoSizeChanged.popInt();
        }
    }

    public static class PFaceDetectValue
    extends Marshallable {
        public int imageWidth;
        public int imageHeight;
        FaceRect[] rectArr = null;
        int[] disArr = null;
        public int num;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            int n2;
            PFaceDetectValue pFaceDetectValue = this;
            super.unmarshall(byArray);
            pFaceDetectValue.imageWidth = pFaceDetectValue.popInt();
            pFaceDetectValue.imageHeight = pFaceDetectValue.popInt();
            int n3 = pFaceDetectValue.popShort();
            if (n3 > 0) {
                this.rectArr = new FaceRect[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    FaceRect faceRect;
                    FaceRect faceRect2 = faceRect;
                    faceRect = new FaceRect();
                    this.rectArr[n2] = faceRect2;
                    this.rectArr[n2].x = this.popInt();
                    this.rectArr[n2].y = this.popInt();
                    this.rectArr[n2].width = this.popInt();
                    this.rectArr[n2].height = this.popInt();
                }
            }
            if ((n3 = this.popShort()) > 0) {
                this.disArr = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.disArr[n2] = this.popInt();
                }
            }
        }

        public static class FaceRect {
            public int x;
            public int y;
            public int width;
            public int height;
        }
    }

    public static class PCameraExposureAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            PCameraExposureAreaChanged pCameraExposureAreaChanged = this;
            pCameraExposureAreaChanged.pushInt(pCameraExposureAreaChanged.x);
            pCameraExposureAreaChanged.pushInt(pCameraExposureAreaChanged.y);
            pCameraExposureAreaChanged.pushInt(pCameraExposureAreaChanged.width);
            pCameraExposureAreaChanged.pushInt(pCameraExposureAreaChanged.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PCameraExposureAreaChanged pCameraExposureAreaChanged = this;
            super.unmarshall(byArray);
            pCameraExposureAreaChanged.x = pCameraExposureAreaChanged.popInt();
            pCameraExposureAreaChanged.y = pCameraExposureAreaChanged.popInt();
            pCameraExposureAreaChanged.width = pCameraExposureAreaChanged.popInt();
            pCameraExposureAreaChanged.height = pCameraExposureAreaChanged.popInt();
        }
    }

    public static class PCameraFocusAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            PCameraFocusAreaChanged pCameraFocusAreaChanged = this;
            pCameraFocusAreaChanged.pushInt(pCameraFocusAreaChanged.x);
            pCameraFocusAreaChanged.pushInt(pCameraFocusAreaChanged.y);
            pCameraFocusAreaChanged.pushInt(pCameraFocusAreaChanged.width);
            pCameraFocusAreaChanged.pushInt(pCameraFocusAreaChanged.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PCameraFocusAreaChanged pCameraFocusAreaChanged = this;
            super.unmarshall(byArray);
            pCameraFocusAreaChanged.x = pCameraFocusAreaChanged.popInt();
            pCameraFocusAreaChanged.y = pCameraFocusAreaChanged.popInt();
            pCameraFocusAreaChanged.width = pCameraFocusAreaChanged.popInt();
            pCameraFocusAreaChanged.height = pCameraFocusAreaChanged.popInt();
        }
    }

    public static class PFirstRemoteVideoDecoded
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstRemoteVideoDecoded pFirstRemoteVideoDecoded = this;
            pFirstRemoteVideoDecoded.pushInt(pFirstRemoteVideoDecoded.uid);
            pFirstRemoteVideoDecoded.pushInt(pFirstRemoteVideoDecoded.width);
            pFirstRemoteVideoDecoded.pushInt(pFirstRemoteVideoDecoded.height);
            pFirstRemoteVideoDecoded.pushInt(pFirstRemoteVideoDecoded.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstRemoteVideoDecoded pFirstRemoteVideoDecoded = this;
            super.unmarshall(byArray);
            pFirstRemoteVideoDecoded.uid = pFirstRemoteVideoDecoded.popInt();
            pFirstRemoteVideoDecoded.width = pFirstRemoteVideoDecoded.popInt();
            pFirstRemoteVideoDecoded.height = pFirstRemoteVideoDecoded.popInt();
            pFirstRemoteVideoDecoded.elapsed = pFirstRemoteVideoDecoded.popInt();
        }
    }

    public static class PFirstLocalVideoFramePublished
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstLocalVideoFramePublished pFirstLocalVideoFramePublished = this;
            pFirstLocalVideoFramePublished.pushInt(pFirstLocalVideoFramePublished.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstLocalVideoFramePublished pFirstLocalVideoFramePublished = this;
            super.unmarshall(byArray);
            pFirstLocalVideoFramePublished.elapsed = pFirstLocalVideoFramePublished.popInt();
        }
    }

    public static class PFirstLocalVideoFrame
    extends Marshallable {
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstLocalVideoFrame pFirstLocalVideoFrame = this;
            pFirstLocalVideoFrame.pushInt(pFirstLocalVideoFrame.width);
            pFirstLocalVideoFrame.pushInt(pFirstLocalVideoFrame.height);
            pFirstLocalVideoFrame.pushInt(pFirstLocalVideoFrame.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstLocalVideoFrame pFirstLocalVideoFrame = this;
            super.unmarshall(byArray);
            pFirstLocalVideoFrame.width = pFirstLocalVideoFrame.popInt();
            pFirstLocalVideoFrame.height = pFirstLocalVideoFrame.popInt();
            pFirstLocalVideoFrame.elapsed = pFirstLocalVideoFrame.popInt();
        }
    }

    public static class PFirstRemoteVideoFrame
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PFirstRemoteVideoFrame pFirstRemoteVideoFrame = this;
            pFirstRemoteVideoFrame.pushInt(pFirstRemoteVideoFrame.uid);
            pFirstRemoteVideoFrame.pushInt(pFirstRemoteVideoFrame.width);
            pFirstRemoteVideoFrame.pushInt(pFirstRemoteVideoFrame.height);
            pFirstRemoteVideoFrame.pushInt(pFirstRemoteVideoFrame.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PFirstRemoteVideoFrame pFirstRemoteVideoFrame = this;
            super.unmarshall(byArray);
            pFirstRemoteVideoFrame.uid = pFirstRemoteVideoFrame.popInt();
            pFirstRemoteVideoFrame.width = pFirstRemoteVideoFrame.popInt();
            pFirstRemoteVideoFrame.height = pFirstRemoteVideoFrame.popInt();
            pFirstRemoteVideoFrame.elapsed = pFirstRemoteVideoFrame.popInt();
        }
    }

    public static class PLocalVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalVideoStats stats;

        public PLocalVideoStat() {
            IRtcEngineEventHandler.LocalVideoStats localVideoStats;
            IRtcEngineEventHandler.LocalVideoStats localVideoStats2 = localVideoStats;
            localVideoStats = new IRtcEngineEventHandler.LocalVideoStats();
            v1.stats = localVideoStats2;
        }

        @Override
        public byte[] marshall() {
            PLocalVideoStat pLocalVideoStat = this;
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.sentBitrate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.sentFrameRate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.encoderOutputFrameRate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.rendererOutputFrameRate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.targetBitrate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.targetFrameRate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.qualityAdaptIndication);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.encodedBitrate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.encodedFrameWidth);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.encodedFrameHeight);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.encodedFrameCount);
            pLocalVideoStat.pushByte((byte)pLocalVideoStat.stats.codecType);
            pLocalVideoStat.pushShort((short)pLocalVideoStat.stats.txPacketLossRate);
            pLocalVideoStat.pushInt(pLocalVideoStat.stats.captureFrameRate);
            pLocalVideoStat.pushByte((byte)pLocalVideoStat.stats.captureBrightnessLevel);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.sentBitrate = this.popInt();
            this.stats.sentFrameRate = this.popInt();
            this.stats.encoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.targetBitrate = this.popInt();
            this.stats.targetFrameRate = this.popInt();
            this.stats.qualityAdaptIndication = this.popInt();
            this.stats.encodedBitrate = this.popInt();
            this.stats.encodedFrameWidth = this.popInt();
            this.stats.encodedFrameHeight = this.popInt();
            this.stats.encodedFrameCount = this.popInt();
            this.stats.codecType = this.popByte();
            this.stats.txPacketLossRate = this.popShort();
            this.stats.captureFrameRate = this.popInt();
            this.stats.captureBrightnessLevel = this.popByte();
        }
    }

    public static class PAudioFileInfo
    extends Marshallable {
        public String filePath;
        public int durationMs;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PAudioFileInfo pAudioFileInfo = this;
            super.unmarshall(byArray);
            pAudioFileInfo.filePath = pAudioFileInfo.popString16UTF8();
            pAudioFileInfo.durationMs = pAudioFileInfo.popInt();
            pAudioFileInfo.error = pAudioFileInfo.popInt();
        }
    }

    public static class PLocalAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalAudioStats stats;

        public PLocalAudioStat() {
            IRtcEngineEventHandler.LocalAudioStats localAudioStats;
            IRtcEngineEventHandler.LocalAudioStats localAudioStats2 = localAudioStats;
            localAudioStats = new IRtcEngineEventHandler.LocalAudioStats();
            v1.stats = localAudioStats2;
        }

        @Override
        public byte[] marshall() {
            PLocalAudioStat pLocalAudioStat = this;
            pLocalAudioStat.pushInt(pLocalAudioStat.stats.numChannels);
            pLocalAudioStat.pushInt(pLocalAudioStat.stats.sentSampleRate);
            pLocalAudioStat.pushInt(pLocalAudioStat.stats.sentBitrate);
            pLocalAudioStat.pushShort((short)pLocalAudioStat.stats.txPacketLossRate);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.numChannels = this.popInt();
            this.stats.sentSampleRate = this.popInt();
            this.stats.sentBitrate = this.popInt();
            this.stats.txPacketLossRate = this.popShort();
        }
    }

    public static class PRemoteAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteAudioStats stats;

        public PRemoteAudioStat() {
            IRtcEngineEventHandler.RemoteAudioStats remoteAudioStats;
            IRtcEngineEventHandler.RemoteAudioStats remoteAudioStats2 = remoteAudioStats;
            remoteAudioStats = new IRtcEngineEventHandler.RemoteAudioStats();
            v1.stats = remoteAudioStats2;
        }

        @Override
        public byte[] marshall() {
            PRemoteAudioStat pRemoteAudioStat = this;
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.uid);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.quality);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.networkTransportDelay);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.jitterBufferDelay);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.audioLossRate);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.numChannels);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.receivedSampleRate);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.receivedBitrate);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.totalFrozenTime);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.frozenRate);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.totalActiveTime);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.publishDuration);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.qoeQuality);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.qualityChangedReason);
            pRemoteAudioStat.pushInt(pRemoteAudioStat.stats.mosValue);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.uid = this.popInt();
            this.stats.quality = this.popInt();
            this.stats.networkTransportDelay = this.popInt();
            this.stats.jitterBufferDelay = this.popInt();
            this.stats.audioLossRate = this.popInt();
            this.stats.numChannels = this.popInt();
            this.stats.receivedSampleRate = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.totalActiveTime = this.popInt();
            this.stats.publishDuration = this.popInt();
            this.stats.qoeQuality = this.popInt();
            this.stats.qualityChangedReason = this.popInt();
            this.stats.mosValue = this.popInt();
        }
    }

    public static class PRemoteVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteVideoStats stats;

        public PRemoteVideoStat() {
            IRtcEngineEventHandler.RemoteVideoStats remoteVideoStats;
            IRtcEngineEventHandler.RemoteVideoStats remoteVideoStats2 = remoteVideoStats;
            remoteVideoStats = new IRtcEngineEventHandler.RemoteVideoStats();
            v1.stats = remoteVideoStats2;
        }

        @Override
        public byte[] marshall() {
            PRemoteVideoStat pRemoteVideoStat = this;
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.uid);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.delay);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.width);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.height);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.receivedBitrate);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.decoderOutputFrameRate);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.rendererOutputFrameRate);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.packetLossRate);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.rxStreamType);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.totalFrozenTime);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.frozenRate);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.totalActiveTime);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.publishDuration);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.qualityChangedReason);
            pRemoteVideoStat.pushInt(pRemoteVideoStat.stats.mosValue);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.uid = this.popInt();
            this.stats.delay = this.popInt();
            this.stats.width = this.popInt();
            this.stats.height = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.decoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.packetLossRate = this.popInt();
            this.stats.rxStreamType = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.totalActiveTime = this.popInt();
            this.stats.publishDuration = this.popInt();
            this.stats.qualityChangedReason = this.popInt();
            this.stats.mosValue = this.popInt();
        }
    }

    public static class PVideoNetOptions
    extends Marshallable {
        short width;
        short height;
        short frameRate;
        short bitrate;

        public void marshall(Marshallable marshallable) {
            marshallable.pushShort(this.width);
            marshallable.pushShort(this.height);
            marshallable.pushShort(this.frameRate);
            marshallable.pushShort(this.bitrate);
        }

        @Override
        public byte[] marshall() {
            PVideoNetOptions pVideoNetOptions = this;
            pVideoNetOptions.marshall(pVideoNetOptions);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PVideoNetOptions pVideoNetOptions = this;
            super.unmarshall(byArray);
            pVideoNetOptions.width = pVideoNetOptions.popShort();
            pVideoNetOptions.height = pVideoNetOptions.popShort();
            pVideoNetOptions.frameRate = pVideoNetOptions.popShort();
            pVideoNetOptions.bitrate = pVideoNetOptions.popShort();
        }
    }

    public static class MediaNetworkInfo
    extends Marshallable {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType;
        int networkSubtype;
        int signalLevel;
        int rssi;
        int asu;
        int frequency;
        int linkspeed;
        String ssid = "";
        String bssid = "";
        ArrayList<String> dnsList = null;

        public void marshall(Marshallable marshallable) {
            marshallable.pushBytes(((MediaNetworkInfo)object).localIp4.getBytes());
            marshallable.pushBytes(((MediaNetworkInfo)object).gatewayIp4.getBytes());
            marshallable.pushBytes(((MediaNetworkInfo)object).localIp6.getBytes());
            marshallable.pushBytes(((MediaNetworkInfo)object).gatewayIp6.getBytes());
            marshallable.pushInt(((MediaNetworkInfo)object).networkType);
            marshallable.pushInt(((MediaNetworkInfo)object).networkSubtype);
            marshallable.pushInt(((MediaNetworkInfo)object).signalLevel);
            marshallable.pushInt(((MediaNetworkInfo)object).rssi);
            marshallable.pushInt(((MediaNetworkInfo)object).asu);
            marshallable.pushInt(((MediaNetworkInfo)object).frequency);
            marshallable.pushInt(((MediaNetworkInfo)object).linkspeed);
            String string2 = ((MediaNetworkInfo)object).ssid;
            if (string2 != null && string2 instanceof String) {
                marshallable.pushBytes(string2.getBytes());
            } else {
                marshallable.pushBytes("".getBytes());
            }
            string2 = ((MediaNetworkInfo)object).bssid;
            if (string2 != null) {
                marshallable.pushBytes(string2.getBytes());
            } else {
                marshallable.pushBytes("".getBytes());
            }
            Object object = ((MediaNetworkInfo)object).dnsList;
            if (object != null) {
                marshallable.pushStringArray((ArrayList<String>)object);
            } else {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
                marshallable.pushStringArray((ArrayList<String>)object);
            }
        }

        @Override
        public byte[] marshall() {
            MediaNetworkInfo mediaNetworkInfo = this;
            mediaNetworkInfo.marshall(mediaNetworkInfo);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class MediaAppContext
    extends Marshallable {
        MediaNetworkInfo networkInfo;

        @Override
        public byte[] marshall() {
            MediaNetworkInfo mediaNetworkInfo = this.networkInfo;
            if (mediaNetworkInfo != null) {
                mediaNetworkInfo.marshall(this);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaResSpeakersReport
    extends Marshallable {
        int mixVolume;
        Speaker[] speakers;

        @Override
        public byte[] marshall() {
            PMediaResSpeakersReport pMediaResSpeakersReport = this;
            pMediaResSpeakersReport.pushInt(pMediaResSpeakersReport.mixVolume);
            int n2 = pMediaResSpeakersReport.speakers.length;
            pMediaResSpeakersReport.pushShort((short)n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                PMediaResSpeakersReport pMediaResSpeakersReport2 = this;
                pMediaResSpeakersReport2.pushInt(pMediaResSpeakersReport2.speakers[i2].uid);
                pMediaResSpeakersReport2.pushInt(pMediaResSpeakersReport2.speakers[i2].volume);
                pMediaResSpeakersReport2.pushInt(pMediaResSpeakersReport2.speakers[i2].vad);
                pMediaResSpeakersReport2.pushString16(pMediaResSpeakersReport2.speakers[i2].channelId);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResSpeakersReport pMediaResSpeakersReport = this;
            super.unmarshall(byArray);
            pMediaResSpeakersReport.mixVolume = pMediaResSpeakersReport.popInt();
            int n2 = pMediaResSpeakersReport.popShort();
            if (n2 > 0) {
                this.speakers = new Speaker[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Speaker speaker;
                    Speaker speaker2 = speaker;
                    speaker = new Speaker();
                    this.speakers[i2] = speaker2;
                    this.speakers[i2].uid = this.popInt();
                    this.speakers[i2].volume = this.popInt();
                    this.speakers[i2].vad = this.popInt();
                    this.speakers[i2].channelId = this.popString16UTF8();
                }
            }
        }

        public static class Speaker {
            public int uid;
            public int volume;
            public int vad;
            public String channelId;
        }
    }

    public static class MediaResSetupTime
    extends Marshallable {
        int elapsed;
        boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            MediaResSetupTime mediaResSetupTime = this;
            super.unmarshall(byArray);
            mediaResSetupTime.elapsed = mediaResSetupTime.popInt();
            mediaResSetupTime.firstSuccess = mediaResSetupTime.popBool();
        }
    }

    public static class PMediaResFirstRemoteAudioDecoded
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            PMediaResFirstRemoteAudioDecoded pMediaResFirstRemoteAudioDecoded = this;
            pMediaResFirstRemoteAudioDecoded.pushInt(pMediaResFirstRemoteAudioDecoded.uid);
            pMediaResFirstRemoteAudioDecoded.pushInt(pMediaResFirstRemoteAudioDecoded.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResFirstRemoteAudioDecoded pMediaResFirstRemoteAudioDecoded = this;
            super.unmarshall(byArray);
            pMediaResFirstRemoteAudioDecoded.uid = pMediaResFirstRemoteAudioDecoded.popInt();
            pMediaResFirstRemoteAudioDecoded.elapsed = pMediaResFirstRemoteAudioDecoded.popInt();
        }
    }

    public static class PMediaResLocalAudioStateChanged
    extends Marshallable {
        int state;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResLocalAudioStateChanged pMediaResLocalAudioStateChanged = this;
            super.unmarshall(byArray);
            pMediaResLocalAudioStateChanged.state = pMediaResLocalAudioStateChanged.popInt();
            pMediaResLocalAudioStateChanged.error = pMediaResLocalAudioStateChanged.popInt();
        }
    }

    public static class PMediaResLocalVideoStateChanged
    extends Marshallable {
        int localVideoState;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResLocalVideoStateChanged pMediaResLocalVideoStateChanged = this;
            super.unmarshall(byArray);
            pMediaResLocalVideoStateChanged.localVideoState = pMediaResLocalVideoStateChanged.popInt();
            pMediaResLocalVideoStateChanged.error = pMediaResLocalVideoStateChanged.popInt();
        }
    }

    public static class PMediaResAudioEffectFinished
    extends Marshallable {
        int soundId;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResAudioEffectFinished pMediaResAudioEffectFinished = this;
            super.unmarshall(byArray);
            pMediaResAudioEffectFinished.soundId = pMediaResAudioEffectFinished.popInt();
        }
    }

    public static class PMediaResLastmileProbeResult
    extends Marshallable {
        short state;
        int rtt;
        LastmileProbeOneWayResult uplinkReport;
        LastmileProbeOneWayResult downlinkReport;

        @Override
        public byte[] marshall() {
            PMediaResLastmileProbeResult pMediaResLastmileProbeResult = this;
            pMediaResLastmileProbeResult.pushShort(pMediaResLastmileProbeResult.state);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.uplinkReport.packetLossRate);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.uplinkReport.jitter);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.uplinkReport.availableBandwidth);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.downlinkReport.packetLossRate);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.downlinkReport.jitter);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.downlinkReport.availableBandwidth);
            pMediaResLastmileProbeResult.pushInt(pMediaResLastmileProbeResult.rtt);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResLastmileProbeResult pMediaResLastmileProbeResult = this;
            super.unmarshall(byArray);
            pMediaResLastmileProbeResult.state = pMediaResLastmileProbeResult.popShort();
            pMediaResLastmileProbeResult.uplinkReport = new LastmileProbeOneWayResult();
            pMediaResLastmileProbeResult.downlinkReport = new LastmileProbeOneWayResult();
            pMediaResLastmileProbeResult.uplinkReport.packetLossRate = this.popInt();
            pMediaResLastmileProbeResult.uplinkReport.jitter = this.popInt();
            pMediaResLastmileProbeResult.uplinkReport.availableBandwidth = this.popInt();
            pMediaResLastmileProbeResult.downlinkReport.packetLossRate = this.popInt();
            pMediaResLastmileProbeResult.downlinkReport.jitter = this.popInt();
            pMediaResLastmileProbeResult.downlinkReport.availableBandwidth = this.popInt();
            pMediaResLastmileProbeResult.rtt = pMediaResLastmileProbeResult.popInt();
        }

        public static class LastmileProbeOneWayResult {
            public int packetLossRate;
            public int jitter;
            public int availableBandwidth;
        }
    }

    public static class PMediaResLastmileQuality
    extends Marshallable {
        int quality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResLastmileQuality pMediaResLastmileQuality = this;
            super.unmarshall(byArray);
            pMediaResLastmileQuality.quality = pMediaResLastmileQuality.popInt();
        }
    }

    public static class PMediaResNetworkQuality
    extends Marshallable {
        int uid;
        int txQuality;
        int rxQuality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResNetworkQuality pMediaResNetworkQuality = this;
            super.unmarshall(byArray);
            pMediaResNetworkQuality.uid = pMediaResNetworkQuality.popInt();
            pMediaResNetworkQuality.txQuality = pMediaResNetworkQuality.popInt();
            pMediaResNetworkQuality.rxQuality = pMediaResNetworkQuality.popInt();
        }
    }

    public static class PMediaResUserState
    extends Marshallable {
        int uid;
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResUserState pMediaResUserState = this;
            super.unmarshall(byArray);
            pMediaResUserState.uid = pMediaResUserState.popInt();
            pMediaResUserState.state = pMediaResUserState.popBool();
        }
    }

    public static class PMediaResUserOfflineEvent
    extends Marshallable {
        int uid;
        int reason;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResUserOfflineEvent pMediaResUserOfflineEvent = this;
            super.unmarshall(byArray);
            pMediaResUserOfflineEvent.uid = pMediaResUserOfflineEvent.popInt();
            pMediaResUserOfflineEvent.reason = pMediaResUserOfflineEvent.popInt();
        }
    }

    public static class PMediaResUserJoinedEvent
    extends Marshallable {
        int uid;
        int elapsed;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResUserJoinedEvent pMediaResUserJoinedEvent = this;
            super.unmarshall(byArray);
            pMediaResUserJoinedEvent.uid = pMediaResUserJoinedEvent.popInt();
            pMediaResUserJoinedEvent.elapsed = pMediaResUserJoinedEvent.popInt();
        }
    }

    public static class PMediaResJoinMedia
    extends Marshallable {
        public String channel;
        public int uid;
        public int elapsed;
        public boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResJoinMedia pMediaResJoinMedia = this;
            super.unmarshall(byArray);
            pMediaResJoinMedia.channel = pMediaResJoinMedia.popString16UTF8();
            pMediaResJoinMedia.uid = pMediaResJoinMedia.popInt();
            pMediaResJoinMedia.elapsed = pMediaResJoinMedia.popInt();
            pMediaResJoinMedia.firstSuccess = pMediaResJoinMedia.popBool();
        }
    }

    public static class PMediaResRtcStats
    extends Marshallable {
        int totalDuration;
        int totalTxBytes;
        int totalRxBytes;
        int txAudioBytes;
        int txVideoBytes;
        int rxAudioBytes;
        int rxVideoBytes;
        int txKBitRate;
        int rxKBitRate;
        int txAudioKBitRate;
        int rxAudioKBitRate;
        int txVideoKBitRate;
        int rxVideoKBitRate;
        int lastmileDelay;
        int txPacketLossRate;
        int rxPacketLossRate;
        int cpuTotalUsage;
        int cpuAppUsage;
        int users;
        int gatewayRtt;
        int memoryTotalUsageRatio;
        int memoryAppUsageRatio;
        int memoryAppUsageInKbytes;
        int videoMosValue;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResRtcStats pMediaResRtcStats = this;
            super.unmarshall(byArray);
            pMediaResRtcStats.totalDuration = pMediaResRtcStats.popInt();
            pMediaResRtcStats.totalTxBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.totalRxBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.txAudioBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.rxAudioBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.txVideoBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.rxVideoBytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.txKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.rxKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.txAudioKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.rxAudioKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.txVideoKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.rxVideoKBitRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.lastmileDelay = pMediaResRtcStats.popShort();
            pMediaResRtcStats.txPacketLossRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.rxPacketLossRate = pMediaResRtcStats.popShort();
            pMediaResRtcStats.cpuTotalUsage = pMediaResRtcStats.popInt();
            pMediaResRtcStats.cpuAppUsage = pMediaResRtcStats.popInt();
            pMediaResRtcStats.users = pMediaResRtcStats.popInt();
            pMediaResRtcStats.gatewayRtt = pMediaResRtcStats.popInt();
            pMediaResRtcStats.memoryTotalUsageRatio = pMediaResRtcStats.popInt();
            pMediaResRtcStats.memoryAppUsageRatio = pMediaResRtcStats.popInt();
            pMediaResRtcStats.memoryAppUsageInKbytes = pMediaResRtcStats.popInt();
            pMediaResRtcStats.videoMosValue = pMediaResRtcStats.popInt();
        }
    }

    public static class PMediaResTransportQuality
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int bitrate;
        public short delay;
        public short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResTransportQuality pMediaResTransportQuality = this;
            super.unmarshall(byArray);
            pMediaResTransportQuality.isAudio = pMediaResTransportQuality.popBool();
            pMediaResTransportQuality.peer_uid = pMediaResTransportQuality.popInt();
            pMediaResTransportQuality.bitrate = pMediaResTransportQuality.popInt();
            pMediaResTransportQuality.delay = pMediaResTransportQuality.popShort();
            pMediaResTransportQuality.lost = pMediaResTransportQuality.popShort();
        }
    }

    public static class PMediaResAudioQuality
    extends Marshallable {
        int peer_uid;
        int quality;
        short delay;
        short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            PMediaResAudioQuality pMediaResAudioQuality = this;
            super.unmarshall(byArray);
            pMediaResAudioQuality.peer_uid = pMediaResAudioQuality.popInt();
            pMediaResAudioQuality.quality = pMediaResAudioQuality.popInt();
            pMediaResAudioQuality.delay = pMediaResAudioQuality.popShort();
            pMediaResAudioQuality.lost = pMediaResAudioQuality.popShort();
        }
    }

    public static class PMediaReqConnectMedia2
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x3F60000;
        String connInfo;

        @Override
        public byte[] marshall() {
            PMediaReqConnectMedia2 pMediaReqConnectMedia2 = this;
            pMediaReqConnectMedia2.pushBytes(pMediaReqConnectMedia2.connInfo.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqLeaveChannel
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x60000;
        int sid;

        @Override
        public byte[] marshall() {
            PMediaReqLeaveChannel pMediaReqLeaveChannel = this;
            pMediaReqLeaveChannel.pushInt(pMediaReqLeaveChannel.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqUserData
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x50000;
        String key;
        String username;
        String mobileinfo;
        int uid;

        @Override
        public byte[] marshall() {
            PMediaReqUserData pMediaReqUserData = this;
            pMediaReqUserData.pushBytes(pMediaReqUserData.key.getBytes());
            pMediaReqUserData.pushBytes(pMediaReqUserData.username.getBytes());
            pMediaReqUserData.pushBytes(pMediaReqUserData.mobileinfo.getBytes());
            pMediaReqUserData.pushInt(pMediaReqUserData.uid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqLeaveLinkd
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x40000;
        int sid;

        @Override
        public byte[] marshall() {
            PMediaReqLeaveLinkd pMediaReqLeaveLinkd = this;
            pMediaReqLeaveLinkd.pushInt(pMediaReqLeaveLinkd.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqJoinMeida
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x30000;
        int sid;

        @Override
        public byte[] marshall() {
            PMediaReqJoinMeida pMediaReqJoinMeida = this;
            pMediaReqJoinMeida.pushInt(pMediaReqJoinMeida.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqCreateChannel
    extends Marshallable {
        public static final int uri = AGORA_UI_SERVER | 0x20000;
        String key;

        @Override
        public byte[] marshall() {
            PMediaReqCreateChannel pMediaReqCreateChannel = this;
            pMediaReqCreateChannel.pushBytes(pMediaReqCreateChannel.key.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }
}

